/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar;

public final class ArParameterConstants {

    public static final String ACCOUNTING_BASIS = "ACCOUNTING_BASIS";
    public static final String COLLECTION_ACTIVITY_TYPE_CODE = "COLLECTION_ACTIVITY_TYPE_CODE";
    public static final String DEFAULT_PROCESSING_CHART = "DEFAULT_PROCESSING_CHART";
    public static final String DEFAULT_PROCESSING_ORG = "DEFAULT_PROCESSING_ORG";
    public static final String DUNNING_CAMPAIGN = "DUNNING_CAMPAIGN";
    public static final String EMAIL = "EMAIL";
    public static final String EMAIL_SUBJECT = "EMAIL_SUBJECT";
    public static final String FINAL_DAYS_PAST_DUE = "FINAL_DAYS_PAST_DUE";
    public static final String INCLUDE_PERIOD_13_IND = "INCLUDE_PERIOD_13_IND";
    public static final String INTERVALS = "INTERVALS";
    public static final String INVOICE_TEMPLATE = "INVOICE_TEMPLATE";
    public static final String LAST_TWO_BUCKETS = "LAST_TWO_BUCKETS";
    public static final String DUE_DATE_DAYS = "DUE_DATE_DAYS";
    public static final String NOTIFICATION_DAYS = "NOTIFICATION_DAYS";
    public static final String OBJECT_CODES = "OBJECT_CODES";
    public static final String OBJECT_CONSOLIDATIONS = "OBJECT_CONSOLIDATIONS";
    public static final String OBJECT_LEVELS = "OBJECT_LEVELS";
    public static final String PRORATE_BILL_IND = "PRORATE_BILL_IND";
    public static final String RECURRENCES = "RECURRENCES";
    public static final String REMIT_TO_ADDRESS_IND = "REMIT_TO_ADDRESS_IND";
    public static final String REMIT_TO_IND = "REMIT_TO_IND";
    public static final String SALES_TAX_ADJUSTMENT_IND = "SALES_TAX_ADJUSTMENT_IND";
    public static final String SALES_TAX_IND = "SALES_TAX_IND";
    public static final String STATE_FINAL_DAYS_PAST_DUE = "STATE_FINAL_DAYS_PAST_DUE";
    public static final String TO_EMAIL = "TO_EMAIL";
    public static final String WRITEOFF_APPROVAL_THRESHOLD = "APPROVAL_THRESHOLD";
    public static final String WRITEOFF_METHOD = "WRITEOFF_METHOD";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private ArParameterConstants() {
    }

    /**
     * This component was added so that the functions using ACCOUNTING_BASIS would work correctly.
     */
    public static class Components {
        public static final String FEDERAL_FINANCIAL_REPORT = "FederalFinancialReport";
    }
}
