/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.batch.vo;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.NormalizedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for customerType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="customerType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerName"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerParentCompanyNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerTypeCode"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerLastActivityDate" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerTaxTypeCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerTaxNbr" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerActiveIndicator"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerPhoneNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customer800PhoneNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerContactName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerContactPhoneNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerFaxNumber" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerBirthDate" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerTaxExemptIndicator" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerCreditLimitAmount" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerCreditApprovedByName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}customerEmailAddress" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/ar/customer}addresses" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "customerType", namespace = XmlConstants.CUSTOMER_NAMESPACE, propOrder = {"customerNumber",
    "customerName", "customerParentCompanyNumber", "customerTypeCode", "customerLastActivityDate",
    "customerTaxTypeCode", "customerTaxNbr", "customerActiveIndicator", "customerPhoneNumber",
    "customer800PhoneNumber", "customerContactName", "customerContactPhoneNumber", "customerBirthDate",
    "customerTaxExemptIndicator", "customerCreditLimitAmount", "customerCreditApprovedByName",
    "customerEmailAddress", "customerAddresses"})
public class CustomerVO {

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerNumber;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE, required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerName;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerParentCompanyNumber;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE, required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerTypeCode;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerLastActivityDate;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerTaxTypeCode;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerTaxNbr;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE, required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerActiveIndicator;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerPhoneNumber;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customer800PhoneNumber;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerContactName;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerContactPhoneNumber;

    // note: this field was not set when the xml load used commons digester method
    // that's why its set now to @XmlTransient
    @XmlTransient
    private String customerFaxNumber;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerBirthDate;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerTaxExemptIndicator;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerCreditLimitAmount;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerCreditApprovedByName;

    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String customerEmailAddress;

    @XmlElementWrapper(name = "addresses")
    @XmlElement(namespace = XmlConstants.CUSTOMER_NAMESPACE, required = true, name = "address")
    private List<CustomerAddressVO> customerAddresses;

    public CustomerVO() {
        customerAddresses = new ArrayList<>();
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(final String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(final String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerParentCompanyNumber() {
        return customerParentCompanyNumber;
    }

    public void setCustomerParentCompanyNumber(final String customerParentCompanyNumber) {
        this.customerParentCompanyNumber = customerParentCompanyNumber;
    }

    public String getCustomerTypeCode() {
        return customerTypeCode;
    }

    public void setCustomerTypeCode(final String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    public String getCustomerLastActivityDate() {
        return customerLastActivityDate;
    }

    public void setCustomerLastActivityDate(final String customerLastActivityDate) {
        this.customerLastActivityDate = customerLastActivityDate;
    }

    public String getCustomerTaxTypeCode() {
        return customerTaxTypeCode;
    }

    public void setCustomerTaxTypeCode(final String customerTaxTypeCode) {
        this.customerTaxTypeCode = customerTaxTypeCode;
    }

    public String getCustomerTaxNbr() {
        return customerTaxNbr;
    }

    public void setCustomerTaxNbr(final String customerTaxNbr) {
        this.customerTaxNbr = customerTaxNbr;
    }

    public String getCustomerActiveIndicator() {
        return customerActiveIndicator;
    }

    public void setCustomerActiveIndicator(final String customerActiveIndicator) {
        this.customerActiveIndicator = customerActiveIndicator;
    }

    public String getCustomerPhoneNumber() {
        return customerPhoneNumber;
    }

    public void setCustomerPhoneNumber(final String customerPhoneNumber) {
        this.customerPhoneNumber = customerPhoneNumber;
    }

    public String getCustomer800PhoneNumber() {
        return customer800PhoneNumber;
    }

    public void setCustomer800PhoneNumber(final String customer800PhoneNumber) {
        this.customer800PhoneNumber = customer800PhoneNumber;
    }

    public String getCustomerContactName() {
        return customerContactName;
    }

    public void setCustomerContactName(final String customerContactName) {
        this.customerContactName = customerContactName;
    }

    public String getCustomerContactPhoneNumber() {
        return customerContactPhoneNumber;
    }

    public void setCustomerContactPhoneNumber(final String customerContactPhoneNumber) {
        this.customerContactPhoneNumber = customerContactPhoneNumber;
    }

    public String getCustomerFaxNumber() {
        return customerFaxNumber;
    }

    public void setCustomerFaxNumber(final String customerFaxNumber) {
        this.customerFaxNumber = customerFaxNumber;
    }

    public String getCustomerBirthDate() {
        return customerBirthDate;
    }

    public void setCustomerBirthDate(final String customerBirthDate) {
        this.customerBirthDate = customerBirthDate;
    }

    public String getCustomerTaxExemptIndicator() {
        return customerTaxExemptIndicator;
    }

    public void setCustomerTaxExemptIndicator(final String customerTaxExemptIndicator) {
        this.customerTaxExemptIndicator = customerTaxExemptIndicator;
    }

    public String getCustomerCreditLimitAmount() {
        return customerCreditLimitAmount;
    }

    public void setCustomerCreditLimitAmount(final String customerCreditLimitAmount) {
        this.customerCreditLimitAmount = customerCreditLimitAmount;
    }

    public String getCustomerCreditApprovedByName() {
        return customerCreditApprovedByName;
    }

    public void setCustomerCreditApprovedByName(final String customerCreditApprovedByName) {
        this.customerCreditApprovedByName = customerCreditApprovedByName;
    }

    public String getCustomerEmailAddress() {
        return customerEmailAddress;
    }

    public void setCustomerEmailAddress(final String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    public List<CustomerAddressVO> getCustomerAddresses() {
        return customerAddresses;
    }

    public void setCustomerAddresses(final List<CustomerAddressVO> customerAddresses) {
        this.customerAddresses = customerAddresses;
    }

    /**
     * This is a convenience method that adds a populated CustomerAddress object directly to the contained ArrayList.
     * <p>
     * It's primarily used by the Customer Load batch process, for each of XML batch file digesting, though it can be
     * used generally.
     * <p>
     * NOTE that it will attempt to wire the parent/child relationship by setting the customerAddress.customerNumber to
     * the customerNumber of 'this', if the number isn't already set.
     *
     * @param customerAddress new customer address
     */
    public void addCustomerAddress(final CustomerAddressVO customerAddress) {
        //  do nothing if passed-in customerAddress is null
        if (customerAddress == null) {
            return;
        }
        //  wire the CustomerNumber to ensure a valid parent/child relationship
        if (StringUtils.isBlank(customerAddress.getCustomerNumber())) {
            if (StringUtils.isNotBlank(customerNumber)) {
                customerAddress.setCustomerNumber(customerNumber);
            }
        }
        customerAddresses.add(customerAddress);
    }

}
