/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.FundGroup;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coa.businessobject.SubFundGroupType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.FiscalYearBasedBusinessObject;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

public class ContractsGrantsInvoiceObjectCode extends PersistableBusinessObjectBase
        implements MutableInactivatable, FiscalYearBasedBusinessObject {

    private Long invoiceObjectCodeIdentifier;
    private Integer universityFiscalYear;

    private String fundGroupCode;
    private String subFundGroupTypeCode;
    private String subFundGroupCode;

    private String chartOfAccountsCode;
    private String receivableFinancialObjectCode;
    private String incomeFinancialObjectCode;

    private boolean active;

    private SystemOptions universityFiscal;
    private FundGroup fundGroup;
    private SubFundGroupType subFundGroupType;
    private SubFundGroup subFundGroup;
    private Chart chart;
    private ObjectCode receivableObjectCode;
    private ObjectCode incomeObjectCode;

    @Override
    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    @Override
    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public Long getInvoiceObjectCodeIdentifier() {
        return invoiceObjectCodeIdentifier;
    }

    public void setInvoiceObjectCodeIdentifier(Long invoiceObjectCodeIdentifier) {
        this.invoiceObjectCodeIdentifier = invoiceObjectCodeIdentifier;
    }

    public String getFundGroupCode() {
        return fundGroupCode;
    }

    public void setFundGroupCode(String fundGroupCode) {
        this.fundGroupCode = fundGroupCode;
    }

    public String getSubFundGroupTypeCode() {
        return subFundGroupTypeCode;
    }

    public void setSubFundGroupTypeCode(String subFundGroupTypeCode) {
        this.subFundGroupTypeCode = subFundGroupTypeCode;
    }

    public String getSubFundGroupCode() {
        return subFundGroupCode;
    }

    public void setSubFundGroupCode(String subFundGroupCode) {
        this.subFundGroupCode = subFundGroupCode;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getReceivableFinancialObjectCode() {
        return receivableFinancialObjectCode;
    }

    public void setReceivableFinancialObjectCode(String receivableFinancialObjectCode) {
        this.receivableFinancialObjectCode = receivableFinancialObjectCode;
    }

    public String getIncomeFinancialObjectCode() {
        return incomeFinancialObjectCode;
    }

    public void setIncomeFinancialObjectCode(String incomeFinancialObjectCode) {
        this.incomeFinancialObjectCode = incomeFinancialObjectCode;
    }

    public SystemOptions getUniversityFiscal() {
        return universityFiscal;
    }

    public void setUniversityFiscal(SystemOptions universityFiscal) {
        this.universityFiscal = universityFiscal;
    }

    public FundGroup getFundGroup() {
        return fundGroup;
    }

    public void setFundGroup(FundGroup fundGroup) {
        this.fundGroup = fundGroup;
    }

    public SubFundGroupType getSubFundGroupType() {
        return subFundGroupType;
    }

    public void setSubFundGroupType(SubFundGroupType subFundGroupType) {
        this.subFundGroupType = subFundGroupType;
    }

    public SubFundGroup getSubFundGroup() {
        return subFundGroup;
    }

    public void setSubFundGroup(SubFundGroup subFundGroup) {
        this.subFundGroup = subFundGroup;
    }

    public Chart getChart() {
        return chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public ObjectCode getReceivableObjectCode() {
        return receivableObjectCode;
    }

    public void setReceivableObjectCode(ObjectCode receivableObjectCode) {
        this.receivableObjectCode = receivableObjectCode;
    }

    public ObjectCode getIncomeObjectCode() {
        return incomeObjectCode;
    }

    public void setIncomeObjectCode(ObjectCode incomeObjectCode) {
        this.incomeObjectCode = incomeObjectCode;
    }
}
