/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import org.kuali.kfs.kim.api.identity.IdentityService;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.module.ar.ArPropertyConstants;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InvoiceRecurrenceLookupableHelperServiceImpl extends KualiLookupableHelperServiceImpl {
    private IdentityService identityService;

    @Override
    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        fieldValues = LookupUtils.mapPrincipalNameToId(
                fieldValues,
                ArPropertyConstants.InvoiceRecurrenceFields.INVOICE_RECURRENCE_INITIATOR_PRINCIPAL_NAME,
                ArPropertyConstants.InvoiceRecurrenceFields.INVOICE_RECURRENCE_INITIATOR_USER_ID,
                identityService
        );

        // the principal could not be mapped, don't perform a search
        if (fieldValues == null) {
            return Collections.emptyList();
        }
        return super.getSearchResultsHelper(fieldValues, unbounded);
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}
