/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;

import java.util.List;

public interface PaymentApplicationAdjustableDocument extends FinancialSystemTransactionalDocument {

    AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader();

    /**
     * @return The number of the document that adjusts this document
     */
    String getAdjustmentDocumentNumber();

    /**
     * @return If this document has been adjusted
     */
    boolean isAdjusted();

    /**
     * @return The total amount of non-AR lines
     */
    KualiDecimal getNonArTotal();

    List<InvoicePaidApplied> getInvoicePaidApplieds();

    List<NonAppliedHolding> getNonAppliedHoldings();
}
