/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.kuali.kfs.sys.rest.presentation.Link;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.util.Objects;
import java.util.StringJoiner;

/**
 * How does this relate to {@link org.kuali.kfs.module.ar.businessobject.NonAppliedHolding} &
 * {@link org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest.NonAppliedHolding}?
 */
public class PaymentApplicationAdjustmentNonAppliedHolding {
    private final String customerName;
    private final String customerNumber;
    private final String customerUrl;
    private final KualiDecimal amount;

    public PaymentApplicationAdjustmentNonAppliedHolding(
            final String customerName,
            final String customerNumber,
            final String customerUrl,
            final KualiDecimal amount
    ) {
        Validate.isTrue(StringUtils.isNotBlank(customerName), "customerName must be supplied");
        Validate.isTrue(StringUtils.isNotBlank(customerNumber), "customerNumber must be supplied");
        Validate.isTrue(StringUtils.isNotBlank(customerUrl), "customerUrl must be supplied");
        // TODO: What kind of validation is needed for 'amount'?
        Validate.isTrue(amount != null, "amount must be supplied");
        this.customerName = customerName;
        this.customerNumber = customerNumber;
        this.customerUrl = customerUrl;
        this.amount = amount;
    }

    public String getCustomerName() {
        return customerName;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public String getCustomerUrl() {
        return customerUrl;
    }

    public KualiDecimal getAmount() {
        return amount;
    }

    // TODO: Feels like this might be out of place. ???
    public Link getCustomerLink() {
        return new Link(customerNumber, customerUrl);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final PaymentApplicationAdjustmentNonAppliedHolding that = (PaymentApplicationAdjustmentNonAppliedHolding) o;
        return customerName.equals(that.customerName) &&
                customerNumber.equals(that.customerNumber) &&
                customerUrl.equals(that.customerUrl) &&
                amount.equals(that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(customerName, customerNumber, customerUrl, amount);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PaymentApplicationAdjustmentNonAppliedHolding.class.getSimpleName() + "[",
                "]")
                .add("amount=" + amount)
                .add("customerName='" + customerName + "'")
                .add("customerNumber='" + customerNumber + "'")
                .add("customerUrl='" + customerUrl + "'")
                .toString();
    }

}
