/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;

import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AdHocRoutingRequest {
    private List<AdHocRouteWorkgroupRequest> groups;
    private List<AdHocRoutePersonRequest> persons;

    public AdHocRoutingRequest(@JsonProperty("groups") List<AdHocRouteWorkgroupRequest> groups,
                               @JsonProperty("persons") List<AdHocRoutePersonRequest> persons
    ) {
        Validate.notNull(groups, "a list of groups must be supplied");
        Validate.notNull(persons, "a list of persons must be supplied");
        this.groups = groups;
        this.persons = persons;
    }

    public List<AdHocRouteWorkgroupRequest> getGroups() {
        return groups;
    }

    public List<AdHocRoutePersonRequest> getPersons() {
        return persons;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AdHocRoutingRequest that = (AdHocRoutingRequest) o;
        return groups.equals(that.groups) && persons.equals(that.persons);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups, persons);
    }
}
