/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.web.struts;

import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.sys.KFSConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * Form class for the Transmit Contracts & Grants Invoices Lookup.
 */
public class TransmitContractsAndGrantsInvoicesLookupForm extends ContractsGrantsReportLookupForm {

    public TransmitContractsAndGrantsInvoicesLookupForm() {
        setHtmlFormAction(ArConstants.Actions.TRANSMIT_CONTRACTS_AND_GRANTS_INVOICES);
    }

    @Override
    public List<ExtraButton> getExtraButtons() {
        List<ExtraButton> buttons = new ArrayList<>();

        // Print button
        ExtraButton printButton = new ExtraButton();
        printButton.setExtraButtonProperty(KFSConstants.DISPATCH_REQUEST_PARAMETER + "." + ArConstants.PRINT_METHOD);
        printButton.setExtraButtonSource("${" + KFSConstants.EXTERNALIZABLE_IMAGES_URL_KEY + "}" +
                ArConstants.TRANSMIT_GENERATE_BUTTON_FILE_NAME);
        printButton.setExtraButtonAltText(ArConstants.TRANSMIT_GENERATE_BUTTON_ALT_TEXT);
        buttons.add(printButton);
        return buttons;
    }

}
