/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.batch;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.ArKeyConstants;
import org.kuali.kfs.module.ar.batch.service.CustomerLoadService;
import org.kuali.kfs.module.ar.batch.vo.CustomerCsvHeaders;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.sys.batch.CsvBatchInputFileTypeBase;

import java.util.List;
import java.util.Map;

public class CustomerLoadCSVInputFileType extends CsvBatchInputFileTypeBase<CustomerCsvHeaders> {

    private static final Logger LOG = LogManager.getLogger();

    private static final String FILE_NAME_PREFIX = "customer_load";
    private static final String FILE_NAME_DELIM = "_";

    private CustomerLoadService customerLoadService;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        return customerLoadService.getFileName(principalName, fileUserIdentifier, FILE_NAME_PREFIX, FILE_NAME_DELIM);
    }

    public String getFileTypeIdentifier() {
        return ArConstants.CustomerLoad.CUSTOMER_CSV_LOAD_FILE_TYPE_IDENTIFIER;
    }

    @Override
    public boolean validate(Object parsedFileContents) {
        List<CustomerDigesterVO> customerVOs = (List<CustomerDigesterVO>) parsedFileContents;
        return customerLoadService.validate(customerVOs);
    }

    public String getTitleKey() {
        return ArKeyConstants.CustomerLoad.MESSAGE_BATCH_UPLOAD_CSV_TITLE_CUSTOMER;
    }

    public void setCustomerLoadService(CustomerLoadService customerLoadService) {
        this.customerLoadService = customerLoadService;
    }

    /**
     * Convert the parsedFileContents object into CustomerDigesterVO for validation
     */
    @Override
    protected Object convertParsedObjectToVO(Object parsedContent) {
        List<CustomerDigesterVO> customerVOs;
        try {
            List<Map<String, String>> parseDataList = (List<Map<String, String>>) parsedContent;
            customerVOs = CustomerLoadCSVBuilder.buildCustomerDigestVO(parseDataList);
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return customerVOs;
    }
}

