/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.datetime.DateTimeService;

import java.sql.Date;

public class AccountsReceivableDocumentHeader extends PersistableBusinessObjectBase implements org.kuali.kfs.integration.ar.AccountsReceivableDocumentHeader {

    private String documentNumber;
    private String customerNumber;
    private String processingChartOfAccountCode;
    private String processingOrganizationCode;
    private Date entryDate;
    private String financialDocumentExplanationText;

    private Customer customer;
    private Chart processingChartOfAccount;
    private Organization processingOrganization;
    private FinancialSystemDocumentHeader documentHeader;

    public String getDocumentNumber() {
        return documentNumber;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public String getCustomerNumber() {
        return StringUtils.upperCase(customerNumber);
    }

    @Override
    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    @Override
    public String getProcessingChartOfAccountCode() {
        return processingChartOfAccountCode;
    }

    @Override
    public void setProcessingChartOfAccountCode(String processingChartOfAccountCode) {
        this.processingChartOfAccountCode = processingChartOfAccountCode;
    }

    @Override
    public String getProcessingOrganizationCode() {
        return processingOrganizationCode;
    }

    @Override
    public void setProcessingOrganizationCode(String processingOrganizationCode) {
        this.processingOrganizationCode = processingOrganizationCode;
    }

    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    public String getFinancialDocumentExplanationText() {
        return financialDocumentExplanationText;
    }

    public void setFinancialDocumentExplanationText(String financialDocumentExplanationText) {
        this.financialDocumentExplanationText = financialDocumentExplanationText;
    }

    public Customer getCustomer() {
        return customer;
    }

    @Deprecated
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Chart getProcessingChartOfAccount() {
        if (processingChartOfAccount == null) {
            if (StringUtils.isNotBlank(getProcessingChartOfAccountCode())) {
                processingChartOfAccount = SpringContext.getBean(ChartService.class).getByPrimaryId(getProcessingChartOfAccountCode());
            }
        }

        return processingChartOfAccount;
    }

    @Deprecated
    public void setProcessingChartOfAccount(Chart processingChartOfAccount) {
        this.processingChartOfAccount = processingChartOfAccount;
    }

    public Organization getProcessingOrganization() {
        if (processingOrganization == null) {
            if (StringUtils.isNotBlank(getProcessingOrganizationCode())
                    && StringUtils.isNotBlank(getProcessingChartOfAccountCode())) {
                processingOrganization = SpringContext.getBean(OrganizationService.class)
                        .getByPrimaryId(getProcessingChartOfAccountCode(), getProcessingOrganizationCode());
            }
        }

        return processingOrganization;
    }

    @Deprecated
    public void setProcessingOrganization(Organization processingOrganization) {
        this.processingOrganization = processingOrganization;
    }

    public FinancialSystemDocumentHeader getDocumentHeader() {
        return documentHeader;
    }

    @Deprecated
    public void setDocumentHeader(FinancialSystemDocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    /**
     * @return a string representation for processing organization
     */
    public String getProcessingChartOfAccCodeAndOrgCode() {
        return getProcessingChartOfAccountCode() + "/" + getProcessingOrganizationCode();
    }

    public String getDocumentStatus() {
        return getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus();
    }

    public String getCreateDate() {
        return SpringContext.getBean(DateTimeService.class).toDateString(getDocumentHeader().getWorkflowDocument()
                .getDateCreated().toDate());
    }

    public String getInitiatorId() {
        return getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
    }
}
