/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

import java.util.ArrayList;
import java.util.List;

/**
 * Defines a Category on Contracts & Grants Invoices.
 */
public class CostCategory extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String categoryCode;
    private String categoryName;
    private boolean indirectCostIndicator;
    private boolean active;
    private Integer categorySortCode;

    private List<CostCategoryObjectCode> objectCodes = new ArrayList<>();
    private List<CostCategoryObjectLevel> objectLevels = new ArrayList<>();
    private List<CostCategoryObjectConsolidation> objectConsolidations = new ArrayList<>();

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isIndirectCostIndicator() {
        return indirectCostIndicator;
    }

    public void setIndirectCostIndicator(boolean indirectCostIndicator) {
        this.indirectCostIndicator = indirectCostIndicator;
    }

    public Integer getCategorySortCode() {
        return categorySortCode;
    }

    public void setCategorySortCode(Integer categorySortCode) {
        this.categorySortCode = categorySortCode;
    }

    public List<CostCategoryObjectCode> getObjectCodes() {
        return objectCodes;
    }

    public void setObjectCodes(List<CostCategoryObjectCode> objectCodes) {
        this.objectCodes = objectCodes;
    }

    public List<CostCategoryObjectLevel> getObjectLevels() {
        return objectLevels;
    }

    public void setObjectLevels(List<CostCategoryObjectLevel> objectLevels) {
        this.objectLevels = objectLevels;
    }

    public List<CostCategoryObjectConsolidation> getObjectConsolidations() {
        return objectConsolidations;
    }

    public void setObjectConsolidations(List<CostCategoryObjectConsolidation> objectConsolidations) {
        this.objectConsolidations = objectConsolidations;
    }

}
