/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch;

import java.util.Date;
import org.kuali.kfs.coreservice.api.parameter.EvaluationOperator;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.api.parameter.ParameterType;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.module.bc.batch.service.GenesisService;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.kfs.sys.context.SpringContext;

public class GenesisBatchStep
extends AbstractStep {
    private GenesisService genesisService;
    private PersistenceStructureService psService;
    private BusinessObjectService boService;
    private static final String RUN_INDICATOR_PARAMETER_NAMESPACE_CODE = "KFS-BC";
    private static final String RUN_INDICATOR_PARAMETER_NAMESPACE_STEP = "GenesisBatchStep";
    private static final String RUN_INDICATOR_PARAMETER_VALUE = "N";
    private static final String RUN_INDICATOR_PARAMETER_ALLOWED = "A";
    private static final String RUN_INDICATOR_PARAMETER_DESCRIPTION = "Tells the job framework whether to run this job or not; set to know because the GenesisBatchJob needs to only be run once after database initialization.";
    private static final String RUN_INDICATOR_PARAMETER_TYPE = "CONFG";
    private static final String RUN_INDICATOR_PARAMETER_APPLICATION_NAMESPACE_CODE = "KFS";

    public boolean execute(String jobName, Date jobRunDate) {
        this.genesisService.genesisStep(BudgetParameterFinder.getBaseFiscalYear());
        this.setInitiatedParameter();
        return true;
    }

    private void setInitiatedParameter() {
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        Parameter runIndicatorParameter = parameterService.getParameter(GenesisBatchStep.class, "RUN_IND");
        if (runIndicatorParameter == null) {
            Parameter.Builder newParameter = Parameter.Builder.create((String)RUN_INDICATOR_PARAMETER_APPLICATION_NAMESPACE_CODE, (String)RUN_INDICATOR_PARAMETER_NAMESPACE_CODE, (String)RUN_INDICATOR_PARAMETER_NAMESPACE_STEP, (String)"RUN_IND", (ParameterType.Builder)ParameterType.Builder.create((String)RUN_INDICATOR_PARAMETER_TYPE));
            newParameter.setValue(RUN_INDICATOR_PARAMETER_VALUE);
            newParameter.setEvaluationOperator(EvaluationOperator.ALLOW);
            newParameter.setDescription(RUN_INDICATOR_PARAMETER_DESCRIPTION);
            parameterService.createParameter(newParameter.build());
        } else {
            Parameter.Builder updatedParameter = Parameter.Builder.create((ParameterContract)runIndicatorParameter);
            updatedParameter.setValue(RUN_INDICATOR_PARAMETER_VALUE);
            parameterService.updateParameter(updatedParameter.build());
        }
    }

    public void setGenesisService(GenesisService genesisService) {
        this.genesisService = genesisService;
    }

    public void setPersistenceStructureService(PersistenceStructureService psService) {
        this.psService = psService;
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }
}

