/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.integration.ld.LaborLedgerPositionObjectBenefit;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.util.SalarySettingCalculator;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class PendingBudgetConstructionGeneralLedger
extends PersistableBusinessObjectBase {
    private String documentNumber;
    private Integer universityFiscalYear;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialBalanceTypeCode;
    private String financialObjectTypeCode;
    private KualiInteger accountLineAnnualBalanceAmount;
    private KualiInteger financialBeginningBalanceLineAmount;
    private BudgetConstructionHeader budgetConstructionHeader;
    private ObjectCode financialObject;
    private Chart chartOfAccounts;
    private Account account;
    private SubAccount subAccount;
    private SubObjectCode financialSubObject;
    private BalanceType balanceType;
    private ObjectType objectType;
    private List<BudgetConstructionMonthly> budgetConstructionMonthly = new ArrayList<BudgetConstructionMonthly>();
    private LaborLedgerObject laborObject;
    private List<LaborLedgerPositionObjectBenefit> positionObjectBenefit;
    private KualiDecimal adjustmentAmount;
    private KualiDecimal percentChange;
    private KualiInteger persistedAccountLineAnnualBalanceAmount;
    private boolean pendingBudgetConstructionAppointmentFundingExists;

    public KualiDecimal getAdjustmentAmount() {
        return this.adjustmentAmount;
    }

    public void setAdjustmentAmount(KualiDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public KualiDecimal getPercentChange() {
        KualiInteger baseAmount = this.getFinancialBeginningBalanceLineAmount();
        KualiInteger requestedAmount = this.getAccountLineAnnualBalanceAmount();
        return SalarySettingCalculator.getPercentChange(baseAmount, requestedAmount);
    }

    public void setPercentChange(KualiDecimal percentChange) {
        this.percentChange = percentChange;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getFinancialBalanceTypeCode() {
        return this.financialBalanceTypeCode;
    }

    public void setFinancialBalanceTypeCode(String financialBalanceTypeCode) {
        this.financialBalanceTypeCode = financialBalanceTypeCode;
    }

    public String getFinancialObjectTypeCode() {
        return this.financialObjectTypeCode;
    }

    public void setFinancialObjectTypeCode(String financialObjectTypeCode) {
        this.financialObjectTypeCode = financialObjectTypeCode;
    }

    public KualiInteger getAccountLineAnnualBalanceAmount() {
        if (this.accountLineAnnualBalanceAmount == null) {
            this.accountLineAnnualBalanceAmount = KualiInteger.ZERO;
        }
        return this.accountLineAnnualBalanceAmount;
    }

    public void setAccountLineAnnualBalanceAmount(KualiInteger accountLineAnnualBalanceAmount) {
        this.accountLineAnnualBalanceAmount = accountLineAnnualBalanceAmount;
    }

    public KualiInteger getPersistedAccountLineAnnualBalanceAmount() {
        return this.persistedAccountLineAnnualBalanceAmount;
    }

    public void setPersistedAccountLineAnnualBalanceAmount(KualiInteger persistedAccountLineAnnualBalanceAmount) {
        this.persistedAccountLineAnnualBalanceAmount = persistedAccountLineAnnualBalanceAmount;
    }

    public KualiInteger getFinancialBeginningBalanceLineAmount() {
        return this.financialBeginningBalanceLineAmount;
    }

    public void setFinancialBeginningBalanceLineAmount(KualiInteger financialBeginningBalanceLineAmount) {
        this.financialBeginningBalanceLineAmount = financialBeginningBalanceLineAmount;
    }

    public List<BudgetConstructionMonthly> getBudgetConstructionMonthly() {
        return this.budgetConstructionMonthly;
    }

    public void setBudgetConstructionMonthly(List<BudgetConstructionMonthly> budgetConstructionMonthly) {
        this.budgetConstructionMonthly = budgetConstructionMonthly;
    }

    public ObjectCode getFinancialObject() {
        return this.financialObject;
    }

    public void setFinancialObject(ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public SubObjectCode getFinancialSubObject() {
        return this.financialSubObject;
    }

    public void setFinancialSubObject(SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public BalanceType getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(BalanceType balanceType) {
        this.balanceType = balanceType;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public BudgetConstructionHeader getBudgetConstructionHeader() {
        return this.budgetConstructionHeader;
    }

    public void setBudgetConstructionHeader(BudgetConstructionHeader budgetConstructionHeader) {
        this.budgetConstructionHeader = budgetConstructionHeader;
    }

    public LaborLedgerObject getLaborObject() {
        this.laborObject = (LaborLedgerObject)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(LaborLedgerObject.class).retrieveExternalizableBusinessObjectIfNecessary((BusinessObject)this, (ExternalizableBusinessObject)this.laborObject, "laborObject");
        return this.laborObject;
    }

    public void setLaborObject(LaborLedgerObject laborObject) {
        this.laborObject = laborObject;
    }

    public List<LaborLedgerPositionObjectBenefit> getPositionObjectBenefit() {
        this.positionObjectBenefit = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(LaborLedgerPositionObjectBenefit.class).retrieveExternalizableBusinessObjectsList((BusinessObject)this, "positionObjectBenefit", LaborLedgerPositionObjectBenefit.class);
        return this.positionObjectBenefit;
    }

    public void setPositionObjectBenefit(List<LaborLedgerPositionObjectBenefit> positionObjectBenefit) {
        this.positionObjectBenefit = positionObjectBenefit;
    }

    public boolean isPendingBudgetConstructionAppointmentFundingExists() {
        this.pendingBudgetConstructionAppointmentFundingExists = false;
        if (this.getLaborObject() != null && this.getLaborObject().isDetailPositionRequiredIndicator()) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("universityFiscalYear", this.getUniversityFiscalYear());
            fieldValues.put("chartOfAccountsCode", this.getChartOfAccountsCode());
            fieldValues.put("accountNumber", this.getAccountNumber());
            fieldValues.put("subAccountNumber", this.getSubAccountNumber());
            fieldValues.put("financialObjectCode", this.getFinancialObjectCode());
            fieldValues.put("financialSubObjectCode", this.getFinancialSubObjectCode());
            int recCount = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).countMatching(PendingBudgetConstructionAppointmentFunding.class, fieldValues);
            this.pendingBudgetConstructionAppointmentFundingExists = recCount > 0;
        }
        return this.pendingBudgetConstructionAppointmentFundingExists;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (this.universityFiscalYear != null) {
            m.put("universityFiscalYear", this.universityFiscalYear.toString());
        }
        m.put("documentNumber", this.getDocumentNumber());
        m.put("chartOfAccountsCode", this.getChartOfAccountsCode());
        m.put("accountNumber", this.getAccountNumber());
        m.put("subAccountNumber", this.getSubAccountNumber());
        m.put("financialObjectCode", this.getFinancialObjectCode());
        m.put("financialSubObjectCode", this.getFinancialSubObjectCode());
        m.put("financialBalanceTypeCode", this.getFinancialBalanceTypeCode());
        m.put("financialObjectTypeCode", this.getFinancialObjectTypeCode());
        return m;
    }

    public Map<String, Object> getValuesMap() {
        Map<String, Object> simpleValues = this.buildPrimaryKeyMap();
        return simpleValues;
    }

    public Map<String, Object> buildPrimaryKeyMap() {
        return ObjectUtil.buildPropertyMap((Object)((Object)this), PendingBudgetConstructionGeneralLedger.getPrimaryKeyFields());
    }

    public static List<String> getPrimaryKeyFields() {
        ArrayList<String> primaryKeyFields = new ArrayList<String>();
        primaryKeyFields.add("documentNumber");
        primaryKeyFields.add("universityFiscalYear");
        primaryKeyFields.add("chartOfAccountsCode");
        primaryKeyFields.add("accountNumber");
        primaryKeyFields.add("subAccountNumber");
        primaryKeyFields.add("financialObjectCode");
        primaryKeyFields.add("financialSubObjectCode");
        primaryKeyFields.add("financialBalanceTypeCode");
        primaryKeyFields.add("financialObjectTypeCode");
        return primaryKeyFields;
    }
}

