/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionFundingLock;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockSummary;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class LockMonitorLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private ConfigurationService kualiConfigurationService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        ArrayList<BudgetConstructionLockSummary> results = new ArrayList<BudgetConstructionLockSummary>();
        String lockUserID = fieldValues.get("lockUserId");
        String lockUnivId = this.getUniversalIdFromNetworkID(lockUserID);
        this.getAccountLocks(results, lockUnivId);
        this.getTransactionLocks(results, lockUnivId);
        this.getOrphanFundingLocks(results, lockUnivId);
        this.getPositionFundingLocks(results, lockUnivId);
        this.getOrphanPositionLocks(results, lockUnivId);
        return new CollectionIncomplete(results, new Long(0L));
    }

    protected void getAccountLocks(List<BudgetConstructionLockSummary> results, String lockUnivId) {
        List<BudgetConstructionHeader> accountLocks = ((LockService)SpringContext.getBean(LockService.class)).getAllAccountLocks(lockUnivId);
        for (BudgetConstructionHeader header : accountLocks) {
            BudgetConstructionLockSummary lockSummary = new BudgetConstructionLockSummary();
            lockSummary.setLockType("account lock");
            lockSummary.setLockUserId(header.getBudgetLockUser().getPrincipalName());
            lockSummary.setDocumentNumber(header.getDocumentNumber());
            lockSummary.setUniversityFiscalYear(header.getUniversityFiscalYear());
            lockSummary.setChartOfAccountsCode(header.getChartOfAccountsCode());
            lockSummary.setAccountNumber(header.getAccountNumber());
            lockSummary.setSubAccountNumber(header.getSubAccountNumber());
            results.add(lockSummary);
        }
    }

    protected void getTransactionLocks(List<BudgetConstructionLockSummary> results, String lockUnivId) {
        List<BudgetConstructionHeader> transLocks = ((LockService)SpringContext.getBean(LockService.class)).getAllTransactionLocks(lockUnivId);
        for (BudgetConstructionHeader header : transLocks) {
            BudgetConstructionLockSummary lockSummary = new BudgetConstructionLockSummary();
            lockSummary.setLockType("transaction lock");
            lockSummary.setLockUserId(header.getBudgetTransactionLockUser().getPrincipalName());
            lockSummary.setDocumentNumber(header.getDocumentNumber());
            lockSummary.setUniversityFiscalYear(header.getUniversityFiscalYear());
            lockSummary.setChartOfAccountsCode(header.getChartOfAccountsCode());
            lockSummary.setAccountNumber(header.getAccountNumber());
            lockSummary.setSubAccountNumber(header.getSubAccountNumber());
            results.add(lockSummary);
        }
    }

    protected void getOrphanFundingLocks(List<BudgetConstructionLockSummary> results, String lockUnivId) {
        List<BudgetConstructionFundingLock> fundingLocks = ((LockService)SpringContext.getBean(LockService.class)).getOrphanedFundingLocks(lockUnivId);
        for (BudgetConstructionFundingLock fundingLock : fundingLocks) {
            BudgetConstructionLockSummary lockSummary = new BudgetConstructionLockSummary();
            lockSummary.setLockType("orphan funding lock");
            lockSummary.setLockUserId(fundingLock.getAppointmentFundingLockUser().getPrincipalName());
            lockSummary.setUniversityFiscalYear(fundingLock.getUniversityFiscalYear());
            lockSummary.setChartOfAccountsCode(fundingLock.getChartOfAccountsCode());
            lockSummary.setAccountNumber(fundingLock.getAccountNumber());
            lockSummary.setSubAccountNumber(fundingLock.getSubAccountNumber());
            results.add(lockSummary);
        }
    }

    protected void getPositionFundingLocks(List<BudgetConstructionLockSummary> results, String lockUnivId) {
        List<PendingBudgetConstructionAppointmentFunding> positionFundingLocks = ((LockService)SpringContext.getBean(LockService.class)).getAllPositionFundingLocks(lockUnivId);
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : positionFundingLocks) {
            BudgetConstructionLockSummary lockSummary = new BudgetConstructionLockSummary();
            lockSummary.setLockType("position/funding lock");
            lockSummary.setLockUserId(appointmentFunding.getBudgetConstructionPosition().getPositionLockUser().getPrincipalName());
            lockSummary.setUniversityFiscalYear(appointmentFunding.getUniversityFiscalYear());
            lockSummary.setChartOfAccountsCode(appointmentFunding.getChartOfAccountsCode());
            lockSummary.setAccountNumber(appointmentFunding.getAccountNumber());
            lockSummary.setSubAccountNumber(appointmentFunding.getSubAccountNumber());
            lockSummary.setPositionNumber(appointmentFunding.getBudgetConstructionPosition().getPositionNumber());
            lockSummary.setPositionDescription(appointmentFunding.getBudgetConstructionPosition().getPositionDescription());
            results.add(lockSummary);
        }
    }

    protected void getOrphanPositionLocks(List<BudgetConstructionLockSummary> results, String lockUnivId) {
        List<BudgetConstructionPosition> positionLocks = ((LockService)SpringContext.getBean(LockService.class)).getOrphanedPositionLocks(lockUnivId);
        for (BudgetConstructionPosition position : positionLocks) {
            BudgetConstructionLockSummary lockSummary = new BudgetConstructionLockSummary();
            lockSummary.setLockType("position lock");
            lockSummary.setLockUserId(position.getPositionLockUser().getPrincipalName());
            lockSummary.setUniversityFiscalYear(position.getUniversityFiscalYear());
            lockSummary.setPositionNumber(position.getPositionNumber());
            lockSummary.setPositionDescription(position.getPositionDescription());
            results.add(lockSummary);
        }
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        BudgetConstructionLockSummary lockSummary = (BudgetConstructionLockSummary)businessObject;
        String imageDirectory = this.kualiConfigurationService.getPropertyValueAsString("externalizable.images.url");
        String lockFields = lockSummary.getUniversityFiscalYear() + "!" + lockSummary.getChartOfAccountsCode() + "!" + lockSummary.getAccountNumber() + "!" + lockSummary.getSubAccountNumber() + "!" + lockSummary.getPositionNumber() + "!";
        lockFields = StringUtils.replace((String)lockFields, (String)"null", (String)"");
        String name = "methodToCall.unlock.";
        name = name + "(((" + StringUtils.replace((String)lockSummary.getLockType(), (String)" ", (String)"_") + ")))";
        name = name + "((~" + lockFields + "~))";
        name = name + "((<" + lockSummary.getLockUserId() + ">))";
        String src = imageDirectory + "tinybutton-unlock.gif";
        String inputType = "image";
        String styleClass = "tinybutton";
        String border = "0";
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        HtmlData.InputHtmlData inputHtmlData = new HtmlData.InputHtmlData(name, inputType, src);
        inputHtmlData.setStyleClass(styleClass);
        inputHtmlData.setBorder(border);
        htmlDataList.add((HtmlData)inputHtmlData);
        return htmlDataList;
    }

    protected String getUniversalIdFromNetworkID(String networkID) {
        String universalId = null;
        if (StringUtils.isNotBlank((String)networkID)) {
            Principal user = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(networkID);
            if (user != null) {
                universalId = user.getPrincipalId();
            } else {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.lock.invalidUser", new String[]{networkID});
            }
        }
        return universalId;
    }

    public HtmlData getReturnUrl(BusinessObject businessObject, LookupForm lookupForm, List pkNames, BusinessObjectRestrictions businessObjectRestrictions) {
        return this.getEmptyAnchorHtmlData();
    }

    public void validateSearchParameters(Map fieldValues) {
    }

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        HtmlData.AnchorHtmlData inquiryUrl = (HtmlData.AnchorHtmlData)super.getInquiryUrl(bo, propertyName);
        inquiryUrl.setHref(StringUtils.replace((String)inquiryUrl.getHref(), (String)"inquiry.do", (String)"kr/inquiry.do"));
        return inquiryUrl;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

