/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgReasonStatisticsReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionReportThresholdSettings;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSalaryTotal;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionReasonStatisticsReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReasonStatisticsReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.report.BudgetConstructionReportHelper;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionReasonStatisticsReportServiceImpl
implements BudgetConstructionReasonStatisticsReportService {
    protected BudgetConstructionReasonStatisticsReportDao budgetConstructionReasonStatisticsReportDao;
    protected BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService;
    protected BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper;
    protected ConfigurationService kualiConfigurationService;
    protected BusinessObjectService businessObjectService;
    protected PersistenceService persistenceServiceOjb;

    @Override
    public void updateReasonStatisticsReport(String principalName, Integer universityFiscalYear, BudgetConstructionReportThresholdSettings budgetConstructionReportThresholdSettings) {
        boolean applyAThreshold = budgetConstructionReportThresholdSettings.isUseThreshold();
        boolean selectOnlyGreaterThanOrEqualToThreshold = budgetConstructionReportThresholdSettings.isUseGreaterThanOperator();
        KualiDecimal thresholdPercent = budgetConstructionReportThresholdSettings.getThresholdPercent();
        if (applyAThreshold) {
            this.budgetConstructionReasonStatisticsReportDao.updateReasonStatisticsReportsWithAThreshold(principalName, universityFiscalYear - 1, selectOnlyGreaterThanOrEqualToThreshold, thresholdPercent);
        } else {
            this.budgetConstructionReasonStatisticsReportDao.updateReasonStatisticsReportsWithoutAThreshold(principalName, universityFiscalYear - 1);
        }
    }

    @Override
    public Collection<BudgetConstructionOrgReasonStatisticsReport> buildReports(Integer universityFiscalYear, String principalId, BudgetConstructionReportThresholdSettings budgetConstructionReportThresholdSettings) {
        ArrayList<BudgetConstructionOrgReasonStatisticsReport> reportSet = new ArrayList<BudgetConstructionOrgReasonStatisticsReport>();
        this.persistenceServiceOjb.clearCache();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalId);
        List<String> orderList = this.buildOrderByList();
        List reasonStatisticsList = this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(BudgetConstructionSalaryTotal.class, searchCriteria, orderList);
        String objectCodes = this.budgetConstructionReportsServiceHelper.getSelectedObjectCodes(principalId);
        String reasonCodes = this.budgetConstructionReportsServiceHelper.getSelectedReasonCodes(principalId);
        for (BudgetConstructionSalaryTotal reasonStatisticsEntry : reasonStatisticsList) {
            BudgetConstructionOrgReasonStatisticsReport orgReasonStatisticsReportEntry = new BudgetConstructionOrgReasonStatisticsReport();
            this.buildReportsHeader(universityFiscalYear, objectCodes, reasonCodes, orgReasonStatisticsReportEntry, reasonStatisticsEntry, budgetConstructionReportThresholdSettings);
            this.buildReportsBody(orgReasonStatisticsReportEntry, reasonStatisticsEntry);
            reportSet.add(orgReasonStatisticsReportEntry);
        }
        return reportSet;
    }

    public void buildReportsHeader(Integer universityFiscalYear, String objectCodes, String reasonCodes, BudgetConstructionOrgReasonStatisticsReport orgReasonStatisticsReportEntry, BudgetConstructionSalaryTotal salaryTotalEntry, BudgetConstructionReportThresholdSettings budgetConstructionReportThresholdSettings) {
        Integer prevFiscalyear = universityFiscalYear - 1;
        orgReasonStatisticsReportEntry.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("chartOfAccountsCode", salaryTotalEntry.getOrganizationChartOfAccountsCode());
        Chart chart = (Chart)this.businessObjectService.findByPrimaryKey(Chart.class, searchCriteria);
        String orgName = salaryTotalEntry.getOrganization().getOrganizationName();
        orgReasonStatisticsReportEntry.setOrganizationCode(salaryTotalEntry.getOrganizationCode());
        if (orgName == null) {
            orgReasonStatisticsReportEntry.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            orgReasonStatisticsReportEntry.setOrganizationName(orgName);
        }
        if (chart == null) {
            orgReasonStatisticsReportEntry.setChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
            orgReasonStatisticsReportEntry.setChartOfAccountsCode(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgReasonStatisticsReportEntry.setChartOfAccountsCode(chart.getChartOfAccountsCode());
            orgReasonStatisticsReportEntry.setChartOfAccountDescription(chart.getFinChartOfAccountDescription());
        }
        Integer prevPrevFiscalyear = prevFiscalyear - 1;
        orgReasonStatisticsReportEntry.setObjectCodes(objectCodes);
        if (budgetConstructionReportThresholdSettings.isUseThreshold()) {
            if (budgetConstructionReportThresholdSettings.isUseGreaterThanOperator()) {
                orgReasonStatisticsReportEntry.setThresholdOrReason("Threshold: greater then or equal to " + budgetConstructionReportThresholdSettings.getThresholdPercent().toString() + "%");
            } else {
                orgReasonStatisticsReportEntry.setThresholdOrReason("Threshold: less than or equal to " + budgetConstructionReportThresholdSettings.getThresholdPercent().toString() + "%");
            }
        } else {
            orgReasonStatisticsReportEntry.setThresholdOrReason("Selected Reasons: " + reasonCodes);
        }
    }

    public void buildReportsBody(BudgetConstructionOrgReasonStatisticsReport orgReasonStatisticsReportEntry, BudgetConstructionSalaryTotal salaryTotalEntry) {
        orgReasonStatisticsReportEntry.setInitialRequestedFteQuantity(salaryTotalEntry.getInitialRequestedFteQuantity());
        orgReasonStatisticsReportEntry.setTotalInitialRequestedAmount(BudgetConstructionReportHelper.convertKualiInteger(salaryTotalEntry.getInitialRequestedAmount()));
        BigDecimal averageAmount = BudgetConstructionReportHelper.calculateDivide(salaryTotalEntry.getInitialRequestedAmount().bigDecimalValue(), salaryTotalEntry.getInitialRequestedFteQuantity());
        orgReasonStatisticsReportEntry.setTotalAverageAmount(BudgetConstructionReportHelper.setDecimalDigit(averageAmount, 0, false).intValue());
        BigDecimal requestedFteQuantity = salaryTotalEntry.getAppointmentRequestedFteQuantity().setScale(5, 4);
        orgReasonStatisticsReportEntry.setAppointmentRequestedFteQuantity(requestedFteQuantity);
        orgReasonStatisticsReportEntry.setTotalCsfAmount(BudgetConstructionReportHelper.convertKualiInteger(salaryTotalEntry.getCsfAmount()));
        orgReasonStatisticsReportEntry.setTotalAppointmentRequestedAmount(BudgetConstructionReportHelper.convertKualiInteger(salaryTotalEntry.getAppointmentRequestedAmount()));
        BigDecimal csfAmount = new BigDecimal(BudgetConstructionReportHelper.convertKualiInteger(salaryTotalEntry.getCsfAmount()));
        BigDecimal averageCsfAmount = BudgetConstructionReportHelper.calculateDivide(csfAmount, salaryTotalEntry.getAppointmentRequestedFteQuantity());
        orgReasonStatisticsReportEntry.setAverageCsfAmount(BudgetConstructionReportHelper.setDecimalDigit(averageCsfAmount, 0, false));
        BigDecimal appointmentRequestedAmount = new BigDecimal(BudgetConstructionReportHelper.convertKualiInteger(salaryTotalEntry.getAppointmentRequestedAmount()));
        BigDecimal averageRequestedAmount = BudgetConstructionReportHelper.calculateDivide(appointmentRequestedAmount, requestedFteQuantity);
        orgReasonStatisticsReportEntry.setAverageAppointmentRequestedAmount(BudgetConstructionReportHelper.setDecimalDigit(averageRequestedAmount, 0, false));
        orgReasonStatisticsReportEntry.setAverageChange(orgReasonStatisticsReportEntry.getAverageAppointmentRequestedAmount().subtract(orgReasonStatisticsReportEntry.getAverageCsfAmount()));
        orgReasonStatisticsReportEntry.setPercentChange(BudgetConstructionReportHelper.calculatePercent(orgReasonStatisticsReportEntry.getAverageChange(), orgReasonStatisticsReportEntry.getAverageCsfAmount()));
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("organizationChartOfAccountsCode");
        returnList.add("organizationCode");
        return returnList;
    }

    public void setBudgetConstructionReasonStatisticsReportDao(BudgetConstructionReasonStatisticsReportDao budgetConstructionReasonStatisticsReportDao) {
        this.budgetConstructionReasonStatisticsReportDao = budgetConstructionReasonStatisticsReportDao;
    }

    public void setBudgetConstructionOrganizationReportsService(BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService) {
        this.budgetConstructionOrganizationReportsService = budgetConstructionOrganizationReportsService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setBudgetConstructionReportsServiceHelper(BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper) {
        this.budgetConstructionReportsServiceHelper = budgetConstructionReportsServiceHelper;
    }

    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

