/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAdministrativePost;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReason;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReasonCode;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgReasonSummaryReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgReasonSummaryReportTotal;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionReportThresholdSettings;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSalaryFunding;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSalarySocialSecurityNumber;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionSalarySummaryReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReasonSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.report.BudgetConstructionReportHelper;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionReasonSummaryReportServiceImpl
implements BudgetConstructionReasonSummaryReportService {
    private static Logger LOG = Logger.getLogger(BudgetConstructionReasonSummaryReportServiceImpl.class);
    protected BudgetConstructionSalarySummaryReportDao budgetConstructionSalarySummaryReportDao;
    protected BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService;
    protected BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper;
    protected ConfigurationService kualiConfigurationService;
    protected BusinessObjectService businessObjectService;

    @Override
    public void updateReasonSummaryReport(String principalId, Integer universityFiscalYear, BudgetConstructionReportThresholdSettings budgetConstructionReportThresholdSettings) {
        boolean selectOnlyGreaterThanOrEqualToThreshold = budgetConstructionReportThresholdSettings.isUseGreaterThanOperator();
        KualiDecimal thresholdPercent = budgetConstructionReportThresholdSettings.getThresholdPercent();
        boolean applyAThreshold = budgetConstructionReportThresholdSettings.isUseThreshold();
        if (applyAThreshold) {
            this.budgetConstructionSalarySummaryReportDao.updateSalaryAndReasonSummaryReportsWithThreshold(principalId, universityFiscalYear - 1, selectOnlyGreaterThanOrEqualToThreshold, thresholdPercent);
        } else {
            this.budgetConstructionSalarySummaryReportDao.updateSalaryAndReasonSummaryReportsWithoutThreshold(principalId, true);
        }
    }

    @Override
    public Collection<BudgetConstructionOrgReasonSummaryReport> buildReports(Integer universityFiscalYear, String principalId, BudgetConstructionReportThresholdSettings reportThresholdSettings) {
        ArrayList<BudgetConstructionOrgReasonSummaryReport> reportSet = new ArrayList<BudgetConstructionOrgReasonSummaryReport>();
        Collection bcSalarySsnList = this.budgetConstructionReportsServiceHelper.getDataForBuildingReports(BudgetConstructionSalarySocialSecurityNumber.class, principalId, this.buildOrderByList());
        HashMap<BudgetConstructionSalarySocialSecurityNumber, Collection<BudgetConstructionSalaryFunding>> salaryFundingMap = new HashMap<BudgetConstructionSalarySocialSecurityNumber, Collection<BudgetConstructionSalaryFunding>>();
        for (BudgetConstructionSalarySocialSecurityNumber ssnEntry : bcSalarySsnList) {
            Collection<BudgetConstructionSalaryFunding> salaryFundingList = this.budgetConstructionReportsServiceHelper.getSalaryFunding(principalId, ssnEntry.getEmplid());
            salaryFundingMap.put(ssnEntry, salaryFundingList);
        }
        List listForCalculateTotalPerson = this.deleteDuplicated((List)bcSalarySsnList, 1);
        List listForCalculateTotalOrg = this.deleteDuplicated((List)bcSalarySsnList, 2);
        Collection<BudgetConstructionOrgReasonSummaryReportTotal> reasonSummaryTotalPerson = this.calculatePersonTotal(universityFiscalYear, bcSalarySsnList, listForCalculateTotalPerson, salaryFundingMap);
        Collection<BudgetConstructionOrgReasonSummaryReportTotal> reasonSummaryTotalOrg = this.calculateOrgTotal(reasonSummaryTotalPerson, listForCalculateTotalOrg, salaryFundingMap);
        String objectCodes = this.budgetConstructionReportsServiceHelper.getSelectedObjectCodes(principalId);
        String reasonCodes = this.budgetConstructionReportsServiceHelper.getSelectedReasonCodes(principalId);
        for (BudgetConstructionSalarySocialSecurityNumber ssnEntry : bcSalarySsnList) {
            Collection salaryFundingList = (Collection)salaryFundingMap.get((Object)ssnEntry);
            for (BudgetConstructionSalaryFunding salaryFundingEntry : salaryFundingList) {
                BudgetConstructionOrgReasonSummaryReport reasonSummaryReport = new BudgetConstructionOrgReasonSummaryReport();
                this.buildReportsHeader(universityFiscalYear, objectCodes, reasonCodes, reasonSummaryReport, salaryFundingEntry, ssnEntry, reportThresholdSettings);
                this.buildReportsBody(universityFiscalYear, reasonSummaryReport, salaryFundingEntry, ssnEntry);
                this.buildReportsTotal(reasonSummaryReport, ssnEntry, reasonSummaryTotalPerson, reasonSummaryTotalOrg);
                reportSet.add(reasonSummaryReport);
            }
        }
        return reportSet;
    }

    public void buildReportsHeader(Integer universityFiscalYear, String objectCodes, String reasonCodes, BudgetConstructionOrgReasonSummaryReport reasonSummaryReport, BudgetConstructionSalaryFunding salaryFundingEntry, BudgetConstructionSalarySocialSecurityNumber bcSSN, BudgetConstructionReportThresholdSettings budgetConstructionReportThresholdSettings) {
        Integer prevFiscalyear = universityFiscalYear - 1;
        reasonSummaryReport.setFiscalYear(prevFiscalyear + "-" + universityFiscalYear.toString().substring(2, 4));
        reasonSummaryReport.setOrganizationCode(bcSSN.getOrganizationCode());
        String organizationName = bcSSN.getOrganization().getOrganizationName();
        if (organizationName == null) {
            String wrongOrganizationName = this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName");
            reasonSummaryReport.setOrganizationName(wrongOrganizationName);
        } else {
            reasonSummaryReport.setOrganizationName(organizationName);
        }
        reasonSummaryReport.setOrgChartOfAccountsCode(bcSSN.getOrganizationChartOfAccountsCode());
        String chartDescription = bcSSN.getOrganizationChartOfAccounts().getFinChartOfAccountDescription();
        if (chartDescription == null) {
            String wrongChartDescription = this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription");
            reasonSummaryReport.setOrgChartOfAccountDescription(wrongChartDescription);
        } else {
            reasonSummaryReport.setOrgChartOfAccountDescription(chartDescription);
        }
        Integer prevPrevFiscalyear = prevFiscalyear - 1;
        reasonSummaryReport.setReqFy(prevFiscalyear + "-" + universityFiscalYear.toString().substring(2, 4));
        reasonSummaryReport.setFinancialObjectCode(salaryFundingEntry.getFinancialObjectCode());
        reasonSummaryReport.setObjectCodes(objectCodes);
        if (budgetConstructionReportThresholdSettings.isUseThreshold()) {
            if (budgetConstructionReportThresholdSettings.isUseGreaterThanOperator()) {
                reasonSummaryReport.setThresholdOrReason("Threshold: greater then or equal to " + budgetConstructionReportThresholdSettings.getThresholdPercent().toString() + "%");
            } else {
                reasonSummaryReport.setThresholdOrReason("Threshold: less than or equal to " + budgetConstructionReportThresholdSettings.getThresholdPercent().toString() + "%");
            }
        } else {
            reasonSummaryReport.setThresholdOrReason("Selected Reasons: " + reasonCodes);
        }
        List<BudgetConstructionAppointmentFundingReason> appointmentFundingReasonList = salaryFundingEntry.getPendingAppointmentFunding().getBudgetConstructionAppointmentFundingReason();
        if (ObjectUtils.isNotNull(appointmentFundingReasonList) && !appointmentFundingReasonList.isEmpty()) {
            BudgetConstructionAppointmentFundingReason appointmentFundingReason = appointmentFundingReasonList.get(0);
            Integer reasonAmount = BudgetConstructionReportHelper.convertKualiInteger(appointmentFundingReason.getAppointmentFundingReasonAmount());
            reasonSummaryReport.setAppointmentFundingReasonAmount(reasonAmount);
            BudgetConstructionAppointmentFundingReasonCode reasonCode = appointmentFundingReason.getAppointmentFundingReason();
            if (ObjectUtils.isNotNull((Object)((Object)reasonCode))) {
                reasonSummaryReport.setAppointmentFundingReasonDescription(reasonCode.getAppointmentFundingReasonDescription());
            }
        }
    }

    public void buildReportsBody(Integer fiscalYear, BudgetConstructionOrgReasonSummaryReport reasonSummaryReport, BudgetConstructionSalaryFunding salaryFundingEntry, BudgetConstructionSalarySocialSecurityNumber salarySSN) {
        BudgetConstructionCalculatedSalaryFoundationTracker csfTracker;
        int curToInt = -1;
        double curFteInt = -1.0;
        PendingBudgetConstructionAppointmentFunding appointmentFunding = salaryFundingEntry.getPendingAppointmentFunding();
        BudgetConstructionIntendedIncumbent intendedIncumbent = this.budgetConstructionReportsServiceHelper.getBudgetConstructionIntendedIncumbent(appointmentFunding);
        if (intendedIncumbent != null) {
            reasonSummaryReport.setIuClassificationLevel(intendedIncumbent.getIuClassificationLevel());
        }
        int nameLength = salarySSN.getName().length();
        reasonSummaryReport.setName(salarySSN.getName().substring(0, nameLength > 35 ? 35 : nameLength));
        BudgetConstructionAdministrativePost administrativePost = this.budgetConstructionReportsServiceHelper.getBudgetConstructionAdministrativePost(appointmentFunding);
        BudgetConstructionPosition budgetConstructionPosition = this.budgetConstructionReportsServiceHelper.getBudgetConstructionPosition(fiscalYear, appointmentFunding);
        reasonSummaryReport.setChartOfAccountsCode(salaryFundingEntry.getChartOfAccountsCode());
        reasonSummaryReport.setAccountNumber(salaryFundingEntry.getAccountNumber());
        reasonSummaryReport.setSubAccountNumber(salaryFundingEntry.getSubAccountNumber());
        reasonSummaryReport.setFinancialSubObjectCode(salaryFundingEntry.getFinancialSubObjectCode());
        if (administrativePost != null) {
            reasonSummaryReport.setAdministrativePost(administrativePost.getAdministrativePost());
        }
        if (budgetConstructionPosition != null) {
            reasonSummaryReport.setPositionNumber(budgetConstructionPosition.getPositionNumber());
            reasonSummaryReport.setNormalWorkMonthsAndiuPayMonths(budgetConstructionPosition.getIuNormalWorkMonths() + "/" + budgetConstructionPosition.getIuPayMonths());
            reasonSummaryReport.setPositionFte(BudgetConstructionReportHelper.setDecimalDigit(budgetConstructionPosition.getPositionFullTimeEquivalency(), 5, false));
            reasonSummaryReport.setPositionSalaryPlanDefault(budgetConstructionPosition.getPositionSalaryPlanDefault());
            reasonSummaryReport.setPositionGradeDefault(budgetConstructionPosition.getPositionGradeDefault());
        }
        if (ObjectUtils.isNotNull((Object)((Object)(csfTracker = appointmentFunding.getEffectiveCSFTracker())))) {
            reasonSummaryReport.setCsfTimePercent(BudgetConstructionReportHelper.setDecimalDigit(csfTracker.getCsfTimePercent(), 2, false));
            reasonSummaryReport.setCsfAmount(csfTracker.getCsfAmount().intValue());
            if (appointmentFunding.getAppointmentRequestedFteQuantity().equals(csfTracker.getCsfFullTimeEmploymentQuantity())) {
                Integer amountChange = appointmentFunding.getAppointmentRequestedAmount().subtract(csfTracker.getCsfAmount()).intValue();
                reasonSummaryReport.setAmountChange(amountChange);
                BigDecimal percentChange = BudgetConstructionReportHelper.calculatePercent(new BigDecimal(amountChange), csfTracker.getCsfAmount().bigDecimalValue());
                reasonSummaryReport.setPercentChange(percentChange);
            }
        }
        if (StringUtils.equals((String)appointmentFunding.getFinancialSubObjectCode(), (String)KFSConstants.getDashFinancialSubObjectCode())) {
            reasonSummaryReport.setFinancialSubObjectCode("");
        } else {
            reasonSummaryReport.setFinancialSubObjectCode(appointmentFunding.getFinancialSubObjectCode());
        }
        reasonSummaryReport.setEmplid(appointmentFunding.getEmplid());
        reasonSummaryReport.setAppointmentFundingDurationCode(appointmentFunding.getAppointmentFundingDurationCode());
        reasonSummaryReport.setAppointmentTotalIntendedAmount(appointmentFunding.getAppointmentTotalIntendedAmount().intValue());
        BigDecimal totalIntendedFteQuantity = BudgetConstructionReportHelper.setDecimalDigit(appointmentFunding.getAppointmentTotalIntendedFteQuantity(), 5, false);
        reasonSummaryReport.setAppointmentTotalIntendedFteQuantity(totalIntendedFteQuantity);
        if (StringUtils.equals((String)appointmentFunding.getAppointmentFundingDurationCode(), (String)"NONE")) {
            reasonSummaryReport.setSalaryAmount(appointmentFunding.getAppointmentRequestedAmount().intValue());
            reasonSummaryReport.setPercentAmount(appointmentFunding.getAppointmentRequestedTimePercent());
            reasonSummaryReport.setSalaryMonths(appointmentFunding.getAppointmentFundingMonth());
        } else {
            reasonSummaryReport.setSalaryAmount(appointmentFunding.getAppointmentRequestedCsfAmount().intValue());
            reasonSummaryReport.setPercentAmount(appointmentFunding.getAppointmentRequestedCsfTimePercent());
            if (budgetConstructionPosition != null) {
                reasonSummaryReport.setSalaryMonths(budgetConstructionPosition.getIuNormalWorkMonths());
            }
        }
        if (appointmentFunding.isAppointmentFundingDeleteIndicator()) {
            reasonSummaryReport.setDeleteBox("*");
        } else {
            reasonSummaryReport.setDeleteBox("");
        }
        if (appointmentFunding.isAppointmentFundingDeleteIndicator()) {
            if (curToInt == -1) {
                curToInt = appointmentFunding.getAppointmentTotalIntendedAmount().intValue();
            } else if (curToInt != appointmentFunding.getAppointmentTotalIntendedAmount().intValue()) {
                reasonSummaryReport.setTiFlag("+");
            }
            if (curFteInt == -1.0) {
                curFteInt = appointmentFunding.getAppointmentTotalIntendedFteQuantity().doubleValue();
            } else if (curFteInt != appointmentFunding.getAppointmentTotalIntendedFteQuantity().doubleValue()) {
                reasonSummaryReport.setTiFlag("+");
            }
        }
    }

    public void buildReportsTotal(BudgetConstructionOrgReasonSummaryReport reasonSummaryReportEntry, BudgetConstructionSalarySocialSecurityNumber ssnEntry, Collection<BudgetConstructionOrgReasonSummaryReportTotal> reasonSummaryTotalPerson, Collection<BudgetConstructionOrgReasonSummaryReportTotal> reasonSummaryTotalOrg) {
        for (BudgetConstructionOrgReasonSummaryReportTotal totalPersonEntry : reasonSummaryTotalPerson) {
            if (this.isSameSsnEntryForTotalPerson(totalPersonEntry.getBudgetConstructionSalarySocialSecurityNumber(), ssnEntry)) {
                reasonSummaryReportEntry.setPersonPositionNumber(totalPersonEntry.getPersonPositionNumber());
                reasonSummaryReportEntry.setPersonFiscalYearTag(totalPersonEntry.getPersonFiscalYearTag());
                reasonSummaryReportEntry.setPersonNormalMonthsAndPayMonths(totalPersonEntry.getPersonCsfNormalMonths().toString() + "/" + totalPersonEntry.getPersonCsfPayMonths().toString());
                reasonSummaryReportEntry.setPersonCsfAmount(totalPersonEntry.getPersonCsfAmount());
                reasonSummaryReportEntry.setPersonCsfPercent(totalPersonEntry.getPersonCsfPercent());
                reasonSummaryReportEntry.setPersonSalaryNormalMonths(totalPersonEntry.getPersonSalaryNormalMonths());
                reasonSummaryReportEntry.setPersonSalaryAmount(totalPersonEntry.getPersonSalaryAmount());
                reasonSummaryReportEntry.setPersonSalaryPercent(totalPersonEntry.getPersonSalaryPercent());
                reasonSummaryReportEntry.setPersonSalaryFte(totalPersonEntry.getPersonSalaryFte());
                reasonSummaryReportEntry.setPersonTiFlag(totalPersonEntry.getPersonTiFlag());
                reasonSummaryReportEntry.setPersonAmountChange(totalPersonEntry.getPersonAmountChange());
                reasonSummaryReportEntry.setPersonPercentChange(totalPersonEntry.getPersonPercentChange());
            }
            for (BudgetConstructionOrgReasonSummaryReportTotal totalOrgEntry : reasonSummaryTotalOrg) {
                if (!this.isSameSsnEntryForTotalOrg(totalOrgEntry.getBudgetConstructionSalarySocialSecurityNumber(), ssnEntry)) continue;
                reasonSummaryReportEntry.setNewFte(totalOrgEntry.getNewFte());
                reasonSummaryReportEntry.setNewTotalAmount(totalOrgEntry.getNewTotalAmount());
                reasonSummaryReportEntry.setConTotalBaseAmount(totalOrgEntry.getConTotalBaseAmount());
                reasonSummaryReportEntry.setConFte(totalOrgEntry.getConFte());
                reasonSummaryReportEntry.setConTotalRequestAmount(totalOrgEntry.getConTotalRequestAmount());
                reasonSummaryReportEntry.setNewAverageAmount(totalOrgEntry.getNewAverageAmount());
                reasonSummaryReportEntry.setConAverageBaseAmount(totalOrgEntry.getConAverageBaseAmount());
                reasonSummaryReportEntry.setConAverageRequestAmount(totalOrgEntry.getConAverageRequestAmount());
                reasonSummaryReportEntry.setConAveragechange(totalOrgEntry.getConAveragechange());
                reasonSummaryReportEntry.setConPercentChange(totalOrgEntry.getConPercentChange());
            }
        }
    }

    protected Collection<BudgetConstructionOrgReasonSummaryReportTotal> calculatePersonTotal(Integer universityFiscalYear, Collection<BudgetConstructionSalarySocialSecurityNumber> bcSalarySsnList, List<BudgetConstructionSalarySocialSecurityNumber> listForCalculateTotalPerson, Map salaryFundingMap) {
        ArrayList<BudgetConstructionOrgReasonSummaryReportTotal> returnCollection = new ArrayList<BudgetConstructionOrgReasonSummaryReportTotal>();
        for (BudgetConstructionSalarySocialSecurityNumber personEntry : listForCalculateTotalPerson) {
            PersonTotalHolder totalsHolder = new PersonTotalHolder();
            totalsHolder.emplid = personEntry.getEmplid();
            for (BudgetConstructionSalarySocialSecurityNumber salaryFundingEntry : bcSalarySsnList) {
                if (!this.isSameSsnEntryForTotalPerson(personEntry, salaryFundingEntry)) continue;
                Collection salaryFundings = (Collection)salaryFundingMap.get((Object)personEntry);
                this.collectPersonTotal(universityFiscalYear, salaryFundings, totalsHolder);
            }
            this.adjustPersonTotal(totalsHolder);
            returnCollection.add(this.createReportTotal(personEntry, totalsHolder));
        }
        return returnCollection;
    }

    protected void adjustPersonTotal(PersonTotalHolder totalsHolder) {
        Integer restatementCsfAmount = 0;
        if (totalsHolder.salaryPayMonth == 0 || totalsHolder.csfPayMonths == 0 || BigDecimal.ZERO.compareTo(totalsHolder.csfPercent) == 0 || totalsHolder.csfNormalMonths == 0) {
            restatementCsfAmount = 0;
        } else {
            BigDecimal salaryMonthPercent = new BigDecimal((double)totalsHolder.salaryNormalMonths.intValue() * 1.0 / (double)totalsHolder.salaryPayMonth.intValue());
            BigDecimal salaryFteQuantity = totalsHolder.salaryPercent.multiply(salaryMonthPercent);
            BigDecimal csfMonthpercent = new BigDecimal((double)totalsHolder.csfNormalMonths.intValue() * 1.0 / (double)totalsHolder.csfPayMonths.intValue());
            BigDecimal csfFteQuantity = totalsHolder.csfPercent.multiply(csfMonthpercent);
            BigDecimal restatementCsfPercent = salaryFteQuantity.divide(csfFteQuantity, 6, 4);
            BigDecimal csfAmount = new BigDecimal(totalsHolder.csfAmount);
            restatementCsfAmount = csfAmount.multiply(restatementCsfPercent).setScale(0, 4).intValue();
        }
        if (totalsHolder.salaryPayMonth == 0) {
            totalsHolder.salaryFte = BigDecimal.ZERO;
        } else {
            BigDecimal salaryFte = totalsHolder.salaryPercent.multiply(new BigDecimal((double)totalsHolder.salaryNormalMonths.intValue() * 1.0 / ((double)totalsHolder.salaryPayMonth.intValue() * 100.0)));
            totalsHolder.salaryFte = BudgetConstructionReportHelper.setDecimalDigit(salaryFte, 5, false);
        }
        if (totalsHolder.salaryPayMonth != totalsHolder.csfPayMonths) {
            if (totalsHolder.csfPayMonths == 0) {
                restatementCsfAmount = 0;
            } else {
                BigDecimal amount = new BigDecimal((double)(restatementCsfAmount * totalsHolder.salaryPayMonth) * 1.0 / (double)totalsHolder.csfPayMonths.intValue());
                restatementCsfAmount = BudgetConstructionReportHelper.setDecimalDigit(amount, 0, false).intValue();
            }
        }
        totalsHolder.csfAmount = restatementCsfAmount;
        totalsHolder.amountChange = totalsHolder.salaryAmount - totalsHolder.csfAmount;
        totalsHolder.percentChange = totalsHolder.csfAmount != 0 ? BudgetConstructionReportHelper.calculatePercent(totalsHolder.amountChange, totalsHolder.csfAmount) : BigDecimal.ZERO;
        totalsHolder.tiFlag = totalsHolder.curToInt != 0 && totalsHolder.curToInt != -1 && totalsHolder.curToInt != totalsHolder.salaryAmount || totalsHolder.curFteInt != 0.0 && totalsHolder.curFteInt != -1.0 && totalsHolder.curFteInt != totalsHolder.salaryFte.doubleValue() ? "+" : "";
    }

    protected void collectPersonTotal(Integer universityFiscalYear, Collection<BudgetConstructionSalaryFunding> salaryFundings, PersonTotalHolder totalsHolder) {
        int maxSalaryAmount = 0;
        int maxCsfAmount = 0;
        for (BudgetConstructionSalaryFunding salaryFunding : salaryFundings) {
            KualiInteger effectiveCsfAmount;
            PendingBudgetConstructionAppointmentFunding appointmentFunding = salaryFunding.getPendingAppointmentFunding();
            BudgetConstructionPosition budgetConstructionPosition = this.budgetConstructionReportsServiceHelper.getBudgetConstructionPosition(universityFiscalYear, appointmentFunding);
            int salaryAmount = 0;
            Integer salaryMonths = 0;
            BigDecimal salaryPercent = BigDecimal.ZERO;
            String durationCode = appointmentFunding.getAppointmentFundingDurationCode();
            if (StringUtils.equals((String)durationCode, (String)"NONE")) {
                salaryAmount = appointmentFunding.getAppointmentRequestedAmount().intValue();
                salaryMonths = appointmentFunding.getAppointmentFundingMonth();
                salaryPercent = appointmentFunding.getAppointmentRequestedTimePercent();
            } else {
                salaryAmount = appointmentFunding.getAppointmentRequestedCsfAmount().intValue();
                salaryMonths = budgetConstructionPosition.getIuNormalWorkMonths();
                boolean hasRequestedCsfTimePercent = appointmentFunding.getAppointmentRequestedCsfTimePercent() != null;
                BigDecimal bigDecimal = salaryPercent = hasRequestedCsfTimePercent ? appointmentFunding.getAppointmentRequestedCsfTimePercent() : BigDecimal.ZERO;
            }
            if (salaryAmount > maxSalaryAmount) {
                maxSalaryAmount = totalsHolder.salaryAmount;
                totalsHolder.salaryPayMonth = budgetConstructionPosition.getIuPayMonths();
                totalsHolder.salaryNormalMonths = salaryMonths;
            }
            PersonTotalHolder hasRequestedCsfTimePercent = totalsHolder;
            Integer.valueOf(hasRequestedCsfTimePercent.salaryAmount + salaryAmount);
            hasRequestedCsfTimePercent.salaryAmount = hasRequestedCsfTimePercent.salaryAmount;
            totalsHolder.salaryPercent = totalsHolder.salaryPercent.add(salaryPercent);
            BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = appointmentFunding.getEffectiveCSFTracker();
            if (csfTracker == null || (effectiveCsfAmount = csfTracker.getCsfAmount()) == null || effectiveCsfAmount.isZero()) continue;
            if (effectiveCsfAmount.intValue() > maxCsfAmount) {
                maxCsfAmount = effectiveCsfAmount.intValue();
            }
            PersonTotalHolder personTotalHolder = totalsHolder;
            Integer.valueOf(personTotalHolder.csfAmount + effectiveCsfAmount.intValue());
            personTotalHolder.csfAmount = personTotalHolder.csfAmount;
            totalsHolder.csfPercent = totalsHolder.csfPercent.add(csfTracker.getCsfTimePercent());
            Integer previousFiscalYear = universityFiscalYear - 1;
            BudgetConstructionPosition previousYearBudgetConstructionPosition = this.budgetConstructionReportsServiceHelper.getBudgetConstructionPosition(previousFiscalYear, appointmentFunding);
            totalsHolder.csfPayMonths = previousYearBudgetConstructionPosition.getIuPayMonths();
            totalsHolder.csfNormalMonths = previousYearBudgetConstructionPosition.getIuNormalWorkMonths();
            totalsHolder.positionNumber = budgetConstructionPosition.getPositionNumber();
            totalsHolder.fiscalYearTag = previousFiscalYear.toString() + ":";
            if (appointmentFunding.isAppointmentFundingDeleteIndicator()) continue;
            if (totalsHolder.curToInt <= -1) {
                totalsHolder.curToInt = appointmentFunding.getAppointmentTotalIntendedAmount().intValue();
            }
            if (!(totalsHolder.curFteInt <= -1.0)) continue;
            totalsHolder.curFteInt = appointmentFunding.getAppointmentTotalIntendedFteQuantity().doubleValue();
        }
    }

    protected Collection<BudgetConstructionOrgReasonSummaryReportTotal> calculateOrgTotal(Collection<BudgetConstructionOrgReasonSummaryReportTotal> reasonSummaryTotalPerson, List<BudgetConstructionSalarySocialSecurityNumber> listForCalculateTotalOrg, Map salaryFundingMap) {
        ArrayList<BudgetConstructionOrgReasonSummaryReportTotal> returnCollection = new ArrayList<BudgetConstructionOrgReasonSummaryReportTotal>();
        for (BudgetConstructionSalarySocialSecurityNumber totalOrgEntry : listForCalculateTotalOrg) {
            BigDecimal averageAmount;
            OrganizationTotalHolder totalsHolder = new OrganizationTotalHolder();
            for (BudgetConstructionOrgReasonSummaryReportTotal reportTotalPersonEntry : reasonSummaryTotalPerson) {
                OrganizationTotalHolder organizationTotalHolder;
                if (!this.isSameSsnEntryForTotalOrg(totalOrgEntry, reportTotalPersonEntry.getBudgetConstructionSalarySocialSecurityNumber())) continue;
                if (reportTotalPersonEntry.getPersonCsfAmount() == 0) {
                    totalsHolder.newFte = totalsHolder.newFte.add(reportTotalPersonEntry.getPersonSalaryFte());
                    organizationTotalHolder = totalsHolder;
                    Integer.valueOf(organizationTotalHolder.newTotalAmount + reportTotalPersonEntry.getPersonSalaryAmount());
                    organizationTotalHolder.newTotalAmount = organizationTotalHolder.newTotalAmount;
                    continue;
                }
                organizationTotalHolder = totalsHolder;
                Integer.valueOf(organizationTotalHolder.conTotalBaseAmount + reportTotalPersonEntry.getPersonCsfAmount());
                organizationTotalHolder.conTotalBaseAmount = organizationTotalHolder.conTotalBaseAmount;
                totalsHolder.conFte = totalsHolder.conFte.add(reportTotalPersonEntry.getPersonSalaryFte());
                organizationTotalHolder = totalsHolder;
                Integer.valueOf(organizationTotalHolder.conTotalRequestAmount + reportTotalPersonEntry.getPersonSalaryAmount());
                organizationTotalHolder.conTotalRequestAmount = organizationTotalHolder.conTotalRequestAmount;
            }
            if (BigDecimal.ZERO.compareTo(totalsHolder.newFte) != 0) {
                averageAmount = BudgetConstructionReportHelper.calculateDivide(new BigDecimal(totalsHolder.newTotalAmount), totalsHolder.newFte);
                totalsHolder.newAverageAmount = BudgetConstructionReportHelper.setDecimalDigit(averageAmount, 0, false).intValue();
            }
            if (BigDecimal.ZERO.compareTo(totalsHolder.conFte) != 0) {
                averageAmount = BudgetConstructionReportHelper.calculateDivide(new BigDecimal(totalsHolder.conTotalBaseAmount), totalsHolder.conFte);
                totalsHolder.conAverageBaseAmount = BudgetConstructionReportHelper.setDecimalDigit(averageAmount, 0, false).intValue();
                BigDecimal averageRequestAmount = BudgetConstructionReportHelper.calculateDivide(new BigDecimal(totalsHolder.conTotalRequestAmount), totalsHolder.conFte);
                totalsHolder.conAverageRequestAmount = BudgetConstructionReportHelper.setDecimalDigit(averageRequestAmount, 0, false).intValue();
            }
            totalsHolder.conAveragechange = totalsHolder.conAverageRequestAmount - totalsHolder.conAverageBaseAmount;
            if (totalsHolder.conAverageBaseAmount != 0) {
                totalsHolder.conPercentChange = BudgetConstructionReportHelper.calculatePercent(totalsHolder.conAveragechange, totalsHolder.conAverageBaseAmount);
            }
            returnCollection.add(this.createReportTotal(totalOrgEntry, totalsHolder));
        }
        return returnCollection;
    }

    protected BudgetConstructionOrgReasonSummaryReportTotal createReportTotal(BudgetConstructionSalarySocialSecurityNumber totalOrgEntry, OrganizationTotalHolder totalsHolder) {
        BudgetConstructionOrgReasonSummaryReportTotal reportTotal = new BudgetConstructionOrgReasonSummaryReportTotal();
        reportTotal.setBudgetConstructionSalarySocialSecurityNumber(totalOrgEntry);
        reportTotal.setNewFte(totalsHolder.newFte);
        reportTotal.setNewTotalAmount(totalsHolder.newTotalAmount);
        reportTotal.setConTotalBaseAmount(totalsHolder.conTotalBaseAmount);
        reportTotal.setConFte(totalsHolder.conFte);
        reportTotal.setConTotalRequestAmount(totalsHolder.conTotalRequestAmount);
        reportTotal.setNewAverageAmount(totalsHolder.newAverageAmount);
        reportTotal.setConAverageBaseAmount(totalsHolder.conAverageBaseAmount);
        reportTotal.setConAverageRequestAmount(totalsHolder.conAverageRequestAmount);
        reportTotal.setConAveragechange(totalsHolder.conAveragechange);
        reportTotal.setConPercentChange(totalsHolder.conPercentChange);
        return reportTotal;
    }

    protected BudgetConstructionOrgReasonSummaryReportTotal createReportTotal(BudgetConstructionSalarySocialSecurityNumber totalPersonEntry, PersonTotalHolder totalsHolder) {
        BudgetConstructionOrgReasonSummaryReportTotal reportTotal = new BudgetConstructionOrgReasonSummaryReportTotal();
        reportTotal.setBudgetConstructionSalarySocialSecurityNumber(totalPersonEntry);
        reportTotal.setPersonPositionNumber(totalsHolder.positionNumber);
        reportTotal.setPersonFiscalYearTag(totalsHolder.fiscalYearTag);
        reportTotal.setPersonCsfNormalMonths(totalsHolder.csfNormalMonths);
        reportTotal.setPersonCsfPayMonths(totalsHolder.csfPayMonths);
        reportTotal.setPersonCsfAmount(totalsHolder.csfAmount);
        reportTotal.setPersonCsfPercent(totalsHolder.csfPercent);
        reportTotal.setPersonSalaryNormalMonths(totalsHolder.salaryNormalMonths);
        reportTotal.setPersonSalaryAmount(totalsHolder.salaryAmount);
        reportTotal.setPersonSalaryPercent(totalsHolder.salaryPercent);
        reportTotal.setPersonSalaryFte(BudgetConstructionReportHelper.setDecimalDigit(totalsHolder.salaryFte, 5, false));
        reportTotal.setPersonTiFlag(totalsHolder.tiFlag);
        reportTotal.setPersonAmountChange(totalsHolder.amountChange);
        reportTotal.setPersonPercentChange(totalsHolder.percentChange);
        return reportTotal;
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("organizationChartOfAccountsCode");
        returnList.add("organizationCode");
        returnList.add("name");
        returnList.add("emplid");
        return returnList;
    }

    protected List deleteDuplicated(List list, int mode) {
        int count = 0;
        BudgetConstructionSalarySocialSecurityNumber ssnEntry = null;
        BudgetConstructionSalarySocialSecurityNumber ssnEntryAux = null;
        ArrayList<BudgetConstructionSalarySocialSecurityNumber> returnList = new ArrayList<BudgetConstructionSalarySocialSecurityNumber>();
        if (list != null && list.size() > 0) {
            ssnEntry = (BudgetConstructionSalarySocialSecurityNumber)((Object)list.get(count));
            ssnEntryAux = (BudgetConstructionSalarySocialSecurityNumber)((Object)list.get(count));
            returnList.add(ssnEntry);
            ++count;
            while (count < list.size()) {
                ssnEntry = (BudgetConstructionSalarySocialSecurityNumber)((Object)list.get(count));
                switch (mode) {
                    case 1: {
                        if (!this.isSameSsnEntryForTotalPerson(ssnEntry, ssnEntryAux)) {
                            returnList.add(ssnEntry);
                            ssnEntryAux = ssnEntry;
                        }
                    }
                    case 2: {
                        if (this.isSameSsnEntryForTotalOrg(ssnEntry, ssnEntryAux)) break;
                        returnList.add(ssnEntry);
                        ssnEntryAux = ssnEntry;
                    }
                }
                ++count;
            }
        }
        return returnList;
    }

    protected boolean isSameSsnEntryForTotalPerson(BudgetConstructionSalarySocialSecurityNumber firstSsn, BudgetConstructionSalarySocialSecurityNumber secondSsn) {
        return firstSsn.getOrganizationChartOfAccountsCode().equals(secondSsn.getOrganizationChartOfAccountsCode()) && firstSsn.getOrganizationCode().equals(secondSsn.getOrganizationCode()) && firstSsn.getEmplid().equals(secondSsn.getEmplid());
    }

    protected boolean isSameSsnEntryForTotalOrg(BudgetConstructionSalarySocialSecurityNumber firstSsn, BudgetConstructionSalarySocialSecurityNumber secondSsn) {
        return firstSsn.getOrganizationChartOfAccountsCode().equals(secondSsn.getOrganizationChartOfAccountsCode()) && firstSsn.getOrganizationCode().equals(secondSsn.getOrganizationCode());
    }

    public void setBudgetConstructionSalarySummaryReportDao(BudgetConstructionSalarySummaryReportDao budgetConstructionSalarySummaryReportDao) {
        this.budgetConstructionSalarySummaryReportDao = budgetConstructionSalarySummaryReportDao;
    }

    public void setBudgetConstructionOrganizationReportsService(BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService) {
        this.budgetConstructionOrganizationReportsService = budgetConstructionOrganizationReportsService;
    }

    public void setBudgetConstructionReportsServiceHelper(BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper) {
        this.budgetConstructionReportsServiceHelper = budgetConstructionReportsServiceHelper;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected class OrganizationTotalHolder {
        BigDecimal newFte = BigDecimal.ZERO;
        Integer newTotalAmount = 0;
        Integer newAverageAmount = 0;
        BigDecimal conFte = BigDecimal.ZERO;
        Integer conTotalBaseAmount = 0;
        Integer conTotalRequestAmount = 0;
        Integer conAverageBaseAmount = 0;
        Integer conAverageRequestAmount = 0;
        Integer conAveragechange = 0;
        BigDecimal conPercentChange = BigDecimal.ZERO;

        protected OrganizationTotalHolder() {
        }
    }

    protected class PersonTotalHolder {
        String emplid = "";
        String positionNumber = "";
        String fiscalYearTag = "";
        String tiFlag = "";
        Integer csfNormalMonths = 0;
        Integer csfPayMonths = 0;
        Integer csfAmount = 0;
        BigDecimal csfPercent = BigDecimal.ZERO;
        Integer salaryNormalMonths = 0;
        Integer salaryPayMonth = 0;
        Integer salaryAmount = 0;
        BigDecimal salaryPercent = BigDecimal.ZERO;
        BigDecimal salaryFte = BigDecimal.ZERO;
        Integer amountChange = 0;
        BigDecimal percentChange = BigDecimal.ZERO;
        int curToInt = -1;
        double curFteInt = -1.0;

        protected PersonTotalHolder() {
        }
    }
}

