/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetParameterService;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;

public class BudgetParameterServiceImpl
implements BudgetParameterService {
    private static final Logger LOG = Logger.getLogger(BudgetParameterService.class);

    @Override
    public BCConstants.AccountSalarySettingOnlyCause isSalarySettingOnlyAccount(BudgetConstructionDocument bcDoc) {
        BCConstants.AccountSalarySettingOnlyCause retVal = BCConstants.AccountSalarySettingOnlyCause.MISSING_PARAM;
        Collection<String> salarySettingFundGroupsParamValues = BudgetParameterFinder.getSalarySettingFundGroups();
        Collection<String> salarySettingSubFundGroupsParamValues = BudgetParameterFinder.getSalarySettingSubFundGroups();
        if (salarySettingFundGroupsParamValues != null && salarySettingSubFundGroupsParamValues != null) {
            retVal = BCConstants.AccountSalarySettingOnlyCause.NONE;
            String fundGroup = bcDoc.getAccount().getSubFundGroup().getFundGroupCode();
            String subfundGroup = bcDoc.getAccount().getSubFundGroup().getSubFundGroupCode();
            if (salarySettingFundGroupsParamValues.contains(fundGroup) && salarySettingSubFundGroupsParamValues.contains(subfundGroup)) {
                retVal = BCConstants.AccountSalarySettingOnlyCause.FUND_AND_SUBFUND;
            } else {
                if (salarySettingFundGroupsParamValues.contains(fundGroup)) {
                    retVal = BCConstants.AccountSalarySettingOnlyCause.FUND;
                }
                if (salarySettingSubFundGroupsParamValues.contains(subfundGroup)) {
                    retVal = BCConstants.AccountSalarySettingOnlyCause.SUBFUND;
                }
            }
        }
        return retVal;
    }

    @Override
    public String getLookupObjectTypes(boolean isRevenue) {
        Collection<String> objectTypes = isRevenue ? BudgetParameterFinder.getRevenueObjectTypes() : BudgetParameterFinder.getExpenditureObjectTypes();
        if (objectTypes.isEmpty()) {
            return "";
        }
        StringBuffer lookupBuilder = new StringBuffer(150);
        boolean isFirst = true;
        for (String ot : objectTypes) {
            if (isFirst) {
                isFirst = false;
            } else {
                lookupBuilder.append('|');
            }
            lookupBuilder.append(ot);
        }
        return lookupBuilder.toString();
    }
}

