/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionObjectPick;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionReasonCodePick;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSubFundPick;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetReportsControlListDao;
import org.kuali.kfs.module.bc.document.service.BudgetReportsControlListService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetReportsControlListServiceImpl
implements BudgetReportsControlListService {
    protected BudgetReportsControlListDao budgetReportsControlListDao;
    protected BusinessObjectService businessObjectService;
    protected PersistenceService persistenceServiceOjb;

    @Override
    public void updateReportsControlList(String principalName, Integer universityFiscalYear, String chartOfAccountsCode, String organizationCode, BCConstants.Report.BuildMode buildMode) {
        this.budgetReportsControlListDao.updateReportControlList(principalName, universityFiscalYear, chartOfAccountsCode, organizationCode, buildMode);
    }

    @Override
    public void updateReportSubFundGroupSelectList(String principalName) {
        this.budgetReportsControlListDao.updateReportsSubFundGroupSelectList(principalName);
    }

    @Override
    public void updateReportObjectCodeSelectList(String principalName) {
        this.budgetReportsControlListDao.updateReportsObjectCodeSelectList(principalName);
    }

    @Override
    public void updateReportReasonCodeSelectList(String principalName) {
        this.budgetReportsControlListDao.updateReportsReasonCodeSelectList(principalName);
    }

    public void setBudgetReportsControlListDao(BudgetReportsControlListDao budgetReportsControlListDao) {
        this.budgetReportsControlListDao = budgetReportsControlListDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public Collection<BudgetConstructionPullup> retrieveSelectedOrganziations(String principalName) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("principalName", principalName);
        criteria.put("pullFlag", new Integer(1));
        return this.businessObjectService.findMatching(BudgetConstructionPullup.class, criteria);
    }

    @Override
    public Collection<BudgetConstructionSubFundPick> retrieveSubFundList(String principalId) {
        this.persistenceServiceOjb.clearCache();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("principalId", principalId);
        return this.businessObjectService.findMatching(BudgetConstructionSubFundPick.class, criteria);
    }

    @Override
    public Collection<BudgetConstructionObjectPick> retrieveObjectCodeList(String principalId) {
        this.persistenceServiceOjb.clearCache();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("principalId", principalId);
        return this.businessObjectService.findMatching(BudgetConstructionObjectPick.class, criteria);
    }

    @Override
    public Collection<BudgetConstructionReasonCodePick> retrieveReasonCodeList(String principalId) {
        this.persistenceServiceOjb.clearCache();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("principalId", principalId);
        return this.businessObjectService.findMatching(BudgetConstructionReasonCodePick.class, criteria);
    }

    @Override
    public void updateObjectCodeSelectFlags(List<BudgetConstructionObjectPick> objectCodePickList) {
        this.budgetReportsControlListDao.updateObjectCodeSelectFlags(objectCodePickList);
    }

    @Override
    public void updateReasonCodeSelectFlags(List<BudgetConstructionReasonCodePick> reasonCodePickList) {
        this.budgetReportsControlListDao.updateReasonCodeSelectFlags(reasonCodePickList);
    }

    @Override
    public void updateSubFundSelectFlags(List<BudgetConstructionSubFundPick> subFundPickList) {
        this.budgetReportsControlListDao.updateSubFundSelectFlags(subFundPickList);
    }

    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

