/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionFundingLock;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionRequestMove;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.dataaccess.ImportRequestDao;
import org.kuali.kfs.module.bc.document.service.BenefitsCalculationService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.BudgetParameterService;
import org.kuali.kfs.module.bc.document.service.BudgetRequestImportService;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.validation.impl.BudgetConstructionRuleUtil;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.module.bc.util.ImportRequestFileParsingHelper;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

public class BudgetRequestImportServiceImpl
implements BudgetRequestImportService {
    protected BusinessObjectService businessObjectService;
    protected ImportRequestDao importRequestDao;
    protected DictionaryValidationService dictionaryValidationService;
    protected LockService lockService;
    protected BudgetDocumentService budgetDocumentService;
    protected LaborModuleService laborModuleService;
    protected BudgetParameterService budgetParameterService;
    protected OptionsService optionsService;
    protected DocumentHelperService documentHelperService;
    protected DocumentService documentService;
    protected ParameterService parameterService;
    protected PersistenceService persistenceServiceOjb;
    private static final Log LOG = LogFactory.getLog(BudgetRequestImportServiceImpl.class);

    @Override
    @NonTransactional
    public void generatePdf(List<String> errorMessages, ByteArrayOutputStream baos) throws DocumentException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)baos);
        document.open();
        for (String error : errorMessages) {
            document.add((Element)new Paragraph(error));
        }
        document.close();
    }

    @Override
    @Transactional
    public List processImportFile(InputStream fileImportStream, String principalId, String fieldSeperator, String textDelimiter, String fileType, Integer budgetYear) throws IOException {
        ArrayList<String> fileErrorList = new ArrayList<String>();
        this.deleteBudgetConstructionMoveRecords(principalId);
        BudgetConstructionRequestMove budgetConstructionRequestMove = new BudgetConstructionRequestMove();
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(fileImportStream));
        int currentLine = 1;
        while (fileReader.ready()) {
            boolean isAnnualFile;
            String line = StringUtils.strip((String)fileReader.readLine());
            boolean bl = isAnnualFile = fileType.equalsIgnoreCase(BCConstants.RequestImportFileType.ANNUAL.toString());
            if (StringUtils.isNotBlank((String)line)) {
                budgetConstructionRequestMove = ImportRequestFileParsingHelper.parseLine(line, fieldSeperator, textDelimiter, isAnnualFile);
                if (budgetConstructionRequestMove == null) {
                    fileErrorList.add("Bad file format at line " + currentLine + ".");
                    this.deleteBudgetConstructionMoveRecords(principalId);
                    return fileErrorList;
                }
                String lineValidationError = this.validateLine(budgetConstructionRequestMove, currentLine, isAnnualFile);
                if (StringUtils.isNotEmpty((String)lineValidationError)) {
                    fileErrorList.add(lineValidationError);
                    this.deleteBudgetConstructionMoveRecords(principalId);
                    return fileErrorList;
                }
                if (StringUtils.isBlank((String)budgetConstructionRequestMove.getSubAccountNumber())) {
                    budgetConstructionRequestMove.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
                }
                if (StringUtils.isBlank((String)budgetConstructionRequestMove.getFinancialSubObjectCode())) {
                    budgetConstructionRequestMove.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
                }
                Collection<String> revenueObjectTypesParamValues = BudgetParameterFinder.getRevenueObjectTypes();
                Collection<String> expenditureObjectTypesParamValues = BudgetParameterFinder.getExpenditureObjectTypes();
                ObjectCode objectCode = this.getObjectCode(budgetConstructionRequestMove, budgetYear);
                if (objectCode != null) {
                    if (expenditureObjectTypesParamValues.contains(objectCode.getFinancialObjectTypeCode())) {
                        budgetConstructionRequestMove.setFinancialObjectTypeCode(objectCode.getFinancialObjectTypeCode());
                    } else if (revenueObjectTypesParamValues.contains(objectCode.getFinancialObjectTypeCode())) {
                        budgetConstructionRequestMove.setFinancialObjectTypeCode(objectCode.getFinancialObjectTypeCode());
                    }
                }
                HashMap<String, String> searchCriteria = new HashMap<String, String>();
                searchCriteria.put("principalId", principalId);
                searchCriteria.put("chartOfAccountsCode", budgetConstructionRequestMove.getChartOfAccountsCode());
                searchCriteria.put("accountNumber", budgetConstructionRequestMove.getAccountNumber());
                searchCriteria.put("subAccountNumber", budgetConstructionRequestMove.getSubAccountNumber());
                searchCriteria.put("financialObjectCode", budgetConstructionRequestMove.getFinancialObjectCode());
                searchCriteria.put("financialSubObjectCode", budgetConstructionRequestMove.getFinancialSubObjectCode());
                if (this.businessObjectService.countMatching(BudgetConstructionRequestMove.class, searchCriteria) != 0) {
                    LOG.error((Object)"Move table store error, import aborted");
                    fileErrorList.add("Duplicate Key for " + budgetConstructionRequestMove.getErrorLinePrefixForLogFile());
                    fileErrorList.add("Move table store error, import aborted");
                    this.deleteBudgetConstructionMoveRecords(principalId);
                    return fileErrorList;
                }
                try {
                    budgetConstructionRequestMove.setPrincipalId(principalId);
                    this.importRequestDao.save((BusinessObject)budgetConstructionRequestMove, false);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)"Move table store error, import aborted");
                    fileErrorList.add("Move table store error, import aborted");
                    return fileErrorList;
                }
            }
            ++currentLine;
        }
        return fileErrorList;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    @Transactional
    public List<String> validateData(Integer budgetYear, String principalId) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalId);
        ArrayList dataToValidateList = new ArrayList(this.businessObjectService.findMatching(BudgetConstructionRequestMove.class, searchCriteria));
        ArrayList<String> errorMessages = new ArrayList<String>();
        HashMap<String, BudgetConstructionHeader> retrievedHeaders = new HashMap<String, BudgetConstructionHeader>();
        for (BudgetConstructionRequestMove record : dataToValidateList) {
            boolean validLine = true;
            record.refreshNonUpdateableReferences();
            String accountKey = record.getChartOfAccountsCode() + record.getAccountNumber() + record.getSubAccountNumber();
            BudgetConstructionHeader budgetConstructionHeader = null;
            if (retrievedHeaders.containsKey(accountKey)) {
                budgetConstructionHeader = (BudgetConstructionHeader)((Object)retrievedHeaders.get(accountKey));
            } else {
                budgetConstructionHeader = this.importRequestDao.getHeaderRecord(record, budgetYear);
                retrievedHeaders.put(accountKey, budgetConstructionHeader);
            }
            SubObjectCode subObjectCode = this.getSubObjectCode(record, budgetYear);
            String code = record.getFinancialObjectTypeCode();
            LaborLedgerObject laborObject = this.laborModuleService.retrieveLaborLedgerObject(budgetYear, record.getChartOfAccountsCode(), record.getFinancialObjectCode());
            ObjectCode objectCode = this.getObjectCode(record, budgetYear);
            Calendar expDate = BudgetConstructionRuleUtil.getNoBudgetAllowedExpireDate(budgetYear);
            if (budgetConstructionHeader == null) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_NO_BUDGETED_ACCOUNT_SUB_ACCOUNT_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_NO_BUDGETED_ACCOUNT_SUB_ACCOUNT_ERROR_CODE.getMessage());
            } else if (!record.getAccount().isActive()) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_ACCOUNT_CLOSED_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_ACCOUNT_CLOSED_ERROR_CODE.getMessage());
            } else if (record.getAccount().isExpired(expDate)) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_ACCOUNT_EXPIRED_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_ACCOUNT_EXPIRED_ERROR_CODE.getMessage());
            } else if (!record.getSubAccountNumber().equalsIgnoreCase(KFSConstants.getDashSubAccountNumber()) && ObjectUtils.isNull((Object)record.getSubAccount())) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_ACCOUNT_INVALID_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_ACCOUNT_INVALID_ERROR_CODE.getMessage());
            } else if (!record.getSubAccountNumber().equalsIgnoreCase(KFSConstants.getDashSubAccountNumber()) && !record.getSubAccount().isActive()) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_ACCOUNT_INACTIVE_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_ACCOUNT_INACTIVE_ERROR_CODE.getMessage());
            } else if (StringUtils.isBlank((String)record.getFinancialObjectTypeCode())) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_OBJECT_TYPE_NULL_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_OBJECT_TYPE_INVALID_ERROR_CODE.getMessage());
            } else if (objectCode != null && !objectCode.isActive()) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_OBJECT_CODE_INACTIVE_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_OBJECT_CODE_INACTIVE_ERROR_CODE.getMessage());
            } else if (laborObject != null && (laborObject.isDetailPositionRequiredIndicator() || laborObject.getFinancialObjectFringeOrSalaryCode().equals("F"))) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_COMPENSATION_OBJECT_CODE_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_COMPENSATION_OBJECT_CODE_ERROR_CODE.getMessage());
            } else if (!record.getAccount().getSubFundGroup().isSubFundGroupWagesIndicator() && laborObject != null) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_NO_WAGE_ACCOUNT_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_NO_WAGE_ACCOUNT_ERROR_CODE.getMessage());
            } else if (!record.getFinancialSubObjectCode().equalsIgnoreCase(KFSConstants.getDashFinancialSubObjectCode()) && subObjectCode == null) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_OBJECT_INVALID_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_OBJECT_INVALID_ERROR_CODE.getMessage());
            } else if (!record.getFinancialSubObjectCode().equalsIgnoreCase(KFSConstants.getDashFinancialSubObjectCode()) && !subObjectCode.isActive()) {
                record.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_OBJECT_INACTIVE_ERROR_CODE.getErrorCode());
                errorMessages.add(record.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.DATA_VALIDATION_SUB_OBJECT_INACTIVE_ERROR_CODE.getMessage());
            }
            this.importRequestDao.save((BusinessObject)record, true);
        }
        return errorMessages;
    }

    @Override
    @Transactional
    public List<String> loadBudget(Person user, String fileType, Integer budgetYear) throws Exception {
        List<BudgetConstructionRequestMove> recordsToLoad = this.importRequestDao.findAllNonErrorCodeRecords(user.getPrincipalId());
        ArrayList<String> errorMessages = new ArrayList<String>();
        HashMap<String, BudgetConstructionRequestMove> recordMap = new HashMap<String, BudgetConstructionRequestMove>();
        String deleteMonthlyWarningErrorMessage = BCConstants.RequestImportErrorCode.UPDATE_ERROR_CODE_MONTHLY_BUDGET_DELETED.getErrorCode();
        for (BudgetConstructionRequestMove recordToLoad : recordsToLoad) {
            String updateBudgetAmountErrorMessage;
            BudgetConstructionHeader header = this.importRequestDao.getHeaderRecord(recordToLoad, budgetYear);
            if (recordMap.containsKey(recordToLoad.getSubAccountingString())) {
                BudgetConstructionRequestMove temp = (BudgetConstructionRequestMove)((Object)recordMap.get(recordToLoad.getSubAccountingString()));
                recordToLoad.setHasAccess(temp.getHasAccess());
                recordToLoad.setHasLock(temp.getHasLock());
                recordToLoad.setRequestUpdateErrorCode(temp.getRequestUpdateErrorCode());
            } else {
                boolean hasAccess = false;
                if (header != null) {
                    BudgetConstructionDocument document;
                    try {
                        document = (BudgetConstructionDocument)this.documentService.getByDocumentHeaderId(header.getDocumentNumber());
                    }
                    catch (WorkflowException e) {
                        throw new RuntimeException("Fail to retrieve budget document for doc id " + header.getDocumentNumber());
                    }
                    TransactionalDocumentAuthorizer documentAuthorizer = (TransactionalDocumentAuthorizer)this.getDocumentHelperService().getDocumentAuthorizer((org.kuali.kfs.krad.document.Document)document);
                    hasAccess = documentAuthorizer.isAuthorizedByTemplate((BusinessObject)document, "KR-NS", "Edit Document", user.getPrincipalId());
                }
                if (hasAccess) {
                    recordToLoad.setHasAccess(true);
                } else {
                    recordToLoad.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.UPDATE_ERROR_CODE_NO_ACCESS_TO_BUDGET_ACCOUNT.getErrorCode());
                    errorMessages.add(recordToLoad.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.UPDATE_ERROR_CODE_NO_ACCESS_TO_BUDGET_ACCOUNT.getMessage());
                }
                if (recordToLoad.getHasAccess()) {
                    BudgetConstructionLockStatus lockStatus = this.lockService.lockAccountAndCommit(header, user.getPrincipalId());
                    if (lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.SUCCESS)) {
                        recordToLoad.setHasLock(true);
                    } else {
                        recordToLoad.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.UPDATE_ERROR_CODE_BUDGET_ACCOUNT_LOCKED.getErrorCode());
                        errorMessages.add(recordToLoad.getErrorLinePrefixForLogFile() + " " + BCConstants.RequestImportErrorCode.UPDATE_ERROR_CODE_BUDGET_ACCOUNT_LOCKED.getMessage());
                    }
                }
                recordMap.put(recordToLoad.getSubAccountingString(), recordToLoad);
            }
            if (recordToLoad.getHasAccess() && recordToLoad.getHasLock() && (StringUtils.isBlank((String)recordToLoad.getRequestUpdateErrorCode()) || recordToLoad.getRequestUpdateErrorCode().endsWith(deleteMonthlyWarningErrorMessage)) && !StringUtils.isEmpty((String)(updateBudgetAmountErrorMessage = this.updateBudgetAmounts(fileType, recordToLoad, header, budgetYear)))) {
                errorMessages.add(recordToLoad.getErrorLinePrefixForLogFile() + " " + updateBudgetAmountErrorMessage);
            }
            this.importRequestDao.save((BusinessObject)recordToLoad, true);
        }
        for (String key : recordMap.keySet()) {
            BudgetConstructionRequestMove record = (BudgetConstructionRequestMove)((Object)recordMap.get(key));
            BudgetConstructionHeader header = this.importRequestDao.getHeaderRecord(record, budgetYear);
            if (record.getHasAccess() && record.getHasLock() && (StringUtils.isBlank((String)record.getRequestUpdateErrorCode()) || record.getRequestUpdateErrorCode().endsWith(deleteMonthlyWarningErrorMessage))) {
                this.udpateBenefits(fileType, header);
            }
            if (!record.getHasLock() || header == null) continue;
            this.lockService.unlockAccount(header);
        }
        this.deleteBudgetConstructionMoveRecords(user.getPrincipalId());
        this.persistenceServiceOjb.clearCache();
        return errorMessages;
    }

    @NonTransactional
    public ImportRequestDao getImportRequestDao() {
        return this.importRequestDao;
    }

    @NonTransactional
    public void setImportRequestDao(ImportRequestDao dao) {
        this.importRequestDao = dao;
    }

    protected String updateBudgetAmounts(String fileType, BudgetConstructionRequestMove importLine, BudgetConstructionHeader header, Integer budgetYear) {
        String errorMessage = "";
        PendingBudgetConstructionGeneralLedger pendingEntry = new PendingBudgetConstructionGeneralLedger();
        pendingEntry.setDocumentNumber(header.getDocumentNumber());
        pendingEntry.setUniversityFiscalYear(budgetYear);
        pendingEntry.setChartOfAccountsCode(importLine.getChartOfAccountsCode());
        pendingEntry.setAccountNumber(importLine.getAccountNumber());
        pendingEntry.setSubAccountNumber(importLine.getSubAccountNumber());
        pendingEntry.setFinancialObjectCode(importLine.getFinancialObjectCode());
        pendingEntry.setFinancialSubObjectCode(importLine.getFinancialSubObjectCode());
        pendingEntry.setFinancialBalanceTypeCode("BB");
        pendingEntry.setFinancialObjectTypeCode(importLine.getFinancialObjectTypeCode());
        PendingBudgetConstructionGeneralLedger retrievedPendingEntry = (PendingBudgetConstructionGeneralLedger)this.businessObjectService.retrieve((PersistableBusinessObject)pendingEntry);
        if (retrievedPendingEntry != null) {
            pendingEntry = retrievedPendingEntry;
        } else {
            pendingEntry.setFinancialBeginningBalanceLineAmount(new KualiInteger(0L));
        }
        if (fileType.equalsIgnoreCase(BCConstants.RequestImportFileType.ANNUAL.toString())) {
            List<BudgetConstructionMonthly> monthlyRecords = pendingEntry.getBudgetConstructionMonthly();
            if (!monthlyRecords.isEmpty()) {
                importLine.setRequestUpdateErrorCode(BCConstants.RequestImportErrorCode.UPDATE_ERROR_CODE_MONTHLY_BUDGET_DELETED.getErrorCode());
                errorMessage = BCConstants.RequestImportErrorCode.UPDATE_ERROR_CODE_MONTHLY_BUDGET_DELETED.getMessage();
                for (BudgetConstructionMonthly monthlyRecord : monthlyRecords) {
                    this.businessObjectService.delete((PersistableBusinessObject)monthlyRecord);
                }
                this.importRequestDao.save((BusinessObject)importLine, true);
            }
            pendingEntry.setAccountLineAnnualBalanceAmount(importLine.getAccountLineAnnualBalanceAmount());
            this.businessObjectService.save((PersistableBusinessObject)pendingEntry);
        } else if (fileType.equalsIgnoreCase(BCConstants.RequestImportFileType.MONTHLY.toString())) {
            KualiInteger annualAmount = new KualiInteger(0L);
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth1LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth2LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth3LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth4LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth5LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth6LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth7LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth8LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth9LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth10LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth11LineAmount());
            annualAmount = annualAmount.add(importLine.getFinancialDocumentMonth12LineAmount());
            pendingEntry.setAccountLineAnnualBalanceAmount(annualAmount);
            BudgetConstructionMonthly monthlyEntry = new BudgetConstructionMonthly();
            monthlyEntry.setDocumentNumber(header.getDocumentNumber());
            monthlyEntry.setUniversityFiscalYear(budgetYear);
            monthlyEntry.setChartOfAccountsCode(importLine.getChartOfAccountsCode());
            monthlyEntry.setAccountNumber(importLine.getAccountNumber());
            monthlyEntry.setSubAccountNumber(importLine.getSubAccountNumber());
            monthlyEntry.setFinancialObjectCode(importLine.getFinancialObjectCode());
            monthlyEntry.setFinancialSubObjectCode(importLine.getFinancialSubObjectCode());
            monthlyEntry.setFinancialBalanceTypeCode("BB");
            monthlyEntry.setFinancialObjectTypeCode(importLine.getFinancialObjectTypeCode());
            BudgetConstructionMonthly retrievedMonthlyEntry = (BudgetConstructionMonthly)this.businessObjectService.retrieve((PersistableBusinessObject)monthlyEntry);
            if (retrievedMonthlyEntry != null) {
                monthlyEntry = retrievedMonthlyEntry;
            }
            monthlyEntry.setFinancialDocumentMonth1LineAmount(importLine.getFinancialDocumentMonth1LineAmount());
            monthlyEntry.setFinancialDocumentMonth2LineAmount(importLine.getFinancialDocumentMonth2LineAmount());
            monthlyEntry.setFinancialDocumentMonth3LineAmount(importLine.getFinancialDocumentMonth3LineAmount());
            monthlyEntry.setFinancialDocumentMonth4LineAmount(importLine.getFinancialDocumentMonth4LineAmount());
            monthlyEntry.setFinancialDocumentMonth5LineAmount(importLine.getFinancialDocumentMonth5LineAmount());
            monthlyEntry.setFinancialDocumentMonth6LineAmount(importLine.getFinancialDocumentMonth6LineAmount());
            monthlyEntry.setFinancialDocumentMonth7LineAmount(importLine.getFinancialDocumentMonth7LineAmount());
            monthlyEntry.setFinancialDocumentMonth8LineAmount(importLine.getFinancialDocumentMonth8LineAmount());
            monthlyEntry.setFinancialDocumentMonth9LineAmount(importLine.getFinancialDocumentMonth9LineAmount());
            monthlyEntry.setFinancialDocumentMonth10LineAmount(importLine.getFinancialDocumentMonth10LineAmount());
            monthlyEntry.setFinancialDocumentMonth11LineAmount(importLine.getFinancialDocumentMonth11LineAmount());
            monthlyEntry.setFinancialDocumentMonth12LineAmount(importLine.getFinancialDocumentMonth12LineAmount());
            this.businessObjectService.save((PersistableBusinessObject)pendingEntry);
            this.businessObjectService.save((PersistableBusinessObject)monthlyEntry);
        }
        return errorMessage;
    }

    protected void udpateBenefits(String fileType, BudgetConstructionHeader header) {
        BenefitsCalculationService benefitsCalculationService = (BenefitsCalculationService)SpringContext.getBean(BenefitsCalculationService.class);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", header.getUniversityFiscalYear());
        fieldValues.put("chartOfAccountsCode", header.getChartOfAccountsCode());
        fieldValues.put("accountNumber", header.getAccountNumber());
        fieldValues.put("subAccountNumber", header.getSubAccountNumber());
        int monthlyCnt = this.businessObjectService.countMatching(BudgetConstructionMonthly.class, fieldValues);
        String sysParam = this.parameterService.getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
        if (sysParam.equalsIgnoreCase("Y")) {
            benefitsCalculationService.calculateAnnualBudgetConstructionGeneralLedgerBenefits(header.getDocumentNumber(), header.getUniversityFiscalYear(), header.getChartOfAccountsCode(), header.getAccountNumber(), header.getSubAccountNumber(), header.getAccount().getLaborBenefitRateCategoryCode());
            if (monthlyCnt > 0 || fileType.equalsIgnoreCase(BCConstants.RequestImportFileType.MONTHLY.toString())) {
                benefitsCalculationService.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(header.getDocumentNumber(), header.getUniversityFiscalYear(), header.getChartOfAccountsCode(), header.getAccountNumber(), header.getSubAccountNumber(), header.getAccount().getLaborBenefitRateCategoryCode());
            }
        } else {
            benefitsCalculationService.calculateAnnualBudgetConstructionGeneralLedgerBenefits(header.getDocumentNumber(), header.getUniversityFiscalYear(), header.getChartOfAccountsCode(), header.getAccountNumber(), header.getSubAccountNumber());
            if (monthlyCnt > 0 || fileType.equalsIgnoreCase(BCConstants.RequestImportFileType.MONTHLY.toString())) {
                benefitsCalculationService.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(header.getDocumentNumber(), header.getUniversityFiscalYear(), header.getChartOfAccountsCode(), header.getAccountNumber(), header.getSubAccountNumber());
            }
        }
    }

    protected String validateLine(BudgetConstructionRequestMove budgetConstructionRequestMove, int lineNumber, boolean isAnnual) {
        if (!this.dictionaryValidationService.isBusinessObjectValid((BusinessObject)budgetConstructionRequestMove)) {
            return "Bad file format at line " + lineNumber + ".";
        }
        if (isAnnual && (budgetConstructionRequestMove.getAccountLineAnnualBalanceAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getAccountLineAnnualBalanceAmount().compareTo(new KualiInteger(-999999999L)) <= 0)) {
            return "Bad file format at line " + lineNumber + ".";
        }
        if (!isAnnual) {
            if (budgetConstructionRequestMove.getFinancialDocumentMonth1LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth1LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth2LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth2LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth3LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth3LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth4LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth4LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth5LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth5LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth6LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth6LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth7LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth7LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth8LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth8LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth9LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth9LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth10LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth10LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth11LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth11LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
            if (budgetConstructionRequestMove.getFinancialDocumentMonth12LineAmount().compareTo(new KualiInteger(999999999L)) >= 0 || budgetConstructionRequestMove.getFinancialDocumentMonth12LineAmount().compareTo(new KualiInteger(-999999999L)) <= 0) {
                return "Bad file format at line " + lineNumber + ".";
            }
        }
        return "";
    }

    protected ObjectCode getObjectCode(BudgetConstructionRequestMove record, Integer budgetYear) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", budgetYear);
        searchCriteria.put("chartOfAccountsCode", record.getChartOfAccountsCode());
        searchCriteria.put("financialObjectCode", record.getFinancialObjectCode());
        ArrayList objectList = new ArrayList(this.businessObjectService.findMatching(ObjectCode.class, searchCriteria));
        if (objectList.size() == 1) {
            return (ObjectCode)objectList.get(0);
        }
        return null;
    }

    protected SubObjectCode getSubObjectCode(BudgetConstructionRequestMove record, Integer budgetYear) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", budgetYear);
        searchCriteria.put("chartOfAccountsCode", record.getChartOfAccountsCode());
        searchCriteria.put("financialObjectCode", record.getFinancialObjectCode());
        searchCriteria.put("accountNumber", record.getAccountNumber());
        searchCriteria.put("financialSubObjectCode", record.getFinancialSubObjectCode());
        ArrayList objectList = new ArrayList(this.businessObjectService.findMatching(SubObjectCode.class, searchCriteria));
        if (objectList.size() == 1) {
            return (SubObjectCode)objectList.get(0);
        }
        return null;
    }

    protected List<BudgetConstructionFundingLock> findBudgetLocks(BudgetConstructionRequestMove record, Integer budgetYear) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", budgetYear);
        searchCriteria.put("chartOfAccountsCode", record.getChartOfAccountsCode());
        searchCriteria.put("accountNumber", record.getAccountNumber());
        searchCriteria.put("subAccountNumber", record.getSubAccountNumber());
        ArrayList<BudgetConstructionFundingLock> lockList = new ArrayList<BudgetConstructionFundingLock>(this.businessObjectService.findMatching(BudgetConstructionFundingLock.class, searchCriteria));
        return lockList;
    }

    List<BudgetConstructionMonthly> getMonthlyRecords(BudgetConstructionRequestMove record, BudgetConstructionHeader header) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("documentNumber", header.getDocumentNumber());
        searchCriteria.put("universityFiscalYear", header.getUniversityFiscalYear());
        searchCriteria.put("chartOfAccountsCode", record.getChartOfAccountsCode());
        searchCriteria.put("accountNumber", record.getAccountNumber());
        searchCriteria.put("subAccountNumber", record.getSubAccountNumber());
        searchCriteria.put("financialObjectCode", record.getFinancialObjectCode());
        searchCriteria.put("financialSubObjectCode", record.getFinancialSubObjectCode());
        searchCriteria.put("financialObjectTypeCode", record.getFinancialObjectTypeCode());
        searchCriteria.put("financialBalanceTypeCode", "BB");
        return new ArrayList<BudgetConstructionMonthly>(this.businessObjectService.findMatching(BudgetConstructionMonthly.class, searchCriteria));
    }

    protected void deleteBudgetConstructionMoveRecords(String principalId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("principalId", principalId);
        this.businessObjectService.deleteMatching(BudgetConstructionRequestMove.class, fieldValues);
    }

    @NonTransactional
    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    @NonTransactional
    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    @NonTransactional
    public void setBudgetDocumentService(BudgetDocumentService budgetDocumentService) {
        this.budgetDocumentService = budgetDocumentService;
    }

    @NonTransactional
    public void setLaborModuleService(LaborModuleService laborModuleService) {
        this.laborModuleService = laborModuleService;
    }

    @NonTransactional
    public LaborModuleService getLaborModuleService() {
        return this.laborModuleService;
    }

    @NonTransactional
    public BudgetParameterService getBudgetParameterService() {
        return this.budgetParameterService;
    }

    @NonTransactional
    public void setBudgetParameterService(BudgetParameterService budgetParameterService) {
        this.budgetParameterService = budgetParameterService;
    }

    @NonTransactional
    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    @NonTransactional
    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    @NonTransactional
    public DocumentHelperService getDocumentHelperService() {
        return this.documentHelperService;
    }

    @NonTransactional
    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }

    @NonTransactional
    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    @NonTransactional
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @NonTransactional
    public ParameterService getParameterService() {
        return this.parameterService;
    }

    @NonTransactional
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @NonTransactional
    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    @NonTransactional
    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

