/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionFundingLock;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockSummary;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionDao;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionLockDao;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.exception.BudgetConstructionLockUnavailableException;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class LockServiceImpl
implements LockService {
    private static final Logger LOG = Logger.getLogger(LockServiceImpl.class);
    protected BudgetConstructionDao budgetConstructionDao;
    protected BudgetConstructionLockDao budgetConstructionLockDao;
    protected BudgetDocumentService budgetDocumentService;

    @Override
    @Transactional
    public BudgetConstructionLockStatus lockAccount(BudgetConstructionHeader bcHeader, String principalId) {
        BudgetConstructionLockStatus bcLockStatus = new BudgetConstructionLockStatus();
        if (bcHeader != null) {
            bcLockStatus.setBudgetConstructionHeader(bcHeader);
            if (bcHeader.getBudgetLockUserIdentifier() == null) {
                bcHeader.setBudgetLockUserIdentifier(principalId);
                try {
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)bcHeader);
                    bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
                }
                catch (DataAccessException ex) {
                    bcLockStatus.setLockStatus(BCConstants.LockStatus.OPTIMISTIC_EX);
                }
                if (bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS) {
                    bcLockStatus.setFundingLocks(this.getFundingLocks(bcHeader));
                    if (!bcLockStatus.getFundingLocks().isEmpty()) {
                        BudgetConstructionHeader freshBcHeader = this.budgetConstructionDao.getByCandidateKey(bcHeader.getChartOfAccountsCode(), bcHeader.getAccountNumber(), bcHeader.getSubAccountNumber(), bcHeader.getUniversityFiscalYear());
                        this.unlockAccount(freshBcHeader);
                        bcLockStatus.setBudgetConstructionHeader(freshBcHeader);
                        bcLockStatus.setLockStatus(BCConstants.LockStatus.FLOCK_FOUND);
                    }
                }
                return bcLockStatus;
            }
            if (bcHeader.getBudgetLockUserIdentifier().equals(principalId)) {
                bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
                return bcLockStatus;
            }
            bcLockStatus.setLockStatus(BCConstants.LockStatus.BY_OTHER);
            bcLockStatus.setAccountLockOwner(bcHeader.getBudgetLockUserIdentifier());
            return bcLockStatus;
        }
        bcLockStatus.setLockStatus(BCConstants.LockStatus.NO_DOOR);
        return bcLockStatus;
    }

    @Override
    @Transactional
    public boolean isAccountLocked(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        BudgetConstructionHeader budgetConstructionHeader = this.budgetDocumentService.getBudgetConstructionHeader(appointmentFunding);
        return this.isAccountLocked(budgetConstructionHeader);
    }

    @Override
    @Transactional
    public boolean isAccountLocked(BudgetConstructionHeader bcHeader) {
        BudgetConstructionHeader freshBcHeader = this.budgetConstructionDao.getByCandidateKey(bcHeader.getChartOfAccountsCode(), bcHeader.getAccountNumber(), bcHeader.getSubAccountNumber(), bcHeader.getUniversityFiscalYear());
        if (freshBcHeader != null) {
            return freshBcHeader.getBudgetLockUserIdentifier() != null;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean isAccountLockedByUser(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear, String principalId) {
        BudgetConstructionHeader freshBcHeader = this.budgetConstructionDao.getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
        return freshBcHeader != null && freshBcHeader.getBudgetLockUserIdentifier() != null && freshBcHeader.getBudgetLockUserIdentifier().equals(principalId);
    }

    @Override
    @Transactional
    public BCConstants.LockStatus unlockAccount(BudgetConstructionHeader bcHeader) {
        BCConstants.LockStatus lockStatus;
        if (bcHeader != null) {
            if (bcHeader.getBudgetLockUserIdentifier() != null) {
                bcHeader.setBudgetLockUserIdentifier(null);
                try {
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)bcHeader);
                    lockStatus = BCConstants.LockStatus.SUCCESS;
                }
                catch (DataAccessException ex) {
                    lockStatus = BCConstants.LockStatus.OPTIMISTIC_EX;
                }
            } else {
                lockStatus = BCConstants.LockStatus.SUCCESS;
            }
        } else {
            lockStatus = BCConstants.LockStatus.NO_DOOR;
        }
        return lockStatus;
    }

    @Override
    @Transactional
    public SortedSet<BudgetConstructionFundingLock> getFundingLocks(BudgetConstructionHeader bcHeader) {
        Collection<BudgetConstructionFundingLock> fundingLocks = this.budgetConstructionDao.getFlocksForAccount(bcHeader.getChartOfAccountsCode(), bcHeader.getAccountNumber(), bcHeader.getSubAccountNumber(), bcHeader.getUniversityFiscalYear());
        TreeSet<BudgetConstructionFundingLock> sortedFundingLocks = new TreeSet<BudgetConstructionFundingLock>(new Comparator<BudgetConstructionFundingLock>(){

            @Override
            public int compare(BudgetConstructionFundingLock aFlock, BudgetConstructionFundingLock bFlock) {
                String nameA = aFlock.getAppointmentFundingLockUser().getName();
                String nameB = bFlock.getAppointmentFundingLockUser().getName();
                return nameA.compareTo(nameB);
            }
        });
        sortedFundingLocks.addAll(fundingLocks);
        return sortedFundingLocks;
    }

    @Override
    @Transactional
    public BudgetConstructionLockStatus lockFunding(BudgetConstructionHeader bcHeader, String principalId) {
        BudgetConstructionLockStatus bcLockStatus = new BudgetConstructionLockStatus();
        if (!this.isAccountLocked(bcHeader)) {
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("chartOfAccountsCode", bcHeader.getChartOfAccountsCode());
            keys.put("accountNumber", bcHeader.getAccountNumber());
            keys.put("subAccountNumber", bcHeader.getSubAccountNumber());
            keys.put("universityFiscalYear", bcHeader.getUniversityFiscalYear());
            keys.put("appointmentFundingLockUserId", principalId);
            BudgetConstructionFundingLock budgetConstructionFundingLock = (BudgetConstructionFundingLock)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionFundingLock.class, keys);
            if (budgetConstructionFundingLock != null && budgetConstructionFundingLock.getAppointmentFundingLockUserId().equals(principalId)) {
                bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
            } else {
                budgetConstructionFundingLock = new BudgetConstructionFundingLock();
                budgetConstructionFundingLock.setAppointmentFundingLockUserId(principalId);
                budgetConstructionFundingLock.setAccountNumber(bcHeader.getAccountNumber());
                budgetConstructionFundingLock.setSubAccountNumber(bcHeader.getSubAccountNumber());
                budgetConstructionFundingLock.setChartOfAccountsCode(bcHeader.getChartOfAccountsCode());
                budgetConstructionFundingLock.setUniversityFiscalYear(bcHeader.getUniversityFiscalYear());
                budgetConstructionFundingLock.setFill1("L");
                budgetConstructionFundingLock.setFill2("L");
                budgetConstructionFundingLock.setFill3("L");
                budgetConstructionFundingLock.setFill4("L");
                budgetConstructionFundingLock.setFill5("L");
                ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)budgetConstructionFundingLock);
                if (this.isAccountLocked(bcHeader)) {
                    bcLockStatus.setLockStatus(BCConstants.LockStatus.BY_OTHER);
                    bcLockStatus.setAccountLockOwner(bcHeader.getBudgetLockUserIdentifier());
                    this.unlockFunding(bcHeader.getChartOfAccountsCode(), bcHeader.getAccountNumber(), bcHeader.getSubAccountNumber(), bcHeader.getUniversityFiscalYear(), principalId);
                } else {
                    bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
                }
            }
        } else {
            bcLockStatus.setLockStatus(BCConstants.LockStatus.BY_OTHER);
            bcLockStatus.setAccountLockOwner(bcHeader.getBudgetLockUserIdentifier());
        }
        return bcLockStatus;
    }

    @Override
    @NonTransactional
    public BudgetConstructionLockStatus lockFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding, Person person) {
        BudgetConstructionHeader budgetConstructionHeader = this.budgetDocumentService.getBudgetConstructionHeader(appointmentFunding);
        return this.lockFunding(budgetConstructionHeader, person.getPrincipalId());
    }

    @Override
    @Transactional
    public BCConstants.LockStatus unlockFunding(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear, String principalId) {
        BCConstants.LockStatus lockStatus;
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put("chartOfAccountsCode", chartOfAccountsCode);
        keys.put("accountNumber", accountNumber);
        keys.put("subAccountNumber", subAccountNumber);
        keys.put("universityFiscalYear", fiscalYear);
        keys.put("appointmentFundingLockUserId", principalId);
        BudgetConstructionFundingLock budgetConstructionFundingLock = (BudgetConstructionFundingLock)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionFundingLock.class, keys);
        if (budgetConstructionFundingLock != null) {
            this.budgetConstructionDao.deleteBudgetConstructionFundingLock(budgetConstructionFundingLock);
            lockStatus = BCConstants.LockStatus.SUCCESS;
        } else {
            lockStatus = BCConstants.LockStatus.NO_DOOR;
        }
        return lockStatus;
    }

    @Override
    @Transactional
    public BCConstants.LockStatus unlockFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding, Person person) {
        Integer fiscalYear = appointmentFunding.getUniversityFiscalYear();
        String chartOfAccountsCode = appointmentFunding.getChartOfAccountsCode();
        String objectCode = appointmentFunding.getFinancialObjectCode();
        String accountNumber = appointmentFunding.getAccountNumber();
        String subAccountNumber = appointmentFunding.getSubAccountNumber();
        return this.unlockFunding(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear, person.getPrincipalId());
    }

    @Override
    @Transactional
    public void unlockFunding(List<PendingBudgetConstructionAppointmentFunding> lockedFundings, Person person) {
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : lockedFundings) {
            this.unlockFunding(appointmentFunding, person);
        }
    }

    @Override
    @Transactional
    public boolean isFundingLockedByUser(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear, String principalId) {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put("chartOfAccountsCode", chartOfAccountsCode);
        keys.put("accountNumber", accountNumber);
        keys.put("subAccountNumber", subAccountNumber);
        keys.put("universityFiscalYear", fiscalYear);
        keys.put("appointmentFundingLockUserId", principalId);
        BudgetConstructionFundingLock budgetConstructionFundingLock = (BudgetConstructionFundingLock)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionFundingLock.class, keys);
        return budgetConstructionFundingLock != null;
    }

    @Override
    @Transactional
    public BudgetConstructionLockStatus lockPosition(String positionNumber, Integer fiscalYear, String principalId) {
        BudgetConstructionLockStatus bcLockStatus = new BudgetConstructionLockStatus();
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put("positionNumber", positionNumber);
        keys.put("universityFiscalYear", fiscalYear);
        BudgetConstructionPosition bcPosition = (BudgetConstructionPosition)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionPosition.class, keys);
        if (bcPosition != null) {
            if (bcPosition.getPositionLockUserIdentifier() == null) {
                bcPosition.setPositionLockUserIdentifier(principalId);
                try {
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)bcPosition);
                    bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
                }
                catch (DataAccessException ex) {
                    bcLockStatus.setLockStatus(BCConstants.LockStatus.OPTIMISTIC_EX);
                }
                return bcLockStatus;
            }
            if (bcPosition.getPositionLockUserIdentifier().equals(principalId)) {
                bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
                return bcLockStatus;
            }
            bcLockStatus.setLockStatus(BCConstants.LockStatus.BY_OTHER);
            bcLockStatus.setPositionLockOwner(bcPosition.getPositionLockUserIdentifier());
            return bcLockStatus;
        }
        bcLockStatus.setLockStatus(BCConstants.LockStatus.NO_DOOR);
        return bcLockStatus;
    }

    @Override
    @Transactional
    public BudgetConstructionLockStatus lockPosition(BudgetConstructionPosition position, Person person) {
        String positionNumber = position.getPositionNumber();
        Integer fiscalYear = position.getUniversityFiscalYear();
        String principalId = person.getPrincipalId();
        return this.lockPosition(positionNumber, fiscalYear, principalId);
    }

    @Override
    @Transactional
    public boolean isPositionLocked(String positionNumber, Integer fiscalYear) {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put("positionNumber", positionNumber);
        keys.put("universityFiscalYear", fiscalYear);
        BudgetConstructionPosition bcPosition = (BudgetConstructionPosition)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionPosition.class, keys);
        if (bcPosition != null) {
            return bcPosition.getPositionLockUserIdentifier() != null;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean isPositionLockedByUser(String positionNumber, Integer fiscalYear, String principalId) {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put("positionNumber", positionNumber);
        keys.put("universityFiscalYear", fiscalYear);
        BudgetConstructionPosition bcPosition = (BudgetConstructionPosition)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionPosition.class, keys);
        return bcPosition != null && bcPosition.getPositionLockUserIdentifier() != null && bcPosition.getPositionLockUserIdentifier().equals(principalId);
    }

    @Override
    @Transactional
    public boolean isPositionFundingLockedByUser(String positionNumber, String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear, String principalId) {
        return this.isPositionLockedByUser(positionNumber, fiscalYear, principalId) && this.isFundingLockedByUser(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear, principalId);
    }

    @Override
    @Transactional
    public BCConstants.LockStatus unlockPosition(String positionNumber, Integer fiscalYear) {
        BCConstants.LockStatus lockStatus;
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put("positionNumber", positionNumber);
        keys.put("universityFiscalYear", fiscalYear);
        BudgetConstructionPosition bcPosition = (BudgetConstructionPosition)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionPosition.class, keys);
        if (bcPosition != null) {
            if (bcPosition.getPositionLockUserIdentifier() != null) {
                bcPosition.setPositionLockUserIdentifier(null);
                try {
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)bcPosition);
                    lockStatus = BCConstants.LockStatus.SUCCESS;
                }
                catch (DataAccessException ex) {
                    lockStatus = BCConstants.LockStatus.OPTIMISTIC_EX;
                }
            } else {
                lockStatus = BCConstants.LockStatus.SUCCESS;
            }
        } else {
            lockStatus = BCConstants.LockStatus.NO_DOOR;
        }
        return lockStatus;
    }

    @Override
    @Transactional
    public BCConstants.LockStatus unlockPosition(String positionNumber, Integer fiscalYear, String principalId) {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put("positionNumber", positionNumber);
        keys.put("universityFiscalYear", fiscalYear);
        BudgetConstructionPosition bcPosition = (BudgetConstructionPosition)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionPosition.class, keys);
        if (bcPosition == null || !principalId.equals(bcPosition.getPositionLockUserIdentifier())) {
            return BCConstants.LockStatus.NO_DOOR;
        }
        try {
            bcPosition.setPositionLockUserIdentifier(null);
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)bcPosition);
            return BCConstants.LockStatus.SUCCESS;
        }
        catch (DataAccessException ex) {
            return BCConstants.LockStatus.OPTIMISTIC_EX;
        }
    }

    @Override
    @Transactional
    public BCConstants.LockStatus unlockPostion(BudgetConstructionPosition position, Person person) {
        Integer fiscalYear = position.getUniversityFiscalYear();
        String positionNumber = position.getPositionNumber();
        return this.unlockPosition(positionNumber, fiscalYear, person.getPrincipalId());
    }

    @Override
    @Transactional
    public void unlockPostion(List<BudgetConstructionPosition> lockedPositions, Person person) {
        for (BudgetConstructionPosition position : lockedPositions) {
            this.unlockPostion(position, person);
        }
    }

    @Override
    @Transactional
    public BudgetConstructionLockStatus lockTransaction(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear, String principalId) {
        int lockRetry = 1;
        boolean done = false;
        BudgetConstructionLockStatus bcLockStatus = new BudgetConstructionLockStatus();
        if (this.isTransactionLockedByUser(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear, principalId)) {
            bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
            done = true;
        }
        while (!done) {
            BudgetConstructionHeader bcHeader = this.budgetConstructionDao.getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
            if (bcHeader != null) {
                if (bcHeader.getBudgetTransactionLockUserIdentifier() == null) {
                    bcHeader.setBudgetTransactionLockUserIdentifier(principalId);
                    try {
                        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)bcHeader);
                        bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
                    }
                    catch (DataAccessException ex) {
                        bcLockStatus.setLockStatus(BCConstants.LockStatus.OPTIMISTIC_EX);
                    }
                    done = true;
                    continue;
                }
                if (lockRetry > 20) {
                    bcLockStatus.setLockStatus(BCConstants.LockStatus.BY_OTHER);
                    bcLockStatus.setTransactionLockOwner(bcHeader.getBudgetTransactionLockUserIdentifier());
                    done = true;
                }
                ++lockRetry;
                continue;
            }
            bcLockStatus.setLockStatus(BCConstants.LockStatus.NO_DOOR);
            done = true;
        }
        return bcLockStatus;
    }

    @Override
    @Transactional
    public BudgetConstructionLockStatus lockTransaction(PendingBudgetConstructionAppointmentFunding appointmentFunding, Person person) {
        String chartOfAccountsCode = appointmentFunding.getChartOfAccountsCode();
        String accountNumber = appointmentFunding.getAccountNumber();
        String subAccountNumber = appointmentFunding.getSubAccountNumber();
        Integer fiscalYear = appointmentFunding.getUniversityFiscalYear();
        return this.lockTransaction(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear, person.getPrincipalId());
    }

    @Override
    @Transactional
    public boolean isTransactionLocked(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear) {
        BudgetConstructionHeader freshBcHeader = this.budgetConstructionDao.getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
        if (freshBcHeader != null) {
            return freshBcHeader.getBudgetTransactionLockUserIdentifier() != null;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean isTransactionLockedByUser(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear, String principalId) {
        BudgetConstructionHeader freshBcHeader = this.budgetConstructionDao.getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
        return freshBcHeader != null && freshBcHeader.getBudgetTransactionLockUserIdentifier() != null && freshBcHeader.getBudgetTransactionLockUserIdentifier().equals(principalId);
    }

    @Override
    @Transactional
    public BCConstants.LockStatus unlockTransaction(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear) {
        BCConstants.LockStatus lockStatus = BCConstants.LockStatus.NO_DOOR;
        BudgetConstructionHeader bcHeader = this.budgetConstructionDao.getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
        if (bcHeader != null) {
            if (bcHeader.getBudgetTransactionLockUserIdentifier() != null) {
                bcHeader.setBudgetTransactionLockUserIdentifier(null);
                try {
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)bcHeader);
                    lockStatus = BCConstants.LockStatus.SUCCESS;
                }
                catch (DataAccessException ex) {
                    lockStatus = BCConstants.LockStatus.OPTIMISTIC_EX;
                }
            } else {
                lockStatus = BCConstants.LockStatus.SUCCESS;
            }
        } else {
            lockStatus = BCConstants.LockStatus.NO_DOOR;
        }
        return lockStatus;
    }

    @Override
    @Transactional
    public void unlockTransaction(PendingBudgetConstructionAppointmentFunding appointmentFunding, Person person) {
        String principalId;
        Integer fiscalYear;
        String subAccountNumber;
        String accountNumber;
        String chartOfAccountsCode = appointmentFunding.getChartOfAccountsCode();
        if (this.isTransactionLockedByUser(chartOfAccountsCode, accountNumber = appointmentFunding.getAccountNumber(), subAccountNumber = appointmentFunding.getSubAccountNumber(), fiscalYear = appointmentFunding.getUniversityFiscalYear(), principalId = person.getPrincipalId())) {
            this.unlockTransaction(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
        }
    }

    @Override
    @Transactional
    public List<BudgetConstructionHeader> getAllAccountLocks(String lockUserId) {
        return this.budgetConstructionLockDao.getAllAccountLocks(lockUserId);
    }

    @Override
    @Transactional
    public List<BudgetConstructionFundingLock> getOrphanedFundingLocks(String lockUserId) {
        return this.budgetConstructionLockDao.getOrphanedFundingLocks(lockUserId);
    }

    @Override
    @Transactional
    public List<BudgetConstructionPosition> getOrphanedPositionLocks(String lockUserId) {
        return this.budgetConstructionLockDao.getOrphanedPositionLocks(lockUserId);
    }

    @Override
    @Transactional
    public List<BudgetConstructionHeader> getAllTransactionLocks(String lockUserId) {
        return this.budgetConstructionLockDao.getAllTransactionLocks(lockUserId);
    }

    @Override
    @Transactional
    public List<PendingBudgetConstructionAppointmentFunding> getAllPositionFundingLocks(String lockUserId) {
        return this.budgetConstructionLockDao.getAllPositionFundingLocks(lockUserId);
    }

    @Override
    @Transactional
    public boolean checkLockExists(BudgetConstructionLockSummary lockSummary) {
        String lockType = lockSummary.getLockType();
        if ("account lock".equals(lockType)) {
            return this.isAccountLockedByUser(lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear(), lockSummary.getLockUser().getPrincipalId());
        }
        if ("transaction lock".equals(lockType)) {
            return this.isTransactionLockedByUser(lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear(), lockSummary.getLockUser().getPrincipalId());
        }
        if ("orphan funding lock".equals(lockType)) {
            return this.isFundingLockedByUser(lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear(), lockSummary.getLockUser().getPrincipalId());
        }
        if ("position lock".equals(lockType)) {
            return this.isPositionLockedByUser(lockSummary.getPositionNumber(), lockSummary.getUniversityFiscalYear(), lockSummary.getLockUser().getPrincipalId());
        }
        if ("position/funding lock".equals(lockType)) {
            return this.isPositionFundingLockedByUser(lockSummary.getPositionNumber(), lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear(), lockSummary.getLockUser().getPrincipalId());
        }
        return false;
    }

    @Override
    @Transactional
    public BCConstants.LockStatus doUnlock(BudgetConstructionLockSummary lockSummary) {
        BudgetConstructionHeader bcHeader;
        String lockType = lockSummary.getLockType();
        if ("account lock".equals(lockType) && (bcHeader = this.budgetConstructionDao.getByCandidateKey(lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear())) != null) {
            return this.unlockAccount(bcHeader);
        }
        if ("transaction lock".equals(lockType)) {
            return this.unlockTransaction(lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear());
        }
        if ("orphan funding lock".equals(lockType)) {
            return this.unlockFunding(lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear(), lockSummary.getLockUser().getPrincipalId());
        }
        if ("position lock".equals(lockType)) {
            return this.unlockPosition(lockSummary.getPositionNumber(), lockSummary.getUniversityFiscalYear());
        }
        if ("position/funding lock".equals(lockType)) {
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("positionNumber", lockSummary.getPositionNumber());
            keys.put("universityFiscalYear", lockSummary.getUniversityFiscalYear());
            BudgetConstructionPosition position = (BudgetConstructionPosition)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionPosition.class, keys);
            for (PendingBudgetConstructionAppointmentFunding appointmentFunding : position.getPendingBudgetConstructionAppointmentFunding()) {
                this.unlockFunding(appointmentFunding.getChartOfAccountsCode(), appointmentFunding.getAccountNumber(), appointmentFunding.getSubAccountNumber(), appointmentFunding.getUniversityFiscalYear(), lockSummary.getLockUser().getPrincipalId());
            }
            return this.unlockPosition(position.getPositionNumber(), position.getUniversityFiscalYear());
        }
        return BCConstants.LockStatus.NO_DOOR;
    }

    @Override
    @Transactional
    public boolean isAccountLockedByUser(BudgetConstructionHeader budgetConstructionHeader, Person person) {
        String chartOfAccountsCode = budgetConstructionHeader.getChartOfAccountsCode();
        String accountNumber = budgetConstructionHeader.getAccountNumber();
        String subAccountNumber = budgetConstructionHeader.getSubAccountNumber();
        Integer fiscalYear = budgetConstructionHeader.getUniversityFiscalYear();
        return this.isAccountLockedByUser(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear, person.getPrincipalId());
    }

    @NonTransactional
    public void setBudgetConstructionDao(BudgetConstructionDao bcHeaderDao) {
        this.budgetConstructionDao = bcHeaderDao;
    }

    @NonTransactional
    public void setBudgetConstructionLockDao(BudgetConstructionLockDao budgetConstructionLockDao) {
        this.budgetConstructionLockDao = budgetConstructionLockDao;
    }

    @NonTransactional
    public void setBudgetDocumentService(BudgetDocumentService budgetDocumentService) {
        this.budgetDocumentService = budgetDocumentService;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PendingBudgetConstructionAppointmentFunding> lockPendingBudgetConstructionAppointmentFundingRecords(List<PendingBudgetConstructionAppointmentFunding> fundingRecords, Person user) throws BudgetConstructionLockUnavailableException {
        ArrayList<PendingBudgetConstructionAppointmentFunding> lockedFundingRecords = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        HashMap<String, PendingBudgetConstructionAppointmentFunding> lockMap = new HashMap<String, PendingBudgetConstructionAppointmentFunding>();
        for (PendingBudgetConstructionAppointmentFunding fundingRecord : fundingRecords) {
            BudgetConstructionHeader header = this.budgetDocumentService.getBudgetConstructionHeader(fundingRecord);
            String lockingKey = fundingRecord.getUniversityFiscalYear() + "-" + fundingRecord.getChartOfAccountsCode() + "-" + fundingRecord.getAccountNumber() + "-" + fundingRecord.getSubAccountNumber();
            if (lockMap.containsKey(lockingKey)) continue;
            BudgetConstructionLockStatus lockStatus = this.lockAccount(header, user.getPrincipalId());
            if (lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.BY_OTHER)) {
                throw new BudgetConstructionLockUnavailableException(lockStatus);
            }
            if (lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.FLOCK_FOUND)) {
                throw new BudgetConstructionLockUnavailableException(lockStatus);
            }
            if (!lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.SUCCESS)) {
                throw new BudgetConstructionLockUnavailableException(lockStatus);
            }
            lockMap.put(lockingKey, fundingRecord);
            lockedFundingRecords.add(fundingRecord);
        }
        return lockedFundingRecords;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BudgetConstructionLockStatus lockAccountAndCommit(BudgetConstructionHeader bcHeader, String principalId) {
        return this.lockAccount(bcHeader, principalId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BudgetConstructionLockStatus lockPositionAndActiveFunding(Integer universityFiscalYear, String positionNumber, String principalId) {
        BudgetConstructionLockStatus lockStatus = this.lockPosition(positionNumber, universityFiscalYear, principalId);
        if (!lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.SUCCESS)) {
            return lockStatus;
        }
        List<PendingBudgetConstructionAppointmentFunding> allPositionFunding = this.budgetConstructionDao.getAllFundingForPosition(universityFiscalYear, positionNumber);
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : allPositionFunding) {
            BudgetConstructionHeader budgetConstructionHeader;
            BudgetConstructionLockStatus fundingLockStatus;
            if (appointmentFunding.isAppointmentFundingDeleteIndicator() || (fundingLockStatus = this.lockFunding(budgetConstructionHeader = this.budgetDocumentService.getBudgetConstructionHeader(appointmentFunding), principalId)).getLockStatus().equals((Object)BCConstants.LockStatus.SUCCESS)) continue;
            return lockStatus;
        }
        BudgetConstructionLockStatus bcLockStatus = new BudgetConstructionLockStatus();
        bcLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
        return bcLockStatus;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BCConstants.LockStatus unlockPositionAndActiveFunding(Integer universityFiscalYear, String positionNumber, String principalId) {
        BCConstants.LockStatus lockStatus = this.unlockPosition(positionNumber, universityFiscalYear, principalId);
        if (!lockStatus.equals((Object)BCConstants.LockStatus.SUCCESS)) {
            return lockStatus;
        }
        List<PendingBudgetConstructionAppointmentFunding> allPositionFunding = this.budgetConstructionDao.getAllFundingForPosition(universityFiscalYear, positionNumber);
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : allPositionFunding) {
            BCConstants.LockStatus fundingLockStatus;
            if (appointmentFunding.isAppointmentFundingDeleteIndicator() || (fundingLockStatus = this.unlockFunding(appointmentFunding.getChartOfAccountsCode(), appointmentFunding.getAccountNumber(), appointmentFunding.getSubAccountNumber(), appointmentFunding.getUniversityFiscalYear(), principalId)).equals((Object)BCConstants.LockStatus.SUCCESS)) continue;
            return lockStatus;
        }
        return BCConstants.LockStatus.SUCCESS;
    }
}

