/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPayRateHolding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.PayrateImportDao;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.service.PayrateImportService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.exception.BudgetConstructionLockUnavailableException;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.module.bc.util.ExternalizedMessageWrapper;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class PayrateImportServiceImpl
implements PayrateImportService {
    protected BusinessObjectService businessObjectService;
    protected LockService lockService;
    protected int importCount;
    protected int updateCount;
    protected OptionsService optionsService;
    protected PayrateImportDao payrateImportDao;
    protected BudgetDocumentService budgetDocumentService;
    protected SalarySettingService salarySettingService;

    @Override
    @Transactional
    public boolean importFile(InputStream fileImportStream, List<ExternalizedMessageWrapper> messageList, String principalId) {
        HashMap<String, String> payRateHoldingPersonUniversalIdentifierKey = new HashMap<String, String>();
        payRateHoldingPersonUniversalIdentifierKey.put("principalId", principalId);
        this.businessObjectService.deleteMatching(BudgetConstructionPayRateHolding.class, payRateHoldingPersonUniversalIdentifierKey);
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(fileImportStream));
        this.importCount = 0;
        try {
            while (fileReader.ready()) {
                BudgetConstructionPayRateHolding budgetConstructionPayRateHolding = new BudgetConstructionPayRateHolding();
                String line = fileReader.readLine();
                ObjectUtil.convertLineToBusinessObject((Object)((Object)budgetConstructionPayRateHolding), (String)line, (int[])DefaultImportFileFormat.fieldLengths, Arrays.asList(DefaultImportFileFormat.fieldNames));
                budgetConstructionPayRateHolding.setPrincipalId(principalId);
                budgetConstructionPayRateHolding.setAppointmentRequestedPayRate(budgetConstructionPayRateHolding.getAppointmentRequestedPayRate().movePointLeft(2));
                this.businessObjectService.save((PersistableBusinessObject)budgetConstructionPayRateHolding);
                ++this.importCount;
            }
        }
        catch (Exception e) {
            this.businessObjectService.deleteMatching(BudgetConstructionPayRateHolding.class, payRateHoldingPersonUniversalIdentifierKey);
            messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.importAborted", new String[0]));
            return false;
        }
        if (this.importCount == 0) {
            messageList.add(new ExternalizedMessageWrapper("message.budget.payrate.noImportRecords", new String[0]));
        } else {
            messageList.add(new ExternalizedMessageWrapper("message.budget.payrate.importCount", String.valueOf(this.importCount)));
        }
        return true;
    }

    @Override
    @Transactional
    public void update(Integer budgetYear, Person user, List<ExternalizedMessageWrapper> messageList, String principalId) {
        ArrayList<PendingBudgetConstructionAppointmentFunding> lockedFundingRecords = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        boolean updateContainsErrors = false;
        this.updateCount = 0;
        HashMap<String, String> payRateHoldingPersonUniversalIdentifierKey = new HashMap<String, String>();
        payRateHoldingPersonUniversalIdentifierKey.put("principalId", principalId);
        List records = (List)this.businessObjectService.findMatching(BudgetConstructionPayRateHolding.class, payRateHoldingPersonUniversalIdentifierKey);
        if (!this.getPayrateLock(lockedFundingRecords, messageList, budgetYear, user, records)) {
            messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.updateAborted", String.valueOf(this.updateCount)));
            this.doRollback();
            return;
        }
        Collection<String> biweeklyPayObjectCodes = BudgetParameterFinder.getBiweeklyPayObjectCodes();
        for (BudgetConstructionPayRateHolding holdingRecord : records) {
            if (holdingRecord.getAppointmentRequestedPayRate().equals(-1.0)) {
                messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.noPayrollMatch", holdingRecord.getEmplid(), holdingRecord.getPositionNumber()));
                updateContainsErrors = true;
                continue;
            }
            List<PendingBudgetConstructionAppointmentFunding> fundingRecords = this.payrateImportDao.getFundingRecords(holdingRecord, budgetYear, biweeklyPayObjectCodes);
            if (fundingRecords.isEmpty()) {
                messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.noActiveFundingRecords", holdingRecord.getEmplid(), holdingRecord.getPositionNumber()));
                updateContainsErrors = true;
                continue;
            }
            for (PendingBudgetConstructionAppointmentFunding fundingRecord : fundingRecords) {
                if (fundingRecord.getAppointmentRequestedPayRate().equals(holdingRecord.getAppointmentRequestedPayRate())) continue;
                if (fundingRecord.getAppointmentRequestedFteQuantity().equals(0) || fundingRecord.getAppointmentRequestedFteQuantity() == null) {
                    messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.noUpdateFteZero", holdingRecord.getEmplid(), holdingRecord.getPositionNumber(), fundingRecord.getChartOfAccountsCode(), fundingRecord.getAccountNumber(), fundingRecord.getSubAccountNumber()));
                    updateContainsErrors = true;
                    continue;
                }
                BigDecimal fteQty = this.salarySettingService.calculateFteQuantity(fundingRecord.getBudgetConstructionPosition().getIuPayMonths(), fundingRecord.getAppointmentFundingMonth(), fundingRecord.getAppointmentRequestedTimePercent());
                BigDecimal annualWorkingHours = BigDecimal.valueOf(BudgetParameterFinder.getAnnualWorkingHours().intValue());
                BigDecimal totalPayHoursForYear = fteQty.multiply(annualWorkingHours);
                KualiInteger annualAmount = new KualiInteger(holdingRecord.getAppointmentRequestedPayRate().multiply(totalPayHoursForYear));
                KualiInteger updateAmount = annualAmount.subtract(fundingRecord.getAppointmentRequestedAmount());
                BudgetConstructionHeader header = this.budgetDocumentService.getBudgetConstructionHeader(fundingRecord);
                if (header == null) {
                    messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.noBudgetDocument", budgetYear.toString(), fundingRecord.getChartOfAccountsCode(), fundingRecord.getAccountNumber(), fundingRecord.getSubAccountNumber()));
                    messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.objectLevelError", fundingRecord.getEmplid(), fundingRecord.getPositionNumber(), fundingRecord.getChartOfAccountsCode(), fundingRecord.getAccountNumber(), fundingRecord.getSubAccountNumber()));
                    updateContainsErrors = true;
                    continue;
                }
                this.budgetDocumentService.updatePendingBudgetGeneralLedger(fundingRecord, updateAmount);
                if (updateAmount.isNonZero()) {
                    this.budgetDocumentService.updatePendingBudgetGeneralLedgerPlug(fundingRecord, updateAmount.negated());
                }
                fundingRecord.setAppointmentRequestedPayRate(holdingRecord.getAppointmentRequestedPayRate());
                fundingRecord.setAppointmentRequestedAmount(annualAmount);
                this.businessObjectService.save((PersistableBusinessObject)fundingRecord);
            }
            ++this.updateCount;
        }
        messageList.add(new ExternalizedMessageWrapper("message.budget.payrate.updateComplete", String.valueOf(this.updateCount)));
        for (PendingBudgetConstructionAppointmentFunding recordToUnlock : lockedFundingRecords) {
            this.lockService.unlockAccount(this.budgetDocumentService.getBudgetConstructionHeader(recordToUnlock));
        }
    }

    @Override
    @NonTransactional
    public void generatePdf(List<ExternalizedMessageWrapper> logMessages, ByteArrayOutputStream baos) throws DocumentException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)baos);
        document.open();
        for (ExternalizedMessageWrapper messageWrapper : logMessages) {
            String message;
            if (messageWrapper.getParams().length == 0) {
                message = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(messageWrapper.getMessageKey());
            } else {
                String temp = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(messageWrapper.getMessageKey());
                message = MessageFormat.format(temp, messageWrapper.getParams());
            }
            document.add((Element)new Paragraph(message));
        }
        document.close();
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    @NonTransactional
    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    @NonTransactional
    public void setPayrateImportDao(PayrateImportDao payrateImportDao) {
        this.payrateImportDao = payrateImportDao;
    }

    @NonTransactional
    public void setBudgetDocumentService(BudgetDocumentService budgetDocumentService) {
        this.budgetDocumentService = budgetDocumentService;
    }

    @NonTransactional
    public void setSalarySettingService(SalarySettingService salarySettingService) {
        this.salarySettingService = salarySettingService;
    }

    protected String getLockingKeyString(PendingBudgetConstructionAppointmentFunding record) {
        return record.getUniversityFiscalYear() + "-" + record.getChartOfAccountsCode() + "-" + record.getAccountNumber() + "-" + record.getSubAccountNumber();
    }

    @Transactional
    protected boolean getPayrateLock(List<PendingBudgetConstructionAppointmentFunding> lockedRecords, List<ExternalizedMessageWrapper> messageList, Integer budgetYear, Person user, List<BudgetConstructionPayRateHolding> records) {
        Collection<String> biweeklyPayObjectCodes = BudgetParameterFinder.getBiweeklyPayObjectCodes();
        for (BudgetConstructionPayRateHolding record : records) {
            List<PendingBudgetConstructionAppointmentFunding> fundingRecords = this.payrateImportDao.getFundingRecords(record, budgetYear, biweeklyPayObjectCodes);
            try {
                lockedRecords.addAll(this.lockService.lockPendingBudgetConstructionAppointmentFundingRecords(fundingRecords, user));
            }
            catch (BudgetConstructionLockUnavailableException e) {
                BudgetConstructionLockStatus lockStatus = e.getLockStatus();
                if (lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.BY_OTHER)) {
                    messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.accountLockExists", new String[0]));
                    return false;
                }
                if (lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.FLOCK_FOUND)) {
                    messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.fundingLockExists", new String[0]));
                    return false;
                }
                if (lockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.SUCCESS)) continue;
                messageList.add(new ExternalizedMessageWrapper("error.budget.payrate.batchAccountLockFailed", new String[0]));
                return false;
            }
        }
        return true;
    }

    protected void doRollback() {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)SpringContext.getBean(PlatformTransactionManager.class);
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
        transactionManager.rollback(transactionStatus);
    }

    protected static class DefaultImportFileFormat {
        private static final int[] fieldLengths = new int[]{11, 8, 50, 5, 4, 3, 3, 10, 8};
        private static final String[] fieldNames = new String[]{"emplid", "positionNumber", "name", "setidSalary", "salaryAdministrationPlan", "grade", "unionCode", "appointmentRequestedPayRate", "csfFreezeDate"};

        protected DefaultImportFileFormat() {
        }
    }
}

