/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.service.impl;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.Incumbent;
import org.kuali.kfs.module.bc.exception.BudgetIncumbentAlreadyExistsException;
import org.kuali.kfs.module.bc.service.BudgetConstructionIntendedIncumbentService;
import org.kuali.kfs.module.bc.service.HumanResourcesPayrollService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class BudgetConstructionIntendedIncumbentServiceImpl
implements BudgetConstructionIntendedIncumbentService {
    private static Logger LOG = Logger.getLogger(BudgetConstructionIntendedIncumbentServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private HumanResourcesPayrollService humanResourcesPayrollService;

    @Override
    @Transactional
    public synchronized void pullNewIncumbentFromExternal(String emplid) throws BudgetIncumbentAlreadyExistsException {
        Incumbent incumbent = this.humanResourcesPayrollService.getIncumbent(emplid);
        BudgetConstructionIntendedIncumbent bcIncumbent = new BudgetConstructionIntendedIncumbent();
        bcIncumbent.setEmplid(incumbent.getEmplid());
        bcIncumbent.setName(incumbent.getName());
        bcIncumbent.setIuClassificationLevel("TL");
        bcIncumbent.setSetidSalary("XXXXX");
        bcIncumbent.setSalaryAdministrationPlan("XXX");
        bcIncumbent.setGrade("YYY");
        bcIncumbent.setActive(Boolean.TRUE);
        BudgetConstructionIntendedIncumbent retrievedIncumbent = this.getByPrimaryId(emplid);
        if (retrievedIncumbent != null) {
            throw new BudgetIncumbentAlreadyExistsException(emplid);
        }
        this.businessObjectService.save((PersistableBusinessObject)bcIncumbent);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void refreshIncumbentFromExternal(String emplid) {
        Incumbent incumbent = this.humanResourcesPayrollService.getIncumbent(emplid);
        BudgetConstructionIntendedIncumbent bcIncumbent = new BudgetConstructionIntendedIncumbent();
        bcIncumbent.setEmplid(incumbent.getEmplid());
        bcIncumbent.setName(incumbent.getName());
        BudgetConstructionIntendedIncumbent retrievedIncumbent = this.getByPrimaryId(emplid);
        bcIncumbent.setVersionNumber(retrievedIncumbent.getVersionNumber());
        bcIncumbent.setIuClassificationLevel("TL");
        bcIncumbent.setSetidSalary("XXXXX");
        bcIncumbent.setSalaryAdministrationPlan("XXX");
        bcIncumbent.setGrade("YYY");
        bcIncumbent.setActive(retrievedIncumbent.isActive());
        this.businessObjectService.save((PersistableBusinessObject)bcIncumbent);
    }

    @Override
    @NonTransactional
    public BudgetConstructionIntendedIncumbent getByPrimaryId(String emplid) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("emplid", emplid);
        return (BudgetConstructionIntendedIncumbent)this.businessObjectService.findByPrimaryKey(BudgetConstructionIntendedIncumbent.class, primaryKeys);
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public void setHumanResourcesPayrollService(HumanResourcesPayrollService humanResourcesPayrollService) {
        this.humanResourcesPayrollService = humanResourcesPayrollService;
    }
}

