/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.service.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.Position;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionDao;
import org.kuali.kfs.module.bc.exception.BudgetPositionAlreadyExistsException;
import org.kuali.kfs.module.bc.service.BudgetConstructionPositionService;
import org.kuali.kfs.module.bc.service.HumanResourcesPayrollService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class BudgetConstructionPositionServiceImpl
implements BudgetConstructionPositionService {
    private static final Logger LOG = Logger.getLogger(BudgetConstructionPositionServiceImpl.class);
    private HumanResourcesPayrollService humanResourcesPayrollService;
    private BusinessObjectService businessObjectService;
    private BudgetConstructionDao budgetConstructionDao;

    @Override
    @Transactional
    public synchronized void pullNewPositionFromExternal(Integer universityFiscalYear, String positionNumber) throws BudgetPositionAlreadyExistsException {
        Position position = this.humanResourcesPayrollService.getPosition(universityFiscalYear, positionNumber);
        BudgetConstructionPosition retrievedPosition = this.getByPrimaryId(universityFiscalYear.toString(), positionNumber);
        if (retrievedPosition != null) {
            throw new BudgetPositionAlreadyExistsException(universityFiscalYear, positionNumber);
        }
        retrievedPosition = new BudgetConstructionPosition();
        BudgetConstructionPosition budgetConstructionPosition = this.buildBudgetPosition(position, retrievedPosition);
        this.businessObjectService.save((PersistableBusinessObject)budgetConstructionPosition);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized void refreshPositionFromExternal(Integer universityFiscalYear, String positionNumber) {
        Position position = this.humanResourcesPayrollService.getPosition(universityFiscalYear, positionNumber);
        BudgetConstructionPosition retrievedPosition = this.getByPrimaryId(universityFiscalYear.toString(), positionNumber);
        BudgetConstructionPosition budgetConstructionPosition = this.buildBudgetPosition(position, retrievedPosition);
        this.businessObjectService.save((PersistableBusinessObject)budgetConstructionPosition);
        this.updateFundingPositionChangeIndicators(universityFiscalYear, positionNumber);
    }

    protected void updateFundingPositionChangeIndicators(Integer universityFiscalYear, String positionNumber) {
        List<PendingBudgetConstructionAppointmentFunding> allPositionFunding = this.budgetConstructionDao.getAllFundingForPosition(universityFiscalYear, positionNumber);
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : allPositionFunding) {
            if (appointmentFunding.isAppointmentFundingDeleteIndicator()) continue;
            appointmentFunding.setPositionObjectChangeIndicator(true);
            appointmentFunding.setPositionSalaryChangeIndicator(true);
            appointmentFunding.setVersionNumber(appointmentFunding.getVersionNumber());
            this.businessObjectService.save((PersistableBusinessObject)appointmentFunding);
        }
    }

    protected BudgetConstructionPosition buildBudgetPosition(Position position, BudgetConstructionPosition budgetConstructionPosition) {
        budgetConstructionPosition.setBudgetedPosition(position.isBudgetedPosition());
        budgetConstructionPosition.setConfidentialPosition(position.isConfidentialPosition());
        budgetConstructionPosition.setIuDefaultObjectCode(position.getIuDefaultObjectCode());
        budgetConstructionPosition.setIuNormalWorkMonths(position.getIuNormalWorkMonths());
        budgetConstructionPosition.setIuPayMonths(position.getIuPayMonths());
        budgetConstructionPosition.setIuPositionType(position.getIuPositionType());
        budgetConstructionPosition.setJobCode(position.getJobCode());
        budgetConstructionPosition.setJobCodeDescription(position.getJobCodeDescription());
        budgetConstructionPosition.setPositionDepartmentIdentifier(position.getPositionDepartmentIdentifier());
        budgetConstructionPosition.setPositionDescription(position.getPositionDescription());
        budgetConstructionPosition.setPositionEffectiveDate(position.getPositionEffectiveDate());
        budgetConstructionPosition.setPositionEffectiveStatus(position.getPositionEffectiveStatus());
        budgetConstructionPosition.setPositionFullTimeEquivalency(position.getPositionFullTimeEquivalency());
        budgetConstructionPosition.setPositionGradeDefault(position.getPositionGradeDefault());
        budgetConstructionPosition.setPositionNumber(position.getPositionNumber());
        budgetConstructionPosition.setPositionRegularTemporary(position.getPositionRegularTemporary());
        budgetConstructionPosition.setPositionSalaryPlanDefault(position.getPositionSalaryPlanDefault());
        budgetConstructionPosition.setPositionStandardHoursDefault(position.getPositionStandardHoursDefault());
        budgetConstructionPosition.setPositionStatus(position.getPositionStatus());
        budgetConstructionPosition.setPositionUnionCode(position.getPositionUnionCode());
        budgetConstructionPosition.setResponsibilityCenterCode(position.getResponsibilityCenterCode());
        budgetConstructionPosition.setSetidDepartment(position.getSetidDepartment());
        budgetConstructionPosition.setSetidJobCode(position.getSetidJobCode());
        budgetConstructionPosition.setSetidSalary(position.getSetidSalary());
        budgetConstructionPosition.setUniversityFiscalYear(position.getUniversityFiscalYear());
        return budgetConstructionPosition;
    }

    @Override
    @NonTransactional
    public BudgetConstructionPosition getByPrimaryId(String fiscalYear, String positionNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("universityFiscalYear", fiscalYear);
        primaryKeys.put("positionNumber", positionNumber);
        return (BudgetConstructionPosition)this.businessObjectService.findByPrimaryKey(BudgetConstructionPosition.class, primaryKeys);
    }

    @Override
    @NonTransactional
    public boolean isBudgetablePosition(BudgetConstructionPosition budgetConstructionPosition) {
        return budgetConstructionPosition != null && budgetConstructionPosition.isBudgetedPosition() && budgetConstructionPosition.isEffective();
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public void setHumanResourcesPayrollService(HumanResourcesPayrollService humanResourcesPayrollService) {
        this.humanResourcesPayrollService = humanResourcesPayrollService;
    }

    @NonTransactional
    public void setBudgetConstructionDao(BudgetConstructionDao budgetConstructionDao) {
        this.budgetConstructionDao = budgetConstructionDao;
    }
}

