/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class SalarySettingCalculator {
    private static final Logger LOG = Logger.getLogger(SalarySettingCalculator.class);

    public static BigDecimal getStandarHours(BigDecimal timePercent) {
        BigDecimal standarHours = timePercent.multiply(BudgetParameterFinder.getWeeklyWorkingHoursAsDecimal()).divide(BCConstants.ONE_HUNDRED, 2, 4);
        return standarHours;
    }

    public static KualiInteger getAppointmentRequestedCsfAmountTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        KualiInteger appointmentRequestedCsfAmountTotal = KualiInteger.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            KualiInteger requestedCsfAmount = appointmentFunding.getAppointmentRequestedCsfAmount();
            if (requestedCsfAmount == null) continue;
            appointmentRequestedCsfAmountTotal = appointmentRequestedCsfAmountTotal.add(requestedCsfAmount);
        }
        return appointmentRequestedCsfAmountTotal;
    }

    public static BigDecimal getAppointmentRequestedCsfTimePercentTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        BigDecimal appointmentRequestedCsfTimePercentTotal = BigDecimal.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            BigDecimal requestedCsfTimePercent = appointmentFunding.getAppointmentRequestedCsfTimePercent();
            if (requestedCsfTimePercent == null) continue;
            appointmentRequestedCsfTimePercentTotal = appointmentRequestedCsfTimePercentTotal.add(requestedCsfTimePercent);
        }
        return appointmentRequestedCsfTimePercentTotal;
    }

    public static BigDecimal getAppointmentRequestedCsfStandardHoursTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        return SalarySettingCalculator.getStandarHours(SalarySettingCalculator.getAppointmentRequestedCsfTimePercentTotal(AppointmentFundings));
    }

    public static BigDecimal getAppointmentRequestedCsfFteQuantityTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        BigDecimal appointmentRequestedCsfFteQuantityTotal = BigDecimal.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            BigDecimal requestedCsfFteQuantity = appointmentFunding.getAppointmentRequestedCsfFteQuantity();
            if (requestedCsfFteQuantity == null) continue;
            appointmentRequestedCsfFteQuantityTotal = appointmentRequestedCsfFteQuantityTotal.add(requestedCsfFteQuantity);
        }
        return appointmentRequestedCsfFteQuantityTotal;
    }

    public static KualiInteger getAppointmentRequestedAmountTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        KualiInteger appointmentRequestedAmountTotal = KualiInteger.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            KualiInteger requestedAmount = appointmentFunding.getAppointmentRequestedAmount();
            if (requestedAmount == null) continue;
            appointmentRequestedAmountTotal = appointmentRequestedAmountTotal.add(requestedAmount);
        }
        return appointmentRequestedAmountTotal;
    }

    public static BigDecimal getAppointmentRequestedTimePercentTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        BigDecimal appointmentRequestedTimePercentTotal = BigDecimal.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            BigDecimal requestedTimePercent = appointmentFunding.getAppointmentRequestedTimePercent();
            if (requestedTimePercent == null) continue;
            appointmentRequestedTimePercentTotal = appointmentRequestedTimePercentTotal.add(requestedTimePercent);
        }
        return appointmentRequestedTimePercentTotal;
    }

    public static BigDecimal getAppointmentRequestedStandardHoursTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        return SalarySettingCalculator.getStandarHours(SalarySettingCalculator.getAppointmentRequestedTimePercentTotal(AppointmentFundings));
    }

    public static BigDecimal getAppointmentRequestedFteQuantityTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        BigDecimal appointmentRequestedFteQuantityTotal = BigDecimal.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            BigDecimal requestedFteQuantity = appointmentFunding.getAppointmentRequestedFteQuantity();
            if (requestedFteQuantity == null) continue;
            appointmentRequestedFteQuantityTotal = appointmentRequestedFteQuantityTotal.add(requestedFteQuantity);
        }
        return appointmentRequestedFteQuantityTotal;
    }

    public static KualiInteger getCsfAmountTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        KualiInteger csfAmountTotal = KualiInteger.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = appointmentFunding.getEffectiveCSFTracker();
            if (csfTracker == null || csfTracker.getCsfAmount() == null) continue;
            csfAmountTotal = csfAmountTotal.add(csfTracker.getCsfAmount());
        }
        return csfAmountTotal;
    }

    public static BigDecimal getCsfTimePercentTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        BigDecimal csfTimePercentTotal = BigDecimal.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = appointmentFunding.getEffectiveCSFTracker();
            if (csfTracker == null || csfTracker.getCsfTimePercent() == null) continue;
            csfTimePercentTotal = csfTimePercentTotal.add(csfTracker.getCsfTimePercent());
        }
        return csfTimePercentTotal;
    }

    public static BigDecimal getCsfStandardHoursTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        return SalarySettingCalculator.getStandarHours(SalarySettingCalculator.getCsfTimePercentTotal(AppointmentFundings));
    }

    public static BigDecimal getCsfFullTimeEmploymentQuantityTotal(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        BigDecimal csfFullTimeEmploymentQuantityTotal = BigDecimal.ZERO;
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = appointmentFunding.getEffectiveCSFTracker();
            if (csfTracker == null || csfTracker.getCsfFullTimeEmploymentQuantity() == null) continue;
            csfFullTimeEmploymentQuantityTotal = csfFullTimeEmploymentQuantityTotal.add(csfTracker.getCsfFullTimeEmploymentQuantity());
        }
        return csfFullTimeEmploymentQuantityTotal;
    }

    public static List<PendingBudgetConstructionAppointmentFunding> getEffectiveAppointmentFundings(List<PendingBudgetConstructionAppointmentFunding> AppointmentFundings) {
        ArrayList<PendingBudgetConstructionAppointmentFunding> effectiveAppointmentFundings = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : AppointmentFundings) {
            if (appointmentFunding.isExcludedFromTotal() || appointmentFunding.isPurged()) continue;
            effectiveAppointmentFundings.add(appointmentFunding);
        }
        return effectiveAppointmentFundings;
    }

    public static KualiDecimal getPercentChange(KualiInteger baseAmount, KualiInteger requestedAmount) {
        KualiDecimal percentChange = null;
        if (requestedAmount != null && baseAmount != null && baseAmount.isNonZero()) {
            KualiInteger difference = requestedAmount.subtract(baseAmount);
            BigDecimal percentChangeAsBigDecimal = difference.multiply(KFSConstants.ONE_HUNDRED).divide(baseAmount);
            percentChange = new KualiDecimal(percentChangeAsBigDecimal);
        }
        return percentChange;
    }
}

