/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.identity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@ConfigureContext
public class BudgetConstructionRoleServiceImplTest
extends KualiTestBase {
    protected Person regionalBudgetManager;
    protected Person universityAdministrationBudgetManager;
    protected Person bothManager;
    protected Person nonProcessor;
    protected RoleService roleService;
    protected PersonService personService;

    protected void setUp() throws Exception {
        super.setUp();
        this.regionalBudgetManager = UserNameFixture.ocmcnall.getPerson();
        this.universityAdministrationBudgetManager = UserNameFixture.wbrazil.getPerson();
        this.bothManager = UserNameFixture.hsoucy.getPerson();
        this.nonProcessor = UserNameFixture.appleton.getPerson();
        this.roleService = KimApiServiceLocator.getRoleService();
        this.personService = KimApiServiceLocator.getPersonService();
    }

    public void testRegionalBudgetManagerQualifications() {
        HashMap qualification = new HashMap();
        List roleQualifiers = this.roleService.getRoleQualifersForPrincipalByNamespaceAndRolename(this.regionalBudgetManager.getPrincipalId(), "KFS-BC", "Processor", qualification);
        BudgetConstructionRoleServiceImplTest.assertNotNull((String)"roleQualifiers should not have returned null", (Object)roleQualifiers);
        BudgetConstructionRoleServiceImplTest.assertFalse((String)"roleQualifiers should not be empty", (boolean)roleQualifiers.isEmpty());
        System.out.println(roleQualifiers);
        BudgetConstructionRoleServiceImplTest.assertTrue((String)"Org EA-EA was not in the list and should have been.", (boolean)this.checkForChartOrg(roleQualifiers, "EA", "EA"));
        BudgetConstructionRoleServiceImplTest.assertFalse((String)"Org UA-UA was in the list and should not have been.", (boolean)this.checkForChartOrg(roleQualifiers, "UA", "UA"));
    }

    public void testUABudgetManagerQualifications() {
        HashMap qualification = new HashMap();
        List roleQualifiers = this.roleService.getRoleQualifersForPrincipalByNamespaceAndRolename(this.universityAdministrationBudgetManager.getPrincipalId(), "KFS-BC", "Processor", qualification);
        BudgetConstructionRoleServiceImplTest.assertNotNull((String)"roleQualifiers should not have returned null", (Object)roleQualifiers);
        BudgetConstructionRoleServiceImplTest.assertFalse((String)"roleQualifiers should not be empty", (boolean)roleQualifiers.isEmpty());
        System.out.println(roleQualifiers);
        BudgetConstructionRoleServiceImplTest.assertTrue((String)"Org UA-UA was not in the list and should have been.", (boolean)this.checkForChartOrg(roleQualifiers, "UA", "UA"));
        BudgetConstructionRoleServiceImplTest.assertFalse((String)"Org EA-EA was in the list and should not have been.", (boolean)this.checkForChartOrg(roleQualifiers, "EA", "EA"));
    }

    public void testBothBudgetManagerQualifications() {
        HashMap qualification = new HashMap();
        List roleQualifiers = this.roleService.getRoleQualifersForPrincipalByNamespaceAndRolename(this.bothManager.getPrincipalId(), "KFS-BC", "Processor", qualification);
        BudgetConstructionRoleServiceImplTest.assertNotNull((String)"roleQualifiers should not have returned null", (Object)roleQualifiers);
        BudgetConstructionRoleServiceImplTest.assertFalse((String)"roleQualifiers should not be empty", (boolean)roleQualifiers.isEmpty());
        System.out.println(roleQualifiers);
        BudgetConstructionRoleServiceImplTest.assertTrue((String)"Org UA-UA was not in the list and should have been.", (boolean)this.checkForChartOrg(roleQualifiers, "UA", "UA"));
        BudgetConstructionRoleServiceImplTest.assertTrue((String)"Org BL-BL was not in the list and should have been.", (boolean)this.checkForChartOrg(roleQualifiers, "BL", "BL"));
    }

    public void testNonProcessorQualifications() {
        HashMap qualification = new HashMap();
        List roleQualifiers = this.roleService.getRoleQualifersForPrincipalByNamespaceAndRolename(this.nonProcessor.getPrincipalId(), "KFS-BC", "Processor", qualification);
        BudgetConstructionRoleServiceImplTest.assertNotNull((String)"roleQualifiers should not have returned null", (Object)roleQualifiers);
        System.out.println(roleQualifiers);
        BudgetConstructionRoleServiceImplTest.assertTrue((String)"roleQualifiers should have been empty", (boolean)roleQualifiers.isEmpty());
    }

    private boolean checkForChartOrg(List<Map<String, String>> roleQualifiers, String chart, String org) {
        boolean found = false;
        for (Map<String, String> q : roleQualifiers) {
            if (!StringUtils.equals((String)q.get("chartOfAccountsCode"), (String)chart) || !StringUtils.equals((String)q.get("chartOfAccountsCode"), (String)org)) continue;
            found = true;
        }
        return found;
    }
}

