/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc;

import java.util.EnumSet;
import org.kuali.kfs.module.bc.BCConstants;

public enum BudgetConstructionReportMode {
    ACCOUNT_FUNDING_DETAIL_REPORT("AccountFundingDetailReport", BCConstants.Report.BuildMode.BCAF, BCConstants.Report.ReportSelectMode.OBJECT_CODE, "BudgetOrgAccountFundingDetail", true),
    ACCOUNT_OBJECT_DETAIL_REPORT("AccountObjectDetailReport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.SUBFUND, "BudgetOrgAccountObjectDetail", true),
    ACCOUNT_SUMMARY_REPORT("AccountSummaryReport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.SUBFUND, "BudgetOrgAccountSummary", true),
    LEVEL_SUMMARY_REPORT("LevelSummaryReport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.SUBFUND, "BudgetOrgLevelSummary", true),
    MONTH_SUMMARY_REPORT("MonthSummaryReport", BCConstants.Report.BuildMode.MONTH, BCConstants.Report.ReportSelectMode.SUBFUND, "BudgetOrgMonthSummary", true),
    OBJECT_SUMMARY_REPORT("ObjectSummaryReport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.SUBFUND, "BudgetOrgObjectSummary", true),
    POSITION_FUNDING_DETAIL_REPORT("PositionFundingDetailReport", BCConstants.Report.BuildMode.BCAF, BCConstants.Report.ReportSelectMode.OBJECT_CODE, "BudgetOrgPositionFundingDetail", true),
    REASON_STATISTICS_REPORT("ReasonStatisticsReport", BCConstants.Report.BuildMode.BCAF, BCConstants.Report.ReportSelectMode.REASON, "BudgetOrgReasonStatistics", false),
    REASON_SUMMARY_REPORT("ReasonSummaryReport", BCConstants.Report.BuildMode.BCAF, BCConstants.Report.ReportSelectMode.REASON, "BudgetOrgReasonSummary", false),
    SALARY_STATISTICS_REPORT("SalaryStatisticsReport", BCConstants.Report.BuildMode.BCAF, BCConstants.Report.ReportSelectMode.OBJECT_CODE, "BudgetOrgSalaryStatistics", true),
    SALARY_SUMMARY_REPORT("SalarySummaryReport", BCConstants.Report.BuildMode.BCAF, BCConstants.Report.ReportSelectMode.OBJECT_CODE, "BudgetOrgSalarySummary", false),
    SUBFUND_SUMMARY_REPORT("SubFundSummaryReport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.SUBFUND, "BudgetOrgSubFundSummary", true),
    SYNCHRONIZATION_PROBLEMS_REPORT("SynchronizationProblemsReport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.ACCOUNT, "BudgetOrgSynchronizationProblems", true),
    TWOPLG_LIST_REPORT("TwoPLGListReport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.ACCOUNT, "BudgetOrgTwoPLGList", true),
    ACCOUNT_EXPORT("AccountExport", BCConstants.Report.BuildMode.PBGL, BCConstants.Report.ReportSelectMode.SUBFUND, true),
    MONTHLY_EXPORT("MonthlyExport", BCConstants.Report.BuildMode.MONTH, BCConstants.Report.ReportSelectMode.SUBFUND, true),
    FUNDING_EXPORT("FundingExport", BCConstants.Report.BuildMode.BCAF, BCConstants.Report.ReportSelectMode.SUBFUND, true);

    public final String reportModeName;
    public final BCConstants.Report.BuildMode reportBuildMode;
    public final BCConstants.Report.ReportSelectMode reportSelectMode;
    public final String jasperFileName;
    public final boolean lockThreshold;
    public final boolean export;

    private BudgetConstructionReportMode(String reportModeName, BCConstants.Report.BuildMode reportBuildMode, BCConstants.Report.ReportSelectMode reportSelectMode, String jasperFileName, boolean lockThreshold) {
        this.reportModeName = reportModeName;
        this.reportBuildMode = reportBuildMode;
        this.reportSelectMode = reportSelectMode;
        this.jasperFileName = jasperFileName;
        this.lockThreshold = lockThreshold;
        this.export = false;
    }

    private BudgetConstructionReportMode(String reportModeName, BCConstants.Report.BuildMode reportBuildMode, BCConstants.Report.ReportSelectMode reportSelectMode, boolean export) {
        this.reportModeName = reportModeName;
        this.reportBuildMode = reportBuildMode;
        this.reportSelectMode = reportSelectMode;
        this.lockThreshold = false;
        this.export = export;
        this.jasperFileName = "";
    }

    public static BudgetConstructionReportMode getBudgetConstructionReportModeByName(String reportModeName) {
        BudgetConstructionReportMode foundReportMode = null;
        for (BudgetConstructionReportMode reportMode : EnumSet.allOf(BudgetConstructionReportMode.class)) {
            if (!reportMode.reportModeName.equals(reportModeName)) continue;
            foundReportMode = reportMode;
            break;
        }
        return foundReportMode;
    }
}

