/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch.dataaccess.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class BudgetConstructionBatchHelperDaoOjb
extends PlatformAwareDaoBaseOjb {
    private String ojbPlatform;
    private HashMap<String, String> countDistinctLeader = null;
    private HashMap<String, String> countDistinctTrailer = null;
    private HashMap<String, String> concatSeparator = null;
    private Integer DEFAULT_QUERY_RETURN_COUNT = 1;

    protected Integer hashCapacity(QueryByCriteria queryID) {
        Double tempValue = (double)((Number)this.getPersistenceBrokerTemplate().getCount((Query)queryID)).floatValue() * 1.45;
        return tempValue.intValue();
    }

    protected Integer hashCapacity(ReportQueryByCriteria queryID) {
        if (queryID.isDistinct() || !queryID.getGroupBy().isEmpty()) {
            Double tempValue = (double)this.queryCountDistinct(queryID).floatValue() * 1.45;
            return tempValue.intValue();
        }
        Double tempValue = (double)((Number)this.getPersistenceBrokerTemplate().getCount((Query)queryID)).floatValue() * 1.45;
        return tempValue.intValue();
    }

    protected Integer hashCapacity(Integer hashSize) {
        Double tempValue = (double)hashSize.floatValue() * 1.45;
        return tempValue.intValue();
    }

    protected Integer hashObjectSize(Class classID, Criteria criteriaID) {
        String[] selectList = new String[]{"COUNT(*)"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(classID, selectList, criteriaID);
        Iterator resultRows = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        if (resultRows.hasNext()) {
            return this.hashCapacity(((Number)((Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)resultRows))[0]).intValue());
        }
        return new Integer(1);
    }

    protected Integer hashObjectSize(Class classID, Criteria criteriaID, String propertyName) {
        String[] selectList = this.buildCountDistinct(propertyName, classID);
        if (selectList[0] == null) {
            return new Integer(this.DEFAULT_QUERY_RETURN_COUNT);
        }
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(classID, selectList, criteriaID);
        Iterator resultRows = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        if (resultRows.hasNext()) {
            return this.hashCapacity(((Number)((Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)resultRows))[0]).intValue());
        }
        return new Integer(1);
    }

    protected Integer hashObjectSize(Class classID, Criteria criteriaID, String[] selectList) {
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(classID, selectList, criteriaID, true);
        return this.hashCapacity(queryID);
    }

    protected String[] buildCountDistinct(ReportQueryByCriteria originalQuery) {
        String[] querySelectList;
        boolean fieldValueFound = false;
        String[] returnSelectList = new String[]{""};
        if (!this.countDistinctLeader.containsKey(this.ojbPlatform)) {
            return returnSelectList;
        }
        StringBuilder countDistinctElement = new StringBuilder(500);
        countDistinctElement.append(this.countDistinctLeader.get(this.ojbPlatform));
        HashMap<String, String> allFields = this.getDBFieldNamesForClass(originalQuery.getSearchClass());
        for (String attributeName : querySelectList = originalQuery.getAttributes()) {
            String columnName = allFields.get(attributeName);
            if (columnName == null) continue;
            if (fieldValueFound) {
                countDistinctElement.append(this.concatSeparator.get(this.ojbPlatform));
            }
            countDistinctElement.append(columnName);
            fieldValueFound = true;
        }
        if (!fieldValueFound) {
            return returnSelectList;
        }
        countDistinctElement.append(this.countDistinctTrailer.get(this.ojbPlatform));
        returnSelectList[0] = countDistinctElement.toString();
        return returnSelectList;
    }

    protected String[] buildCountDistinct(String ojbAttributeName, Class ojbClass) {
        String[] returnSelectList = new String[]{""};
        HashMap<String, String> allFields = this.getDBFieldNamesForClass(ojbClass);
        String dbColumnName = allFields.get(ojbAttributeName);
        if (dbColumnName == null) {
            return returnSelectList;
        }
        returnSelectList[0] = "COUNT(DISTINCT " + dbColumnName + ")";
        return returnSelectList;
    }

    protected HashMap<String, String> getDBFieldNamesForClass(Class ojbClass) {
        ClassDescriptor ojbClassDescriptor = MetadataManager.getInstance().getRepository().getDescriptorFor(ojbClass);
        FieldDescriptor[] fieldDescriptorArray = ojbClassDescriptor.getFieldDescriptions();
        HashMap<String, String> returnSet = new HashMap<String, String>(Double.valueOf(1.34 * (double)fieldDescriptorArray.length).intValue());
        for (FieldDescriptor fieldInDB : fieldDescriptorArray) {
            returnSet.put(fieldInDB.getAttributeName(), fieldInDB.getColumnName());
        }
        return returnSet;
    }

    protected Integer queryCountDistinct(ReportQueryByCriteria originalQuery) {
        String[] countDistinctElement = this.buildCountDistinct(originalQuery);
        if (countDistinctElement[0] == null) {
            return new Integer(this.DEFAULT_QUERY_RETURN_COUNT);
        }
        Class targetClass = originalQuery.getSearchClass();
        Criteria criteriaID = originalQuery.getCriteria();
        ReportQueryByCriteria countQuery = new ReportQueryByCriteria(targetClass, countDistinctElement, criteriaID);
        Iterator resultRows = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)countQuery);
        if (resultRows.hasNext()) {
            return ((Number)((Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)resultRows))[0]).intValue();
        }
        return new Integer(this.DEFAULT_QUERY_RETURN_COUNT);
    }

    public String getOjbPlatform() {
        return this.ojbPlatform;
    }

    public void setOjbPlatform(String ojbPlatform) {
        this.ojbPlatform = ojbPlatform;
    }

    public void setOjbOraclePlatform(String ojbOraclePlatform) {
        if (this.countDistinctLeader == null) {
            this.countDistinctLeader = new HashMap();
        }
        if (this.countDistinctTrailer == null) {
            this.countDistinctTrailer = new HashMap();
        }
        if (this.concatSeparator == null) {
            this.concatSeparator = new HashMap();
        }
        this.countDistinctLeader.put(ojbOraclePlatform, new String("COUNT( DISTINCT "));
        this.countDistinctTrailer.put(ojbOraclePlatform, new String(")"));
        this.concatSeparator.put(ojbOraclePlatform, new String("||"));
    }

    public void setOjbMySqlPlatform(String ojbMySqlPlatform) {
        if (this.countDistinctLeader == null) {
            this.countDistinctLeader = new HashMap();
        }
        if (this.countDistinctTrailer == null) {
            this.countDistinctTrailer = new HashMap();
        }
        if (this.concatSeparator == null) {
            this.concatSeparator = new HashMap();
        }
        this.countDistinctLeader.put(ojbMySqlPlatform, new String("COUNT( DISTINCT CONCAT("));
        this.countDistinctTrailer.put(ojbMySqlPlatform, new String("))"));
        this.concatSeparator.put(ojbMySqlPlatform, new String(","));
    }
}

