/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch.dataaccess.impl;

import java.sql.Date;
import java.util.GregorianCalendar;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.batch.dataaccess.BudgetConstructionHumanResourcesPayrollInterfaceDao;
import org.kuali.kfs.module.bc.document.dataaccess.impl.BudgetConstructionDaoJdbcBase;

public class BudgetConstructionHumanResourcesPayrollInterfaceDaoJdbc
extends BudgetConstructionDaoJdbcBase
implements BudgetConstructionHumanResourcesPayrollInterfaceDao {
    @Override
    public void buildBudgetConstructionAdministrativePosts() {
        String sqlString = new String("DELETE FROM LD_BCN_ADM_POST_T\n");
        this.getSimpleJdbcTemplate().update(sqlString, new Object[0]);
    }

    @Override
    public void buildBudgetConstructionAppointmentFundingReasons(Integer requestFiscalYear) {
        String sqlString = new String("DELETE FROM LD_BCN_AF_REASON_T WHERE (UNIV_FISCAL_YR = ?)\n");
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{requestFiscalYear});
    }

    @Override
    public void buildBudgetConstructionIntendedIncumbent(Integer requestFiscalYear) {
        Integer baseFiscalYear = requestFiscalYear - 1;
        StringBuilder sqlBuilder = new StringBuilder(1500);
        sqlBuilder.append("DELETE FROM LD_BCN_INTINCBNT_T\n");
        sqlBuilder.append("WHERE (EXISTS (SELECT 1\n");
        sqlBuilder.append("               FROM LD_CSF_TRACKER_T\n");
        sqlBuilder.append("               WHERE (LD_CSF_TRACKER_T.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                 AND (LD_CSF_TRACKER_T.EMPLID = LD_BCN_INTINCBNT_T.EMPLID)\n");
        sqlBuilder.append("                 AND (LD_CSF_TRACKER_T.POS_CSF_DELETE_CD = ?)))\n");
        String sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{baseFiscalYear, "-"});
        sqlBuilder.delete(0, sqlBuilder.length());
        String defaultClassificationId = new String("TL");
        GregorianCalendar calendarJuly1 = new GregorianCalendar(baseFiscalYear, 6, 1);
        GregorianCalendar calendarAugust1 = new GregorianCalendar(baseFiscalYear, 7, 1);
        Date julyFirst = new Date(calendarJuly1.getTimeInMillis());
        Date augustFirst = new Date(calendarAugust1.getTimeInMillis());
        sqlBuilder.append("INSERT INTO LD_BCN_INTINCBNT_T\n");
        sqlBuilder.append("(EMPLID, PERSON_NM, SETID_SALARY, SAL_ADMIN_PLAN, GRADE, IU_CLASSIF_LEVEL, ACTV_IND)\n");
        sqlBuilder.append("(SELECT EMPLID, PERSON_NM, BUSINESS_UNIT, POS_SAL_PLAN_DFLT, POS_GRADE_DFLT, ?, 'Y'\n");
        sqlBuilder.append("FROM\n");
        sqlBuilder.append("(SELECT DISTINCT csf.EMPLID,\n");
        sqlBuilder.append("        CONCAT(CONCAT(csf.EMPLID,' LastNm HR'),CONCAT(', ',CONCAT(csf.EMPLID,' 1stNm HR'))) AS PERSON_NM,\n");
        sqlBuilder.append("        pos.BUSINESS_UNIT,\n");
        sqlBuilder.append("        pos.POS_SAL_PLAN_DFLT,\n");
        sqlBuilder.append("        pos.POS_GRADE_DFLT\n");
        sqlBuilder.append(" FROM LD_CSF_TRACKER_T csf,\n");
        sqlBuilder.append(" PS_POSITION_DATA pos\n");
        sqlBuilder.append(" WHERE (csf.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("   AND (csf.POS_CSF_DELETE_CD = ?)\n");
        sqlBuilder.append("   AND (csf.POSITION_NBR = pos.POSITION_NBR)\n");
        sqlBuilder.append("   AND  ((pos.EFFDT <= ?) OR (pos.EFFDT = ?))\n");
        sqlBuilder.append("   AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                    FROM PS_POSITION_DATA pox\n");
        sqlBuilder.append("                    WHERE (pos.POSITION_NBR = pox.POSITION_NBR)\n");
        sqlBuilder.append("                      AND (pos.EFFDT < pox.EFFDT)\n");
        sqlBuilder.append("                      AND ((pox.EFFDT <= ?) OR (pox.EFFDT = ?))))\n");
        sqlBuilder.append("   AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                    FROM LD_CSF_TRACKER_T cfx\n");
        sqlBuilder.append("                    WHERE (csf.UNIV_FISCAL_YR = cfx.UNIV_FISCAL_YR)\n");
        sqlBuilder.append("                      AND (csf.EMPLID = cfx.EMPLID)\n");
        sqlBuilder.append("                      AND (cfx.POS_CSF_DELETE_CD = ?)\n");
        sqlBuilder.append("                      AND (csf.POSITION_NBR < cfx.POSITION_NBR)))) makeUnique)\n");
        sqlString = sqlBuilder.toString();
        Object[] sqlArgumentList = new Object[]{defaultClassificationId, baseFiscalYear, "-", julyFirst, augustFirst, julyFirst, augustFirst, "-"};
        int[] sqlArgumentTypes = new int[]{12, 4, 12, 91, 91, 91, 91, 12};
        this.getSimpleJdbcTemplate().update(sqlString, sqlArgumentList);
    }

    @Override
    public void buildBudgetConstructionIntendedIncumbentWithFacultyAttributes(Integer requestFiscalYear) {
        this.buildBudgetConstructionIntendedIncumbent(requestFiscalYear);
    }

    @Override
    public void buildBudgetConstructionPositionBaseYear(Integer baseFiscalYear) {
        StringBuilder sqlBuilder = new StringBuilder(2000);
        String defaultRCCd = new String("--");
        String orgSeparator = new String("-");
        GregorianCalendar calendarJuly1 = new GregorianCalendar(baseFiscalYear, 6, 1);
        Date julyFirst = new Date(calendarJuly1.getTimeInMillis());
        sqlBuilder.append("DELETE FROM LD_BCN_POS_T\n");
        sqlBuilder.append("WHERE (UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("  AND (EXISTS (SELECT 1\n");
        sqlBuilder.append("               FROM LD_CSF_TRACKER_T\n");
        sqlBuilder.append("               WHERE (LD_CSF_TRACKER_T.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                 AND (LD_CSF_TRACKER_T.POSITION_NBR = LD_BCN_POS_T.POSITION_NBR)\n");
        sqlBuilder.append("                 AND (LD_CSF_TRACKER_T.POS_CSF_DELETE_CD = ?)))\n");
        String sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{baseFiscalYear, baseFiscalYear, "-"});
        sqlBuilder.delete(0, sqlBuilder.length());
        sqlBuilder.append("INSERT INTO LD_BCN_POS_T\n");
        sqlBuilder.append("(POSITION_NBR, UNIV_FISCAL_YR, POS_EFFDT, POS_EFF_STATUS, POSN_STATUS,\n");
        sqlBuilder.append(" BUDGETED_POSN, CONFIDENTIAL_POSN, POS_STD_HRS_DFLT, POS_REG_TEMP, POS_FTE, POS_DESCR, SETID_DEPT, POS_DEPTID,\n");
        sqlBuilder.append(" RC_CD, POS_SAL_PLAN_DFLT, POS_GRADE_DFLT, SETID_JOBCODE, JOBCODE, SETID_SALARY,\n");
        sqlBuilder.append(" POS_LOCK_USR_ID)\n");
        sqlBuilder.append("(SELECT px.POSITION_NBR,\n");
        sqlBuilder.append("        ?, px.EFFDT, px.POS_EFF_STATUS,\n");
        sqlBuilder.append("        px.POSN_STATUS, px.BUDGETED_POSN, 'N',\n");
        sqlBuilder.append("        px.STD_HRS_DEFAULT, px.POS_REG_TEMP, px.POS_FTE, px.DESCR, px.BUSINESS_UNIT,\n");
        sqlBuilder.append("        px.DEPTID, COALESCE(org.RC_CD,?),\n");
        sqlBuilder.append("        px.POS_SAL_PLAN_DFLT, px.POS_GRADE_DFLT, px.BUSINESS_UNIT, px.JOBCODE,\n");
        sqlBuilder.append("        px.BUSINESS_UNIT, ?\n");
        sqlBuilder.append(" FROM PS_POSITION_DATA px LEFT OUTER JOIN LD_BCN_ORG_RPTS_T org\n");
        sqlBuilder.append("      ON (CONCAT(CONCAT(org.FIN_COA_CD,?),org.ORG_CD) = px.DEPTID)\n");
        sqlBuilder.append(" WHERE (px.EFFDT < ?)\n");
        sqlBuilder.append("   AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                    FROM LD_BCN_POS_T\n");
        sqlBuilder.append("                    WHERE (LD_BCN_POS_T.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                      AND (px.POSITION_NBR = LD_BCN_POS_T.POSITION_NBR)))\n");
        sqlBuilder.append("   AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                    FROM PS_POSITION_DATA py\n");
        sqlBuilder.append("                    WHERE (px.POSITION_NBR = py.POSITION_NBR)\n");
        sqlBuilder.append("                      AND (py.EFFDT < ?)\n");
        sqlBuilder.append("                      AND (px.EFFDT < py.EFFDT)))\n");
        sqlBuilder.append("   AND (EXISTS (SELECT 1\n");
        sqlBuilder.append("                FROM LD_CSF_TRACKER_T csf\n");
        sqlBuilder.append("                WHERE (csf.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                  AND (csf.POS_CSF_DELETE_CD = ?)\n");
        sqlBuilder.append("                  AND (csf.POSITION_NBR = px.POSITION_NBR))))\n");
        sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{baseFiscalYear, defaultRCCd, BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS, orgSeparator, julyFirst, baseFiscalYear, julyFirst, baseFiscalYear, "-"});
        this.setAcademicDefaultObjectClass(baseFiscalYear);
        this.setMonthlyStaffOvertimeEligibleDefaultObjectClass(baseFiscalYear);
        this.setMonthlyStaffOvertimeExemptDefaultObjectClass(baseFiscalYear);
        this.setBiweeklyStaffDefaultObjectClass(baseFiscalYear);
    }

    @Override
    public void buildBudgetConstructionPositonRequestYear(Integer requestFiscalYear) {
        StringBuilder sqlBuilder = new StringBuilder(2500);
        String defaultRCCd = new String("--");
        String orgSeparator = new String("-");
        Integer baseFiscalYear = requestFiscalYear - 1;
        GregorianCalendar calendarJuly1 = new GregorianCalendar(baseFiscalYear, 6, 1);
        GregorianCalendar calendarAugust1 = new GregorianCalendar(baseFiscalYear, 7, 1);
        Date julyFirst = new Date(calendarJuly1.getTimeInMillis());
        Date augustFirst = new Date(calendarAugust1.getTimeInMillis());
        String academicPositionType = new String("AC");
        String academicTenureTrackSalaryPlan = new String("AC1");
        sqlBuilder.append("INSERT INTO LD_BCN_POS_T\n");
        sqlBuilder.append("(POSITION_NBR, UNIV_FISCAL_YR, POS_EFFDT, POS_EFF_STATUS, POSN_STATUS,\n");
        sqlBuilder.append(" BUDGETED_POSN, CONFIDENTIAL_POSN, POS_STD_HRS_DFLT, POS_REG_TEMP, POS_FTE, POS_DESCR, SETID_DEPT, POS_DEPTID,\n");
        sqlBuilder.append(" RC_CD, POS_SAL_PLAN_DFLT, POS_GRADE_DFLT, SETID_JOBCODE, JOBCODE, SETID_SALARY,\n");
        sqlBuilder.append(" POS_LOCK_USR_ID)\n");
        sqlBuilder.append("(SELECT px.POSITION_NBR,\n");
        sqlBuilder.append("        ?, px.EFFDT, px.POS_EFF_STATUS,\n");
        sqlBuilder.append("        px.POSN_STATUS, px.BUDGETED_POSN, 'N',\n");
        sqlBuilder.append("        px.STD_HRS_DEFAULT, px.POS_REG_TEMP, px.POS_FTE, px.DESCR, px.BUSINESS_UNIT,\n");
        sqlBuilder.append("        px.DEPTID, COALESCE(org.RC_CD,?),\n");
        sqlBuilder.append("        px.POS_SAL_PLAN_DFLT, px.POS_GRADE_DFLT, px.BUSINESS_UNIT, px.JOBCODE,\n");
        sqlBuilder.append("        px.BUSINESS_UNIT, ?\n");
        sqlBuilder.append(" FROM PS_POSITION_DATA px LEFT OUTER JOIN LD_BCN_ORG_RPTS_T org\n");
        sqlBuilder.append("      ON (CONCAT(CONCAT(org.FIN_COA_CD,?),org.ORG_CD) = px.DEPTID)\n");
        sqlBuilder.append(" WHERE ((px.EFFDT <= ?) OR ((px.EFFDT = ?) AND (px.POS_SAL_PLAN_DFLT = ?)))\n");
        sqlBuilder.append("   AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                    FROM LD_BCN_POS_T\n");
        sqlBuilder.append("                    WHERE (LD_BCN_POS_T.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                      AND (px.POSITION_NBR = LD_BCN_POS_T.POSITION_NBR)))\n");
        sqlBuilder.append("   AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                    FROM PS_POSITION_DATA py\n");
        sqlBuilder.append("                    WHERE (px.POSITION_NBR = py.POSITION_NBR)\n");
        sqlBuilder.append("                      AND ((py.EFFDT <= ?) OR ((py.EFFDT = ?) AND (px.POS_SAL_PLAN_DFLT = ?)))\n");
        sqlBuilder.append("                      AND (px.EFFDT < py.EFFDT)))\n");
        sqlBuilder.append("   AND (EXISTS (SELECT 1\n");
        sqlBuilder.append("                FROM LD_CSF_TRACKER_T csf\n");
        sqlBuilder.append("                WHERE (csf.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                  AND (csf.POS_CSF_DELETE_CD = ?)\n");
        sqlBuilder.append("                  AND (csf.POSITION_NBR = px.POSITION_NBR))))\n");
        String sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{requestFiscalYear, defaultRCCd, BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS, orgSeparator, julyFirst, augustFirst, academicTenureTrackSalaryPlan, requestFiscalYear, julyFirst, augustFirst, academicTenureTrackSalaryPlan, baseFiscalYear, "-"});
        this.setAcademicDefaultObjectClass(requestFiscalYear);
        this.setMonthlyStaffOvertimeEligibleDefaultObjectClass(requestFiscalYear);
        this.setMonthlyStaffOvertimeExemptDefaultObjectClass(requestFiscalYear);
        this.setBiweeklyStaffDefaultObjectClass(requestFiscalYear);
    }

    protected void setAcademicDefaultObjectClass(Integer fiscalYear) {
        Integer monthConstant = new Integer(10);
        String positionType = new String("AC");
        String defaultObject = new String("2000");
        String salaryPlan = new String("AC1");
        StringBuilder sqlBuilder = new StringBuilder(500);
        sqlBuilder.append("UPDATE LD_BCN_POS_T\n");
        sqlBuilder.append("SET IU_NORM_WORK_MONTHS = ?,\n");
        sqlBuilder.append("    IU_PAY_MONTHS = ?,\n");
        sqlBuilder.append("    IU_POSITION_TYPE = ?,\n");
        sqlBuilder.append("    IU_DFLT_OBJ_CD = ?\n");
        sqlBuilder.append("WHERE (UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("  AND (POS_SAL_PLAN_DFLT = ?)");
        String sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{monthConstant, monthConstant, positionType, defaultObject, fiscalYear, salaryPlan});
    }

    protected void setMonthlyStaffOvertimeEligibleDefaultObjectClass(Integer fiscalYear) {
        Integer monthConstant = new Integer(12);
        String positionType = new String("SM");
        String defaultObject = new String("2480");
        String[] salaryPlan = new String[]{new String("PAO"), new String("PAU")};
        StringBuilder sqlBuilder = new StringBuilder(500);
        sqlBuilder.append("UPDATE LD_BCN_POS_T\n");
        sqlBuilder.append("SET IU_NORM_WORK_MONTHS = ?,\n");
        sqlBuilder.append("    IU_PAY_MONTHS = ?,\n");
        sqlBuilder.append("    IU_POSITION_TYPE = ?,\n");
        sqlBuilder.append("    IU_DFLT_OBJ_CD = ?\n");
        sqlBuilder.append("WHERE (UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("  AND (POS_SAL_PLAN_DFLT IN (?,?))\n");
        String sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{monthConstant, monthConstant, positionType, defaultObject, fiscalYear, salaryPlan[0], salaryPlan[1]});
    }

    protected void setMonthlyStaffOvertimeExemptDefaultObjectClass(Integer fiscalYear) {
        Integer monthConstant = new Integer(12);
        String positionType = new String("SM");
        String defaultObject = new String("2400");
        String salaryPlan = new String("P%");
        StringBuilder sqlBuilder = new StringBuilder(500);
        sqlBuilder.append("UPDATE LD_BCN_POS_T\n");
        sqlBuilder.append("SET IU_NORM_WORK_MONTHS = ?,\n");
        sqlBuilder.append("    IU_PAY_MONTHS = ?,\n");
        sqlBuilder.append("    IU_POSITION_TYPE = ?,\n");
        sqlBuilder.append("    IU_DFLT_OBJ_CD = ?\n");
        sqlBuilder.append("WHERE (UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("  AND (POS_SAL_PLAN_DFLT LIKE ?)\n");
        sqlBuilder.append("  AND (IU_DFLT_OBJ_CD IS NULL)\n");
        String sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{monthConstant, monthConstant, positionType, defaultObject, fiscalYear, salaryPlan});
    }

    protected void setBiweeklyStaffDefaultObjectClass(Integer fiscalYear) {
        Integer monthConstant = new Integer(12);
        String positionType = new String("SB");
        String defaultObject = new String("2500");
        String defaultUnionCode = new String("B1");
        StringBuilder sqlBuilder = new StringBuilder(500);
        sqlBuilder.append("UPDATE LD_BCN_POS_T\n");
        sqlBuilder.append("SET IU_NORM_WORK_MONTHS = ?,\n");
        sqlBuilder.append("    IU_PAY_MONTHS = ?,\n");
        sqlBuilder.append("    IU_POSITION_TYPE = ?,\n");
        sqlBuilder.append("    POS_UNION_CD = ?,\n");
        sqlBuilder.append("    IU_DFLT_OBJ_CD = ?\n");
        sqlBuilder.append("WHERE (UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("  AND (IU_DFLT_OBJ_CD IS NULL)\n");
        String sqlString = sqlBuilder.toString();
        this.getSimpleJdbcTemplate().update(sqlString, new Object[]{monthConstant, monthConstant, positionType, defaultUnionCode, defaultObject, fiscalYear});
    }

    @Override
    public void updateNamesInBudgetConstructionIntendedIncumbent() {
    }
}

