/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountSalaryDetailReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountSalaryDetailReportTotal;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAdministrativePost;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountSalaryDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.report.BudgetConstructionReportHelper;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionAccountSalaryDetailReportServiceImpl
implements BudgetConstructionAccountSalaryDetailReportService {
    protected ConfigurationService kualiConfigurationService;
    protected BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper;
    protected SalarySettingService salarySettingService;

    @Override
    public Collection<BudgetConstructionAccountSalaryDetailReport> buildReports(Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber, String subAccountNumber) {
        ArrayList<BudgetConstructionAccountSalaryDetailReport> reportSet = new ArrayList<BudgetConstructionAccountSalaryDetailReport>();
        Map<String, Object> searchCriteria = this.buildSearchCriteria(universityFiscalYear, chartOfAccountsCode, accountNumber, subAccountNumber);
        List<String> orderList = this.buildOrderByList();
        Collection pendingAppointmentFundingList = this.budgetConstructionReportsServiceHelper.getDataForBuildingReports(PendingBudgetConstructionAppointmentFunding.class, searchCriteria, orderList);
        List listForTotal = BudgetConstructionReportHelper.deleteDuplicated((List)pendingAppointmentFundingList, this.fieldsForTotal());
        Collection<BudgetConstructionAccountSalaryDetailReportTotal> accountSalaryDetailTotal = this.calculateTotal(pendingAppointmentFundingList, listForTotal);
        for (PendingBudgetConstructionAppointmentFunding pendingAppointmentFunding : pendingAppointmentFundingList) {
            BudgetConstructionAccountSalaryDetailReport accountSalaryDetailReport = new BudgetConstructionAccountSalaryDetailReport();
            this.buildReportsHeader(universityFiscalYear, pendingAppointmentFunding, accountSalaryDetailReport);
            this.buildReportsBody(universityFiscalYear, pendingAppointmentFunding, accountSalaryDetailReport);
            this.buildReportsTotal(pendingAppointmentFunding, accountSalaryDetailReport, accountSalaryDetailTotal);
            reportSet.add(accountSalaryDetailReport);
        }
        return reportSet;
    }

    protected void buildReportsHeader(Integer universityFiscalYear, PendingBudgetConstructionAppointmentFunding pendingAppointmentFunding, BudgetConstructionAccountSalaryDetailReport accountSalaryDetailReport) {
        Integer prevFiscalyear = universityFiscalYear - 1;
        accountSalaryDetailReport.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        accountSalaryDetailReport.setAccountNumber(pendingAppointmentFunding.getAccountNumber());
        accountSalaryDetailReport.setSubAccountNumber(pendingAppointmentFunding.getSubAccountNumber());
        accountSalaryDetailReport.setChartOfAccountsCode(pendingAppointmentFunding.getChartOfAccountsCode());
        accountSalaryDetailReport.setOrganizationCode(pendingAppointmentFunding.getAccount().getOrganizationCode());
        String chartOfAccountDescription = "";
        if (pendingAppointmentFunding.getChartOfAccounts() != null) {
            try {
                chartOfAccountDescription = pendingAppointmentFunding.getChartOfAccounts().getFinChartOfAccountDescription();
            }
            catch (PersistenceBrokerException e) {
                chartOfAccountDescription = this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription");
            }
        } else {
            chartOfAccountDescription = "Chart not defined";
        }
        accountSalaryDetailReport.setChartOfAccountDescription(chartOfAccountDescription);
        String orgName = null;
        try {
            orgName = pendingAppointmentFunding.getAccount().getOrganization().getOrganizationName();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        String accountName = pendingAppointmentFunding.getAccount().getAccountName();
        String fundGroupCode = pendingAppointmentFunding.getAccount().getSubFundGroup().getFundGroupCode();
        String fundGroupName = pendingAppointmentFunding.getAccount().getSubFundGroup().getFundGroup().getName();
        if (orgName == null) {
            accountSalaryDetailReport.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            accountSalaryDetailReport.setOrganizationName(orgName);
        }
        if (fundGroupCode == null) {
            accountSalaryDetailReport.setFundGroupCode(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingFundGroupCode"));
        } else {
            accountSalaryDetailReport.setFundGroupCode(fundGroupCode);
        }
        if (fundGroupName == null) {
            accountSalaryDetailReport.setFundGroupName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingFundGroupName"));
        } else {
            accountSalaryDetailReport.setFundGroupName(fundGroupName);
        }
        if (accountName == null) {
            accountSalaryDetailReport.setAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingAccountDescription"));
        } else {
            accountSalaryDetailReport.setAccountName(accountName);
        }
        String subAccountName = "";
        if (!pendingAppointmentFunding.getSubAccountNumber().equals(KFSConstants.getDashSubAccountNumber())) {
            try {
                subAccountName = pendingAppointmentFunding.getSubAccount().getSubAccountName();
            }
            catch (PersistenceBrokerException e) {
                subAccountName = this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubAccountDescription");
            }
        }
        accountSalaryDetailReport.setSubAccountName(subAccountName);
    }

    protected void buildReportsBody(Integer universityFiscalYear, PendingBudgetConstructionAppointmentFunding pendingAppointmentFunding, BudgetConstructionAccountSalaryDetailReport accountMonthlyDetailReport) {
        Integer amountChange = new Integer(0);
        BigDecimal percentChange = BigDecimal.ZERO;
        BudgetConstructionIntendedIncumbent intendedIncumbent = this.budgetConstructionReportsServiceHelper.getBudgetConstructionIntendedIncumbent(pendingAppointmentFunding);
        BudgetConstructionAdministrativePost administrativePost = this.budgetConstructionReportsServiceHelper.getBudgetConstructionAdministrativePost(pendingAppointmentFunding);
        BudgetConstructionPosition position = this.budgetConstructionReportsServiceHelper.getBudgetConstructionPosition(universityFiscalYear, pendingAppointmentFunding);
        BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = pendingAppointmentFunding.getEffectiveCSFTracker();
        accountMonthlyDetailReport.setFinancialSubObjectCode(pendingAppointmentFunding.getFinancialSubObjectCode());
        if (intendedIncumbent != null) {
            accountMonthlyDetailReport.setIuClassificationLevel(intendedIncumbent.getIuClassificationLevel());
        }
        if (administrativePost != null) {
            accountMonthlyDetailReport.setAdministrativePost(administrativePost.getAdministrativePost());
        }
        if (position != null) {
            accountMonthlyDetailReport.setPositionNumber(position.getPositionNumber());
            accountMonthlyDetailReport.setPositionSalaryPlanDefault(position.getPositionSalaryPlanDefault());
            accountMonthlyDetailReport.setPositionGradeDefault(position.getPositionGradeDefault());
            accountMonthlyDetailReport.setNormalWorkMonthsAndiuPayMonths(position.getIuNormalWorkMonths() + "/" + position.getIuPayMonths());
        }
        if (csfTracker != null) {
            accountMonthlyDetailReport.setPositionCsfAmount(csfTracker.getCsfAmount().intValue());
            accountMonthlyDetailReport.setCsfTimePercent(BudgetConstructionReportHelper.setDecimalDigit(csfTracker.getCsfTimePercent(), 2, false));
            accountMonthlyDetailReport.setPositionCsfFullTimeEmploymentQuantity(BudgetConstructionReportHelper.setDecimalDigit(csfTracker.getCsfFullTimeEmploymentQuantity(), 5, false));
            accountMonthlyDetailReport.setPositionCsfFundingStatusCode(csfTracker.getCsfFundingStatusCode());
            BigDecimal csfFte = BudgetConstructionReportHelper.setDecimalDigit(csfTracker.getCsfFullTimeEmploymentQuantity(), 5, false);
            BigDecimal reqFte = BudgetConstructionReportHelper.setDecimalDigit(pendingAppointmentFunding.getAppointmentRequestedFteQuantity(), 5, false);
            if (reqFte.compareTo(csfFte) == 0) {
                amountChange = pendingAppointmentFunding.getAppointmentRequestedAmount().subtract(csfTracker.getCsfAmount()).intValue();
                if (!csfTracker.getCsfAmount().equals((Object)KualiInteger.ZERO)) {
                    percentChange = BudgetConstructionReportHelper.calculatePercent(amountChange, csfTracker.getCsfAmount().intValue());
                }
            }
        }
        accountMonthlyDetailReport.setAppointmentFundingMonth(pendingAppointmentFunding.getAppointmentFundingMonth());
        if (this.salarySettingService.isHourlyPaidObject(pendingAppointmentFunding.getUniversityFiscalYear(), pendingAppointmentFunding.getChartOfAccountsCode(), pendingAppointmentFunding.getFinancialObjectCode())) {
            accountMonthlyDetailReport.setAppointmentRequestedPayRate(pendingAppointmentFunding.getAppointmentRequestedPayRate());
        }
        accountMonthlyDetailReport.setAppointmentRequestedAmount(pendingAppointmentFunding.getAppointmentRequestedAmount().intValue());
        accountMonthlyDetailReport.setAppointmentRequestedTimePercent(BudgetConstructionReportHelper.setDecimalDigit(pendingAppointmentFunding.getAppointmentRequestedTimePercent(), 2, false));
        accountMonthlyDetailReport.setAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(pendingAppointmentFunding.getAppointmentRequestedFteQuantity(), 5, false));
        accountMonthlyDetailReport.setAppointmentRequestedCsfAmount(pendingAppointmentFunding.getAppointmentRequestedCsfAmount().intValue());
        accountMonthlyDetailReport.setAppointmentRequestedCsfTimePercent(BudgetConstructionReportHelper.setDecimalDigit(pendingAppointmentFunding.getAppointmentRequestedCsfTimePercent(), 2, false));
        accountMonthlyDetailReport.setAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(pendingAppointmentFunding.getAppointmentRequestedCsfFteQuantity(), 5, false));
        accountMonthlyDetailReport.setAppointmentFundingDurationCode(pendingAppointmentFunding.getAppointmentFundingDurationCode());
        accountMonthlyDetailReport.setAppointmentTotalIntendedAmount(pendingAppointmentFunding.getAppointmentTotalIntendedAmount().intValue());
        accountMonthlyDetailReport.setAppointmentTotalIntendedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(pendingAppointmentFunding.getAppointmentTotalIntendedFteQuantity(), 5, false));
        accountMonthlyDetailReport.setFinancialObjectCode(pendingAppointmentFunding.getFinancialObjectCode());
        accountMonthlyDetailReport.setFinancialObjectCodeName(pendingAppointmentFunding.getFinancialObject().getFinancialObjectCodeName());
        String deleteBox = pendingAppointmentFunding.isAppointmentFundingDeleteIndicator() ? "*" : "";
        accountMonthlyDetailReport.setDeleteBox(deleteBox);
        if (pendingAppointmentFunding.getEmplid().equals("VACANT")) {
            accountMonthlyDetailReport.setName("VACANT");
        } else {
            int nameLength = intendedIncumbent.getName().length();
            accountMonthlyDetailReport.setName(intendedIncumbent.getName().substring(0, nameLength > 35 ? 35 : nameLength));
        }
        accountMonthlyDetailReport.setAmountChange(amountChange);
        accountMonthlyDetailReport.setPercentChange(percentChange);
    }

    protected void buildReportsTotal(PendingBudgetConstructionAppointmentFunding pendingAppointmentFunding, BudgetConstructionAccountSalaryDetailReport accountMonthlyDetailReport, Collection<BudgetConstructionAccountSalaryDetailReportTotal> accountSalaryDetailTotal) {
        for (BudgetConstructionAccountSalaryDetailReportTotal totalEntry : accountSalaryDetailTotal) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)totalEntry.getPendingBudgetConstructionAppointmentFunding(), (BusinessObject)pendingAppointmentFunding, this.fieldsForTotal())) continue;
            String objectCodeName = "";
            if (pendingAppointmentFunding.getFinancialObject() != null) {
                try {
                    objectCodeName = pendingAppointmentFunding.getFinancialObject().getFinancialObjectCodeName();
                }
                catch (PersistenceBrokerException e) {
                    objectCodeName = this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingObjectName");
                }
            } else {
                objectCodeName = "Object not defined";
            }
            accountMonthlyDetailReport.setTotalDescription(objectCodeName);
            accountMonthlyDetailReport.setTotalBaseAmount(totalEntry.getTotalBaseAmount());
            accountMonthlyDetailReport.setTotalBaseFte(totalEntry.getTotalBaseFte());
            accountMonthlyDetailReport.setTotalRequestAmount(totalEntry.getTotalRequestAmount());
            accountMonthlyDetailReport.setTotalRequestFte(totalEntry.getTotalRequestFte());
            accountMonthlyDetailReport.setTotalAmountChange(totalEntry.getTotalRequestAmount() - totalEntry.getTotalBaseAmount());
            accountMonthlyDetailReport.setTotalPercentChange(BudgetConstructionReportHelper.calculatePercent(accountMonthlyDetailReport.getTotalAmountChange(), totalEntry.getTotalBaseAmount()));
        }
    }

    protected Collection<BudgetConstructionAccountSalaryDetailReportTotal> calculateTotal(Collection<PendingBudgetConstructionAppointmentFunding> pendingAppointmentFundingList, List<PendingBudgetConstructionAppointmentFunding> listForTotal) {
        ArrayList<BudgetConstructionAccountSalaryDetailReportTotal> reportTotals = new ArrayList<BudgetConstructionAccountSalaryDetailReportTotal>();
        for (PendingBudgetConstructionAppointmentFunding totalEntry : listForTotal) {
            KualiInteger totalBaseAmount = KualiInteger.ZERO;
            BigDecimal totalBaseFte = BigDecimal.ZERO;
            Integer totalRequestAmount = new Integer(0);
            BigDecimal totalRequestFte = BigDecimal.ZERO;
            BudgetConstructionAccountSalaryDetailReportTotal budgetConstructionAccountSalaryDetailReportTotal = new BudgetConstructionAccountSalaryDetailReportTotal();
            for (PendingBudgetConstructionAppointmentFunding appointmentFundingEntry : pendingAppointmentFundingList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)totalEntry, (BusinessObject)appointmentFundingEntry, this.fieldsForTotal())) continue;
                BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = appointmentFundingEntry.getEffectiveCSFTracker();
                if (csfTracker != null) {
                    totalBaseAmount = totalBaseAmount.add(csfTracker.getCsfAmount());
                    totalBaseFte = totalBaseFte.add(csfTracker.getCsfFullTimeEmploymentQuantity());
                }
                totalRequestAmount = totalRequestAmount + new Integer(appointmentFundingEntry.getAppointmentRequestedAmount().intValue());
                totalRequestFte = totalRequestFte.add(appointmentFundingEntry.getAppointmentRequestedFteQuantity());
            }
            budgetConstructionAccountSalaryDetailReportTotal.setTotalBaseAmount(totalBaseAmount.intValue());
            budgetConstructionAccountSalaryDetailReportTotal.setTotalBaseFte(totalBaseFte);
            budgetConstructionAccountSalaryDetailReportTotal.setTotalRequestAmount(totalRequestAmount);
            budgetConstructionAccountSalaryDetailReportTotal.setTotalRequestFte(totalRequestFte);
            budgetConstructionAccountSalaryDetailReportTotal.setPendingBudgetConstructionAppointmentFunding(totalEntry);
            reportTotals.add(budgetConstructionAccountSalaryDetailReportTotal);
        }
        return reportTotals;
    }

    protected List<String> fieldsForTotal() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("financialObjectCode");
        return fieldList;
    }

    protected List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("financialObjectCode");
        returnList.add("financialSubObjectCode");
        returnList.add("positionNumber");
        returnList.add("emplid");
        return returnList;
    }

    protected Map<String, Object> buildSearchCriteria(Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber, String subAccountNumber) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", universityFiscalYear);
        searchCriteria.put("chartOfAccountsCode", chartOfAccountsCode);
        searchCriteria.put("accountNumber", accountNumber);
        searchCriteria.put("subAccountNumber", subAccountNumber);
        return searchCriteria;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBudgetConstructionReportsServiceHelper(BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper) {
        this.budgetConstructionReportsServiceHelper = budgetConstructionReportsServiceHelper;
    }

    public void setSalarySettingService(SalarySettingService salarySettingService) {
        this.salarySettingService = salarySettingService;
    }
}

