/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.SalarySettingRuleHelperService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.service.HumanResourcesPayrollService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class SalarySettingRuleHelperServiceImpl
implements SalarySettingRuleHelperService {
    private static final Logger LOG = Logger.getLogger(SalarySettingRuleHelperServiceImpl.class);
    protected SalarySettingService salarySettingService;
    protected HumanResourcesPayrollService humanResourcesPayrollService;

    @Override
    public boolean canBeAdjusted(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        if (appointmentFunding.getEffectiveCSFTracker() == null) {
            return false;
        }
        return !appointmentFunding.isAppointmentFundingDeleteIndicator();
    }

    @Override
    public boolean hasActiveJob(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap, BCConstants.SynchronizationCheckType synchronizationCheckType) {
        Integer fiscalYear = appointmentFunding.getUniversityFiscalYear();
        String emplid = appointmentFunding.getEmplid();
        String positionNumber = appointmentFunding.getPositionNumber();
        if (synchronizationCheckType.equals((Object)BCConstants.SynchronizationCheckType.EID) && emplid.equals("VACANT")) {
            return true;
        }
        boolean hasActiveJob = this.humanResourcesPayrollService.isActiveJob(emplid, positionNumber, fiscalYear, synchronizationCheckType);
        if (!hasActiveJob) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.noActiveJobFound", new String[]{appointmentFunding.getEmplid(), appointmentFunding.getPositionNumber()});
            return false;
        }
        return true;
    }

    @Override
    public boolean hasObjectCodeMatchingDefaultOfPosition(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String defaultObjectCode = appointmentFunding.getBudgetConstructionPosition().getIuDefaultObjectCode();
        String objectCode = appointmentFunding.getFinancialObjectCode();
        if (!StringUtils.equals((String)objectCode, (String)defaultObjectCode)) {
            errorMap.putError("financialObjectCode", "error.budget.notDefaultObjectCode", new String[]{defaultObjectCode});
            return false;
        }
        return true;
    }

    @Override
    public boolean hasRequestedAmountZeroWhenFullYearLeave(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        KualiInteger requestedAmount;
        String leaveDurationCode = appointmentFunding.getAppointmentFundingDurationCode();
        if ((StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.LWPA.durationCode) || StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.LWPF.durationCode)) && !(requestedAmount = appointmentFunding.getAppointmentRequestedAmount()).isZero()) {
            errorMap.putError("appointmentRequestedAmount", "error.budget.requestedAmountNotZeroWhenFullYearleave", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasRequestedFteQuantityZeroWhenFullYearLeave(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String leaveDurationCode = appointmentFunding.getAppointmentFundingDurationCode();
        if (StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.LWPA.durationCode) || StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.LWPF.durationCode)) {
            BigDecimal requestedFteQuantity = appointmentFunding.getAppointmentRequestedFteQuantity();
            if (requestedFteQuantity.compareTo(BigDecimal.ZERO) != 0) {
                errorMap.putError("appointmentRequestedFteQuantity", "error.budget.requestedFteNotZeroWhenFullYearleave", new String[0]);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean hasNoExistingLine(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        boolean hasNoExistingLine;
        boolean bl = hasNoExistingLine = this.salarySettingService.findAppointmentFunding(appointmentFundings, appointmentFunding) == null;
        if (!hasNoExistingLine) {
            errorMap.putError("newBCAFLine", "error.budget.duplicateFundingLine", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidRequestedAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        KualiInteger requestedAmount = appointmentFunding.getAppointmentRequestedAmount();
        if (requestedAmount == null || requestedAmount.isNegative()) {
            errorMap.putError("appointmentRequestedAmount", "error.budget.requestedSalaryIsNonnegative", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidRequestedAmountQuickSalarySetting(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        if (this.hasValidRequestedAmount(appointmentFunding, errorMap)) {
            KualiInteger requestedAmount = appointmentFunding.getAppointmentRequestedAmount();
            BigDecimal requestedFteQuantity = appointmentFunding.getAppointmentRequestedFteQuantity();
            BigDecimal hourlyRate = appointmentFunding.getAppointmentRequestedPayRate();
            if (requestedAmount.isPositive() && requestedFteQuantity != null && requestedFteQuantity.compareTo(BigDecimal.ZERO) == 0) {
                errorMap.putError("appointmentRequestedAmount", "error.budget.requestedSalaryNeedsFteFirst", new String[0]);
                return false;
            }
            if (hourlyRate != null && hourlyRate.compareTo(BigDecimal.ZERO) != 0 && requestedFteQuantity != null && requestedFteQuantity.compareTo(BigDecimal.ZERO) == 0) {
                errorMap.putError("appointmentRequestedPayRate", "error.budget.requestedSalaryNeedsFteFirst", new String[0]);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidRequestedCsfAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        KualiInteger csfAmount = appointmentFunding.getAppointmentRequestedCsfAmount();
        String leaveDurationCode = appointmentFunding.getAppointmentFundingDurationCode();
        if (!StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.NONE.durationCode)) {
            if (csfAmount == null || !csfAmount.isPositive()) {
                errorMap.putError("appointmentRequestedCsfAmount", "error.budget.fteAmountGreaterThanZero", new String[0]);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean hasValidRequestedCsfTimePercent(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        BigDecimal csfTimePercent = appointmentFunding.getAppointmentRequestedCsfTimePercent();
        String leaveDurationCode = appointmentFunding.getAppointmentFundingDurationCode();
        if (!StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.NONE.durationCode)) {
            if (csfTimePercent == null || csfTimePercent.compareTo(BigDecimal.ZERO) <= 0 || csfTimePercent.compareTo(BCConstants.ONE_HUNDRED) > 0) {
                errorMap.putError("appointmentRequestedCsfTimePercent", "error.budget.leaveTimePercentNotInRange", new String[]{BigDecimal.ZERO.toPlainString(), BCConstants.ONE_HUNDRED.toPlainString()});
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean hasValidRequestedFteQuantity(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        BigDecimal requestedFteQuantity = appointmentFunding.getAppointmentRequestedFteQuantity();
        if (requestedFteQuantity == null || requestedFteQuantity.compareTo(BigDecimal.ZERO) < 0 || requestedFteQuantity.compareTo(BigDecimal.ONE) > 0) {
            errorMap.putError("appointmentRequestedFteQuantity", "error.budget.fteQuantityNotInRange", new String[]{BigDecimal.ZERO.toPlainString(), BigDecimal.ONE.toPlainString()});
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidRequestedFundingMonth(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        Integer fundingMonths = appointmentFunding.getAppointmentFundingMonth();
        if (fundingMonths == null) {
            errorMap.putError("appointmentFundingMonth", "error.budget.emptyFundingMonth", new String[0]);
            return false;
        }
        String leaveDurationCode = appointmentFunding.getAppointmentFundingDurationCode();
        Integer normalWorkMonths = appointmentFunding.getBudgetConstructionPosition().getIuNormalWorkMonths();
        if (!StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.NONE.durationCode)) {
            if (fundingMonths < 0 || fundingMonths > normalWorkMonths) {
                errorMap.putError("appointmentFundingMonth", "error.budget.fundingMonthNotInRange", new String[]{ObjectUtils.toString((Object)fundingMonths), "0", ObjectUtils.toString((Object)normalWorkMonths)});
                return false;
            }
            return true;
        }
        if (!fundingMonths.equals(normalWorkMonths)) {
            errorMap.putError("appointmentFundingMonth", "error.budget.notEqualNormalWorkMonths", new String[]{ObjectUtils.toString((Object)fundingMonths), ObjectUtils.toString((Object)normalWorkMonths)});
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidRequestedTimePercent(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        KualiInteger requestedAmount = appointmentFunding.getAppointmentRequestedAmount();
        BigDecimal requestedTimePercent = appointmentFunding.getAppointmentRequestedTimePercent();
        BigDecimal hourlyRate = appointmentFunding.getAppointmentRequestedPayRate();
        if (requestedTimePercent == null) {
            errorMap.putError("appointmentRequestedTimePercent", "error.budget.emptyRequestedTimePercent", new String[0]);
            return false;
        }
        if (requestedTimePercent.compareTo(BigDecimal.ZERO) < 0 || requestedTimePercent.compareTo(BCConstants.ONE_HUNDRED) > 0) {
            errorMap.putError("appointmentRequestedTimePercent", "error.budget.timePercentNotInRange", new String[]{BigDecimal.ZERO.toPlainString(), BCConstants.ONE_HUNDRED.toPlainString()});
            return false;
        }
        if ((requestedAmount.isPositive() || hourlyRate != null && hourlyRate.compareTo(BigDecimal.ZERO) != 0) && requestedTimePercent.compareTo(BigDecimal.ZERO) <= 0) {
            errorMap.putError("appointmentRequestedTimePercent", "error.budget.timePercentGreaterThanZero", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidAdjustmentAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        KualiDecimal adjustmentAmount = appointmentFunding.getAdjustmentAmount();
        if (adjustmentAmount == null) {
            errorMap.putError("adjustmentAmount", "error.budget.adjustmentAmountRequired", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidPayRateOrAnnualAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        BigDecimal payRate = appointmentFunding.getAppointmentRequestedPayRate();
        KualiInteger requestedAmount = appointmentFunding.getAppointmentRequestedAmount();
        if (requestedAmount == null && payRate == null) {
            errorMap.putError("appointmentRequestedPayRate", "error.budget.emptyPayRateAnnualAmount", new String[0]);
            errorMap.putError("appointmentRequestedAmount", "error.budget.emptyPayRateAnnualAmount", new String[0]);
            return false;
        }
        return true;
    }

    public void setSalarySettingService(SalarySettingService salarySettingService) {
        this.salarySettingService = salarySettingService;
    }

    public void setHumanResourcesPayrollService(HumanResourcesPayrollService humanResourcesPayrollService) {
        this.humanResourcesPayrollService = humanResourcesPayrollService;
    }
}

