/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionProcessorService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.document.web.struts.SalarySettingBaseForm;
import org.kuali.kfs.module.bc.util.SalarySettingFieldsHolder;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public abstract class DetailSalarySettingForm
extends SalarySettingBaseForm {
    private static final Logger LOG = Logger.getLogger(DetailSalarySettingForm.class);
    private PendingBudgetConstructionAppointmentFunding newBCAFLine;
    private boolean addLine;
    private String positionNumber;
    private String emplid;
    private String name;
    private SalarySettingService salarySettingService = (SalarySettingService)SpringContext.getBean(SalarySettingService.class);
    private BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
    private LockService lockService = (LockService)SpringContext.getBean(LockService.class);
    private BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    private static final List<String> comparableFields = DetailSalarySettingForm.getComparableFields();

    public DetailSalarySettingForm() {
        this.setEditingMode(new HashMap<String, String>());
        this.setNewBCAFLine(new PendingBudgetConstructionAppointmentFunding());
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        this.setSingleAccountMode(this.resetSingleAccountModeFlag());
        this.populateBCAFLines();
    }

    @Override
    public void populateBCAFLines() {
        super.populateBCAFLines();
        this.refreshBCAFLine(this.getNewBCAFLine());
    }

    @Override
    public void refreshBCAFLine(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        super.refreshBCAFLine(appointmentFunding);
        appointmentFunding.refreshReferenceObject("budgetConstructionIntendedIncumbent");
        appointmentFunding.refreshReferenceObject("budgetConstructionPosition");
        appointmentFunding.refreshReferenceObject("budgetConstructionAdministrativePost");
    }

    public boolean acquirePositionAndFundingLocks(MessageMap errorMap) {
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = this.getAppointmentFundings();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            boolean gotLocks = this.acquirePositionAndFundingLocks(appointmentFunding, errorMap);
            if (gotLocks) continue;
            return false;
        }
        return true;
    }

    public boolean acquirePositionAndFundingLocks(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        LOG.debug((Object)"acquirePositionAndFundingLocks() started");
        try {
            BudgetConstructionLockStatus positionLockingStatus;
            String principalId;
            Integer universityFiscalYear;
            if (appointmentFunding.isDisplayOnlyMode() || !appointmentFunding.isBudgetable()) {
                return true;
            }
            BudgetConstructionPosition position = appointmentFunding.getBudgetConstructionPosition();
            String positionNumber = position.getPositionNumber();
            Boolean positionWasAlreadyLocked = this.lockService.isPositionLockedByUser(positionNumber, universityFiscalYear = position.getUniversityFiscalYear(), principalId = this.getPerson().getPrincipalId());
            if (!positionWasAlreadyLocked.booleanValue() && !BCConstants.LockStatus.SUCCESS.equals((Object)(positionLockingStatus = this.lockService.lockPosition(position, this.getPerson())).getLockStatus())) {
                errorMap.putError("newBCAFLine", "error.budget.failToLockPosition", new String[]{"Position Number:" + position.getPositionNumber() + ", Fiscal Year:" + position.getUniversityFiscalYear().toString() + ", Desc:" + position.getPositionDescription() + ", Locked By:" + position.getPositionLockUser().getPrincipalName()});
                if (!appointmentFunding.isNewLineIndicator()) {
                    this.releasePositionAndFundingLocks();
                }
                return false;
            }
            BudgetConstructionLockStatus fundingLockingStatus = this.getLockStatusForBudgetByAccountMode(appointmentFunding);
            if (fundingLockingStatus == null) {
                fundingLockingStatus = this.lockService.lockFunding(appointmentFunding, this.getPerson());
            }
            if (!BCConstants.LockStatus.SUCCESS.equals((Object)fundingLockingStatus.getLockStatus())) {
                String lockUserName = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(fundingLockingStatus.getAccountLockOwner()).getPrincipalName();
                errorMap.putError("newBCAFLine", "error.budget.failToLockFunding", new String[]{appointmentFunding.getAppointmentFundingString() + ", Document Locked By:" + lockUserName});
                if (!appointmentFunding.isNewLineIndicator()) {
                    this.releasePositionAndFundingLocks();
                } else if (!positionWasAlreadyLocked.booleanValue()) {
                    this.lockService.unlockPosition(positionNumber, universityFiscalYear, principalId);
                }
                return false;
            }
        }
        catch (Exception e) {
            this.releasePositionAndFundingLocks();
            String errorMessage = "Failed when acquiring position/funding lock for " + (Object)((Object)appointmentFunding);
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        return true;
    }

    public boolean updateAccessMode(MessageMap errorMap) {
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = this.getAppointmentFundings();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            boolean accessModeUpdated = this.updateAccessMode(appointmentFunding, errorMap);
            if (accessModeUpdated) continue;
            return false;
        }
        return true;
    }

    public boolean updateAccessMode(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        LOG.debug((Object)"updateAccessMode() started");
        try {
            SalarySettingFieldsHolder fieldsHolder = this.getSalarySettingFieldsHolder();
            boolean updated = this.salarySettingService.updateAccessOfAppointmentFunding(appointmentFunding, fieldsHolder, this.isBudgetByAccountMode(), this.isEditAllowed(), this.getPerson());
            if (!updated) {
                errorMap.putError("newBCAFLine", "error.budget.failToUpdateFundingAccess", new String[]{appointmentFunding.getAppointmentFundingString()});
                return false;
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to update the access mode of " + (Object)((Object)appointmentFunding) + ".";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        return true;
    }

    public boolean acquireTransactionLocks(MessageMap messageMap) {
        LOG.debug((Object)"acquireTransactionLocks() started");
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : this.getSavableAppointmentFundings()) {
            try {
                BudgetConstructionLockStatus transactionLockStatus = this.getLockStatusForBudgetByAccountMode(appointmentFunding);
                if (transactionLockStatus == null) {
                    transactionLockStatus = this.lockService.lockTransaction(appointmentFunding, this.getPerson());
                }
                if (BCConstants.LockStatus.SUCCESS.equals((Object)transactionLockStatus.getLockStatus())) continue;
                messageMap.putError("newBCAFLine", "error.budget.failToAcquireTransactionLock", new String[]{appointmentFunding.getAppointmentFundingString()});
                this.releaseTransactionLocks();
                return false;
            }
            catch (Exception e) {
                this.releaseTransactionLocks();
                this.releasePositionAndFundingLocks();
                LOG.error((Object)("Failed when acquiring transaction lock for " + (Object)((Object)appointmentFunding)), (Throwable)e);
                throw new RuntimeException("Failed when acquiring transaction lock for " + (Object)((Object)appointmentFunding), e);
            }
        }
        return true;
    }

    public void releasePositionAndFundingLocks() {
        LOG.debug((Object)"releasePositionAndFundingLocks() started");
        List<PendingBudgetConstructionAppointmentFunding> releasableAppointmentFundings = this.getReleasableAppointmentFundings();
        this.lockService.unlockFunding(releasableAppointmentFundings, this.getPerson());
        HashSet<BudgetConstructionPosition> lockedPositionSet = new HashSet<BudgetConstructionPosition>();
        for (PendingBudgetConstructionAppointmentFunding fundingLine : releasableAppointmentFundings) {
            lockedPositionSet.add(fundingLine.getBudgetConstructionPosition());
            LOG.info((Object)("fundingLine: " + (Object)((Object)fundingLine)));
        }
        LOG.info((Object)("releasePositionAndFundingLocks()" + lockedPositionSet));
        ArrayList<BudgetConstructionPosition> lockedPositions = new ArrayList<BudgetConstructionPosition>();
        lockedPositions.addAll(lockedPositionSet);
        this.lockService.unlockPostion(lockedPositions, this.getPerson());
        for (BudgetConstructionPosition position : lockedPositionSet) {
            LOG.info((Object)("fundingLine: " + position.getPositionLockUserIdentifier()));
        }
    }

    public void releaseTransactionLocks() {
        LOG.debug((Object)"releaseTransactionLocks() started");
        List<PendingBudgetConstructionAppointmentFunding> fundingsWithTransactionLocks = this.getReleasableAppointmentFundings();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : fundingsWithTransactionLocks) {
            this.lockService.unlockTransaction(appointmentFunding, this.getPerson());
        }
    }

    public List<PendingBudgetConstructionAppointmentFunding> getSavableAppointmentFundings() {
        LOG.debug((Object)"getSavableAppointmentFundings() started");
        ArrayList<PendingBudgetConstructionAppointmentFunding> savableAppointmentFundings = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        for (PendingBudgetConstructionAppointmentFunding fundingLine : this.getAppointmentFundings()) {
            if (fundingLine.isDisplayOnlyMode()) continue;
            savableAppointmentFundings.add(fundingLine);
        }
        return savableAppointmentFundings;
    }

    public List<PendingBudgetConstructionAppointmentFunding> getReleasableAppointmentFundings() {
        LOG.debug((Object)"getReleasableAppointmentFundings() started");
        List<PendingBudgetConstructionAppointmentFunding> savableAppointmentFundings = this.getSavableAppointmentFundings();
        ArrayList<PendingBudgetConstructionAppointmentFunding> releasableAppointmentFundings = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        releasableAppointmentFundings.addAll(savableAppointmentFundings);
        return releasableAppointmentFundings;
    }

    public List<PendingBudgetConstructionAppointmentFunding> getActiveFundingLines() {
        LOG.debug((Object)"getActiveFundingLines() started");
        ArrayList<PendingBudgetConstructionAppointmentFunding> activeFundingLines = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : this.getSavableAppointmentFundings()) {
            if (appointmentFunding.isAppointmentFundingDeleteIndicator()) continue;
            activeFundingLines.add(appointmentFunding);
        }
        return activeFundingLines;
    }

    public PendingBudgetConstructionAppointmentFunding createNewAppointmentFundingLine() {
        PendingBudgetConstructionAppointmentFunding appointmentFunding = new PendingBudgetConstructionAppointmentFunding();
        if (this.isAddLine() || this.isSingleAccountMode()) {
            appointmentFunding.setChartOfAccountsCode(this.getChartOfAccountsCode());
            appointmentFunding.setAccountNumber(this.getAccountNumber());
            if (this.getSubAccountNumber().equals(KFSConstants.getDashSubAccountNumber())) {
                appointmentFunding.setSubAccountNumber("");
            } else {
                appointmentFunding.setSubAccountNumber(this.getSubAccountNumber());
            }
            appointmentFunding.setFinancialObjectCode(this.getFinancialObjectCode());
            if (this.getFinancialSubObjectCode().equals(KFSConstants.getDashFinancialSubObjectCode())) {
                appointmentFunding.setFinancialSubObjectCode("");
            } else {
                appointmentFunding.setFinancialSubObjectCode(this.getFinancialSubObjectCode());
            }
        }
        appointmentFunding.setUniversityFiscalYear(this.getUniversityFiscalYear());
        appointmentFunding.setAppointmentFundingDeleteIndicator(false);
        appointmentFunding.setNewLineIndicator(true);
        appointmentFunding.setAppointmentFundingDurationCode(BCConstants.AppointmentFundingDurationCodes.NONE.durationCode);
        return appointmentFunding;
    }

    public void pickAppointmentFundingsForSingleAccount() {
        LOG.debug((Object)"pickAppointmentFundingsForSingleAccount() started");
        ArrayList<PendingBudgetConstructionAppointmentFunding> excludedFundings = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : this.getAppointmentFundings()) {
            if (ObjectUtil.equals((Object)((Object)appointmentFunding), (Object)((Object)this), comparableFields)) continue;
            excludedFundings.add(appointmentFunding);
        }
        this.getAppointmentFundings().removeAll(excludedFundings);
    }

    private BudgetConstructionLockStatus getLockStatusForBudgetByAccountMode(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"getLockStatusForBudgetByAccountMode() started");
        BudgetConstructionLockStatus transactionLockStatus = null;
        if (this.isBudgetByAccountMode() && ObjectUtil.equals((Object)((Object)appointmentFunding), (Object)((Object)this), comparableFields)) {
            transactionLockStatus = new BudgetConstructionLockStatus();
            transactionLockStatus.setLockStatus(BCConstants.LockStatus.SUCCESS);
        }
        return transactionLockStatus;
    }

    public static List<String> getComparableFields() {
        ArrayList<String> comparableFields = new ArrayList<String>();
        comparableFields.add("chartOfAccountsCode");
        comparableFields.add("accountNumber");
        comparableFields.add("subAccountNumber");
        return comparableFields;
    }

    private boolean resetSingleAccountModeFlag() {
        List<Organization> processorOrgs = ((BudgetConstructionProcessorService)SpringContext.getBean(BudgetConstructionProcessorService.class)).getProcessorOrgs(this.getPerson());
        Boolean isOrgApprover = processorOrgs != null && !processorOrgs.isEmpty();
        if (this.isBudgetByAccountMode()) {
            Account account = new Account();
            account.setAccountNumber(this.getAccountNumber());
            account.setChartOfAccountsCode(this.getChartOfAccountsCode());
            account = (Account)this.businessObjectService.retrieve((PersistableBusinessObject)account);
            RoleService roleService = KimApiServiceLocator.getRoleService();
            HashMap<String, String> qualification = new HashMap<String, String>();
            qualification.put("chartOfAccountsCode", this.getChartOfAccountsCode());
            qualification.put("accountNumber", this.getAccountNumber());
            qualification.put("documentTypeName", "BC");
            ArrayList<String> roleId = new ArrayList<String>();
            roleId.add(roleService.getRoleIdByNamespaceCodeAndName("KFS-SYS", "Fiscal Officer"));
            Boolean isFiscalOfficerOrDelegate = roleService.principalHasRole(this.getPerson().getPrincipalId(), roleId, qualification);
            return isFiscalOfficerOrDelegate != false && isOrgApprover == false;
        }
        if (isOrgApprover.booleanValue()) {
            return false;
        }
        throw new RuntimeException("Access denied: not authorized to do the detail salary setting");
    }

    public PendingBudgetConstructionAppointmentFunding getNewBCAFLine() {
        return this.newBCAFLine;
    }

    public void setNewBCAFLine(PendingBudgetConstructionAppointmentFunding newBCAFLine) {
        this.newBCAFLine = newBCAFLine;
    }

    public String getEmplid() {
        return this.emplid;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public boolean isAddLine() {
        return this.addLine;
    }

    public void setAddLine(boolean addLine) {
        this.addLine = addLine;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean shouldPropertyBePopulatedInForm(String requestParameterName, HttpServletRequest request) {
        if (super.shouldPropertyBePopulatedInForm(requestParameterName, request)) {
            return true;
        }
        return requestParameterName.endsWith("appointmentRequestedCsfAmount") || requestParameterName.endsWith("appointmentRequestedCsfTimePercent") || requestParameterName.endsWith("appointmentFundingReasonAmount") || requestParameterName.endsWith("chartOfAccountsCode");
    }
}

