/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAuthorizationStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.validation.event.SaveMonthlyBudgetEvent;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionForm;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionAction;
import org.kuali.kfs.module.bc.document.web.struts.MonthlyBudgetForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class MonthlyBudgetAction
extends BudgetExpansionAction {
    private static final Logger LOG = Logger.getLogger(MonthlyBudgetAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        MonthlyBudgetForm monthlyBudgetForm = (MonthlyBudgetForm)form;
        this.populateAuthorizationFields(monthlyBudgetForm);
        if (monthlyBudgetForm.getMethodToCall().equals("loadExpansionScreen")) {
            BudgetConstructionMonthly bcMonthly = monthlyBudgetForm.getBudgetConstructionMonthly();
            PendingBudgetConstructionGeneralLedger pbgl = bcMonthly.getPendingBudgetConstructionGeneralLedger();
            boolean tmpReadOnly = monthlyBudgetForm.isSystemViewOnly() || !monthlyBudgetForm.isEditAllowed();
            tmpReadOnly |= bcMonthly.getFinancialObjectCode().equalsIgnoreCase("2PLG");
            boolean bl = !monthlyBudgetForm.isBenefitsCalculationDisabled() && pbgl.getLaborObject() != null && pbgl.getLaborObject().getFinancialObjectFringeOrSalaryCode().equalsIgnoreCase("F");
            monthlyBudgetForm.setBudgetableDocument(((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).isBudgetableDocumentNoWagesCheck(pbgl.getBudgetConstructionHeader()));
            monthlyBudgetForm.setMonthlyReadOnly(tmpReadOnly |= bl);
        }
        return forward;
    }

    protected void populateAuthorizationFields(MonthlyBudgetForm monthlyBudgetForm) {
        BudgetConstructionAuthorizationStatus authorizationStatus = (BudgetConstructionAuthorizationStatus)GlobalVariables.getUserSession().retrieveObject("BcDocEditStatus");
        if (authorizationStatus == null) {
            return;
        }
        monthlyBudgetForm.setDocumentActions(authorizationStatus.getDocumentActions());
        monthlyBudgetForm.setEditingMode(authorizationStatus.getEditingMode());
    }

    public ActionForward loadExpansionScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm monthlyBudgetForm = (MonthlyBudgetForm)form;
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("documentNumber", monthlyBudgetForm.getDocumentNumber());
        fieldValues.put("universityFiscalYear", monthlyBudgetForm.getUniversityFiscalYear());
        fieldValues.put("chartOfAccountsCode", monthlyBudgetForm.getChartOfAccountsCode());
        fieldValues.put("accountNumber", monthlyBudgetForm.getAccountNumber());
        fieldValues.put("subAccountNumber", monthlyBudgetForm.getSubAccountNumber());
        fieldValues.put("financialObjectCode", monthlyBudgetForm.getFinancialObjectCode());
        fieldValues.put("financialSubObjectCode", monthlyBudgetForm.getFinancialSubObjectCode());
        fieldValues.put("financialBalanceTypeCode", monthlyBudgetForm.getFinancialBalanceTypeCode());
        fieldValues.put("financialObjectTypeCode", monthlyBudgetForm.getFinancialObjectTypeCode());
        BudgetConstructionMonthly budgetConstructionMonthly = (BudgetConstructionMonthly)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionMonthly.class, fieldValues);
        if (budgetConstructionMonthly == null) {
            budgetConstructionMonthly = new BudgetConstructionMonthly();
            budgetConstructionMonthly.setDocumentNumber(monthlyBudgetForm.getDocumentNumber());
            budgetConstructionMonthly.setUniversityFiscalYear(monthlyBudgetForm.getUniversityFiscalYear());
            budgetConstructionMonthly.setChartOfAccountsCode(monthlyBudgetForm.getChartOfAccountsCode());
            budgetConstructionMonthly.setAccountNumber(monthlyBudgetForm.getAccountNumber());
            budgetConstructionMonthly.setSubAccountNumber(monthlyBudgetForm.getSubAccountNumber());
            budgetConstructionMonthly.setFinancialObjectCode(monthlyBudgetForm.getFinancialObjectCode());
            budgetConstructionMonthly.setFinancialSubObjectCode(monthlyBudgetForm.getFinancialSubObjectCode());
            budgetConstructionMonthly.setFinancialBalanceTypeCode(monthlyBudgetForm.getFinancialBalanceTypeCode());
            budgetConstructionMonthly.setFinancialObjectTypeCode(monthlyBudgetForm.getFinancialObjectTypeCode());
            budgetConstructionMonthly.refreshReferenceObject("pendingBudgetConstructionGeneralLedger");
            monthlyBudgetForm.setMonthlyPersisted(false);
        } else {
            monthlyBudgetForm.setMonthlyPersisted(true);
        }
        monthlyBudgetForm.setBudgetConstructionMonthly(budgetConstructionMonthly);
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm monthlyBudgetForm = (MonthlyBudgetForm)form;
        BudgetConstructionMonthly budgetConstructionMonthly = monthlyBudgetForm.getBudgetConstructionMonthly();
        this.replaceMonthlyNullWithZero(budgetConstructionMonthly);
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)((Object)GlobalVariables.getUserSession().retrieveObject(monthlyBudgetForm.getReturnFormKey()));
        BudgetConstructionDocument bcDoc = budgetConstructionForm.getBudgetConstructionDocument();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new SaveMonthlyBudgetEvent("budgetConstructionMonthly", (Document)bcDoc, budgetConstructionMonthly));
        if (rulePassed) {
            KualiInteger pbglRequestAmount;
            KualiInteger monthTotalAmount = budgetConstructionMonthly.getFinancialDocumentMonthTotalLineAmount();
            if (!monthTotalAmount.equals((Object)(pbglRequestAmount = budgetConstructionMonthly.getPendingBudgetConstructionGeneralLedger().getAccountLineAnnualBalanceAmount()))) {
                String question = request.getParameter("questionIndex");
                ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
                if (question == null || !"cf.confirmationQuestion".equals(question)) {
                    String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("document.budget.question.confirmMonthlyOverride.text");
                    questionText = StringUtils.replace((String)questionText, (String)"{0}", (String)pbglRequestAmount.toString());
                    questionText = StringUtils.replace((String)questionText, (String)"{1}", (String)monthTotalAmount.toString());
                    return this.performQuestionWithoutInput(mapping, form, request, response, "cf.confirmationQuestion", questionText, "cf.confirmationQuestion", "save", "");
                }
                String buttonClicked = request.getParameter("buttonClicked");
                if ("cf.confirmationQuestion".equals(question) && "0".equals(buttonClicked)) {
                    ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).saveMonthlyBudget(monthlyBudgetForm, budgetConstructionMonthly);
                    KNSGlobalVariables.getMessageList().add("message.budget.monthlyAnnualOverrideSaved", new String[0]);
                    monthlyBudgetForm.setMonthlyPersisted(true);
                }
            } else {
                ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).saveMonthlyBudget(monthlyBudgetForm, budgetConstructionMonthly);
                KNSGlobalVariables.getMessageList().add("message.saved", new String[0]);
                monthlyBudgetForm.setMonthlyPersisted(true);
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm monthlyBudgetForm = (MonthlyBudgetForm)form;
        BudgetConstructionMonthly budgetConstructionMonthly = monthlyBudgetForm.getBudgetConstructionMonthly();
        if (!monthlyBudgetForm.isMonthlyReadOnly()) {
            String question = request.getParameter("questionIndex");
            ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", kualiConfiguration.getPropertyValueAsString("document.question.saveBeforeClose.text"), "cf.confirmationQuestion", "close", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("cf.confirmationQuestion".equals(question) || "DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
                return this.save(mapping, form, request, response);
            }
        }
        return this.returnToCaller(mapping, form, request, response);
    }

    public ActionForward performMonthlySpread(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm tForm = (MonthlyBudgetForm)form;
        BudgetConstructionMonthly bcMth = tForm.getBudgetConstructionMonthly();
        KualiInteger requestAmt = bcMth.getPendingBudgetConstructionGeneralLedger().getAccountLineAnnualBalanceAmount();
        if (requestAmt != null) {
            bcMth.setFinancialDocumentMonth2LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth3LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth4LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth5LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth6LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth7LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth8LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth9LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth10LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth11LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            bcMth.setFinancialDocumentMonth12LineAmount(new KualiInteger(requestAmt.divide(new KualiInteger(12L))));
            KualiInteger totSoFar = bcMth.getFinancialDocumentMonth2LineAmount();
            totSoFar = totSoFar.add(bcMth.getFinancialDocumentMonth3LineAmount().add(bcMth.getFinancialDocumentMonth4LineAmount()));
            totSoFar = totSoFar.add(bcMth.getFinancialDocumentMonth5LineAmount().add(bcMth.getFinancialDocumentMonth6LineAmount()));
            totSoFar = totSoFar.add(bcMth.getFinancialDocumentMonth7LineAmount().add(bcMth.getFinancialDocumentMonth8LineAmount()));
            totSoFar = totSoFar.add(bcMth.getFinancialDocumentMonth9LineAmount().add(bcMth.getFinancialDocumentMonth10LineAmount()));
            totSoFar = totSoFar.add(bcMth.getFinancialDocumentMonth11LineAmount().add(bcMth.getFinancialDocumentMonth12LineAmount()));
            bcMth.setFinancialDocumentMonth1LineAmount(requestAmt.subtract(totSoFar));
        }
        return mapping.findForward("basic");
    }

    public ActionForward performMonthlyZero(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm tForm = (MonthlyBudgetForm)form;
        BudgetConstructionMonthly bcMth = tForm.getBudgetConstructionMonthly();
        bcMth.setFinancialDocumentMonth1LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth2LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth3LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth4LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth5LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth6LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth7LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth8LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth9LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth10LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth11LineAmount(new KualiInteger(0L));
        bcMth.setFinancialDocumentMonth12LineAmount(new KualiInteger(0L));
        return mapping.findForward("basic");
    }

    public ActionForward performMonthlyDelete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm monthlyBudgetForm = (MonthlyBudgetForm)form;
        BudgetConstructionMonthly budgetConstructionMonthly = monthlyBudgetForm.getBudgetConstructionMonthly();
        if (!monthlyBudgetForm.isSystemViewOnly() && monthlyBudgetForm.isEditAllowed()) {
            String question = request.getParameter("questionIndex");
            ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocDelete", kualiConfiguration.getPropertyValueAsString("document.question.delete.text"), "cf.confirmationQuestion", "close", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("DocDelete".equals(question) && "0".equals(buttonClicked)) {
                ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).delete((PersistableBusinessObject)budgetConstructionMonthly);
                BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)((Object)GlobalVariables.getUserSession().retrieveObject(monthlyBudgetForm.getReturnFormKey()));
                BudgetConstructionDocument bcDoc = budgetConstructionForm.getBudgetConstructionDocument();
                ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).callForBenefitsCalcIfNeeded(bcDoc, budgetConstructionMonthly, KualiInteger.ZERO);
                return this.returnToCaller(mapping, form, request, response);
            }
        }
        return mapping.findForward("basic");
    }

    public void replaceMonthlyNullWithZero(BudgetConstructionMonthly bcMth) {
        if (bcMth.getFinancialDocumentMonth1LineAmount() == null) {
            bcMth.setFinancialDocumentMonth1LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth2LineAmount() == null) {
            bcMth.setFinancialDocumentMonth2LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth3LineAmount() == null) {
            bcMth.setFinancialDocumentMonth3LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth4LineAmount() == null) {
            bcMth.setFinancialDocumentMonth4LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth5LineAmount() == null) {
            bcMth.setFinancialDocumentMonth5LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth6LineAmount() == null) {
            bcMth.setFinancialDocumentMonth6LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth7LineAmount() == null) {
            bcMth.setFinancialDocumentMonth7LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth8LineAmount() == null) {
            bcMth.setFinancialDocumentMonth8LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth9LineAmount() == null) {
            bcMth.setFinancialDocumentMonth9LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth10LineAmount() == null) {
            bcMth.setFinancialDocumentMonth10LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth11LineAmount() == null) {
            bcMth.setFinancialDocumentMonth11LineAmount(new KualiInteger(0L));
        }
        if (bcMth.getFinancialDocumentMonth12LineAmount() == null) {
            bcMth.setFinancialDocumentMonth12LineAmount(new KualiInteger(0L));
        }
    }

    public ActionForward showDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm tForm = (MonthlyBudgetForm)form;
        tForm.setHideDetails(false);
        return mapping.findForward("basic");
    }

    public ActionForward hideDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonthlyBudgetForm tForm = (MonthlyBudgetForm)form;
        tForm.setHideDetails(true);
        return mapping.findForward("basic");
    }
}

