/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import org.kuali.kfs.fp.businessobject.FiscalYearFunctionControl;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionFundingLock;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionDao;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LockServiceTest
extends KualiTestBase {
    private LockService lockService;
    private BudgetConstructionDao bcHeaderDao;
    private FinancialSystemDocumentHeader docHeader;
    private BudgetConstructionHeader bcHeader;
    private BudgetConstructionHeader bcHeaderTwo;
    private BudgetConstructionPosition bcPosition;
    private PendingBudgetConstructionAppointmentFunding bcAFunding;
    private BudgetConstructionLockStatus bcLockStatus;
    private BCConstants.LockStatus lockStatus;
    private SortedSet<BudgetConstructionFundingLock> fundingLocks;
    Iterator<BudgetConstructionFundingLock> fundingIter;
    private BudgetConstructionFundingLock fundingLock;
    private String fdocNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String emplid;
    private Integer universityFiscalYear;
    private String positionNumber;
    private String pUIdOne = "3670600494";
    private String pUIdTwo = "6162502038";

    public void setUp() throws Exception {
        super.setUp();
        this.lockService = (LockService)SpringContext.getBean(LockService.class);
        this.bcHeaderDao = (BudgetConstructionDao)SpringContext.getBean(BudgetConstructionDao.class);
        if (!this.runTests()) {
            return;
        }
        this.universityFiscalYear = this.setTestFiscalYear();
        LockServiceTest.assertTrue((String)"Unable to obtain fiscal year", (this.universityFiscalYear != 0 ? 1 : 0) != 0);
        System.err.println("Testing Fiscal Year: " + this.universityFiscalYear);
        LockServiceTest.assertTrue((String)"Unable to set test funding", (boolean)this.setTestFunding());
        LockServiceTest.assertTrue((String)"Unable to set test document number", (boolean)this.setTestDocumentNumber());
    }

    public void tearDown() throws Exception {
        this.clearTestRowLocks();
        super.tearDown();
    }

    private boolean runTests() {
        return false;
    }

    @ConfigureContext(shouldCommitTransactions=true)
    public void testOne() {
        if (!this.runTests()) {
            return;
        }
        this.clearTestRowLocks();
        LockServiceTest.assertFalse((String)"test header was unlocked on initialization", (boolean)this.lockService.isAccountLocked(this.bcHeader));
        this.bcLockStatus = this.lockService.lockAccount(this.bcHeader, this.pUIdOne);
        LockServiceTest.assertTrue((String)"account lock attempt on header succeeded", (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)"test header has an account lock", (boolean)this.lockService.isAccountLocked(this.bcHeader));
        this.bcLockStatus = this.lockService.lockAccount(this.bcHeader, this.pUIdOne);
        LockServiceTest.assertTrue((String)"test header locked successfully on second attempt", (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.lockService.unlockAccount(this.bcHeader);
        LockServiceTest.assertFalse((String)"unlock attempt on test header succeeded--no lock found", (boolean)this.lockService.isAccountLocked(this.bcHeader));
        this.bcLockStatus = this.lockService.lockAccount(this.bcHeader, this.pUIdOne);
        LockServiceTest.assertTrue((String)("initial header lock by " + this.pUIdOne + " succeeded"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)("header locked by " + this.pUIdOne), (boolean)this.lockService.isAccountLocked(this.bcHeader));
        this.bcHeaderTwo = this.bcHeaderDao.getByCandidateKey(this.chartOfAccountsCode, this.accountNumber, this.subAccountNumber, this.universityFiscalYear);
        LockServiceTest.assertTrue((String)"two objects pointing to the same header have the same account", (boolean)this.bcHeaderTwo.getAccountNumber().equals(this.accountNumber));
        this.bcLockStatus = this.lockService.lockAccount(this.bcHeaderTwo, this.pUIdTwo);
        LockServiceTest.assertTrue((String)(this.pUIdTwo + " could not get a lock on header already locked by " + this.pUIdOne), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.BY_OTHER ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)("lock is owned by " + this.pUIdOne), (boolean)this.bcLockStatus.getAccountLockOwner().equals(this.pUIdOne));
        LockServiceTest.assertTrue((String)(this.pUIdTwo + "'s pointer to the test header row shows a lock"), (boolean)this.lockService.isAccountLocked(this.bcHeaderTwo));
        this.bcLockStatus = this.lockService.lockFunding(this.bcHeader, this.pUIdOne);
        LockServiceTest.assertTrue((String)"failed funding lock attempt on a header with an existing acccount lock", (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.BY_OTHER ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)"no funding locks exist after failed attempt", (boolean)this.lockService.getFundingLocks(this.bcHeader).isEmpty());
        this.lockService.unlockAccount(this.bcHeaderTwo);
        LockServiceTest.assertFalse((String)"account was unlocked successfully", (boolean)this.lockService.isAccountLocked(this.bcHeaderTwo));
        LockServiceTest.assertTrue((String)"unlock with a different object against the same row triggers an OJB optimistic lock exception", (this.lockService.unlockAccount(this.bcHeader) == BCConstants.LockStatus.OPTIMISTIC_EX ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)"the account is still unlocked", (boolean)this.lockService.isAccountLocked(this.bcHeader));
        this.bcLockStatus = this.lockService.lockFunding(this.bcHeader, this.pUIdOne);
        LockServiceTest.assertTrue((String)(this.pUIdOne + " obtained a funding lock"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.bcLockStatus = this.lockService.lockFunding(this.bcHeader, this.pUIdOne);
        LockServiceTest.assertTrue((String)(this.pUIdOne + "'s re-attempt to fetch the same lock also succeeded"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.bcLockStatus = this.lockService.lockFunding(this.bcHeader, this.pUIdTwo);
        LockServiceTest.assertTrue((String)(this.pUIdTwo + " can also get a funding lock for the same accounting key"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)"the set of funding locks for this accounting key is not empty", (boolean)this.lockService.getFundingLocks(this.bcHeader).isEmpty());
        this.fundingLocks = this.lockService.getFundingLocks(this.bcHeader);
        this.fundingIter = this.fundingLocks.iterator();
        LockServiceTest.assertTrue((boolean)this.fundingIter.hasNext());
        this.fundingLock = this.fundingIter.next();
        LockServiceTest.assertTrue((String)"the first funding lock is by accounting key, not by position", (boolean)this.fundingLock.getPositionNumber().equals("NotFnd"));
        LockServiceTest.assertTrue((boolean)this.fundingIter.hasNext());
        this.fundingLock = this.fundingIter.next();
        LockServiceTest.assertTrue((String)"the second funding lock is also not by position", (boolean)this.fundingLock.getPositionNumber().equals("NotFnd"));
        this.lockStatus = this.lockService.unlockFunding(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear(), this.pUIdOne);
        LockServiceTest.assertTrue((String)(this.pUIdOne + "'s funding lock was successfully removed"), (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.lockStatus = this.lockService.unlockFunding(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear(), this.pUIdTwo);
        LockServiceTest.assertTrue((String)(this.pUIdTwo + "'s funding lock was successfully removed"), (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)"there are no remaining funding locks for this accounting key", (boolean)this.lockService.getFundingLocks(this.bcHeader).isEmpty());
        this.bcLockStatus = this.lockService.lockPosition(this.positionNumber, this.universityFiscalYear, this.pUIdOne);
        LockServiceTest.assertTrue((String)(this.pUIdOne + " successfully obtained a position lock"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.bcLockStatus = this.lockService.lockFunding(this.bcHeader, this.pUIdOne);
        LockServiceTest.assertTrue((String)(this.pUIdOne + " successfully obtained a funding lock on an account funding the position"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.bcLockStatus = this.lockService.lockFunding(this.bcHeader, this.pUIdTwo);
        LockServiceTest.assertTrue((String)(this.pUIdTwo + " successfully obtained an orphan funding lock--no position lock is involved"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)"the funding lock table has rows for the account specified by this header", (boolean)this.lockService.getFundingLocks(this.bcHeader).isEmpty());
        this.bcLockStatus = this.lockService.lockAccount(this.bcHeaderTwo, this.pUIdTwo);
        LockServiceTest.assertTrue((String)(this.pUIdTwo + " cannot lock an accounting key for which this user has a funding lock"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.FLOCK_FOUND ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)"there are no funding locks involving this accounting key", (boolean)this.bcLockStatus.getFundingLocks().isEmpty());
        this.fundingIter = this.bcLockStatus.getFundingLocks().iterator();
        LockServiceTest.assertTrue((String)"an orphan funding lock exists", (boolean)this.fundingIter.hasNext());
        this.fundingLock = this.fundingIter.next();
        LockServiceTest.assertTrue((String)"funding lock is marked as an orphan", (boolean)this.fundingLock.getPositionNumber().equals("NotFnd"));
        LockServiceTest.assertTrue((String)"a funding lock exists with an associated position", (boolean)this.fundingIter.hasNext());
        this.fundingLock = this.fundingIter.next();
        LockServiceTest.assertTrue((String)(this.positionNumber + " has a funding lock"), (boolean)this.fundingLock.getPositionNumber().equals(this.positionNumber));
        LockServiceTest.assertFalse((String)(this.pUIdTwo + " does not have an account lock"), (boolean)this.lockService.isAccountLocked(this.bcHeaderTwo));
        this.lockStatus = this.lockService.unlockFunding(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear(), this.pUIdOne);
        LockServiceTest.assertTrue((String)(this.pUIdOne + " successfully released a funding lock"), (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.lockStatus = this.lockService.unlockFunding(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear(), this.pUIdTwo);
        LockServiceTest.assertTrue((String)(this.pUIdTwo + " successfully released a funding lock"), (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)"no funding locks are left", (boolean)this.lockService.getFundingLocks(this.bcHeader).isEmpty());
        this.lockStatus = this.lockService.unlockPosition(this.positionNumber, this.universityFiscalYear);
        LockServiceTest.assertTrue((String)(this.positionNumber + " lock was released successfully"), (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.bcLockStatus = this.lockService.lockPosition(this.positionNumber, this.universityFiscalYear, this.pUIdOne);
        LockServiceTest.assertTrue((String)("position lock: lock obtained by " + this.pUIdOne), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.bcLockStatus = this.lockService.lockPosition(this.positionNumber, this.universityFiscalYear, this.pUIdOne);
        LockServiceTest.assertTrue((String)("position lock: successful re-lock attempt by " + this.pUIdOne), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)("position lock: " + this.positionNumber + " is locked"), (boolean)this.lockService.isPositionLocked(this.positionNumber, this.universityFiscalYear));
        this.lockStatus = this.lockService.unlockPosition(this.positionNumber, this.universityFiscalYear);
        LockServiceTest.assertTrue((this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)("position lock: " + this.positionNumber + " successfully unlocked"), (boolean)this.lockService.isPositionLocked(this.positionNumber, this.universityFiscalYear));
        this.bcLockStatus = this.lockService.lockPosition(this.positionNumber, this.universityFiscalYear, this.pUIdOne);
        LockServiceTest.assertTrue((String)("position lock conflict: position lock obtained by " + this.pUIdOne), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        this.bcLockStatus = this.lockService.lockPosition(this.positionNumber, this.universityFiscalYear, this.pUIdTwo);
        LockServiceTest.assertTrue((String)("position lock conflict: position lock denied to " + this.pUIdTwo), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.BY_OTHER ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)"position lock conflict: position is still locked", (boolean)this.lockService.isPositionLocked(this.positionNumber, this.universityFiscalYear));
        this.lockStatus = this.lockService.unlockPosition(this.positionNumber, this.universityFiscalYear);
        LockServiceTest.assertTrue((String)"position lock conflict: position lock successfully released", (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)"position lock conflict: no positions locks remain", (boolean)this.lockService.isPositionLocked(this.positionNumber, this.universityFiscalYear));
        this.lockService.unlockTransaction(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear());
        LockServiceTest.assertFalse((String)"transaction lock: no current locks", (boolean)this.lockService.isTransactionLocked(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear()));
        this.bcLockStatus = this.lockService.lockTransaction(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear(), this.pUIdOne);
        LockServiceTest.assertTrue((String)("transaction lock: obtained by " + this.pUIdOne), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)"transaction lock: in effect", (boolean)this.lockService.isTransactionLocked(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear()));
        this.lockStatus = this.lockService.unlockTransaction(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear());
        LockServiceTest.assertTrue((String)("transaction lock: successfully released by " + this.pUIdOne), (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)"transaction lock: no longer in effect", (boolean)this.lockService.isTransactionLocked(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear()));
        LockServiceTest.assertFalse((String)"conflicting transaction lock: current locks", (boolean)this.lockService.isTransactionLocked(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear()));
        this.bcLockStatus = this.lockService.lockTransaction(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear(), this.pUIdOne);
        LockServiceTest.assertTrue((String)("conflicting transaction lock: lock obtained by " + this.pUIdOne), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)"conflicting transaction lock: transaction lock is in effect", (boolean)this.lockService.isTransactionLocked(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear()));
        this.bcLockStatus = this.lockService.lockTransaction(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear(), this.pUIdTwo);
        LockServiceTest.assertTrue((String)("conflicting transaction lock: " + this.pUIdTwo + " could not get the same transaction lock"), (this.bcLockStatus.getLockStatus() == BCConstants.LockStatus.BY_OTHER ? 1 : 0) != 0);
        LockServiceTest.assertTrue((String)("conflicting transaction lock: lock is owned by " + this.pUIdOne), (boolean)this.bcLockStatus.getTransactionLockOwner().equals(this.pUIdOne));
        LockServiceTest.assertTrue((String)("conflicting transaction lock: still locked by " + this.pUIdOne), (boolean)this.lockService.isTransactionLocked(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear()));
        this.lockStatus = this.lockService.unlockTransaction(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear());
        LockServiceTest.assertTrue((String)("conflicting transaction lock: lock removed by " + this.pUIdOne), (this.lockStatus == BCConstants.LockStatus.SUCCESS ? 1 : 0) != 0);
        LockServiceTest.assertFalse((String)"conflicting transaction lock: transaction locks still exist", (boolean)this.lockService.isTransactionLocked(this.bcHeader.getChartOfAccountsCode(), this.bcHeader.getAccountNumber(), this.bcHeader.getSubAccountNumber(), this.bcHeader.getUniversityFiscalYear()));
    }

    private boolean setTestDocumentNumber() {
        boolean returnValue = false;
        HashMap<String, Object> fieldValues = new HashMap<String, Object>(4);
        fieldValues.put("universityFiscalYear", this.universityFiscalYear);
        fieldValues.put("chartOfAccountsCode", this.chartOfAccountsCode);
        fieldValues.put("accountNumber", this.accountNumber);
        fieldValues.put("subAccountNumber", this.subAccountNumber);
        Collection bcDocuments = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(BudgetConstructionHeader.class, fieldValues);
        Iterator bcHeaderRows = bcDocuments.iterator();
        while (bcHeaderRows.hasNext()) {
            BudgetConstructionHeader bcHeaderRow = (BudgetConstructionHeader)bcHeaderRows.next();
            this.fdocNumber = bcHeaderRow.getDocumentNumber();
            returnValue = true;
            this.bcHeader = bcHeaderRow;
            while (bcHeaderRows.hasNext()) {
                bcHeaderRows.next();
            }
        }
        return returnValue;
    }

    private Integer setTestFiscalYear() {
        Integer fiscalYear = new Integer(0);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>(2);
        fieldValues.put("financialSystemFunctionControlCode", "BCACTV");
        fieldValues.put("financialSystemFunctionActiveIndicator", Boolean.TRUE);
        Collection returnedYears = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatchingOrderBy(FiscalYearFunctionControl.class, fieldValues, "universityFiscalYear", false);
        Iterator activeYears = returnedYears.iterator();
        if (activeYears.hasNext()) {
            fiscalYear = ((FiscalYearFunctionControl)activeYears.next()).getUniversityFiscalYear();
            while (activeYears.hasNext()) {
                activeYears.next();
            }
        }
        return fiscalYear;
    }

    private boolean setTestFunding() {
        boolean returnValue = false;
        HashMap<String, Comparable<Boolean>> fieldValues = new HashMap<String, Comparable<Boolean>>(2);
        fieldValues.put("active", new Boolean(true));
        fieldValues.put("universityFiscalYear", this.universityFiscalYear);
        Collection resultSet = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PendingBudgetConstructionAppointmentFunding.class, fieldValues);
        Iterator fundingRows = resultSet.iterator();
        while (fundingRows.hasNext()) {
            PendingBudgetConstructionAppointmentFunding fundingRow = (PendingBudgetConstructionAppointmentFunding)fundingRows.next();
            if (fundingRow.getEmplid().equals("VACANT")) continue;
            returnValue = true;
            this.chartOfAccountsCode = fundingRow.getChartOfAccountsCode();
            this.accountNumber = fundingRow.getAccountNumber();
            this.subAccountNumber = fundingRow.getSubAccountNumber();
            this.financialObjectCode = fundingRow.getFinancialObjectCode();
            this.financialSubObjectCode = fundingRow.getFinancialSubObjectCode();
            this.emplid = fundingRow.getEmplid();
            this.positionNumber = fundingRow.getPositionNumber();
            this.bcAFunding = fundingRow;
            while (fundingRows.hasNext()) {
                fundingRows.next();
            }
        }
        return returnValue;
    }

    @ConfigureContext(shouldCommitTransactions=true)
    private void clearTestRowLocks() {
        this.lockService.unlockAccount(this.bcHeader);
        this.lockService.unlockTransaction(this.chartOfAccountsCode, this.accountNumber, this.subAccountNumber, this.universityFiscalYear);
        this.lockService.unlockPosition(this.positionNumber, this.universityFiscalYear);
        this.lockService.unlockFunding(this.chartOfAccountsCode, this.accountNumber, this.subAccountNumber, this.universityFiscalYear, this.pUIdOne);
        this.lockService.unlockFunding(this.chartOfAccountsCode, this.accountNumber, this.subAccountNumber, this.universityFiscalYear, this.pUIdTwo);
    }
}

