/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.bc;

/**
 * BC Property Name Constants
 */
public class BCPropertyConstants {
    public static final String PULL_FLAG = "pullFlag";
    public static final String PENDING_BUDGET_CONSTRUCTION_APPOINTMENT_FUNDING = "pendingBudgetConstructionAppointmentFunding";
    public static final String BUDGET_CONSTRUCTION_REPORT_THRESHOLD_SETTINGS = "budgetConstructionReportThresholdSettings";

    public static final String ACCOUNT_REPORTS_EXIST = "accountReportsExist";
    public static final String ORGANIZATION_LEVEL_CODE = "organizationLevelCode";
    public static final String ORGANIZATION_CHART_OF_ACCOUNTS_CODE = "organizationChartOfAccountsCode";
    public static final String BUDGET_CONSTRUCTION_MONTHLY = "budgetConstructionMonthly";
    public static final String BUDGET_CONSTRUCTION_ACCOUNT_REPORTS = "budgetConstructionAccountReports";
    public static final String BUDGET_CONSTRUCTION_HEADER = "budgetConstructionHeader";
    public static final String PENDING_BUDGET_CONSTRUCTION_GENERAL_LEDGER_REVENUE_LINES = "pendingBudgetConstructionGeneralLedgerRevenueLines";
    public static final String PENDING_BUDGET_CONSTRUCTION_GENERAL_LEDGER_EXPENDITURE_LINES = "pendingBudgetConstructionGeneralLedgerExpenditureLines";
    public static final String BUDGET_CONSTRUCTION_CALCULATED_SALARY_FOUNDATION_TRACKER = "bcnCalculatedSalaryFoundationTracker";
    public static final String BUDGET_CONSTRUCTION_INTENDED_INCUMBENT = "budgetConstructionIntendedIncumbent";
    public static final String LOCK_USER_ID = "lockUserId";
    public static final String LOCK_TYPE = "lockType";
    public static final String BUDGET_LOCK_USER_IDENTIFIER = "budgetLockUserIdentifier";
    public static final String BUDGET_TRANSACTION_LOCK_USER_IDENTIFIER = "budgetTransactionLockUserIdentifier";
    public static final String POSITION_LOCK_USER_IDENTIFIER = "positionLockUserIdentifier";
    public static final String POSITION_NUMBER = "positionNumber";
    public static final String APPOINTMENT_FUNDING_LOCK_USER_ID = "appointmentFundingLockUserId";
    public static final String BUDGET_CONSTRUCTION_POSITION = "budgetConstructionPosition";
    public static final String BUDGET_CONSTRUCTION_FUNDING_LOCKS = "budgetConstructionFundingLocks";

    public static final String APPOINTMENT_FUNDING_DELETE_INDICATOR = "appointmentFundingDeleteIndicator";

    public static final String APPOINTMENT_REQUESTED_AMOUNT = "appointmentRequestedAmount";
    public static final String APPOINTMENT_REQUESTED_TIME_PERCENT = "appointmentRequestedTimePercent";
    public static final String APPOINTMENT_REQUESTED_PAY_RATE = "appointmentRequestedPayRate";
    public static final String APPOINTMENT_FUNDING_MONTH = "appointmentFundingMonth";

    public static final String APPOINTMENT_REQUESTED_CSF_AMOUNT = "appointmentRequestedCsfAmount";
    public static final String APPOINTMENT_CHART_OF_ACCOUNT = "chartOfAccountsCode";
    public static final String APPOINTMENT_REQUESTED_CSF_FTE_QUANTITY = "appointmentRequestedCsfFteQuantity";
    public static final String APPOINTMENT_REQUESTED_CSF_TIME_PERCENT = "appointmentRequestedCsfTimePercent";
    public static final String APPOINTMENT_REQUESTED_FTE_QUANTITY = "appointmentRequestedFteQuantity";

    public static final String APPOINTMENT_DURATION_CODE = "appointmentDurationCode";
    public static final String APPOINTMENT_TOTAL_INTENDED_AMOUNT = "appointmentTotalIntendedAmount";
    public static final String APPOINTMENT_TOTAL_INTENDED_FTE_QUANTITY = "appointmentTotalIntendedFteQuantity";
    public static final String APPOINTMENT_FUNDING_REASON = "appointmentFundingReason";
    public static final String APPOINTMENT_FUNDING_REASON_CODE = "appointmentFundingReasonCode";
    public static final String APPOINTMENT_FUNDING_REASON_AMOUNT = "appointmentFundingReasonAmount";

    public static final String POSITION_DEPARTMENT_IDENTIFIER = "positionDepartmentIdentifier";
    public static final String IU_POSITION_TYPE = "iuPositionType";
    public static final String POSITION_SALARY_PLAN_DEFAULT = "positionSalaryPlanDefault";
    public static final String SALARY_ADMINISTRATION_PLAN = "salaryAdministrationPlan";
    public static final String POSITION_GRADE_DEFAULT = "positionGradeDefault";
    public static final String GRADE = "grade";
    public static final String SET_SALARY_ID = "setidSalary";
    public static final String POSITION_UNION_CODE = "positionUnionCode";
    public static final String CSF_FREEZE_DATE = "csfFreezeDate";
    public static final String BUDGET_CONSTRUCTION_ADMINISTRATIVE_POST = "budgetConstructionAdministrativePost";
    public static final String CONFIDENTIAL_POSITION = "confidentialPosition";
    public static final String BUDGET_BY_ACCOUNT_MODE = "budgetByAccountMode";
    public static final String MAIN_WINDOW = "mainWindow";
    public static final String ADD_LINE = "addLine";
    public static final String SINGLE_ACCOUNT_MODE = "singleAccountMode";
    public static final String ADJUSTMENT_AMOUNT = "adjustmentAmount";
    public static final String NEW_BCAF_LINE = "newBCAFLine";
    public static final String SALARY_SETTING_EXPANSION = "salarySettingExpansion";
    public static final String ADJUSTMENT_MEASUREMENT = "adjustmentMeasurement";
    public static final String REFRESH_POSITION_BEFORE_SALARY_SETTING = "refreshPositionBeforeSalarySetting";
    public static final String REFRESH_INCUMBENT_BEFORE_SALARY_SETTING = "refreshIncumbentBeforeSalarySetting";

    public static final String CALL_BACK_MESSAGES = "callBackMessages";
    public static final String CALL_BACK_ERRORS = "callBackErrors";

    public static final String FINANCIAL_DOCUMENT_MONTH1_LINE_AMOUNT = "financialDocumentMonth1LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH2_LINE_AMOUNT = "financialDocumentMonth2LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH3_LINE_AMOUNT = "financialDocumentMonth3LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH4_LINE_AMOUNT = "financialDocumentMonth4LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH5_LINE_AMOUNT = "financialDocumentMonth5LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH6_LINE_AMOUNT = "financialDocumentMonth6LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH7_LINE_AMOUNT = "financialDocumentMonth7LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH8_LINE_AMOUNT = "financialDocumentMonth8LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH9_LINE_AMOUNT = "financialDocumentMonth9LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH10_LINE_AMOUNT = "financialDocumentMont101LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH11_LINE_AMOUNT = "financialDocumentMonth11LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH12_LINE_AMOUNT = "financialDocumentMonth12LineAmount";

    public static final String THRESHOLD_PERCENT = "thresholdPercent";

    public static final String OBJECT_CODE_PICK_LIST = "objectCodePickList";
}
