/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.businessobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cab.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;

public class PurchasingAccountsPayableDocument
extends PersistableBusinessObjectBase {
    private String documentNumber;
    private Integer purapDocumentIdentifier;
    private Integer purchaseOrderIdentifier;
    private String documentTypeCode;
    private String activityStatusCode;
    private DocumentTypeEBO financialSystemDocumentTypeCode;
    private FinancialSystemDocumentHeader documentHeader;
    private List<PurchasingAccountsPayableItemAsset> purchasingAccountsPayableItemAssets = new ArrayList<PurchasingAccountsPayableItemAsset>();
    private boolean active;
    private String purApContactEmailAddress;
    private String purApContactPhoneNumber;
    private String statusDescription;
    private String capitalAssetSystemTypeCodeFromPurAp;

    public String getCapitalAssetSystemTypeCodeFromPurAp() {
        return this.capitalAssetSystemTypeCodeFromPurAp;
    }

    public void setCapitalAssetSystemTypeCodeFromPurAp(String capitalAssetSystemTypeCodeFromPurAp) {
        this.capitalAssetSystemTypeCodeFromPurAp = capitalAssetSystemTypeCodeFromPurAp;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getPurapDocumentIdentifier() {
        return this.purapDocumentIdentifier;
    }

    public void setPurapDocumentIdentifier(Integer purapDocumentIdentifier) {
        this.purapDocumentIdentifier = purapDocumentIdentifier;
    }

    public Integer getPurchaseOrderIdentifier() {
        return this.purchaseOrderIdentifier;
    }

    public void setPurchaseOrderIdentifier(Integer purchaseOrderIdentifier) {
        this.purchaseOrderIdentifier = purchaseOrderIdentifier;
    }

    public String getDocumentTypeCode() {
        return this.documentTypeCode;
    }

    public void setDocumentTypeCode(String documentTypeCode) {
        this.documentTypeCode = documentTypeCode;
    }

    public boolean isActive() {
        return "N".equalsIgnoreCase(this.getActivityStatusCode()) || "M".equalsIgnoreCase(this.getActivityStatusCode());
    }

    public String getActivityStatusCode() {
        return this.activityStatusCode;
    }

    public void setActivityStatusCode(String activityStatusCode) {
        this.activityStatusCode = activityStatusCode;
    }

    public DocumentTypeEBO getFinancialSystemDocumentTypeCode() {
        if (this.financialSystemDocumentTypeCode == null || !StringUtils.equals((String)this.financialSystemDocumentTypeCode.getName(), (String)this.documentTypeCode)) {
            DocumentType docType;
            this.financialSystemDocumentTypeCode = null;
            if (StringUtils.isNotBlank((String)this.documentTypeCode) && (docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.documentTypeCode)) != null) {
                this.financialSystemDocumentTypeCode = org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)docType);
            }
        }
        return this.financialSystemDocumentTypeCode;
    }

    public FinancialSystemDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(FinancialSystemDocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public List<PurchasingAccountsPayableItemAsset> getPurchasingAccountsPayableItemAssets() {
        return this.purchasingAccountsPayableItemAssets;
    }

    public void setPurchasingAccountsPayableItemAssets(List<PurchasingAccountsPayableItemAsset> purchasingAccountsPayableItemAssets) {
        this.purchasingAccountsPayableItemAssets = purchasingAccountsPayableItemAssets;
    }

    public String getPurApContactEmailAddress() {
        return this.purApContactEmailAddress;
    }

    public void setPurApContactEmailAddress(String purApContactEmailAddress) {
        this.purApContactEmailAddress = purApContactEmailAddress;
    }

    public String getPurApContactPhoneNumber() {
        return this.purApContactPhoneNumber;
    }

    public void setPurApContactPhoneNumber(String purApContactPhoneNumber) {
        this.purApContactPhoneNumber = purApContactPhoneNumber;
    }

    public String getStatusDescription() {
        if (StringUtils.isNotBlank((String)this.statusDescription)) {
            return this.statusDescription;
        }
        HashMap<String, Integer> objectKeys = new HashMap<String, Integer>();
        objectKeys.put("purapDocumentIdentifier", this.getPurapDocumentIdentifier());
        if ("PREQ".equals(this.documentTypeCode)) {
            PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(PaymentRequestDocument.class, objectKeys);
            if (ObjectUtils.isNotNull((Object)paymentRequestDocument)) {
                this.statusDescription = paymentRequestDocument.getApplicationDocumentStatus();
            }
        } else {
            VendorCreditMemoDocument vendorCreditMemoDocument = (VendorCreditMemoDocument)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(VendorCreditMemoDocument.class, objectKeys);
            if (ObjectUtils.isNotNull((Object)vendorCreditMemoDocument)) {
                this.statusDescription = vendorCreditMemoDocument.getApplicationDocumentStatus();
            }
        }
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public List buildListOfDeletionAwareLists() {
        ArrayList<List<PurchasingAccountsPayableItemAsset>> managedLists = new ArrayList<List<PurchasingAccountsPayableItemAsset>>();
        managedLists.add(this.getPurchasingAccountsPayableItemAssets());
        return managedLists;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.documentNumber);
        return m;
    }

    public PurchasingAccountsPayableItemAsset getPurchasingAccountsPayableItemAsset(int index) {
        int size = this.getPurchasingAccountsPayableItemAssets().size();
        while (size <= index || this.getPurchasingAccountsPayableItemAssets().get(index) == null) {
            this.getPurchasingAccountsPayableItemAssets().add(size++, new PurchasingAccountsPayableItemAsset());
        }
        return this.getPurchasingAccountsPayableItemAssets().get(index);
    }
}

