/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.module.cab.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cab.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cab.dataaccess.PurchasingAccountsPayableReportDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class PurchasingAccountsPayableReportDaoOjb
extends PlatformAwareDaoBaseOjb
implements PurchasingAccountsPayableReportDao {
    private static Logger LOG = Logger.getLogger(PurchasingAccountsPayableReportDaoOjb.class);

    @Override
    public Collection findPurchasingAccountsPayableDocuments(Map fieldValues) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new PurchasingAccountsPayableDocument()));
        QueryByCriteria query = QueryFactory.newQuery(PurchasingAccountsPayableDocument.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Iterator findGeneralLedgers(Map fieldValues) {
        LOG.debug((Object)"findGeneralLedgers started...");
        ReportQueryByCriteria query = this.getGeneralLedgerReportQuery(fieldValues);
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    protected ReportQueryByCriteria getGeneralLedgerReportQuery(Map fieldValues) {
        Collection docTypeCodes = this.getDocumentType(fieldValues);
        Collection activityStatusCodes = this.getActivityStatusCode(fieldValues);
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new GeneralLedgerEntry()));
        if (!docTypeCodes.isEmpty()) {
            criteria.addIn("financialDocumentTypeCode", docTypeCodes);
        }
        if (!activityStatusCodes.isEmpty()) {
            criteria.addIn("activityStatusCode", activityStatusCodes);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(GeneralLedgerEntry.class, (Criteria)criteria);
        List<String> attributeList = this.buildAttributeList(false);
        String[] attributes = attributeList.toArray(new String[attributeList.size()]);
        query.setAttributes(attributes);
        return query;
    }

    protected Collection getActivityStatusCode(Map fieldValues) {
        ArrayList<String> activityStatusCodes = new ArrayList<String>();
        if (fieldValues.containsKey("activityStatusCode")) {
            String fieldValue = (String)fieldValues.get("activityStatusCode");
            if ("N".equalsIgnoreCase(fieldValue)) {
                activityStatusCodes.add("N");
                activityStatusCodes.add("M");
            }
            fieldValues.remove("activityStatusCode");
        }
        return activityStatusCodes;
    }

    protected Collection getDocumentType(Map fieldValues) {
        ArrayList<String> docTypeCodes = new ArrayList<String>();
        if (fieldValues.containsKey("financialDocumentTypeCode")) {
            String fieldValue = (String)fieldValues.get("financialDocumentTypeCode");
            if (StringUtils.isEmpty((String)fieldValue)) {
                docTypeCodes.add("PREQ");
                docTypeCodes.add("CM");
            } else {
                docTypeCodes.add(fieldValue);
            }
            fieldValues.remove("financialDocumentTypeCode");
        }
        return docTypeCodes;
    }

    protected List<String> buildAttributeList(boolean isExtended) {
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("universityFiscalYear");
        attributeList.add("universityFiscalPeriodCode");
        attributeList.add("chartOfAccountsCode");
        attributeList.add("accountNumber");
        attributeList.add("financialObjectCode");
        attributeList.add("financialDocumentTypeCode");
        attributeList.add("documentNumber");
        attributeList.add("transactionDebitCreditCode");
        attributeList.add("transactionLedgerEntryAmount");
        attributeList.add("referenceFinancialDocumentNumber");
        attributeList.add("transactionDate");
        attributeList.add("transactionLedgerSubmitAmount");
        attributeList.add("activityStatusCode");
        return attributeList;
    }
}

