/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.service.impl.StringHelper;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.exception.InvalidAddressException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.MailService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.batch.AssetPaymentInfo;
import org.kuali.kfs.module.cam.batch.service.AssetDepreciationService;
import org.kuali.kfs.module.cam.batch.service.ReportService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationConvention;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationTransaction;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetYearEndDepreciation;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciableAssetsDao;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.batch.service.SchedulerService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AssetDepreciationServiceImpl
implements AssetDepreciationService {
    private static final Logger LOG = Logger.getLogger(AssetDepreciationServiceImpl.class);
    protected ParameterService parameterService;
    protected AssetService assetService;
    protected ReportService reportService;
    protected DateTimeService dateTimeService;
    protected DepreciableAssetsDao depreciableAssetsDao;
    protected ConfigurationService kualiConfigurationService;
    protected GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    protected BusinessObjectService businessObjectService;
    protected UniversityDateService universityDateService;
    protected OptionsService optionsService;
    protected DataDictionaryService dataDictionaryService;
    protected DepreciationBatchDao depreciationBatchDao;
    protected String cronExpression;
    protected MailService mailService;
    protected volatile WorkflowDocumentService workflowDocumentService;
    private AssetDateService assetDateService;
    private SchedulerService schedulerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runDepreciation() {
        String depreciationDateParameter;
        ArrayList<String[]> reportLog;
        String errorMsg;
        block22: {
            Integer fiscalYear = -1;
            Integer fiscalMonth = -1;
            errorMsg = "";
            ArrayList<String> documentNos = new ArrayList<String>();
            reportLog = new ArrayList<String[]>();
            Collection<AssetObjectCode> assetObjectCodes = new ArrayList<AssetObjectCode>();
            boolean hasErrors = false;
            Calendar depreciationDate = this.dateTimeService.getCurrentCalendar();
            Object depDate = null;
            Calendar currentDate = this.dateTimeService.getCurrentCalendar();
            depreciationDateParameter = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            boolean executeJob = false;
            String errorMessage = this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.alreadyRan");
            try {
                executeJob = this.runAssetDepreciation();
                if (executeJob) {
                    UniversityDate universityDate;
                    LOG.info((Object)"*******DEPRECIATION BATCH -  HAS BEGUN *******");
                    if (!this.parameterService.parameterExists(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_RUN_DATE").booleanValue()) {
                        throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.depreciationDateNotFound"));
                    }
                    depreciationDateParameter = this.parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_RUN_DATE");
                    if (StringUtils.isBlank((String)depreciationDateParameter)) {
                        depreciationDateParameter = dateFormat.format(this.dateTimeService.getCurrentDate());
                    }
                    if (!StringUtils.isBlank((String)depreciationDateParameter)) {
                        try {
                            depreciationDate.setTime(dateFormat.parse(depreciationDateParameter.trim()));
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.invalidDepreciationDateFormat"));
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("DEPRECIATION BATCH - Depreciation run date: " + depreciationDateParameter));
                    }
                    if ((universityDate = (UniversityDate)this.businessObjectService.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(depreciationDate.getTimeInMillis()))) == null) {
                        throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.gl.UniversityDateNotFound"));
                    }
                    fiscalYear = universityDate.getUniversityFiscalYear();
                    fiscalMonth = new Integer(universityDate.getUniversityFiscalAccountingPeriod());
                    assetObjectCodes = this.getAssetObjectCodes(fiscalYear);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("DEPRECIATION BATCH - Fiscal Year = " + fiscalYear + " & Fiscal Period=" + fiscalMonth));
                    }
                    int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
                    reportLog.addAll(this.depreciableAssetsDao.generateStatistics(true, null, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
                    this.updateAssetsDatesForLastFiscalPeriod(fiscalMonth, fiscalYear);
                    LOG.info((Object)"DEPRECIATION BATCH - Getting list of asset payments eligible for depreciation.");
                    Collection<AssetPaymentInfo> depreciableAssetsCollection = this.depreciationBatchDao.getListOfDepreciableAssetPaymentInfo(fiscalYear, fiscalMonth, depreciationDate);
                    if (depreciableAssetsCollection != null && !depreciableAssetsCollection.isEmpty()) {
                        SortedMap<String, AssetDepreciationTransaction> depreciationTransactions = this.calculateDepreciation(fiscalYear, fiscalMonth, depreciableAssetsCollection, depreciationDate, assetObjectCodes);
                        this.processGeneralLedgerPendingEntry(fiscalYear, fiscalMonth, documentNos, depreciationTransactions);
                    } else {
                        throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.assetsNotFound"));
                    }
                }
                if (hasErrors || !executeJob) break block22;
            }
            catch (Exception e) {
                block23: {
                    try {
                        LOG.error((Object)"Error occurred");
                        LOG.error((Object)"DEPRECIATION BATCH - **************************************************************************");
                        LOG.error((Object)("DEPRECIATION BATCH - AN ERROR HAS OCCURRED! - ERROR: " + e.getMessage()), (Throwable)e);
                        LOG.error((Object)"DEPRECIATION BATCH - **************************************************************************");
                        hasErrors = true;
                        errorMsg = "Depreciation process ran unsucessfuly.\nReason:" + e.getMessage();
                        if (hasErrors || !executeJob) break block23;
                    }
                    catch (Throwable throwable) {
                        if (!hasErrors && executeJob) {
                            int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
                            reportLog.addAll(this.depreciableAssetsDao.generateStatistics(false, documentNos, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
                        }
                        if (!reportLog.isEmpty() || !errorMsg.trim().equals("")) {
                            this.reportService.generateDepreciationReport(reportLog, errorMsg, depreciationDateParameter);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"*******DEPRECIATION BATCH -  HAS ENDED *******");
                        }
                        throw throwable;
                    }
                    int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
                    reportLog.addAll(this.depreciableAssetsDao.generateStatistics(false, documentNos, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
                }
                if (!reportLog.isEmpty() || !errorMsg.trim().equals("")) {
                    this.reportService.generateDepreciationReport(reportLog, errorMsg, depreciationDateParameter);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"*******DEPRECIATION BATCH -  HAS ENDED *******");
                }
            }
            int fiscalStartMonth = Integer.parseInt(this.optionsService.getCurrentYearOptions().getUniversityFiscalYearStartMo());
            reportLog.addAll(this.depreciableAssetsDao.generateStatistics(false, documentNos, fiscalYear, fiscalMonth, depreciationDate, this.dateTimeService.toDateString(depreciationDate.getTime()), assetObjectCodes, fiscalStartMonth, errorMessage));
        }
        if (!reportLog.isEmpty() || !errorMsg.trim().equals("")) {
            this.reportService.generateDepreciationReport(reportLog, errorMsg, depreciationDateParameter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"*******DEPRECIATION BATCH -  HAS ENDED *******");
        }
    }

    @Override
    public Collection<AssetObjectCode> getAssetObjectCodes(Integer fiscalYear) {
        LOG.debug((Object)"DepreciableAssetsDAoOjb.getAssetObjectCodes() -  started");
        LOG.info((Object)"DEPRECIATION BATCH - Getting asset object codes.");
        HashMap<String, Constable> fields = new HashMap<String, Constable>();
        fields.put("universityFiscalYear", fiscalYear);
        fields.put("active", Boolean.TRUE);
        Collection assetObjectCodesCollection = this.businessObjectService.findMatching(AssetObjectCode.class, fields);
        LOG.info((Object)("DEPRECIATION BATCH - Finished getting asset object codes - which are:" + assetObjectCodesCollection.toString()));
        LOG.debug((Object)"DepreciableAssetsDAoOjb.getAssetObjectCodes() -  ended");
        return assetObjectCodesCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runYearEndDepreciation(Integer fiscalYearToDepreciate) {
        Parameter.Builder param;
        String notAcceptedAssetStatusString;
        boolean statusContainsR;
        block17: {
            Integer fiscalYear = -1;
            Integer fiscalMonth = -1;
            ArrayList<String> documentNos = new ArrayList<String>();
            String errorMsg = "";
            ArrayList<String[]> reportLog = new ArrayList<String[]>();
            boolean hasErrors = false;
            boolean includeRetired = false;
            Calendar depreciationDate = Calendar.getInstance();
            AssetYearEndDepreciation assetYearEndDepreciation = null;
            this.assetService = (AssetService)SpringContext.getBean(AssetService.class);
            ArrayList notAcceptedAssetStatus = new ArrayList();
            statusContainsR = false;
            notAcceptedAssetStatusString = "";
            String depreciationDateParameter = fiscalYearToDepreciate.toString() + this.getLastDayOfFiscalyear();
            notAcceptedAssetStatus.addAll(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES"));
            LOG.info((Object)("notAcceptedAssetStatusString = " + notAcceptedAssetStatusString));
            if (notAcceptedAssetStatus.contains("R")) {
                LOG.info((Object)"looks like notAcceptedAssetStatusString contains R");
                statusContainsR = true;
                notAcceptedAssetStatus.remove("R");
                for (int i = 0; i < notAcceptedAssetStatus.size(); ++i) {
                    String s = (String)notAcceptedAssetStatus.get(i);
                    notAcceptedAssetStatusString = notAcceptedAssetStatusString + s + ";";
                }
                if (notAcceptedAssetStatusString.endsWith(";")) {
                    notAcceptedAssetStatusString = notAcceptedAssetStatusString.substring(0, notAcceptedAssetStatusString.length() - 1);
                }
                param = Parameter.Builder.create((ParameterContract)this.parameterService.getParameter(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES"));
                param.setValue(notAcceptedAssetStatusString);
                this.parameterService.updateParameter(param.build());
            }
            try {
                LOG.info((Object)"*******YEAR END DEPRECIATION - HAS BEGUN *******");
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, CamsConstants.Parameters.INCLUDE_RETIRED_ASSETS_IND) = " + this.parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, CamsConstants.Parameters.INCLUDE_RETIRED_ASSETS_IND)));
                }
                includeRetired = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, CamsConstants.Parameters.INCLUDE_RETIRED_ASSETS_IND);
                UniversityDate universityDate = (UniversityDate)this.businessObjectService.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(depreciationDate.getTimeInMillis()));
                if (universityDate == null) {
                    throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.gl.UniversityDateNotFound"));
                }
                fiscalYear = universityDate.getUniversityFiscalYear();
                fiscalMonth = new Integer(universityDate.getUniversityFiscalAccountingPeriod());
                depreciationDate.setTime(Date.valueOf(fiscalYearToDepreciate.toString() + this.getLastDayOfFiscalyear()));
                fiscalYear = fiscalYearToDepreciate;
                fiscalMonth = 12;
                Collection<AssetObjectCode> assetObjectCodes = this.getAssetObjectCodes(fiscalYear);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("YEAR END DEPRECIATION - Fiscal Year = " + fiscalYear + " & Fiscal Period=" + fiscalMonth));
                }
                this.depreciationBatchDao.updateAssetsCreatedInLastFiscalPeriod(fiscalMonth, fiscalYear);
                LOG.info((Object)"YEAR END DEPRECIATION - Getting list of YEAR END DEPRECIATION asset payments eligible for depreciation.");
                Collection<AssetPaymentInfo> depreciableAssetsCollection = this.depreciationBatchDao.getListOfDepreciableAssetPaymentInfoYearEnd(fiscalYear, fiscalMonth, depreciationDate, includeRetired);
                if (depreciableAssetsCollection != null && !depreciableAssetsCollection.isEmpty()) {
                    SortedMap<String, AssetDepreciationTransaction> depreciationTransactions = this.calculateYearEndDepreciation(depreciableAssetsCollection, depreciationDate, fiscalYearToDepreciate, fiscalYear, fiscalMonth, assetObjectCodes);
                    this.processYearEndGeneralLedgerPendingEntry(fiscalYear, documentNos, depreciationTransactions);
                    break block17;
                }
                throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.assetsNotFound"));
            }
            catch (Exception e) {
                LOG.error((Object)"YEAR END DEPRECIATION - **************************************************************************");
                LOG.error((Object)("YEAR END DEPRECIATION - AN ERROR HAS OCCURRED! - ERROR: " + e.getClass().getName() + " : " + e.getMessage()));
                LOG.error((Object)"YEAR END DEPRECIATION - **************************************************************************");
                LOG.error((Object)e);
                hasErrors = true;
                errorMsg = "YEAR END DEPRECIATION -  process ran unsucessfuly.\nReason:" + e.getMessage();
            }
            finally {
                if (!hasErrors && assetYearEndDepreciation != null) {
                    assetYearEndDepreciation.setRunDate(new Date(new java.util.Date().getTime()));
                }
                if (!reportLog.isEmpty() || !errorMsg.trim().equals("")) {
                    this.reportService.generateDepreciationReport(reportLog, errorMsg, depreciationDateParameter);
                }
                LOG.info((Object)"******* YEAR END DEPRECIATION - HAS ENDED *******");
            }
        }
        if (statusContainsR) {
            notAcceptedAssetStatusString = notAcceptedAssetStatusString + ";R";
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("notAcceptedAssetStatusString after reset= " + notAcceptedAssetStatusString));
            }
            param = Parameter.Builder.create((ParameterContract)this.parameterService.getParameter(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES"));
            param.setValue(notAcceptedAssetStatusString);
            this.parameterService.updateParameter(param.build());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES now = " + this.parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES")));
            }
        }
    }

    protected boolean runAssetDepreciation() throws ParseException {
        java.util.Date endDate;
        boolean executeJob = false;
        ArrayList<String> errorMessages = new ArrayList<String>();
        java.util.Date currentDate = this.convertToDate(this.dateTimeService.toDateString(this.dateTimeService.getCurrentDate()));
        java.util.Date beginDate = this.getBlankOutBeginDate(errorMessages);
        if (this.hasBlankOutPeriodStarted(beginDate, endDate = this.getBlankOutEndDate(errorMessages), errorMessages)) {
            String blankOutPeriodrunDate = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_RUN_DATE");
            if (!StringHelper.isNullOrEmpty((String)blankOutPeriodrunDate)) {
                java.util.Date runDate = this.convertToDate(blankOutPeriodrunDate);
                if (runDate.compareTo(beginDate) >= 0 && runDate.compareTo(endDate) <= 0) {
                    if (currentDate.equals(runDate)) {
                        executeJob = true;
                    } else {
                        LOG.info((Object)"Today is not BLANK_OUT_PERIOD_RUN_DATE. executeJob not set to true");
                    }
                } else {
                    String blankOutBegin = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_BEGIN_MMDD");
                    String blankOutEnd = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_END_MMDD");
                    String message = "BLANK_OUT_PERIOD_RUN_DATE: " + blankOutPeriodrunDate + " is not in the blank out period range." + "Blank out period range is [ " + blankOutBegin + "-" + blankOutEnd + " ] .";
                    errorMessages.add(message);
                    LOG.info((Object)message);
                }
            } else {
                String message = "Parameter BLANK_OUT_PERIOD_RUN_DATE (component: Asset Depreciation Step) is not set Please set the date correctly to run the job.";
                errorMessages.add(message);
                LOG.info((Object)message);
            }
        } else if (this.getSchedulerService().cronConditionMet(this.cronExpression)) {
            executeJob = true;
        } else {
            LOG.info((Object)"Cron condition not met. executeJob not set to true");
        }
        if (!executeJob && !errorMessages.isEmpty()) {
            this.sendWarningMail(errorMessages);
        }
        return executeJob;
    }

    protected boolean hasBlankOutPeriodStarted(java.util.Date beginDate, java.util.Date endDate, List<String> errorMessages) throws ParseException {
        java.util.Date currentDate = this.convertToDate(this.dateTimeService.toDateString(this.dateTimeService.getCurrentDate()));
        String blankOutBegin = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_BEGIN_MMDD");
        String blankOutEnd = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_END_MMDD");
        if (ObjectUtils.isNotNull((Object)beginDate) && ObjectUtils.isNotNull((Object)endDate)) {
            if (currentDate.compareTo(beginDate) >= 0 && currentDate.compareTo(endDate) <= 0) {
                return true;
            }
        } else {
            String message = "Unable to determine blank out period for a given " + blankOutBegin + " - " + blankOutEnd + " range .";
            errorMessages.add(message);
            LOG.info((Object)message);
        }
        return false;
    }

    private java.util.Date getBlankOutEndDate(List<String> errorMessages) throws ParseException {
        String endDate = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_END_MMDD");
        if (!StringHelper.isNullOrEmpty((String)endDate)) {
            int endDay = new Integer(StringUtils.substringAfterLast((String)endDate, (String)"/"));
            int endMonth = new Integer(StringUtils.substringBeforeLast((String)endDate, (String)"/")) - 1;
            Calendar blankOutEndcalendar = Calendar.getInstance();
            blankOutEndcalendar.set(blankOutEndcalendar.get(1), endMonth, endDay);
            return this.convertToDate(this.dateTimeService.toString(blankOutEndcalendar.getTime(), "MM/dd/yyyy"));
        }
        String message = "Parameter BLANK_OUT_END_MMDD (component:Asset Depreciation Step) is not set.";
        errorMessages.add(message);
        LOG.info((Object)message);
        return null;
    }

    private java.util.Date getBlankOutBeginDate(List<String> errorMessages) throws ParseException {
        String beginDate = this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_BEGIN_MMDD");
        if (!StringHelper.isNullOrEmpty((String)beginDate)) {
            int beginDay = new Integer(StringUtils.substringAfterLast((String)beginDate, (String)"/"));
            int beginMonth = new Integer(StringUtils.substringBeforeLast((String)beginDate, (String)"/")) - 1;
            Calendar blankOutBegincalendar = Calendar.getInstance();
            blankOutBegincalendar.set(blankOutBegincalendar.get(1), beginMonth, beginDay);
            return this.convertToDate(this.dateTimeService.toString(blankOutBegincalendar.getTime(), "MM/dd/yyyy"));
        }
        String message = "Parameter BLANK_OUT_BEGIN_MMDD (component:Asset Depreciation Step) is not set.";
        errorMessages.add(message);
        LOG.info((Object)message);
        return null;
    }

    private java.util.Date convertToDate(String date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        dateFormat.setLenient(false);
        return dateFormat.parse(date);
    }

    protected SortedMap<String, AssetDepreciationTransaction> calculateDepreciation(Integer fiscalYear, Integer fiscalMonth, Collection<AssetPaymentInfo> depreciableAssetsCollection, Calendar depreciationDate, Collection<AssetObjectCode> assetObjectCodes) {
        LOG.debug((Object)"calculateDepreciation() - start");
        ArrayList organizationPlantFundObjectSubType = new ArrayList();
        ArrayList campusPlantFundObjectSubType = new ArrayList();
        TreeMap<String, AssetDepreciationTransaction> depreciationTransactionSummary = new TreeMap<String, AssetDepreciationTransaction>();
        double monthsElapsed = 0.0;
        double assetLifeInMonths = 0.0;
        KualiDecimal accumulatedDepreciationAmount = KualiDecimal.ZERO;
        Calendar assetDepreciationDate = Calendar.getInstance();
        try {
            LOG.debug((Object)"DEPRECIATION BATCH - Getting the parameters for the plant fund object sub types.");
            if (this.parameterService.parameterExists(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_ORGANIZATON_PLANT_FUND_OBJECT_SUB_TYPE").booleanValue()) {
                organizationPlantFundObjectSubType = new ArrayList(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_ORGANIZATON_PLANT_FUND_OBJECT_SUB_TYPE"));
            }
            if (this.parameterService.parameterExists(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE").booleanValue()) {
                campusPlantFundObjectSubType = new ArrayList(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE"));
            }
            this.depreciationBatchDao.resetPeriodValuesWhenFirstFiscalPeriod(fiscalMonth);
            LOG.debug((Object)"getBaseAmountOfAssets(Collection<AssetPayment> depreciableAssetsCollection) - Started.");
            LOG.debug((Object)"DEPRECIATION BATCH - Calculating the base amount for each asset.");
            Map<Long, KualiDecimal> salvageValueAssetDeprAmounts = this.depreciationBatchDao.getPrimaryDepreciationBaseAmountForSV();
            Map<String, AssetObjectCode> assetObjectCodeMap = this.buildChartObjectToCapitalizationObjectMap(assetObjectCodes);
            HashMap<String, ObjectCode> capitalizationObjectCodes = new HashMap<String, ObjectCode>();
            LOG.debug((Object)"DEPRECIATION BATCH - Reading collection with eligible asset payment details.");
            int counter = 0;
            ArrayList<AssetPaymentInfo> saveList = new ArrayList<AssetPaymentInfo>();
            for (AssetPaymentInfo assetPaymentInfo : depreciableAssetsCollection) {
                AssetObjectCode assetObjectCode = assetObjectCodeMap.get(assetPaymentInfo.getChartOfAccountsCode() + "-" + assetPaymentInfo.getFinancialObjectCode());
                if (assetObjectCode == null) {
                    LOG.error((Object)("DEPRECIATION BATCH - Asset object code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetPaymentInfo.getFinancialObjectCode()));
                    LOG.error((Object)("DEPRECIATION BATCH - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                ObjectCode accumulatedDepreciationFinancialObject = this.getDepreciationObjectCode(fiscalYear, capitalizationObjectCodes, assetPaymentInfo, assetObjectCode.getAccumulatedDepreciationFinancialObjectCode());
                ObjectCode depreciationExpenseFinancialObject = this.getDepreciationObjectCode(fiscalYear, capitalizationObjectCodes, assetPaymentInfo, assetObjectCode.getDepreciationExpenseFinancialObjectCode());
                if (ObjectUtils.isNull((Object)accumulatedDepreciationFinancialObject)) {
                    LOG.error((Object)("DEPRECIATION BATCH - Accumulated Depreciation Financial Object Code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetObjectCode.getAccumulatedDepreciationFinancialObjectCode()));
                    LOG.error((Object)("DEPRECIATION BATCH - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                if (ObjectUtils.isNull((Object)depreciationExpenseFinancialObject)) {
                    LOG.error((Object)("DEPRECIATION BATCH - Depreciation Expense Financial Object Code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetObjectCode.getDepreciationExpenseFinancialObjectCode()));
                    LOG.error((Object)("DEPRECIATION BATCH - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                Long assetNumber = assetPaymentInfo.getCapitalAssetNumber();
                assetDepreciationDate.setTime(assetPaymentInfo.getDepreciationDate());
                accumulatedDepreciationAmount = KualiDecimal.ZERO;
                KualiDecimal deprAmountSum = salvageValueAssetDeprAmounts.get(assetNumber);
                assetLifeInMonths = assetPaymentInfo.getDepreciableLifeLimit() * 12;
                monthsElapsed = depreciationDate.get(2) - assetDepreciationDate.get(2) + (depreciationDate.get(1) - assetDepreciationDate.get(1)) * 12 + 1;
                KualiDecimal primaryDepreciationBaseAmount = assetPaymentInfo.getPrimaryDepreciationBaseAmount();
                if (primaryDepreciationBaseAmount == null) {
                    assetPaymentInfo.setPrimaryDepreciationBaseAmount(KualiDecimal.ZERO);
                }
                if (assetPaymentInfo.getAccumulatedPrimaryDepreciationAmount() == null) {
                    assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount(KualiDecimal.ZERO);
                }
                if (monthsElapsed >= assetLifeInMonths) {
                    if ("SL".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode())) {
                        accumulatedDepreciationAmount = primaryDepreciationBaseAmount;
                    } else if ("SV".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode()) && deprAmountSum != null && deprAmountSum.isNonZero()) {
                        accumulatedDepreciationAmount = (KualiDecimal)primaryDepreciationBaseAmount.subtract(((KualiDecimal)primaryDepreciationBaseAmount.divide((AbstractKualiDecimal)deprAmountSum)).multiply((AbstractKualiDecimal)assetPaymentInfo.getSalvageAmount()));
                    }
                } else if ("SL".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode())) {
                    accumulatedDepreciationAmount = new KualiDecimal(monthsElapsed / assetLifeInMonths * primaryDepreciationBaseAmount.doubleValue());
                } else if ("SV".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode()) && deprAmountSum != null && deprAmountSum.isNonZero()) {
                    accumulatedDepreciationAmount = new KualiDecimal(monthsElapsed / assetLifeInMonths * ((KualiDecimal)primaryDepreciationBaseAmount.subtract(((KualiDecimal)primaryDepreciationBaseAmount.divide((AbstractKualiDecimal)deprAmountSum)).multiply((AbstractKualiDecimal)assetPaymentInfo.getSalvageAmount()))).doubleValue());
                }
                KualiDecimal transactionAmount = (KualiDecimal)accumulatedDepreciationAmount.subtract((AbstractKualiDecimal)assetPaymentInfo.getAccumulatedPrimaryDepreciationAmount());
                String transactionType = "D";
                if (transactionAmount.isNegative()) {
                    transactionType = "C";
                }
                String plantAccount = "";
                String plantCOA = "";
                if (organizationPlantFundObjectSubType.contains(assetPaymentInfo.getFinancialObjectSubTypeCode())) {
                    plantAccount = assetPaymentInfo.getOrganizationPlantAccountNumber();
                    plantCOA = assetPaymentInfo.getOrganizationPlantChartCode();
                } else if (campusPlantFundObjectSubType.contains(assetPaymentInfo.getFinancialObjectSubTypeCode())) {
                    plantAccount = assetPaymentInfo.getCampusPlantAccountNumber();
                    plantCOA = assetPaymentInfo.getCampusPlantChartCode();
                }
                if (StringUtils.isBlank((String)plantCOA) || StringUtils.isBlank((String)plantAccount)) {
                    LOG.error((Object)("DEPRECIATION BATCH - Plant COA is " + plantCOA + " and plant account is " + plantAccount + " for Financial Object SubType Code = " + assetPaymentInfo.getFinancialObjectSubTypeCode() + " so Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                LOG.debug((Object)("Asset#: " + assetNumber + " - Payment sequence#:" + assetPaymentInfo.getPaymentSequenceNumber() + " - Asset Depreciation date:" + assetDepreciationDate + " - Life:" + assetLifeInMonths + " - Depreciation base amt:" + primaryDepreciationBaseAmount + " - Accumulated depreciation:" + assetPaymentInfo.getAccumulatedPrimaryDepreciationAmount() + " - Month Elapsed:" + monthsElapsed + " - Calculated accum depreciation:" + accumulatedDepreciationAmount + " - Depreciation amount:" + transactionAmount.toString() + " - Depreciation Method:" + assetPaymentInfo.getPrimaryDepreciationMethodCode()));
                assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount(accumulatedDepreciationAmount);
                assetPaymentInfo.setTransactionAmount(transactionAmount);
                saveList.add(assetPaymentInfo);
                if (++counter % 1000 == 0) {
                    this.getDepreciationBatchDao().updateAssetPayments(saveList, fiscalMonth);
                    saveList.clear();
                }
                if (!transactionAmount.isNonZero()) continue;
                this.populateDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, depreciationExpenseFinancialObject, depreciationTransactionSummary);
                transactionType = transactionType.equals("D") ? "C" : "D";
                this.populateDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, accumulatedDepreciationFinancialObject, depreciationTransactionSummary);
            }
            this.getDepreciationBatchDao().updateAssetPayments(saveList, fiscalMonth);
            saveList.clear();
            return depreciationTransactionSummary;
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred", (Throwable)e);
            throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.calculationError") + " :" + e.getMessage());
        }
    }

    protected void populateDepreciationTransaction(AssetPaymentInfo assetPayment, String transactionType, String plantCOA, String plantAccount, ObjectCode deprObjectCode, SortedMap<String, AssetDepreciationTransaction> depreciationTransactionSummary) {
        LOG.debug((Object)"populateDepreciationTransaction(AssetDepreciationTransaction depreciationTransaction, AssetPayment assetPayment, String transactionType, KualiDecimal transactionAmount, String plantCOA, String plantAccount, String accumulatedDepreciationFinancialObjectCode, String depreciationExpenseFinancialObjectCode, ObjectCode financialObject, SortedMap<String, AssetDepreciationTransaction> depreciationTransactionSummary) -  started");
        LOG.debug((Object)("DEPRECIATION BATCH - populateDepreciationTransaction(): populating AssetDepreciationTransaction pojo - Asset#:" + assetPayment.getCapitalAssetNumber()));
        AssetDepreciationTransaction depreciationTransaction = new AssetDepreciationTransaction();
        depreciationTransaction.setCapitalAssetNumber(assetPayment.getCapitalAssetNumber());
        depreciationTransaction.setChartOfAccountsCode(plantCOA);
        depreciationTransaction.setAccountNumber(plantAccount);
        depreciationTransaction.setSubAccountNumber(assetPayment.getSubAccountNumber());
        depreciationTransaction.setFinancialObjectCode(deprObjectCode.getFinancialObjectCode());
        depreciationTransaction.setFinancialSubObjectCode(assetPayment.getFinancialSubObjectCode());
        depreciationTransaction.setFinancialObjectTypeCode(deprObjectCode.getFinancialObjectTypeCode());
        depreciationTransaction.setTransactionType(transactionType);
        depreciationTransaction.setProjectCode(assetPayment.getProjectCode());
        depreciationTransaction.setTransactionAmount(assetPayment.getTransactionAmount());
        depreciationTransaction.setTransactionLedgerEntryDescription("Batch Depreciation Asset " + assetPayment.getCapitalAssetNumber());
        String sKey = depreciationTransaction.getKey();
        if (depreciationTransactionSummary.containsKey(sKey)) {
            depreciationTransaction = (AssetDepreciationTransaction)((Object)depreciationTransactionSummary.get(sKey));
            depreciationTransaction.setTransactionAmount((KualiDecimal)depreciationTransaction.getTransactionAmount().add((AbstractKualiDecimal)assetPayment.getTransactionAmount()));
        } else {
            depreciationTransactionSummary.put(sKey, depreciationTransaction);
        }
        LOG.debug((Object)"populateDepreciationTransaction(AssetDepreciationTransaction depreciationTransaction, AssetPayment assetPayment, String transactionType, KualiDecimal transactionAmount, String plantCOA, String plantAccount, String accumulatedDepreciationFinancialObjectCode, String depreciationExpenseFinancialObjectCode, ObjectCode financialObject, SortedMap<String, AssetDepreciationTransaction> depreciationTransactionSummary) -  ended");
    }

    protected void processGeneralLedgerPendingEntry(Integer fiscalYear, Integer fiscalMonth, List<String> documentNos, SortedMap<String, AssetDepreciationTransaction> trans) {
        LOG.debug((Object)"populateExplicitGeneralLedgerPendingEntry(AccountingDocument, AccountingLine, GeneralLedgerPendingEntrySequenceHelper, GeneralLedgerPendingEntry) - start");
        try {
            String documentNumber = this.createNewDepreciationDocument(documentNos);
            String financialSystemDocumentTypeCodeCode = "DEPR";
            LOG.debug((Object)("DEPRECIATION BATCH - Depreciation Document Type Code: " + financialSystemDocumentTypeCodeCode));
            Timestamp transactionTimestamp = new Timestamp(this.dateTimeService.getCurrentDate().getTime());
            GeneralLedgerPendingEntrySequenceHelper sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper();
            ArrayList<GeneralLedgerPendingEntry> saveList = new ArrayList<GeneralLedgerPendingEntry>();
            int counter = 0;
            for (AssetDepreciationTransaction t : trans.values()) {
                if (!t.getTransactionAmount().isNonZero()) continue;
                ++counter;
                LOG.debug((Object)("DEPRECIATION BATCH - Creating GLPE entries for asset:" + t.getCapitalAssetNumber()));
                GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
                explicitEntry.setFinancialSystemOriginationCode("01");
                explicitEntry.setDocumentNumber(documentNumber);
                explicitEntry.setTransactionLedgerEntrySequenceNumber(new Integer(sequenceHelper.getSequenceCounter()));
                sequenceHelper.increment();
                explicitEntry.setChartOfAccountsCode(t.getChartOfAccountsCode());
                explicitEntry.setAccountNumber(t.getAccountNumber());
                explicitEntry.setSubAccountNumber(null);
                explicitEntry.setFinancialObjectCode(t.getFinancialObjectCode());
                explicitEntry.setFinancialSubObjectCode(null);
                explicitEntry.setFinancialBalanceTypeCode("AC");
                explicitEntry.setFinancialObjectTypeCode(t.getFinancialObjectTypeCode());
                explicitEntry.setUniversityFiscalYear(fiscalYear);
                explicitEntry.setUniversityFiscalPeriodCode(StringUtils.leftPad((String)fiscalMonth.toString().trim(), (int)2, (String)"0"));
                explicitEntry.setTransactionLedgerEntryDescription(t.getTransactionLedgerEntryDescription());
                explicitEntry.setTransactionLedgerEntryAmount((KualiDecimal)t.getTransactionAmount().abs());
                explicitEntry.setTransactionDebitCreditCode(t.getTransactionType());
                explicitEntry.setTransactionDate(new Date(transactionTimestamp.getTime()));
                explicitEntry.setFinancialDocumentTypeCode(financialSystemDocumentTypeCodeCode);
                explicitEntry.setFinancialDocumentApprovedCode("A");
                explicitEntry.setVersionNumber(new Long(1L));
                explicitEntry.setTransactionEntryProcessedTs(new Timestamp(transactionTimestamp.getTime()));
                saveList.add(explicitEntry);
                if (counter % 1000 == 0) {
                    this.getDepreciationBatchDao().savePendingGLEntries(saveList);
                    saveList.clear();
                }
                if (sequenceHelper.getSequenceCounter() != 99999) continue;
                documentNumber = this.createNewDepreciationDocument(documentNos);
                sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper();
            }
            this.getDepreciationBatchDao().savePendingGLEntries(saveList);
            saveList.clear();
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred", (Throwable)e);
            throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.glpeUpdateError") + " :" + e.getMessage());
        }
        LOG.debug((Object)"populateExplicitGeneralLedgerPendingEntry(AccountingDocument, AccountingLine, GeneralLedgerPendingEntrySequenceHelper, GeneralLedgerPendingEntry) - end");
    }

    protected String createNewDepreciationDocument(List<String> documentNos) throws WorkflowException {
        WorkflowDocument workflowDocument = this.getWorkflowDocumentService().createWorkflowDocument("DEPR", GlobalVariables.getUserSession().getPerson());
        LOG.debug((Object)"DEPRECIATION BATCH - Creating document header entry.");
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setWorkflowDocument(workflowDocument);
        documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setExplanation("Batch Depreciation Entry");
        documentHeader.setDocumentDescription("Batch Depreciation Entry");
        documentHeader.setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
        LOG.debug((Object)"DEPRECIATION BATCH - Saving document header entry.");
        this.businessObjectService.save((PersistableBusinessObject)documentHeader);
        LOG.debug((Object)"DEPRECIATION BATCH - Document Header entry was saved successfully.");
        String documentNumber = documentHeader.getDocumentNumber();
        documentNos.add(documentNumber);
        LOG.debug((Object)("DEPRECIATION BATCH - Document Number Created: " + documentNumber));
        return documentNumber;
    }

    protected ObjectCode getDepreciationObjectCode(Integer fiscalYear, Map<String, ObjectCode> capObjectCodesCache, AssetPaymentInfo assetPaymentInfo, String capitalizationFinancialObjectCode) {
        ObjectCode deprObjCode = null;
        String key = assetPaymentInfo.getChartOfAccountsCode() + "-" + capitalizationFinancialObjectCode;
        deprObjCode = capObjectCodesCache.get(key);
        if (deprObjCode == null && ObjectUtils.isNotNull((Object)(deprObjCode = ((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class)).getByPrimaryId(fiscalYear, assetPaymentInfo.getChartOfAccountsCode(), capitalizationFinancialObjectCode)))) {
            capObjectCodesCache.put(key, deprObjCode);
        }
        return deprObjCode;
    }

    protected Map<String, AssetObjectCode> buildChartObjectToCapitalizationObjectMap(Collection<AssetObjectCode> assetObjectCodes) {
        HashMap<String, AssetObjectCode> assetObjectCodeMap = new HashMap<String, AssetObjectCode>();
        for (AssetObjectCode assetObjectCode : assetObjectCodes) {
            List<ObjectCode> objectCodes = assetObjectCode.getObjectCode();
            for (ObjectCode objectCode : objectCodes) {
                String key = objectCode.getChartOfAccountsCode() + "-" + objectCode.getFinancialObjectCode();
                if (assetObjectCodeMap.containsKey(key)) continue;
                assetObjectCodeMap.put(key, assetObjectCode);
            }
        }
        return assetObjectCodeMap;
    }

    private void sendWarningMail(List<String> errorMessages) {
        LOG.debug((Object)"sendEmail() starting");
        MailMessage message = new MailMessage();
        message.setFromAddress(this.mailService.getBatchMailingList());
        String subject = "Asset Depreciation Job status";
        message.setSubject(subject);
        Collection toAddresses = this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "RUN_DATE_NOTIFICATION_EMAIL_ADDRESSES");
        message.getToAddresses().add(toAddresses);
        StringBuffer sb = new StringBuffer();
        sb.append("Unable to run Depreciation process.Reason:\n");
        for (String msg : errorMessages) {
            sb.append(msg + "\n");
        }
        sb.append("Please set the dates correctly to run the job.");
        message.setMessage(sb.toString());
        try {
            this.mailService.sendMessage(message);
        }
        catch (MessagingException e) {
            LOG.error((Object)"sendErrorEmail() Invalid email address. Message not sent", (Throwable)e);
        }
        catch (InvalidAddressException e) {
            LOG.error((Object)"sendErrorEmail() Invalid email address. Message not sent", (Throwable)e);
        }
    }

    protected String getLastDayOfFiscalyear() {
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        String date = parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_ALL.class, "FISCAL_YEAR_END_MONTH_AND_DAY");
        return "-" + date.substring(0, 2) + "-" + date.substring(2);
    }

    protected void populateYearEndDepreciationTransaction(AssetPaymentInfo assetPayment, String transactionType, String plantCOA, String plantAccount, ObjectCode deprObjectCode, SortedMap<String, AssetDepreciationTransaction> depreciationTransactionSummary) {
        LOG.info((Object)("\npopulateYearEndDepreciationTransaction - Asset#:" + assetPayment.getCapitalAssetNumber() + " amount:" + assetPayment.getTransactionAmount() + " type:" + transactionType));
        LOG.info((Object)("deprObjectCode.getFinancialObjectCode():" + deprObjectCode.getFinancialObjectCode() + " deprObjectCode.getFinancialObjectTypeCode():" + deprObjectCode.getFinancialObjectTypeCode()));
        AssetDepreciationTransaction depreciationTransaction = new AssetDepreciationTransaction();
        depreciationTransaction.setCapitalAssetNumber(assetPayment.getCapitalAssetNumber());
        depreciationTransaction.setChartOfAccountsCode(plantCOA);
        depreciationTransaction.setAccountNumber(plantAccount);
        depreciationTransaction.setSubAccountNumber(assetPayment.getSubAccountNumber());
        depreciationTransaction.setFinancialObjectCode(deprObjectCode.getFinancialObjectCode());
        depreciationTransaction.setFinancialSubObjectCode(assetPayment.getFinancialSubObjectCode());
        depreciationTransaction.setFinancialObjectTypeCode(deprObjectCode.getFinancialObjectTypeCode());
        depreciationTransaction.setTransactionType(transactionType);
        depreciationTransaction.setProjectCode(assetPayment.getProjectCode());
        depreciationTransaction.setTransactionAmount(assetPayment.getTransactionAmount());
        depreciationTransaction.setTransactionLedgerEntryDescription("Year End Depreciation Asset " + assetPayment.getCapitalAssetNumber());
        String sKey = depreciationTransaction.getKey();
        if (depreciationTransactionSummary.containsKey(sKey)) {
            LOG.info((Object)("depreciationTransactionSummary.containsKey(sKey) where sKey=" + sKey));
            depreciationTransaction = (AssetDepreciationTransaction)((Object)depreciationTransactionSummary.get(sKey));
            depreciationTransaction.setTransactionAmount((KualiDecimal)depreciationTransaction.getTransactionAmount().add((AbstractKualiDecimal)assetPayment.getTransactionAmount()));
        } else {
            LOG.info((Object)("depreciationTransactionSummary DOESNT containsKey(sKey) where sKey=" + sKey));
            depreciationTransactionSummary.put(sKey, depreciationTransaction);
        }
        LOG.info((Object)"\n\n");
    }

    protected SortedMap<String, AssetDepreciationTransaction> calculateYearEndDepreciation(Collection<AssetPaymentInfo> depreciableAssetsCollection, Calendar depreciationDate, Integer fiscalYearToDepreciate, Integer fiscalYear, Integer fiscalMonth, Collection<AssetObjectCode> assetObjectCodes) {
        LOG.info((Object)"calculateDepreciation() - start");
        TreeMap<String, AssetDepreciationTransaction> depreciationTransactionSummary = new TreeMap<String, AssetDepreciationTransaction>();
        double monthsElapsed = 0.0;
        double assetLifeInMonths = 0.0;
        KualiDecimal accumulatedDepreciationAmount = KualiDecimal.ZERO;
        Calendar assetDepreciationDate = Calendar.getInstance();
        try {
            LOG.info((Object)"YEAR END DEPRECIATION - Getting the parameters for the plant fund object sub types.");
            Collection organizationPlantFundObjectSubType = this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_ORGANIZATON_PLANT_FUND_OBJECT_SUB_TYPE");
            Collection campusPlantFundObjectSubType = this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE");
            this.depreciationBatchDao.resetPeriodValuesWhenFirstFiscalPeriod(fiscalMonth);
            LOG.info((Object)"getBaseAmountOfAssets(Collection<AssetPayment> depreciableAssetsCollection) - Started.");
            LOG.info((Object)"YEAR END DEPRECIATION - Calculating the base amount for each asset.");
            Map<Long, KualiDecimal> salvageValueAssetDeprAmounts = this.depreciationBatchDao.getPrimaryDepreciationBaseAmountForSV();
            Map<String, AssetObjectCode> assetObjectCodeMap = this.buildChartObjectToCapitalizationObjectMap(assetObjectCodes);
            HashMap<String, ObjectCode> capitalizationObjectCodes = new HashMap<String, ObjectCode>();
            LOG.info((Object)"YEAR END DEPRECIATION - Reading collection with eligible asset payment details.");
            int counter = 0;
            ArrayList<AssetPaymentInfo> saveList = new ArrayList<AssetPaymentInfo>();
            for (AssetPaymentInfo assetPaymentInfo : depreciableAssetsCollection) {
                KualiDecimal primaryDepreciationBaseAmount;
                AssetObjectCode assetObjectCode;
                boolean asset_is_retired = false;
                boolean asset_is_not_in_last_year_of_life = false;
                HashMap<String, Long> pKeys = new HashMap<String, Long>();
                Long assetNumber = assetPaymentInfo.getCapitalAssetNumber();
                pKeys.put("capitalAssetNumber", assetNumber);
                Asset asset = (Asset)this.businessObjectService.findByPrimaryKey(Asset.class, pKeys);
                if (asset != null) {
                    asset_is_retired = this.assetService.isAssetRetired(asset);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("asset#" + assetNumber + "   asset_is_retired = " + asset_is_retired));
                    }
                }
                if ((assetObjectCode = assetObjectCodeMap.get(assetPaymentInfo.getChartOfAccountsCode() + "-" + assetPaymentInfo.getFinancialObjectCode())) == null) {
                    LOG.error((Object)("YEAR END DEPRECIATION - Asset object code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetPaymentInfo.getFinancialObjectCode()));
                    LOG.error((Object)("YEAR END DEPRECIATION - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                LOG.info((Object)("YEAR END DEPRECIATION - fiscal year " + fiscalYear + " chartOfAccountsCode:" + assetPaymentInfo.getChartOfAccountsCode() + " FinancialObjectCode:" + assetPaymentInfo.getFinancialObjectCode()));
                ObjectCode accumulatedDepreciationFinancialObject = this.getDepreciationObjectCode(fiscalYear, capitalizationObjectCodes, assetPaymentInfo, assetObjectCode.getAccumulatedDepreciationFinancialObjectCode());
                ObjectCode depreciationExpenseFinancialObject = this.getDepreciationObjectCode(fiscalYear, capitalizationObjectCodes, assetPaymentInfo, assetObjectCode.getDepreciationExpenseFinancialObjectCode());
                String retire_code = this.parameterService.getParameterValueAsString(AssetRetirementGlobal.class, "DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE");
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("retire_code from system parameter DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE = " + retire_code));
                }
                ObjectCode depreciationYearEndExpenseFinancialObject = this.getDepreciationObjectCode(fiscalYear, capitalizationObjectCodes, assetPaymentInfo, retire_code);
                if (ObjectUtils.isNull((Object)accumulatedDepreciationFinancialObject)) {
                    LOG.error((Object)("YEAR END DEPRECIATION - Accumulated Depreciation Financial Object Code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetObjectCode.getAccumulatedDepreciationFinancialObjectCode()));
                    LOG.error((Object)("YEAR END DEPRECIATION - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("YEAR END DEPRECIATION - accumulatedDepreciationFinancialObject:" + accumulatedDepreciationFinancialObject.getFinancialObjectCode()));
                }
                if (ObjectUtils.isNull((Object)depreciationExpenseFinancialObject)) {
                    LOG.error((Object)("YEAR END DEPRECIATION - Depreciation Expense Financial Object Code not found for " + fiscalYear + "-" + assetPaymentInfo.getChartOfAccountsCode() + "-" + assetObjectCode.getDepreciationExpenseFinancialObjectCode()));
                    LOG.error((Object)("YEAR END DEPRECIATION - Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("YEAR END DEPRECIATION - depreciationExpenseFinancialObject:" + depreciationExpenseFinancialObject.getFinancialObjectCode()));
                }
                assetDepreciationDate.setTime(assetPaymentInfo.getDepreciationDate());
                accumulatedDepreciationAmount = KualiDecimal.ZERO;
                KualiDecimal deprAmountSum = salvageValueAssetDeprAmounts.get(assetNumber);
                assetLifeInMonths = assetPaymentInfo.getDepreciableLifeLimit() * 12;
                monthsElapsed = depreciationDate.get(2) - assetDepreciationDate.get(2) + (depreciationDate.get(1) - assetDepreciationDate.get(1)) * 12 + 1;
                if (assetLifeInMonths - monthsElapsed > 12.0) {
                    asset_is_not_in_last_year_of_life = true;
                }
                if ((primaryDepreciationBaseAmount = assetPaymentInfo.getPrimaryDepreciationBaseAmount()) == null) {
                    primaryDepreciationBaseAmount = KualiDecimal.ZERO;
                    assetPaymentInfo.setPrimaryDepreciationBaseAmount(KualiDecimal.ZERO);
                }
                if (assetPaymentInfo.getAccumulatedPrimaryDepreciationAmount() == null) {
                    assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount(KualiDecimal.ZERO);
                }
                if (monthsElapsed >= assetLifeInMonths) {
                    if ("SL".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode())) {
                        accumulatedDepreciationAmount = primaryDepreciationBaseAmount;
                    } else if ("SV".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode()) && deprAmountSum != null && deprAmountSum.isNonZero()) {
                        accumulatedDepreciationAmount = (KualiDecimal)primaryDepreciationBaseAmount.subtract(((KualiDecimal)primaryDepreciationBaseAmount.divide((AbstractKualiDecimal)deprAmountSum)).multiply((AbstractKualiDecimal)assetPaymentInfo.getSalvageAmount()));
                    }
                } else if ("SL".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode())) {
                    accumulatedDepreciationAmount = new KualiDecimal(monthsElapsed / assetLifeInMonths * primaryDepreciationBaseAmount.doubleValue());
                } else if ("SV".equals(assetPaymentInfo.getPrimaryDepreciationMethodCode()) && deprAmountSum != null && deprAmountSum.isNonZero()) {
                    accumulatedDepreciationAmount = new KualiDecimal(monthsElapsed / assetLifeInMonths * ((KualiDecimal)primaryDepreciationBaseAmount.subtract(((KualiDecimal)primaryDepreciationBaseAmount.divide((AbstractKualiDecimal)deprAmountSum)).multiply((AbstractKualiDecimal)assetPaymentInfo.getSalvageAmount()))).doubleValue());
                }
                KualiDecimal transactionAmount = (KualiDecimal)accumulatedDepreciationAmount.subtract((AbstractKualiDecimal)assetPaymentInfo.getAccumulatedPrimaryDepreciationAmount());
                HashMap<String, String> primaryKeys = new HashMap<String, String>();
                primaryKeys.put("financialObjectSubTypeCode", asset.getFinancialObjectSubTypeCode());
                AssetDepreciationConvention depreciationConvention = (AssetDepreciationConvention)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(AssetDepreciationConvention.class, primaryKeys);
                String conventionCode = depreciationConvention.getDepreciationConventionCode();
                if ("HY".equalsIgnoreCase(conventionCode) && asset_is_retired && asset_is_not_in_last_year_of_life) {
                    transactionAmount = (KualiDecimal)transactionAmount.divide((AbstractKualiDecimal)new KualiDecimal(2));
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("transactionAmount after being halved = " + transactionAmount));
                    }
                }
                String transactionType = "D";
                if (transactionAmount.isNegative()) {
                    transactionType = "C";
                }
                String plantAccount = "";
                String plantCOA = "";
                if (organizationPlantFundObjectSubType.contains(assetPaymentInfo.getFinancialObjectSubTypeCode())) {
                    plantAccount = assetPaymentInfo.getOrganizationPlantAccountNumber();
                    plantCOA = assetPaymentInfo.getOrganizationPlantChartCode();
                } else if (campusPlantFundObjectSubType.contains(assetPaymentInfo.getFinancialObjectSubTypeCode())) {
                    plantAccount = assetPaymentInfo.getCampusPlantAccountNumber();
                    plantCOA = assetPaymentInfo.getCampusPlantChartCode();
                }
                if (StringUtils.isBlank((String)plantCOA) || StringUtils.isBlank((String)plantAccount)) {
                    LOG.error((Object)("YEAR END DEPRECIATION - Plant COA is " + plantCOA + " and plant account is " + plantAccount + " for Financial Object SubType Code = " + assetPaymentInfo.getFinancialObjectSubTypeCode() + " so Asset payment is not included in depreciation " + assetPaymentInfo.getCapitalAssetNumber() + " - " + assetPaymentInfo.getPaymentSequenceNumber()));
                    continue;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Asset#: " + assetNumber + " - Payment sequence#:" + assetPaymentInfo.getPaymentSequenceNumber() + " - Asset Depreciation date:" + sdf.format(assetDepreciationDate.getTime()) + " - Life:" + assetLifeInMonths + " - Depreciation base amt:" + primaryDepreciationBaseAmount));
                    LOG.info((Object)("Accumulated depreciation:" + assetPaymentInfo.getAccumulatedPrimaryDepreciationAmount() + " - Month Elapsed:" + monthsElapsed + " - Calculated accum depreciation:" + accumulatedDepreciationAmount + " - Depreciation amount:" + transactionAmount.toString() + " - Depreciation Method:" + assetPaymentInfo.getPrimaryDepreciationMethodCode()));
                }
                if (asset_is_retired && asset_is_not_in_last_year_of_life) {
                    assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount((KualiDecimal)accumulatedDepreciationAmount.subtract((AbstractKualiDecimal)transactionAmount));
                } else {
                    assetPaymentInfo.setAccumulatedPrimaryDepreciationAmount(accumulatedDepreciationAmount);
                }
                assetPaymentInfo.setTransactionAmount(transactionAmount);
                saveList.add(assetPaymentInfo);
                if (++counter % 1000 == 0) {
                    this.getDepreciationBatchDao().updateAssetPayments(saveList, fiscalMonth);
                    saveList.clear();
                }
                if (!transactionAmount.isNonZero()) continue;
                this.populateYearEndDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, depreciationExpenseFinancialObject, depreciationTransactionSummary);
                transactionType = transactionType.equals("D") ? "C" : "D";
                this.populateYearEndDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, accumulatedDepreciationFinancialObject, depreciationTransactionSummary);
                if (!asset_is_retired) continue;
                this.populateYearEndDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, depreciationYearEndExpenseFinancialObject, depreciationTransactionSummary);
                transactionType = transactionType.equals("D") ? "C" : "D";
                this.populateYearEndDepreciationTransaction(assetPaymentInfo, transactionType, plantCOA, plantAccount, accumulatedDepreciationFinancialObject, depreciationTransactionSummary);
            }
            this.getDepreciationBatchDao().updateAssetPayments(saveList, fiscalMonth);
            saveList.clear();
            return depreciationTransactionSummary;
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred", (Throwable)e);
            throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.calculationError") + " :" + e.getMessage(), e);
        }
    }

    protected void processYearEndGeneralLedgerPendingEntry(Integer fiscalYear, List<String> documentNos, SortedMap<String, AssetDepreciationTransaction> trans) {
        Integer fiscalMonth = new Integer(13);
        this.processGeneralLedgerPendingEntry(fiscalYear, fiscalMonth, documentNos, trans);
    }

    protected void updateAssetsDatesForLastFiscalPeriod(Integer fiscalMonth, Integer fiscalYear) {
        if (fiscalMonth == 12) {
            LOG.info((Object)"DEPRECIATION BATCH - Starting updateAssetsCreatedInLastFiscalPeriod()");
            java.util.Date lastDateOfFiscalYear = this.universityDateService.getLastDateOfFiscalYear(fiscalYear);
            if (lastDateOfFiscalYear == null) {
                throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.gl.UniversityDateNotFound"));
            }
            Date lastFiscalYearDate = new Date(lastDateOfFiscalYear.getTime());
            ArrayList<String> movableEquipmentObjectSubTypes = new ArrayList<String>();
            if (this.parameterService.parameterExists(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES").booleanValue()) {
                movableEquipmentObjectSubTypes.addAll(this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES"));
            }
            if (!movableEquipmentObjectSubTypes.isEmpty()) {
                this.updateAssetDatesPerConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, "CD");
                this.updateAssetDatesPerConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, "FY");
                this.updateAssetDatesPerConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, "HY");
            }
            LOG.info((Object)"DEPRECIATION BATCH - Finished updateAssetsCreatedInLastFiscalPeriod()");
        }
    }

    protected void updateAssetDatesPerConvention(Date lastFiscalYearDate, List<String> movableEquipmentObjectSubTypes, String depreciationConventionCd) {
        List<Map<String, Object>> selectedAssets = this.getDepreciationBatchDao().getAssetsByDepreciationConvention(lastFiscalYearDate, movableEquipmentObjectSubTypes, depreciationConventionCd);
        if (selectedAssets != null && !selectedAssets.isEmpty()) {
            ArrayList<String> assetNumbers = new ArrayList<String>();
            for (Map<String, Object> assetMap : selectedAssets) {
                assetNumbers.add(((BigDecimal)assetMap.get("CPTLAST_NBR")).toString());
            }
            Date depreciationDate = this.getAssetDateService().computeDepreciationDateForPeriod13(depreciationConventionCd, lastFiscalYearDate);
            this.getDepreciationBatchDao().updateAssetInServiceAndDepreciationDate(assetNumbers, lastFiscalYearDate, depreciationDate);
            LOG.info((Object)("DEPRECIATION BATCH - Finished updateAssetInServiceAndDepreciationDate() for Depreciation convention " + depreciationConventionCd + " for " + assetNumbers.size() + " assets : " + ((Object)assetNumbers).toString()));
        }
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDepreciableAssetsDao(DepreciableAssetsDao depreciableAssetsDao) {
        this.depreciableAssetsDao = depreciableAssetsDao;
    }

    public void setCamsReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setConfigurationService(ConfigurationService kcs) {
        this.kualiConfigurationService = kcs;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DepreciationBatchDao getDepreciationBatchDao() {
        return this.depreciationBatchDao;
    }

    @Override
    public void setDepreciationBatchDao(DepreciationBatchDao depreciationBatchDao) {
        this.depreciationBatchDao = depreciationBatchDao;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        if (this.workflowDocumentService == null) {
            this.workflowDocumentService = KRADServiceLocatorWeb.getWorkflowDocumentService();
        }
        return this.workflowDocumentService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public AssetDateService getAssetDateService() {
        return this.assetDateService;
    }

    public void setAssetDateService(AssetDateService assetDateService) {
        this.assetDateService = assetDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }
}

