/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch.dataaccess.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cab.batch.dataaccess.ExtractDao;
import org.kuali.kfs.module.cab.businessobject.BatchParameters;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class ExtractDaoOjb
extends PlatformAwareDaoBaseOjb
implements ExtractDao {
    private static final Logger LOG = Logger.getLogger(ExtractDaoOjb.class);

    @Override
    public Collection<Entry> findMatchingGLEntries(BatchParameters batchParameters) {
        Criteria criteria = new Criteria();
        criteria.addGreaterThan((Object)"transactionDateTimeStamp", (Object)batchParameters.getLastRunTime());
        if (!batchParameters.getExcludedChartCodes().isEmpty()) {
            criteria.addNotIn("chartOfAccountsCode", batchParameters.getExcludedChartCodes());
        }
        if (!batchParameters.getExcludedSubFundCodes().isEmpty()) {
            criteria.addNotIn("account.subFundGroupCode", batchParameters.getExcludedSubFundCodes());
        }
        if (!batchParameters.getIncludedFinancialBalanceTypeCodes().isEmpty()) {
            criteria.addIn("financialBalanceTypeCode", batchParameters.getIncludedFinancialBalanceTypeCodes());
        }
        if (!batchParameters.getIncludedFinancialObjectSubTypeCodes().isEmpty()) {
            criteria.addIn("financialObject.financialObjectSubTypeCode", batchParameters.getIncludedFinancialObjectSubTypeCodes());
        }
        if (!batchParameters.getExcludedFiscalPeriods().isEmpty()) {
            criteria.addNotIn("universityFiscalPeriodCode", batchParameters.getExcludedFiscalPeriods());
        }
        if (!batchParameters.getExcludedDocTypeCodes().isEmpty()) {
            criteria.addNotIn("financialDocumentTypeCode", batchParameters.getExcludedDocTypeCodes());
        }
        QueryByCriteria query = new QueryByCriteria(Entry.class, criteria);
        query.addOrderByAscending("documentNumber");
        query.addOrderByAscending("transactionDateTimeStamp");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Collection<PurchaseOrderAccount> findPreTaggablePOAccounts(BatchParameters batchParameters, List<String> docNumbersAwaitingPurchaseOrderStatus) {
        Criteria statusCodeCond1 = new Criteria();
        statusCodeCond1.addEqualTo("purapItem.purapDocument.capitalAssetSystemStateCode", (Object)"NEW");
        Criteria statusCodeOrCond = new Criteria();
        statusCodeOrCond.addIsNull("purapItem.purapDocument.capitalAssetSystemStateCode");
        statusCodeOrCond.addOrCriteria(statusCodeCond1);
        Criteria criteria = new Criteria();
        Timestamp lastRunTimestamp = new Timestamp(batchParameters.getLastRunDate().getTime());
        criteria.addGreaterThan((Object)"purapItem.purapDocument.purchaseOrderInitialOpenTimestamp", (Object)lastRunTimestamp);
        criteria.addAndCriteria(statusCodeOrCond);
        criteria.addGreaterOrEqualThan((Object)"purapItem.itemUnitPrice", (Object)batchParameters.getCapitalizationLimitAmount());
        if (!batchParameters.getExcludedChartCodes().isEmpty()) {
            criteria.addNotIn("chartOfAccountsCode", batchParameters.getExcludedChartCodes());
        }
        if (!batchParameters.getExcludedSubFundCodes().isEmpty()) {
            criteria.addNotIn("account.subFundGroupCode", batchParameters.getExcludedSubFundCodes());
        }
        if (!batchParameters.getIncludedFinancialObjectSubTypeCodes().isEmpty()) {
            criteria.addIn("objectCode.financialObjectSubTypeCode", batchParameters.getIncludedFinancialObjectSubTypeCodes());
        }
        QueryByCriteria query = new QueryByCriteria(PurchaseOrderAccount.class, criteria);
        Collection purchaseOrderAccounts = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<PurchaseOrderAccount> purchaseOrderAcctsAwaitingPOOpenStatus = new ArrayList<PurchaseOrderAccount>();
        for (PurchaseOrderAccount purchaseOrderAccount : purchaseOrderAccounts) {
            if (!docNumbersAwaitingPurchaseOrderStatus.contains(purchaseOrderAccount.getDocumentNumber())) continue;
            purchaseOrderAcctsAwaitingPOOpenStatus.add(purchaseOrderAccount);
        }
        return purchaseOrderAcctsAwaitingPOOpenStatus;
    }

    @Override
    @Deprecated
    public Collection<PurchaseOrderAccount> findPreTaggablePOAccounts(BatchParameters batchParameters) {
        Criteria statusCodeCond1 = new Criteria();
        statusCodeCond1.addEqualTo("purapItem.purapDocument.capitalAssetSystemStateCode", (Object)"NEW");
        Criteria statusCodeOrCond = new Criteria();
        statusCodeOrCond.addIsNull("purapItem.purapDocument.capitalAssetSystemStateCode");
        statusCodeOrCond.addOrCriteria(statusCodeCond1);
        Criteria criteria = new Criteria();
        Timestamp lastRunTimestamp = new Timestamp(batchParameters.getLastRunDate().getTime());
        criteria.addGreaterThan((Object)"purapItem.purapDocument.purchaseOrderInitialOpenTimestamp", (Object)lastRunTimestamp);
        criteria.addAndCriteria(statusCodeOrCond);
        criteria.addGreaterOrEqualThan((Object)"purapItem.itemUnitPrice", (Object)batchParameters.getCapitalizationLimitAmount());
        if (!batchParameters.getExcludedChartCodes().isEmpty()) {
            criteria.addNotIn("chartOfAccountsCode", batchParameters.getExcludedChartCodes());
        }
        if (!batchParameters.getExcludedSubFundCodes().isEmpty()) {
            criteria.addNotIn("account.subFundGroupCode", batchParameters.getExcludedSubFundCodes());
        }
        if (!batchParameters.getIncludedFinancialObjectSubTypeCodes().isEmpty()) {
            criteria.addIn("objectCode.financialObjectSubTypeCode", batchParameters.getIncludedFinancialObjectSubTypeCodes());
        }
        QueryByCriteria query = new QueryByCriteria(PurchaseOrderAccount.class, criteria);
        Collection purchaseOrderAccounts = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList docNumbersAwaitingPurchaseOrderStatus = new ArrayList();
        ArrayList<PurchaseOrderAccount> purchaseOrderAcctsAwaitingPOOpenStatus = new ArrayList<PurchaseOrderAccount>();
        for (PurchaseOrderAccount purchaseOrderAccount : purchaseOrderAccounts) {
            if (!docNumbersAwaitingPurchaseOrderStatus.contains(purchaseOrderAccount.getDocumentNumber())) continue;
            purchaseOrderAcctsAwaitingPOOpenStatus.add(purchaseOrderAccount);
        }
        return purchaseOrderAcctsAwaitingPOOpenStatus;
    }

    @Override
    public Collection<CreditMemoAccountRevision> findCreditMemoAccountRevisions(BatchParameters batchParameters) {
        Criteria criteria = new Criteria();
        criteria.addGreaterThan((Object)"accountRevisionTimestamp", (Object)batchParameters.getLastRunTime());
        if (!batchParameters.getExcludedChartCodes().isEmpty()) {
            criteria.addNotIn("chartOfAccountsCode", batchParameters.getExcludedChartCodes());
        }
        if (!batchParameters.getExcludedSubFundCodes().isEmpty()) {
            criteria.addNotIn("account.subFundGroupCode", batchParameters.getExcludedSubFundCodes());
        }
        if (!batchParameters.getIncludedFinancialObjectSubTypeCodes().isEmpty()) {
            criteria.addIn("objectCode.financialObjectSubTypeCode", batchParameters.getIncludedFinancialObjectSubTypeCodes());
        }
        QueryByCriteria query = new QueryByCriteria(CreditMemoAccountRevision.class, criteria);
        query.addOrderByAscending("accountRevisionTimestamp");
        Collection historyRecs = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return historyRecs;
    }

    @Override
    public Collection<PaymentRequestAccountRevision> findPaymentRequestAccountRevisions(BatchParameters batchParameters) {
        Criteria criteria = new Criteria();
        criteria.addGreaterThan((Object)"accountRevisionTimestamp", (Object)batchParameters.getLastRunTime());
        if (!batchParameters.getExcludedChartCodes().isEmpty()) {
            criteria.addNotIn("chartOfAccountsCode", batchParameters.getExcludedChartCodes());
        }
        if (!batchParameters.getExcludedSubFundCodes().isEmpty()) {
            criteria.addNotIn("account.subFundGroupCode", batchParameters.getExcludedSubFundCodes());
        }
        if (!batchParameters.getIncludedFinancialObjectSubTypeCodes().isEmpty()) {
            criteria.addIn("objectCode.financialObjectSubTypeCode", batchParameters.getIncludedFinancialObjectSubTypeCodes());
        }
        QueryByCriteria query = new QueryByCriteria(PaymentRequestAccountRevision.class, criteria);
        query.addOrderByAscending("accountRevisionTimestamp");
        Collection historyRecs = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return historyRecs;
    }
}

