/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.OriginationCodeService;

public class AssetPaymentOriginCodeValidation
extends GenericValidation {
    private OriginationCodeService originationCodeService;
    private DataDictionaryService dataDictionaryService;
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        if (assetPaymentDocument.isCapitalAssetBuilderOriginIndicator()) {
            return true;
        }
        AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)this.getAccountingLineForValidation();
        boolean result = true;
        if (!StringUtils.isBlank((String)assetPaymentDetail.getExpenditureFinancialSystemOriginationCode()) && this.originationCodeService.getByPrimaryKey(assetPaymentDetail.getExpenditureFinancialSystemOriginationCode()) == null) {
            String label = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(OriginationCode.class.getName()).getAttributeDefinition("financialSystemOriginationCode").getLabel();
            GlobalVariables.getMessageMap().putError("expenditureFinancialSystemOriginationCode", "error.existence", new String[]{label});
            result = false;
        }
        return result;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLine) {
        this.accountingLineForValidation = accountingLine;
    }

    public OriginationCodeService getOriginationCodeService() {
        return this.originationCodeService;
    }

    public void setOriginationCodeService(OriginationCodeService originationCodeService) {
        this.originationCodeService = originationCodeService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

