/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.KualiGlobalMaintainableImpl;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;

public class AssetLocationGlobalMaintainableImpl
extends KualiGlobalMaintainableImpl {
    private static Logger LOG = Logger.getLogger(AssetLocationGlobalMaintainableImpl.class);

    public void addNewLineToCollection(String collectionName) {
        AssetLocationGlobalDetail addAssetLine = (AssetLocationGlobalDetail)((Object)this.newCollectionLines.get(collectionName));
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("capitalAssetNumber", addAssetLine.getCapitalAssetNumber());
        Asset asset = (Asset)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Asset.class, map);
        if (ObjectUtils.isNotNull((Object)((Object)asset)) && ObjectUtils.isNotNull((Object)asset.getCapitalAssetNumber())) {
            if (StringUtils.isBlank((String)addAssetLine.getCampusCode())) {
                addAssetLine.setCampusCode(asset.getCampusCode());
            }
            if (StringUtils.isBlank((String)addAssetLine.getBuildingCode())) {
                addAssetLine.setBuildingCode(asset.getBuildingCode());
            }
            if (StringUtils.isBlank((String)addAssetLine.getBuildingRoomNumber())) {
                addAssetLine.setBuildingRoomNumber(asset.getBuildingRoomNumber());
            }
            if (StringUtils.isBlank((String)addAssetLine.getBuildingSubRoomNumber())) {
                addAssetLine.setBuildingSubRoomNumber(asset.getBuildingSubRoomNumber());
            }
            if (StringUtils.isBlank((String)addAssetLine.getCampusTagNumber())) {
                addAssetLine.setCampusTagNumber(asset.getCampusTagNumber());
            }
            addAssetLine.setNewCollectionRecord(true);
        }
        super.addNewLineToCollection(collectionName);
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        WorkflowDocument workflowDoc = documentHeader.getWorkflowDocument();
        if (workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isProcessed() || workflowDoc.isFinal()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
    }

    public List<MaintenanceLock> generateMaintenanceLocks() {
        return new ArrayList<MaintenanceLock>();
    }

    public Map<String, String> populateNewCollectionLines(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        String capitalAssetNumber = fieldValues.get("assetLocationGlobalDetails.capitalAssetNumber");
        if (StringUtils.isNotBlank((String)capitalAssetNumber)) {
            fieldValues.remove("assetLocationGlobalDetails.capitalAssetNumber");
            fieldValues.put("assetLocationGlobalDetails.capitalAssetNumber", capitalAssetNumber.trim());
        }
        return super.populateNewCollectionLines(fieldValues, maintenanceDocument, methodToCall);
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public Class<? extends PersistableBusinessObject> getPrimaryEditedBusinessObjectClass() {
        return Asset.class;
    }

    public void addMultipleValueLookupResults(MaintenanceDocument document, String collectionName, Collection<PersistableBusinessObject> rawValues, boolean needsBlank, PersistableBusinessObject bo) {
        AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)document.getDocumentBusinessObject();
        ArrayList<Asset> allowedAssetsCollection = new ArrayList<Asset>();
        String maintDocTypeName = "CASM";
        GlobalVariables.getMessageMap().clearErrorMessages();
        for (PersistableBusinessObject businessObject : rawValues) {
            Asset asset = (Asset)businessObject;
            if (!StringUtils.isNotBlank((String)"CASM")) continue;
            boolean allowsEdit = this.getBusinessObjectAuthorizationService().canMaintain((Object)asset, GlobalVariables.getUserSession().getPerson(), "CASM");
            if (allowsEdit) {
                allowedAssetsCollection.add(asset);
                continue;
            }
            GlobalVariables.getMessageMap().putErrorForSectionId("Edit List of Assets", "error.asset.authorization", new String[]{GlobalVariables.getUserSession().getPerson().getPrincipalName(), asset.getCapitalAssetNumber().toString()});
        }
        super.addMultipleValueLookupResults(document, collectionName, allowedAssetsCollection, needsBlank, bo);
    }
}

