/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.authorization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.authorization.AccountingLineAuthorizerBase;
import org.kuali.kfs.sys.document.web.AccountingLineRenderingContext;
import org.kuali.kfs.sys.document.web.AccountingLineViewAction;
import org.kuali.rice.kim.api.identity.Person;

public class AssetPaymentAccountingLineAuthorizer
extends AccountingLineAuthorizerBase {
    public boolean determineEditPermissionOnField(AccountingDocument accountingDocument, AccountingLine accountingLine, String accountingLineCollectionProperty, String fieldName, boolean editablePage) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)accountingDocument;
        if (assetPaymentDocument.isCapitalAssetBuilderOriginIndicator()) {
            return false;
        }
        return super.determineEditPermissionOnField(accountingDocument, accountingLine, accountingLineCollectionProperty, fieldName, editablePage);
    }

    public boolean isGroupEditable(AccountingDocument accountingDocument, List<? extends AccountingLineRenderingContext> accountingLineRenderingContexts, Person currentUser) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)accountingDocument;
        if (assetPaymentDocument.isCapitalAssetBuilderOriginIndicator()) {
            return false;
        }
        return super.isGroupEditable(accountingDocument, accountingLineRenderingContexts, currentUser);
    }

    protected Map<String, AccountingLineViewAction> getActionMap(AccountingLineRenderingContext accountingLineRenderingContext, String accountingLinePropertyName, Integer accountingLineIndex, String groupTitle) {
        boolean isFromCab = false;
        AccountingDocument accountingDocument = accountingLineRenderingContext.getAccountingDocument();
        if (accountingDocument != null && AssetPaymentDocument.class.isAssignableFrom(accountingDocument.getClass())) {
            isFromCab = ((AssetPaymentDocument)accountingDocument).isCapitalAssetBuilderOriginIndicator();
        }
        HashMap<String, AccountingLineViewAction> actionMap = new HashMap<String, AccountingLineViewAction>();
        if (accountingLineIndex == null || accountingLineIndex < 0) {
            AccountingLineViewAction addAction = this.getAddAction(accountingLineRenderingContext.getAccountingLine(), accountingLinePropertyName, groupTitle);
            actionMap.put("insert", addAction);
        } else {
            if (!isFromCab && accountingLineRenderingContext.allowDelete()) {
                AccountingLineViewAction deleteAction = this.getDeleteAction(accountingLineRenderingContext.getAccountingLine(), accountingLinePropertyName, accountingLineIndex, groupTitle);
                actionMap.put("delete", deleteAction);
            }
            AccountingLineViewAction balanceInquiryAction = this.getBalanceInquiryAction(accountingLineRenderingContext.getAccountingLine(), accountingLinePropertyName, accountingLineIndex, groupTitle);
            actionMap.put("performBalanceInquiryFor", balanceInquiryAction);
        }
        return actionMap;
    }
}

