/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.services.IdentityManagementService;

public class AssetLocationGlobalRule
extends MaintenanceDocumentRuleBase {
    protected static final Logger LOG = Logger.getLogger(AssetLocationGlobalRule.class);
    protected AssetService assetService = (AssetService)SpringContext.getBean(AssetService.class);

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = super.processCustomSaveDocumentBusinessRules(document);
        AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)document.getNewMaintainableObject().getBusinessObject();
        return valid &= !this.getCapitalAssetManagementModuleService().isAssetLocked(this.retrieveAssetNumberForLocking(assetLocationGlobal), "ALOC", document.getDocumentNumber());
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument documentCopy) {
        boolean success = true;
        AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)documentCopy.getNewMaintainableObject().getBusinessObject();
        List<AssetLocationGlobalDetail> oldAssetLocationGlobalDetail = assetLocationGlobal.getAssetLocationGlobalDetails();
        int index = 0;
        boolean hasCapitalAssetChanged = false;
        if (this.hasAssetLocationGlobalDetails(oldAssetLocationGlobalDetail)) {
            HashSet<String> tags = new HashSet<String>();
            boolean pos = false;
            for (AssetLocationGlobalDetail detail : assetLocationGlobal.getAssetLocationGlobalDetails()) {
                String errorPath = "document.newMaintainableObject.assetLocationGlobalDetails[" + index + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                success &= this.validateActiveCapitalAsset(detail);
                success &= this.validateCampusCode(detail);
                success &= this.validateBuildingCode(detail);
                success &= this.validateBuildingRoomNumber(detail);
                success &= this.validateTagNumber(detail);
                success &= this.validateTagDuplicationWithinDocument(detail, tags);
                success &= this.validateTagDuplication(detail.getCapitalAssetNumber(), detail.getCampusTagNumber());
                success &= this.checkRequiredFieldsAfterAdd(detail);
                this.hasCapitalAssetChanged(detail);
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
                ++index;
            }
        }
        success &= super.processCustomRouteDocumentBusinessRules(documentCopy);
        WorkflowDocument workflowDoc = documentCopy.getDocumentHeader().getWorkflowDocument();
        if (!GlobalVariables.getMessageMap().hasErrors() && (workflowDoc.isInitiated() || workflowDoc.isSaved())) {
            success &= this.setAssetLocks(documentCopy);
        }
        return success;
    }

    protected List<Long> retrieveAssetNumberForLocking(AssetLocationGlobal assetLocationGlobal) {
        ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
        for (AssetLocationGlobalDetail locationDetail : assetLocationGlobal.getAssetLocationGlobalDetails()) {
            if (locationDetail.getCapitalAssetNumber() == null) continue;
            capitalAssetNumbers.add(locationDetail.getCapitalAssetNumber());
        }
        return capitalAssetNumbers;
    }

    private boolean setAssetLocks(MaintenanceDocument document) {
        AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)document.getNewMaintainableObject().getBusinessObject();
        return this.getCapitalAssetManagementModuleService().storeAssetLocks(this.retrieveAssetNumberForLocking(assetLocationGlobal), document.getDocumentNumber(), "ALOC", null);
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument documentCopy, String collectionName, PersistableBusinessObject bo) {
        boolean success = true;
        AssetLocationGlobal assetLocationGlobal = (AssetLocationGlobal)documentCopy.getNewMaintainableObject().getBusinessObject();
        HashSet<String> tags = new HashSet<String>();
        for (AssetLocationGlobalDetail detail : assetLocationGlobal.getAssetLocationGlobalDetails()) {
            if (detail.getCampusTagNumber() == null) continue;
            tags.add(detail.getCampusTagNumber());
        }
        AssetLocationGlobalDetail newLineDetail = (AssetLocationGlobalDetail)bo;
        success = this.validateActiveCapitalAsset(newLineDetail);
        if (success) {
            success &= this.authorizeCapitalAsset(newLineDetail);
            success &= this.validateCampusCode(newLineDetail);
            success &= this.validateBuildingCode(newLineDetail);
            success &= this.validateBuildingRoomNumber(newLineDetail);
            if (success &= this.validateTagDuplicationWithinDocument(newLineDetail, tags)) {
                success &= this.validateTagDuplication(newLineDetail.getCapitalAssetNumber(), newLineDetail.getCampusTagNumber());
            }
        }
        return success & super.processCustomAddCollectionLineBusinessRules(documentCopy, collectionName, bo);
    }

    protected boolean authorizeCapitalAsset(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)assetLocationGlobalDetail.getCapitalAssetNumber())) {
            assetLocationGlobalDetail.refreshReferenceObject("asset");
            assetLocationGlobalDetail.getAsset().refreshReferenceObject("organizationOwnerAccount");
            HashMap<String, String> qualification = new HashMap<String, String>();
            qualification.put("chartOfAccountsCode", assetLocationGlobalDetail.getAsset().getOrganizationOwnerChartOfAccountsCode());
            qualification.put("organizationCode", assetLocationGlobalDetail.getAsset().getOrganizationOwnerAccount().getOrganizationCode());
            if (!((IdentityManagementService)SpringContext.getBean(IdentityManagementService.class)).isAuthorized(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "KFS-CAM", "Maintain Asset Location", qualification)) {
                success &= false;
                GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.asset.authorization", new String[]{GlobalVariables.getUserSession().getPerson().getPrincipalName(), assetLocationGlobalDetail.getCapitalAssetNumber().toString()});
            }
        }
        return success;
    }

    protected boolean hasCapitalAssetChanged(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = false;
        if (ObjectUtils.isNotNull((Object)assetLocationGlobalDetail.getCapitalAssetNumber())) {
            assetLocationGlobalDetail.refreshReferenceObject("asset");
            assetLocationGlobalDetail.refreshReferenceObject("asset");
            Asset asset = assetLocationGlobalDetail.getAsset();
            if (ObjectUtils.isNotNull((Object)((Object)assetLocationGlobalDetail.getAsset()))) {
                if (!StringUtils.equalsIgnoreCase((String)asset.getCampusCode(), (String)assetLocationGlobalDetail.getCampusCode())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((String)asset.getBuildingCode(), (String)assetLocationGlobalDetail.getBuildingCode())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((String)asset.getBuildingRoomNumber(), (String)assetLocationGlobalDetail.getBuildingRoomNumber())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((String)asset.getBuildingSubRoomNumber(), (String)assetLocationGlobalDetail.getBuildingSubRoomNumber())) {
                    success = true;
                }
                if (!StringUtils.equalsIgnoreCase((String)asset.getCampusTagNumber(), (String)assetLocationGlobalDetail.getCampusTagNumber())) {
                    success = true;
                }
                if (!success) {
                    GlobalVariables.getMessageMap().putWarning("capitalAssetNumber", "warning.asset.not.changed", new String[]{assetLocationGlobalDetail.getCapitalAssetNumber().toString()});
                }
            }
        }
        return success;
    }

    protected boolean hasAssetLocationGlobalDetails(List<AssetLocationGlobalDetail> assetLocationGlobalDetails) {
        boolean success = true;
        if (assetLocationGlobalDetails.size() == 0) {
            success = false;
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.asset.location.no.asset.location.detail.line", new String[0]);
        }
        return success;
    }

    protected boolean validateActiveCapitalAsset(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)assetLocationGlobalDetail.getCapitalAssetNumber())) {
            assetLocationGlobalDetail.refreshReferenceObject("asset");
            if (ObjectUtils.isNull((Object)((Object)assetLocationGlobalDetail.getAsset()))) {
                GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.asset.location.invalid.capital.asset.number", new String[]{assetLocationGlobalDetail.getCapitalAssetNumber().toString()});
                success = false;
            } else if (this.assetService.isAssetRetired(assetLocationGlobalDetail.getAsset())) {
                GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.non.active.asset.retirment", new String[]{assetLocationGlobalDetail.getCapitalAssetNumber().toString()});
                success = false;
            }
        }
        return success;
    }

    protected boolean validateCampusCode(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = true;
        if (StringUtils.isNotBlank((String)assetLocationGlobalDetail.getCampusCode()) && ObjectUtils.isNull((Object)assetLocationGlobalDetail.getCampus())) {
            GlobalVariables.getMessageMap().putError("campusCode", "error.asset.location.invalid.campus.code", new String[]{assetLocationGlobalDetail.getCampusCode(), assetLocationGlobalDetail.getCapitalAssetNumber().toString()});
            success = false;
        }
        return success;
    }

    protected boolean validateBuildingCode(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = true;
        if (StringUtils.isNotBlank((String)assetLocationGlobalDetail.getCampusCode()) && StringUtils.isNotBlank((String)assetLocationGlobalDetail.getBuildingCode())) {
            assetLocationGlobalDetail.refreshReferenceObject("building");
            if (ObjectUtils.isNull((Object)assetLocationGlobalDetail.getBuilding())) {
                GlobalVariables.getMessageMap().putError("buildingCode", "error.asset.location.invalid.building.code", new String[]{assetLocationGlobalDetail.getBuildingCode(), assetLocationGlobalDetail.getCampusCode()});
                success = false;
            }
        }
        return success;
    }

    protected boolean validateBuildingRoomNumber(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = true;
        if (StringUtils.isNotBlank((String)assetLocationGlobalDetail.getBuildingRoomNumber())) {
            assetLocationGlobalDetail.refreshReferenceObject("buildingRoom");
            if (ObjectUtils.isNull((Object)assetLocationGlobalDetail.getBuildingRoom())) {
                GlobalVariables.getMessageMap().putError("buildingRoomNumber", "error.asset.location.invalid.room.code", new String[]{assetLocationGlobalDetail.getBuildingCode(), assetLocationGlobalDetail.getBuildingRoomNumber(), assetLocationGlobalDetail.getCampusCode()});
                success = false;
            }
        }
        return success;
    }

    protected boolean validateTagNumber(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = true;
        if (StringUtils.isBlank((String)assetLocationGlobalDetail.getCampusTagNumber())) {
            GlobalVariables.getMessageMap().putError("campusTagNumber", "error.asset.location.tag.number.required", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean validateTagDuplication(Long capitalAssetNumber, String campusTagNumber) {
        boolean success = true;
        if (capitalAssetNumber != null && ObjectUtils.isNotNull((Object)campusTagNumber) && !"N".equalsIgnoreCase(campusTagNumber)) {
            List<Asset> activeAssetsMatchingTagNumber = this.assetService.findActiveAssetsMatchingTagNumber(campusTagNumber);
            for (Asset asset : activeAssetsMatchingTagNumber) {
                if (asset.getCapitalAssetNumber().equals(capitalAssetNumber)) continue;
                GlobalVariables.getMessageMap().putError("campusTagNumber", "error.asset.location.duplicate.tag.number", new String[]{campusTagNumber, String.valueOf(asset.getCapitalAssetNumber()), capitalAssetNumber.toString()});
                success = false;
                break;
            }
        }
        return success;
    }

    protected boolean validateTagDuplicationWithinDocument(AssetLocationGlobalDetail assetLocationGlobalDetail, Set<String> tagsList) {
        boolean success = true;
        Long capitalAssetNumber = assetLocationGlobalDetail.getCapitalAssetNumber();
        String campusTagNumber = assetLocationGlobalDetail.getCampusTagNumber();
        if (capitalAssetNumber != null && ObjectUtils.isNotNull((Object)campusTagNumber) && !"N".equalsIgnoreCase(campusTagNumber) && !tagsList.add(campusTagNumber)) {
            success &= false;
            GlobalVariables.getMessageMap().putError("campusTagNumber", "error.asset.location.duplicate.tag.within.document", new String[]{campusTagNumber, capitalAssetNumber.toString()});
        }
        return success;
    }

    protected boolean checkRequiredFieldsAfterAdd(AssetLocationGlobalDetail assetLocationGlobalDetail) {
        boolean success = true;
        if (StringUtils.isBlank((String)assetLocationGlobalDetail.getCampusCode())) {
            GlobalVariables.getMessageMap().putError("campusCode", "error.asset.location.campus.code.required", new String[0]);
            success = false;
        }
        if (StringUtils.isBlank((String)assetLocationGlobalDetail.getBuildingCode())) {
            GlobalVariables.getMessageMap().putError("buildingCode", "error.asset.location.building.code.required", new String[0]);
            success = false;
        }
        if (StringUtils.isBlank((String)assetLocationGlobalDetail.getBuildingRoomNumber())) {
            GlobalVariables.getMessageMap().putError("buildingRoomNumber", "error.asset.location.room.number.required", new String[0]);
            success = false;
        }
        return success;
    }
}

