/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab;

import java.util.List;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cab.businessobject.GlAccountLineGroup;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class GlAccountLineGroupTest
extends KualiTestBase {
    protected void setUp() throws Exception {
    }

    public void testCombineEntry() throws Exception {
        GlAccountLineGroup first = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, "D", new KualiDecimal(100));
        Entry second = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, "D", new KualiDecimal(200));
        GlAccountLineGroupTest.assertTrue((boolean)first.equals((Object)new GlAccountLineGroup(second)));
        first.combineEntry(second);
        GlAccountLineGroupTest.assertEquals((String)"D", (String)first.getTargetEntry().getTransactionDebitCreditCode());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(300), (Object)first.getTargetEntry().getTransactionLedgerEntryAmount());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(300), (Object)first.getAmount());
        Entry third = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, "C", new KualiDecimal(200));
        GlAccountLineGroupTest.assertTrue((boolean)first.equals((Object)new GlAccountLineGroup(third)));
        first.combineEntry(third);
        GlAccountLineGroupTest.assertEquals((String)"D", (String)first.getTargetEntry().getTransactionDebitCreditCode());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(100), (Object)first.getTargetEntry().getTransactionLedgerEntryAmount());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(100), (Object)first.getAmount());
        Entry fourth = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, "C", new KualiDecimal(200));
        GlAccountLineGroupTest.assertTrue((boolean)first.equals((Object)new GlAccountLineGroup(fourth)));
        first.combineEntry(fourth);
        GlAccountLineGroupTest.assertEquals((String)"C", (String)first.getTargetEntry().getTransactionDebitCreditCode());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(100), (Object)first.getTargetEntry().getTransactionLedgerEntryAmount());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(-100), (Object)first.getAmount());
        Entry fifth = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, "D", new KualiDecimal(200));
        GlAccountLineGroupTest.assertTrue((boolean)first.equals((Object)new GlAccountLineGroup(fifth)));
        first.combineEntry(fifth);
        GlAccountLineGroupTest.assertEquals((String)"D", (String)first.getTargetEntry().getTransactionDebitCreditCode());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(100), (Object)first.getTargetEntry().getTransactionLedgerEntryAmount());
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(100), (Object)first.getAmount());
        List sourceEntries = first.getSourceEntries();
        GlAccountLineGroupTest.assertEquals((int)5, (int)sourceEntries.size());
        KualiDecimal srcAmount = KualiDecimal.ZERO;
        for (Entry entry : sourceEntries) {
            if ("C".equals(entry.getTransactionDebitCreditCode())) {
                srcAmount = (KualiDecimal)srcAmount.add(entry.getTransactionLedgerEntryAmount().negated());
                continue;
            }
            srcAmount = (KualiDecimal)srcAmount.add((AbstractKualiDecimal)entry.getTransactionLedgerEntryAmount());
        }
        GlAccountLineGroupTest.assertEquals((Object)new KualiDecimal(100), (Object)srcAmount);
        GlAccountLineGroupTest.assertTrue((boolean)first.getAmount().equals((Object)srcAmount));
    }

    private GlAccountLineGroup createAccountLineGroup(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, String dbtCrdtCode, KualiDecimal amount) {
        Entry entry = this.createEntry(i, chartCode, acctNum, subAcctNum, objCd, subObjCd, fiscalPrd, docNum, refDocNum, dbtCrdtCode, amount);
        GlAccountLineGroup first = new GlAccountLineGroup(entry);
        return first;
    }

    private Entry createEntry(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, String dbtCrdtCode, KualiDecimal amount) {
        Entry entry = new Entry();
        entry.setUniversityFiscalYear(i);
        entry.setChartOfAccountsCode(chartCode);
        entry.setAccountNumber(acctNum);
        entry.setSubAccountNumber(subAcctNum);
        entry.setFinancialObjectCode(objCd);
        entry.setFinancialSubObjectCode(subObjCd);
        entry.setUniversityFiscalPeriodCode(fiscalPrd);
        entry.setDocumentNumber(docNum);
        entry.setReferenceFinancialDocumentNumber(refDocNum);
        entry.setTransactionDebitCreditCode(dbtCrdtCode);
        entry.setTransactionLedgerEntryAmount(amount);
        return entry;
    }
}

