/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cab.batch.ExtractProcessLog;
import org.kuali.kfs.module.cab.batch.service.BatchExtractService;
import org.kuali.kfs.module.cab.batch.service.BatchTestBase;
import org.kuali.kfs.module.cab.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cab.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cab.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cab.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

public class BatchExtractServiceTest
extends BatchTestBase {
    private BatchExtractService batchExtractService;
    private BusinessObjectService boService;

    @Override
    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.batchExtractService = (BatchExtractService)SpringContext.getBean(BatchExtractService.class);
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    public void testBatchProcess() throws Exception {
        ExtractProcessLog processLog = new ExtractProcessLog();
        Collection glEntries = this.batchExtractService.findElgibleGLEntries(processLog);
        BatchExtractServiceTest.assertNotNull((Object)glEntries);
        BatchExtractServiceTest.assertEquals((int)13, (int)glEntries.size());
        ArrayList fpLines = new ArrayList();
        ArrayList purapLines = new ArrayList();
        this.batchExtractService.separatePOLines(fpLines, purapLines, glEntries);
        BatchExtractServiceTest.assertEquals((int)11, (int)purapLines.size());
        BatchExtractServiceTest.assertEquals((int)2, (int)fpLines.size());
        this.batchExtractService.saveFPLines(fpLines, processLog);
        Collection fpGls = this.boService.findAll(GeneralLedgerEntry.class);
        BatchExtractServiceTest.assertEquals((int)2, (int)fpGls.size());
        Timestamp ts = new Timestamp(DateUtils.parseDate((String)"01/01/1970 23:59:59", (String[])new String[]{"MM/dd/yyyy HH:mm:ss"}).getTime());
        this.batchExtractService.updateLastExtractTime(ts);
        Parameter parameter = this.findCabExtractTimeParam();
        BatchExtractServiceTest.assertEquals((String)"01/01/1970 23:59:59", (String)parameter.getValue());
        this.batchExtractService.savePOLines(purapLines, processLog);
        Collection gls = this.boService.findAll(GeneralLedgerEntry.class);
        BatchExtractServiceTest.assertEquals((int)13, (int)gls.size());
        Collection allCabDocs = this.boService.findAll(PurchasingAccountsPayableDocument.class);
        BatchExtractServiceTest.assertEquals((int)7, (int)allCabDocs.size());
        Collection allCabItems = this.boService.findAll(PurchasingAccountsPayableItemAsset.class);
        BatchExtractServiceTest.assertEquals((int)14, (int)allCabItems.size());
        Collection allCabAccts = this.boService.findAll(PurchasingAccountsPayableLineAssetAccount.class);
        BatchExtractServiceTest.assertEquals((int)17, (int)allCabAccts.size());
    }

    public void testFindPreTaggablePOAccounts() throws Exception {
        Collection preTaggablePOAccounts = this.batchExtractService.findPreTaggablePOAccounts();
        BatchExtractServiceTest.assertEquals((int)6, (int)preTaggablePOAccounts.size());
        this.batchExtractService.savePreTagLines(preTaggablePOAccounts);
    }
}

