/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch.service;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cab.fixture.CreditMemoAccountFixture;
import org.kuali.kfs.module.cab.fixture.CreditMemoAccountRevisionFixture;
import org.kuali.kfs.module.cab.fixture.CreditMemoDocumentFixture;
import org.kuali.kfs.module.cab.fixture.CreditMemoItemFixture;
import org.kuali.kfs.module.cab.fixture.DocumentRouteHeaderValueFixture;
import org.kuali.kfs.module.cab.fixture.EntryFixture;
import org.kuali.kfs.module.cab.fixture.FinancialSystemDocumentHeaderFixture;
import org.kuali.kfs.module.cab.fixture.PaymentRequestAccountFixture;
import org.kuali.kfs.module.cab.fixture.PaymentRequestAccountRevisionFixture;
import org.kuali.kfs.module.cab.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.cab.fixture.PaymentRequestItemFixture;
import org.kuali.kfs.module.cab.fixture.PurchaseOrderAccountFixture;
import org.kuali.kfs.module.cab.fixture.PurchaseOrderCapitalAssetItemFixture;
import org.kuali.kfs.module.cab.fixture.PurchaseOrderCapitalAssetLocationFixture;
import org.kuali.kfs.module.cab.fixture.PurchaseOrderCapitalAssetSystemFixture;
import org.kuali.kfs.module.cab.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.cab.fixture.PurchaseOrderItemFixture;
import org.kuali.kfs.module.cab.fixture.RequisitionAccountFixture;
import org.kuali.kfs.module.cab.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.cab.fixture.RequisitionItemFixture;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

public abstract class BatchTestBase
extends KualiTestBase {
    protected static final String SQL_PACKAGE = "org/kuali/kfs/module/cab/sql/";
    protected DateTimeService dateTimeService;

    protected void setUp() throws Exception {
        super.setUp();
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.updateLastExtractTime();
        this.prepareTestDataRecords();
    }

    protected void updateLastExtractTime() {
        this.updateLastCabExtractTime();
        this.updateLastPreTagExtractTime();
    }

    protected void updateLastCabExtractTime() {
        Parameter lastExtractTime = this.findCabExtractTimeParam();
        if (ObjectUtils.isNotNull((Object)lastExtractTime)) {
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Parameter.Builder updatedParm = Parameter.Builder.create((ParameterContract)lastExtractTime);
            updatedParm.setValue(fmt.format(DateUtils.addDays((Date)this.dateTimeService.getCurrentDate(), (int)-1)));
            ((ParameterService)SpringContext.getBean(ParameterService.class)).updateParameter(updatedParm.build());
        } else {
            BatchTestBase.fail((String)"Could not find the parameter LAST_EXTRACT_TIME");
        }
    }

    protected Parameter findCabExtractTimeParam() {
        Parameter lastExtractTime = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameter("KFS-CAB", "Batch", "LAST_EXTRACT_TIME");
        return lastExtractTime;
    }

    protected void updateLastPreTagExtractTime() {
        Parameter lastExtractTime = this.findPretagExtractDateParam();
        if (lastExtractTime != null) {
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy");
            Parameter.Builder updatedParm = Parameter.Builder.create((ParameterContract)lastExtractTime);
            updatedParm.setValue(fmt.format(DateUtils.addDays((Date)this.dateTimeService.getCurrentDate(), (int)-1)));
            ((ParameterService)SpringContext.getBean(ParameterService.class)).updateParameter(updatedParm.build());
        } else {
            BatchTestBase.fail((String)"Could not find the parameter LAST_EXTRACT_TIME");
        }
    }

    protected Parameter findPretagExtractDateParam() {
        Parameter lastExtractTime = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameter("KFS-CAB", "PreAssetTaggingStep", "LAST_EXTRACT_DATE");
        return lastExtractTime;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void prepareTestDataRecords() throws SQLException {
        DocumentRouteHeaderValueFixture.setUpData();
        FinancialSystemDocumentHeaderFixture.setUpData();
        RequisitionDocumentFixture.setUpData();
        RequisitionItemFixture.setUpData();
        RequisitionAccountFixture.setUpData();
        PurchaseOrderDocumentFixture.setUpData();
        PurchaseOrderItemFixture.setUpData();
        PurchaseOrderAccountFixture.setUpData();
        PurchaseOrderCapitalAssetSystemFixture.setUpData();
        PurchaseOrderCapitalAssetItemFixture.setUpData();
        PurchaseOrderCapitalAssetLocationFixture.setUpData();
        PaymentRequestDocumentFixture.setUpData();
        PaymentRequestItemFixture.setUpData();
        PaymentRequestAccountFixture.setUpData();
        PaymentRequestAccountRevisionFixture.setUpData();
        CreditMemoDocumentFixture.setUpData();
        CreditMemoItemFixture.setUpData();
        CreditMemoAccountFixture.setUpData();
        CreditMemoAccountRevisionFixture.setUpData();
        EntryFixture.setUpData();
    }
}

