/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.document.validation.impl;

import java.util.Map;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.document.validation.PurapRuleTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingCapitalAssetValidation;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentWithCapitalAssetItemsFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.document.validation.Validation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.document.validation.impl.CompositeValidation;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
public class PurchasingDocumentCapitalAssetRuleTest
extends PurapRuleTestBase {
    private Map<String, Validation> validations;

    protected void setUp() throws Exception {
        super.setUp();
        KNSGlobalVariables.setMessageList((MessageList)new MessageList());
        this.validations = SpringContext.getBeansOfType(Validation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        super.tearDown();
    }

    public void testMissingCommodityCodeWhenRequired() throws Exception {
        TestUtils.setSystemParameter(RequisitionDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        RequisitionDocumentFixture reqFixture = RequisitionDocumentFixture.REQ_NO_APO_VALID;
        CompositeValidation validation = (CompositeValidation)this.validations.get("Requisition-newProcessItemValidation");
        RequisitionDocument req = reqFixture.createRequisitionDocument();
        AttributedDocumentEventBase event = new AttributedDocumentEventBase("", "", (Document)req);
        for (RequisitionItem item : req.getItems()) {
            event.setIterationSubject((Object)item);
            validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentCapitalAssetRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.required"));
        String fieldName = "document.item[0].purchasingCommodityCode";
        PurchasingDocumentCapitalAssetRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage(fieldName, "error.required"));
        GlobalVariables.getMessageMap().clearErrorMessages();
        TestUtils.setSystemParameter(PurchaseOrderDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        PurchaseOrderDocumentFixture poFixture = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS;
        validation = (CompositeValidation)this.validations.get("PurchaseOrder-newProcessItemValidation");
        PurchaseOrderDocument po = poFixture.createPurchaseOrderDocument();
        event = new AttributedDocumentEventBase("", "", (Document)po);
        for (PurchaseOrderItem item : po.getItems()) {
            event.setIterationSubject((Object)item);
            validation.validate((AttributedDocumentEvent)event);
        }
        PurchasingDocumentCapitalAssetRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.required"));
        PurchasingDocumentCapitalAssetRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage(fieldName, "error.required"));
    }

    public void testValidateOneSystemCapitalAssetSystemChartsRequiringParameters() {
        RequisitionDocument requisition = RequisitionDocumentWithCapitalAssetItemsFixture.REQ_VALID_ONE_NEW_CAPITAL_ASSET_ITEM.createRequisitionDocument();
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems((PurchasingDocument)requisition);
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetSystem((PurchasingDocument)requisition);
        PurchasingCapitalAssetValidation validation = (PurchasingCapitalAssetValidation)this.validations.get("Purchasing-capitalAssetValidation-test");
        PurchasingDocumentCapitalAssetRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)requisition)));
        RequisitionDocument purchasingDocument = requisition;
        ((PurApAccountingLine)((PurApItem)purchasingDocument.getItems().get(0)).getSourceAccountingLines().get(0)).setChartOfAccountsCode("BA");
        PurchasingDocumentCapitalAssetRuleTest.assertFalse((String)"Chart BA should have required comments", (boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)requisition)));
    }
}

