/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.LedgerPostingDocument;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentPresentationControllerBase;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetGlobalPresentationController
extends FinancialSystemMaintenanceDocumentPresentationControllerBase {
    public Set<String> getConditionallyHiddenPropertyNames(BusinessObject businessObject) {
        Set fields = super.getConditionallyHiddenPropertyNames(businessObject);
        MaintenanceDocument document = (MaintenanceDocument)businessObject;
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        MaintainableCollectionDefinition maintCollDef = ((MaintenanceDocumentDictionaryService)SpringContext.getBean(MaintenanceDocumentDictionaryService.class)).getMaintainableCollection("AA", "assetPaymentDetails");
        boolean isAssetSeparate = ((AssetGlobalService)SpringContext.getBean(AssetGlobalService.class)).isAssetSeparate(assetGlobal);
        if (assetGlobal.isCapitalAssetBuilderOriginIndicator() || isAssetSeparate) {
            maintCollDef.setIncludeAddLine(false);
            for (AssetPaymentDetail payment : assetGlobal.getAssetPaymentDetails()) {
                payment.setNewCollectionRecord(false);
            }
        } else {
            maintCollDef.setIncludeAddLine(true);
        }
        AssetGlobalService assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
        if (!assetGlobalService.isAssetSeparateByPayment(assetGlobal)) {
            fields.add("separateSourcePaymentSequenceNumber");
        }
        if (!isAssetSeparate) {
            fields.addAll(this.getAssetGlobalLocationHiddenFields(assetGlobal));
            if (assetGlobalService.existsInGroup(assetGlobalService.getNonNewAcquisitionCodeGroup(), assetGlobal.getAcquisitionTypeCode())) {
                fields.add("add.assetPaymentDetails.expenditureFinancialDocumentPostedDate");
                fields.add("add.assetPaymentDetails.expenditureFinancialDocumentNumber");
                fields.add("add.assetPaymentDetails.expenditureFinancialDocumentTypeCode");
                fields.add("add.assetPaymentDetails.expenditureFinancialSystemOriginationCode");
                if (!document.getDocumentHeader().getWorkflowDocument().isFinal()) {
                    fields.addAll(this.getAssetGlobalPaymentsHiddenFields(assetGlobal));
                }
            }
        }
        if (isAssetSeparate && (assetGlobal.getAssetSharedDetails().isEmpty() || assetGlobal.getAssetSharedDetails().get(0).getAssetGlobalUniqueDetails().isEmpty())) {
            fields.add("calculateEqualSourceAmountsButton");
        }
        return fields;
    }

    public Set<String> getConditionallyReadOnlyPropertyNames(MaintenanceDocument document) {
        Set fields = super.getConditionallyReadOnlyPropertyNames(document);
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        if (((AssetGlobalService)SpringContext.getBean(AssetGlobalService.class)).isAssetSeparate(assetGlobal)) {
            fields.addAll(this.getAssetGlobalDetailsReadOnlyFields());
            fields.addAll(this.getAssetGlobalPaymentsReadOnlyFields(assetGlobal));
        } else if (assetGlobal.isCapitalAssetBuilderOriginIndicator()) {
            fields.addAll(this.getAssetGlobalPaymentsReadOnlyFields(assetGlobal));
        }
        if (!((AccountService)SpringContext.getBean(AccountService.class)).accountsCanCrossCharts()) {
            String COA_CODE_NAME = "add.assetPaymentDetails.chartOfAccountsCode";
            fields.add(COA_CODE_NAME);
        }
        return fields;
    }

    public Set<String> getConditionallyHiddenSectionIds(BusinessObject businessObject) {
        Set fields = super.getConditionallyHiddenSectionIds(businessObject);
        MaintenanceDocument document = (MaintenanceDocument)businessObject;
        AssetGlobal assetGlobal = (AssetGlobal)document.getNewMaintainableObject().getBusinessObject();
        String docType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        ParameterEvaluator evaluator = this.getParameterEvaluatorService().getParameterEvaluator("KFS-SYS", "Document", "FISCAL_PERIOD_SELECTION_DOCUMENT_TYPES", docType);
        if (!evaluator.evaluationSucceeds()) {
            fields.add("Accounting Period");
        }
        if (!((AssetGlobalService)SpringContext.getBean(AssetGlobalService.class)).isAssetSeparate(assetGlobal)) {
            fields.add("assetInformation");
            fields.add("recalculateSeparateSourceAmount");
        }
        return fields;
    }

    protected Set<String> getAssetGlobalLocationHiddenFields(AssetGlobal assetGlobal) {
        HashSet<String> fields = new HashSet<String>();
        int i = 0;
        for (AssetGlobalDetail assetSharedDetail : assetGlobal.getAssetSharedDetails()) {
            fields.add("add.assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "." + CamsPropertyConstants.AssetGlobalDetail.REPRESENTATIVE_UNIVERSAL_IDENTIFIER);
            fields.add("add.assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "." + CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_TYPE_CODE);
            fields.add("add.assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "." + CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_DESCRIPTION);
            fields.add("add.assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "." + CamsPropertyConstants.AssetGlobalDetail.MANUFACTURER_NAME);
            fields.add("add.assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "." + CamsPropertyConstants.AssetGlobalDetail.ORGANIZATION_TEXT);
            fields.add("add.assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "." + CamsPropertyConstants.AssetGlobalDetail.MANUFACTURER_MODEL_NUMBER);
            fields.add("add.assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "." + CamsPropertyConstants.AssetGlobalDetail.SEPARATE_SOURCE_AMOUNT);
            int j = 0;
            for (AssetGlobalDetail assetGlobalUniqueDetail : assetSharedDetail.getAssetGlobalUniqueDetails()) {
                fields.add("assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "[" + j + "]." + CamsPropertyConstants.AssetGlobalDetail.REPRESENTATIVE_UNIVERSAL_IDENTIFIER);
                fields.add("assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "[" + j + "]." + CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_TYPE_CODE);
                fields.add("assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "[" + j + "]." + CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_DESCRIPTION);
                fields.add("assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "[" + j + "]." + CamsPropertyConstants.AssetGlobalDetail.MANUFACTURER_NAME);
                fields.add("assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "[" + j + "]." + CamsPropertyConstants.AssetGlobalDetail.ORGANIZATION_TEXT);
                fields.add("assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "[" + j + "]." + CamsPropertyConstants.AssetGlobalDetail.MANUFACTURER_MODEL_NUMBER);
                fields.add("assetSharedDetails[" + i + "]." + "assetGlobalUniqueDetails" + "[" + j + "]." + CamsPropertyConstants.AssetGlobalDetail.SEPARATE_SOURCE_AMOUNT);
                ++j;
            }
            ++i;
        }
        return fields;
    }

    protected Set<String> getAssetGlobalPaymentsHiddenFields(AssetGlobal assetGlobal) {
        HashSet<String> fields = new HashSet<String>();
        int i = 0;
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialDocumentPostedDate");
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialDocumentNumber");
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialDocumentTypeCode");
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialSystemOriginationCode");
            ++i;
        }
        return fields;
    }

    protected Set<String> getAssetGlobalDetailsReadOnlyFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("organizationOwnerChartOfAccountsCode");
        fields.add("organizationOwnerAccountNumber");
        fields.add("organizationOwnerAccount.organizationCode");
        fields.add("agencyNumber");
        fields.add("acquisitionTypeCode");
        fields.add("inventoryStatusCode");
        fields.add("conditionCode");
        fields.add("capitalAssetDescription");
        fields.add("capitalAssetTypeCode");
        fields.add("vendorName");
        fields.add("manufacturerName");
        fields.add("manufacturerModelNumber");
        fields.add("organizationText");
        fields.add("assetRepresentative.principalName");
        fields.add("lastInventoryDate");
        fields.add("createDate");
        fields.add("capitalAssetInServiceDate");
        fields.add("capitalAssetDepreciationDate");
        fields.add("landCountyName");
        fields.add("landAcreageSize");
        fields.add("landParcelNumber");
        return fields;
    }

    protected Set<String> getAssetGlobalPaymentsReadOnlyFields(AssetGlobal assetGlobal) {
        HashSet<String> fields = new HashSet<String>();
        int i = 0;
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            fields.add("assetPaymentDetails[" + i + "]." + "sequenceNumber");
            fields.add("assetPaymentDetails[" + i + "]." + "chartOfAccountsCode");
            fields.add("assetPaymentDetails[" + i + "]." + "accountNumber");
            fields.add("assetPaymentDetails[" + i + "]." + "subAccountNumber");
            fields.add("assetPaymentDetails[" + i + "]." + "financialObjectCode");
            fields.add("assetPaymentDetails[" + i + "]." + "financialSubObjectCode");
            fields.add("assetPaymentDetails[" + i + "]." + "projectCode");
            fields.add("assetPaymentDetails[" + i + "]." + "organizationReferenceId");
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialDocumentNumber");
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialDocumentTypeCode");
            fields.add("assetPaymentDetails[" + i + "]." + "purchaseOrderNumber");
            fields.add("assetPaymentDetails[" + i + "]." + "requisitionNumber");
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialDocumentPostedDate");
            fields.add("assetPaymentDetails[" + i + "]." + "postingYear");
            fields.add("assetPaymentDetails[" + i + "]." + "postingPeriodCode");
            fields.add("assetPaymentDetails[" + i + "]." + "amount");
            fields.add("assetPaymentDetails[" + i + "]." + "expenditureFinancialSystemOriginationCode");
            ++i;
        }
        return fields;
    }

    public Set<String> getDocumentActions(Document document) {
        Set documentActions = super.getDocumentActions(document);
        if (document instanceof LedgerPostingDocument) {
            String docType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
            ParameterEvaluatorService parameterEvaluatorService = (ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class);
            ParameterEvaluator evaluator = parameterEvaluatorService.getParameterEvaluator("KFS-SYS", "Document", "FISCAL_PERIOD_SELECTION_DOCUMENT_TYPES", docType);
            if (evaluator.evaluationSucceeds()) {
                documentActions.add("AccountingPeriodViewAction");
            }
        }
        return documentActions;
    }
}

