/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetPaymentAssetValidation
extends GenericValidation {
    private AssetPaymentService assetPaymentService;

    public boolean validate(AttributedDocumentEvent event) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = assetPaymentDocument.getAssetPaymentAssetDetail();
        boolean valid = true;
        int zeroCostAssetCount = 0;
        int nonZeroCostAssetCount = 0;
        int position_a = -1;
        for (AssetPaymentAssetDetail assetPaymentAssetDetail : assetPaymentAssetDetails) {
            String errorPath = "document.assetPaymentAssetDetail[" + ++position_a + "]." + "capitalAssetNumber";
            if (assetPaymentAssetDetail.getAsset().getTotalCostAmount() != null && assetPaymentAssetDetail.getAsset().getTotalCostAmount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                ++nonZeroCostAssetCount;
            } else {
                ++zeroCostAssetCount;
            }
            valid &= this.getAssetPaymentService().validateAssets(errorPath, assetPaymentAssetDetail.getAsset());
        }
        if (zeroCostAssetCount > 0 && nonZeroCostAssetCount > 0) {
            GlobalVariables.getMessageMap().putErrorForSectionId("commonErrorSection", "error.payment.document.noZeroValueAssetsAllowed", new String[0]);
            valid &= false;
        }
        return valid;
    }

    public AssetPaymentService getAssetPaymentService() {
        return this.assetPaymentService;
    }

    public void setAssetPaymentService(AssetPaymentService assetPaymentService) {
        this.assetPaymentService = assetPaymentService;
    }
}

