/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.inquiry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.module.cam.document.service.RetirementInfoService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetInquirableImpl
extends KualiInquirableImpl {
    protected static Logger LOG = Logger.getLogger(AssetInquirableImpl.class);

    public BusinessObject getBusinessObject(Map fieldValues) {
        Asset asset = (Asset)super.getBusinessObject(fieldValues);
        if (ObjectUtils.isNotNull((Object)((Object)asset))) {
            AssetLocationService assetlocationService = (AssetLocationService)SpringContext.getBean(AssetLocationService.class);
            assetlocationService.setOffCampusLocation(asset);
            PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
            paymentSummaryService.calculateAndSetPaymentSummary(asset);
            AssetService assetService = (AssetService)SpringContext.getBean(AssetService.class);
            assetService.setSeparateHistory(asset);
            RetirementInfoService retirementInfoService = (RetirementInfoService)SpringContext.getBean(RetirementInfoService.class);
            retirementInfoService.setRetirementInfo(asset);
            retirementInfoService.setMergeHistory(asset);
            EquipmentLoanOrReturnService equipmentLoanOrReturnService = (EquipmentLoanOrReturnService)SpringContext.getBean(EquipmentLoanOrReturnService.class);
            equipmentLoanOrReturnService.setEquipmentLoanInfo(asset);
        }
        return asset;
    }

    public List<Section> getSections(BusinessObject businessObject) {
        List sections = super.getSections(businessObject);
        Section sectionToRemove = null;
        Asset asset = (Asset)businessObject;
        for (Section section : sections) {
            if (!"paymentInformation".equals(section.getSectionId()) || asset.getAssetPayments().size() <= 10) continue;
            sectionToRemove = section;
        }
        if (sectionToRemove != null) {
            sections.remove(sectionToRemove);
        }
        return sections;
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ("organizationOwnerAccount.organizationCode".equals(attributeName) && businessObject instanceof Asset) {
            Asset asset = (Asset)businessObject;
            Properties parameters = new Properties();
            parameters.put("methodToCall", "start");
            parameters.put("businessObjectClassName", Organization.class.getName());
            parameters.put("chartOfAccountsCode", asset.getOrganizationOwnerAccount().getChartOfAccountsCode());
            parameters.put("organizationCode", asset.getOrganizationOwnerAccount().getOrganizationCode());
            HashMap<String, String> fieldList = new HashMap<String, String>();
            fieldList.put("chartOfAccountsCode", asset.getOrganizationOwnerAccount().getChartOfAccountsCode());
            fieldList.put("organizationCode", asset.getOrganizationOwnerAccount().getOrganizationCode());
            return this.getHyperLink(Organization.class, fieldList, UrlFactory.parameterizeUrl((String)"inquiry.do", (Properties)parameters));
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }
}

