/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.PreAssetTaggingStep;
import org.kuali.kfs.module.cam.batch.service.BatchTestBase;
import org.kuali.kfs.module.cam.batch.service.impl.BatchExtractServiceImpl;
import org.kuali.kfs.module.cam.businessobject.Pretag;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.ProxyUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PreAssetTaggingStepTest
extends BatchTestBase {
    private PreAssetTaggingStep preAssetTaggingStep;
    private DateTimeService dateTimeService;

    @Override
    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.preAssetTaggingStep = (PreAssetTaggingStep)ProxyUtils.getTargetIfProxied((Object)SpringContext.getBean(PreAssetTaggingStep.class));
        BatchExtractServiceImpl batchExtractService = (BatchExtractServiceImpl)ProxyUtils.getTargetIfProxied((Object)this.preAssetTaggingStep.getBatchExtractService());
        batchExtractService.setFinancialSystemDocumentService((FinancialSystemDocumentService)new BatchTestBase.BatchTestBaseFinancialSystemDocumentService());
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    public void testExecute() throws Exception {
        Date currentSqlDate = this.dateTimeService.getCurrentSqlDate();
        this.preAssetTaggingStep.execute("testPreAssetTaggingExtractStep", this.dateTimeService.getCurrentDate());
        Collection<Pretag> match = this.findByPO("21");
        PreAssetTaggingStepTest.assertEquals((int)0, (int)match.size());
        match = this.findByPO("22");
        PreAssetTaggingStepTest.assertEquals((int)2, (int)match.size());
        match = this.findByPO("23");
        PreAssetTaggingStepTest.assertEquals((int)2, (int)match.size());
        SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy");
        PreAssetTaggingStepTest.assertEquals((String)fmt.format(currentSqlDate), (String)this.findPretagExtractDateParam().getValue());
    }

    private Collection<Pretag> findByPO(String poNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("purchaseOrderNumber", poNumber);
        Collection match = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(Pretag.class, fieldValues);
        PreAssetTaggingStepTest.assertNotNull((Object)match);
        return match;
    }
}

